{#<div class="container">#}
  <div class="row m-0">
    <div class="col-12 text-center p-80x" id="loading-dashboard" style="display:none">
      <span class="font-weight-bold">{{ mt._('statistics.loading') }}</span>
      <span>{{ image("assets/img/loading.gif", "style": "height:100px", "class": "m-0-auto") }}</span>
    </div>
  </div>
  <div class="row mx-0" id="all-index-stats">
    <!-- Nav Tabs -->
    <ul class="nav nav-tabs w-40" role="tablist" style="margin-left:30%">
      <li class="nav-item w-50"><a href="#tab_das" role="tab" data-toggle="tab" class="active">{{ mt._('statistics.tab.dashboard') }}</a></li>
      <li class="nav-item w-50"><a href="#tab_sta" role="tab" data-toggle="tab">{{ mt._('statistics.tab.statistics') }}</a></li>
    </ul><!-- .nav-tabs -->

    <!-- Tab panes -->
    <div class="col-12 tab-content account-info">
      <div role="tabpanel" class="tab-pane fade show active" id="tab_das">
        <div class="row" style="margin-left:20%;margin-right:20%">
          <div class="col-12 col-lg-4">
            <div class="account-title text-capitalize text-right float-left pr-10x" style="line-height:48px">{{ mt._('_common.season') }}</div>
            <div class="account-field float-left {% if seasons|length > 0 %}form-element form-select{% endif %} w-50">
            {% if seasons|length > 0 %}
              <label class="form-custom-select">
                <select id="season-dashboard" name="season-dashboard">
                  {% for cdstag in seasons %}
                  <option value="{{ cdstag.cdstag }}">{{ cdstag.cdstag }}</option>
                  {% endfor %}
                </select>
              </label>
            {% else %}
              <div class="pt-13x">{{ mt._('statistics.noseasons') }}</div>
            {% endif %}
            </div>
          </div>
          <div class="col-12 col-lg-6">
            <input type="hidden" style="width:200px" name="period_dashboard" id="period_dashboard" class="form-control" value=""/>
            <div id="period_dashboard-box" class="row pull-right py-5x px-10x" style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:250px">
              <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
              <div class='col-md-9 px-0'><span></span></div>
              <div class='col-md-1 px-0'><b class="caret"></b></div>
            </div>
            <div class='pr-20x pull-right font-weight-bold' style="line-height:40px">{{ mt._('_common.period') }}</div>
          </div>
          <div class="col-2 text-right"><button type="button" class="btn btn-generic w-100 m-0" id="btn-dashboard">{{ mt._('_common.load') }}</button></div>
        </div>
        <div id="dashboard-stats" style="display:none">
          <div class="row m-0" style="padding-left:4%">
            <div class="col-12 text-uppercase font-weight-bold mb-20x">{{ mt._('statistics.overallanalysis') }}</div>
          </div>
          <div class="row m-0">
            <div class="stats-box">
              <div class="stats-box-title">{{ mt._('statistics.totorders') }}</div>
              <div class="stats-box-value col-ov" id="tot-ord"></div>
            </div>
            <div class="stats-box">
              <div class="stats-box-title">{{ mt._('statistics.soldqty') }}</div>
              <div class="stats-box-value col-ov" id="qty-tot"></div>
            </div>
            <div class="stats-box">
              <div class="stats-box-title">{{ mt._('statistics.avgqtyorder') }}</div>
              <div class="stats-box-value" id="qty-avg-ord"></div>
            </div>
            <div class="stats-box">
              <div class="stats-box-title">{{ mt._('statistics.soldvalue') }}</div>
              <div class="stats-box-value col-ov" id="val-tot"></div>
            </div>
            <div class="stats-box">
              <div class="stats-box-title">{{ mt._('statistics.avgvalorder') }}</div>
              <div class="stats-box-value" id="val-avg-ord"></div>
            </div>
            <div class="stats-box">
              <div class="stats-box-title">{{ mt._('statistics.avgvalproduct') }}</div>
              <div class="stats-box-value" id="val-avg-prd"></div>
            </div>
          </div>
          <div class="row m-0 mt-50x" style="padding-left:4%;padding-right:4%">
            <div class="col-12 col-lg-6" id="top-10-qty">
              <div class="text-uppercase font-weight-bold mb-20x">{{ mt._('statistics.top10cust.qty') }}</div>
              <canvas id="canvas-qty"></canvas>
            </div>
            <div class="col-12 col-lg-6" id="top-10-val">
              <div class="text-uppercase font-weight-bold mb-20x">{{ mt._('statistics.top10cust.val') }}</div>
              <canvas id="canvas-val"></canvas>
            </div>
          </div>
          <div class="row top-row justify-content-center" id="top-10-mod-qty">
            <div class="col-12">
              <div class="text-uppercase font-weight-bold">{{ mt._('statistics.top10bestseller') }} ({{ mt._('_common.quantity') }})</div>
            </div>
            <div id="backward-slider-best-qty" style="opacity:0.5">{{ image("assets/img/backward_slider.png", "class": "float-left", "style": "background-color:white", "alt": mt._('_common.previous')) }}</div>
            <div id="forward-slider-best-qty">{{ image("assets/img/forward_slider.png", "class": "float-right", "style": "background-color:white", "alt": mt._('_common.next')) }}</div>
            <div class="col-12 slide-best-qty">
              <div id="slider-best-qty" style="width:2200px">
                {% for i in 0..9 %}
                <div id="best-mod-qty{{ i }}" class="best-model">
                  <div>{{ image("/assets/img/default_model.jpg", "id": "best-img-qty" ~ i) }}</div>
                  <div class="best-descr" id="best-qty{{ i }}" title="">
                    <div class="best-title" id="best-title-qty{{ i }}"></div>
                    <div class="best-descr" id="best-descr-qty{{ i }}"></div>
                    <div class="best-value" id="best-value-qty{{ i }}"></div>
                  </div>
                </div>
                {% endfor %}
              </div>
            </div>
          </div>
          <div class="row top-row justify-content-center" id="top-10-mod-val">
            <div class="col-12">
              <div class="text-uppercase font-weight-bold">{{ mt._('statistics.top10bestseller') }} ({{ mt._('_common.value') }})</div>
            </div>
            <div id="backward-slider-best-val" style="opacity:0.5">{{ image("assets/img/backward_slider.png", "class": "float-left", "style": "background-color:white", "alt": mt._('_common.previous')) }}</div>
            <div id="forward-slider-best-val">{{ image("assets/img/forward_slider.png", "class": "float-right", "style": "background-color:white", "alt": mt._('_common.next')) }}</div>
            <div class="col-12 slide-best-val">
              <div id="slider-best-val" style="width:2200px">
                {% for i in 0..9 %}
                <div id="best-mod-val{{ i }}" class="best-model">
                  <div>{{ image("/assets/img/default_model.jpg", "id": "best-img-val" ~ i) }}</div>
                  <div class="best-descr" id="best-val{{ i }}" title="">
                    <div class="best-title" id="best-title-val{{ i }}"></div>
                    <div class="best-descr" id="best-descr-val{{ i }}"></div>
                    <div class="best-value" id="best-value-val{{ i }}"></div>
                  </div>
                </div>
                {% endfor %}
              </div>
            </div>
          </div>
          <div class="row m-0 mt-50x" style="padding-left:4%;padding-right:4%" id="trend">
            <div class="col-12" id="trend-container">
              <div class="text-uppercase font-weight-bold mb-20x">{{ mt._('statistics.salestrend') }}</div>
              <canvas id="canvas-trn"></canvas>
            </div>
          </div>
        </div>
      </div>

      <div role="tabpanel" class="tab-pane fade mx-0" id="tab_sta">
        <div class="row m-0">
          <div class="col-6">
            <div class="account-title">{{ mt._('statistics.group.title') }}</div>
            <div class="account-field">
              <div class="form-element form-select">
                <label class="form-custom-select">
                  <select id="grouping" name="grouping">
                    <option value="group_01">{{ mt._('statistics.group.modtype') }}</option>
                    <option value="group_02">{{ mt._('statistics.group.modtypebrandline') }}</option>
                    <option value="group_03">{{ mt._('statistics.group.brandline') }}</option>
                    <option value="group_07">{{ mt._('statistics.group.brandlineserie') }}</option>
                    <option value="group_04">{{ mt._('statistics.group.brandlinemodel') }}</option>
                    <option value="group_05">{{ mt._('statistics.group.brandlinearticle') }}</option>
                    <option value="group_06">{{ mt._('statistics.group.brandlinemodtype') }}</option>
                    <option value="group_08">{{ mt._('statistics.group.cust') }}</option>
                    <option value="group_09">{{ mt._('statistics.group.custmodtype') }}</option>
                    <option value="group_10">{{ mt._('statistics.group.custbrandline') }}</option>
                    <option value="group_11">{{ mt._('statistics.group.custbrandlinemod') }}</option>
                    <option value="group_12">{{ mt._('statistics.group.custbrandlineart') }}</option>
                  </select>
                </label>
              </div>
            </div>
          </div>
        </div>
        <div class="row m-0 pt-20x">
          <div class="col-12">
            <div class="account-title" style="border-bottom:1px #eee solid">{{ mt._('statistics.selectelements') }}</div>
          </div>
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.catalog') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-cat" data-toggle='modal' data-target='.modal-catalogs'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.cat') }}</div>
                <div id="sel-cat fs9">{{ mt._('statistics.selected.cat.all') }}</div>
              </div>
            </div>
          </div>
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.customer') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-cus" data-toggle='modal' data-target='.modal-customers'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.cus') }}</div>
                <div id="sel-cus fs9">{{ mt._('statistics.selected.cus.all') }}</div>
              </div>
            </div>
          </div>
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.line') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-lin" data-toggle='modal' data-target='.modal-lines'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.lin') }}</div>
                <div id="sel-lin fs9">{{ mt._('statistics.selected.lin.all') }}</div>
              </div>
            </div>
          </div>
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.country') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-cou" data-toggle='modal' data-target='.modal-countries'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.cou') }}</div>
                <div id="sel-cou fs9">{{ mt._('statistics.selected.cou.all') }}</div>
              </div>
            </div>
          </div>
          {% if series|length > 0 and series[0] != "" %}
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.series') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-ser" data-toggle='modal' data-target='.modal-series'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.ser') }}</div>
                <div id="sel-ser fs9">{{ mt._('statistics.selected.ser.all') }}</div>
              </div>
            </div>
          </div>
          {% endif %}
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.zone') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-zon" data-toggle='modal' data-target='.modal-zones'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.zon') }}</div>
                <div id="sel-zon fs9">{{ mt._('statistics.selected.zon.all') }}</div>
              </div>
            </div>
          </div>
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.modeltype') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-mot" data-toggle='modal' data-target='.modal-modeltypes'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.mot') }}</div>
                <div id="sel-mot fs9">{{ mt._('statistics.selected.mot.all') }}</div>
              </div>
            </div>
          </div>
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.ordertype') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-ort" data-toggle='modal' data-target='.modal-ordertypes'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.ort') }}</div>
                <div id="sel-ort fs9">{{ mt._('statistics.selected.ort.all') }}</div>
              </div>
            </div>
          </div>
          <div class="col-12 col-lg-6 pb-20x">
            <div class="row">
              <div class="col-3 text-capitalize font-weight-bold pt-25x">{{ mt._('_common.genre') }}</div>
              <div class="col-3">
                <button type="button" class="btn btn-generic" id="btn-gen" data-toggle='modal' data-target='.modal-genres'>{{ mt._('_common.select') }}</button>
              </div>
              <div class="col-6 pt-15x">
                <div class="font-weight-bold">{{ mt._('statistics.selected.gen') }}</div>
                <div id="sel-gen fs9">{{ mt._('statistics.selected.gen.all') }}</div>
              </div>
            </div>
          </div>
        </div>
        <div class="row m-0 pt-20x">
          <div class="col-12">
            <div class="account-title" style="border-bottom:1px #eee solid">{{ mt._('statistics.selectperiod') }}</div>
          </div>
          <div class="col-12 pt-20x">
            <div class="form-group m-0">
              <label class="radio radio-container period-type text-uppercase my-0 mx-40x">
                <input type="radio" value="0" name="period_type" checked> {{ mt._('statistics.season') }}
                <span class="radio-checkmark"></span>
              </label>
              <label class="radio radio-container period-type text-uppercase my-0 mx-40x">
                <input type="radio" value="1" name="period_type"> {{ mt._('statistics.period') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
          </div>
        </div>
        <div class="row m-0 pt-40x" id="season-choose">
          <div class="col-12">
            <div class="row">
              <div class="col-4 col-lg-1 mb-20x">
                <div class="account-title text-capitalize pt-13x">{{ mt._('_common.season') }} 1</div>
              </div>
              <div class="col-8 col-lg-3 mb-20x">
                <div class="account-field {% if seasons|length > 0 %}form-element form-select{% endif %} mb-0">
                {% if seasons|length > 0 %}
                  <label class="form-custom-select">
                    <select id="season1" name="season1">
                      <option value="_none" selected>-</option>
                      {% for cdstag in seasons %}
                      <option value="{{ cdstag.cdstag }}">{{ cdstag.cdstag }}</option>
                      {% endfor %}
                    </select>
                  </label>
                {% else %}
                  <div class="pt-13x">{{ mt._('statistics.noseasons') }}</div>
                {% endif %}
                </div>
              </div>
              <div class="col-4 col-lg-1 mb-20x">
                <div class="account-title text-capitalize pt-13x">{{ mt._('_common.season') }} 2</div>
              </div>
              <div class="col-8 col-lg-3 mb-20x">
                <div class="account-field {% if seasons|length > 0 %}form-element form-select{% endif %} mb-0">
                {% if seasons|length > 0 %}
                  <label class="form-custom-select">
                    <select id="season2" name="season2">
                      <option value="_none" selected>-</option>
                      {% for cdstag in seasons %}
                      <option value="{{ cdstag.cdstag }}">{{ cdstag.cdstag }}</option>
                      {% endfor %}
                    </select>
                  </label>
                {% else %}
                  <div class="pt-13x">{{ mt._('statistics.noseasons') }}</div>
                {% endif %}
                </div>
              </div>
              <div class="col-4 col-lg-1 mb-20x">
                <div class="account-title text-capitalize pt-13x">{{ mt._('_common.season') }} 3</div>
              </div>
              <div class="col-8 col-lg-3 mb-20x">
                <div class="account-field {% if seasons|length > 0 %}form-element form-select{% endif %} mb-0">
                {% if seasons|length > 0 %}
                  <label class="form-custom-select">
                    <select id="season3" name="season3">
                      <option value="_none" selected>-</option>
                      {% for cdstag in seasons %}
                      <option value="{{ cdstag.cdstag }}">{{ cdstag.cdstag }}</option>
                      {% endfor %}
                    </select>
                  </label>
                {% else %}
                  <div class="pt-13x">{{ mt._('statistics.noseasons') }}</div>
                {% endif %}
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="row m-0 pt-40x" id="period-choose" style="display:none">
          <div class="col-12">
            <div class="row">
              <div class="col-12 col-lg-4 mb-20x">
                <input type="hidden" style="width:200px" name="period1" id="period1" class="form-control" value=""/>
                <div id="period1-box" class="row pull-right py-5x px-10x" style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:250px">
                  <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                  <div class='col-md-9 px-0'><span></span></div>
                  <div class='col-md-1 px-0'><b class="caret"></b></div>
                </div>
                <div class='pr-20x pull-right font-weight-bold' style="line-height:40px">{{ mt._('_common.period') }} 1</div>
              </div>
              <div class="col-12 col-lg-4 mb-20x">
                <input type="hidden" style="width:200px" name="period2" id="period2" class="form-control" value=""/>
                <div id="period2-box" class="row pull-right py-5x px-10x" style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:250px">
                  <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                  <div class='col-md-9 px-0'><span></span></div>
                  <div class='col-md-1 px-0'><b class="caret"></b></div>
                </div>
                <div class='pr-20x pull-right font-weight-bold' style="line-height:40px">{{ mt._('_common.period') }} 2</div>
              </div>
              <div class="col-12 col-lg-4 mb-20x">
                <input type="hidden" style="width:200px" name="period3" id="period3" class="form-control" value=""/>
                <div id="period3-box" class="row pull-right py-5x px-10x" style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:250px">
                  <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                  <div class='col-md-9 px-0'><span></span></div>
                  <div class='col-md-1 px-0'><b class="caret"></b></div>
                </div>
                <div class='pr-20x pull-right font-weight-bold' style="line-height:40px">{{ mt._('_common.period') }} 3</div>
              </div>
            </div>
          </div>
        </div>
        <div class="row m-0 py-20x">
          <div class="col-8"></div>
          <div class="col-4 text-right">
            <button type="button" class="btn btn-generic" id="elaborate">{{ mt._('statistics.elaborate') }}</button>
            <div class="msg-error">{{ mt._('statistics.time.error') }}</div>
          </div>
        </div>
      </div>
      <div id="send-filters-form" style="display:none"></div>
    </div>
  </div>
  {#
</div>
#}
