<script>
$(document).ready(function(){
  if ($('#chatting-user').html() == "") {
    $('#popup-send-area').hide();
  }
  $('.right-col').height($('.left-col').height());

  {% if curr_user != '' %}
  beautifyMessages();
  {% endif %}
  setTimeout(updateState, 1500);
});
function getTemplateLi(chat) {
  var html = "<li id='" + chat['user'] + "' class='listed-chat' data-lines='" + chat['lines'] + "' data-user='" + chat['user'] + "' data-initial-lines='" + chat['lines'] + "'>";
  html += "<a href='{{ url('support/index') }}/" + chat['user'] + "' class='font-weight-bold'>";
  html += "<i class='fa fa-user'></i>";
  html += "<span class='led-green' " + (!chat['isonline'] ? 'style="display:none"' : '') + "></span>";
  html += "<span class='chat-user'>" + chat['user']  + "</span>";
  html += "<span class='new-lines'>(" + chat['lines'] + ")</span>";
  html += "</a>";
  html += "</li>";

  return html;
}
function orderLiElements(a, b){
  return ($(b).data('user')) < ($(a).data('user')) ? 1 : -1;
}
{% if curr_user != '' %}
function getTemplateMessage(message){
  var longname = "{{ mt._('chat.support') }}";
  var shortname = longname.substring(0, 1).toUpperCase();
  var dt = new Date();
  var dtHours = dt.getHours() < 10 ? "0" + dt.getHours().toString() : dt.getHours();
  var dtMinutes = dt.getMinutes() < 10 ? "0" + dt.getMinutes().toString() : dt.getMinutes();
  var dtDate = dt.getDate() < 10 ? "0" + dt.getDate().toString() : dt.getDate();
  var dtMonth = dt.getMonth() < 9 ? "0" + (parseInt(dt.getMonth()) + 1).toString() : parseInt(dt.getMonth()) + 1;
  var currentTime = dtHours + ":" + dtMinutes + " " + dtDate + "-" + dtMonth + "-" + dt.getFullYear();
  var html = "<div class='popup-message' data-verse='in'><div class='user-avatar'>";
  html += "<div class='short-name'>" + shortname + "</div><div class='long-name'>" + longname + "</div>";
  html += "</div><div class='content in'><div class='message'>" + message + "</div>";
  html += "<div class='date'>" + currentTime + "</div></div></div>";

  return html;
}
function beautifyMessages(){
  $('.popup-message').each(function(){
    if ($(this).prev().data('verse') == $(this).data('verse')) {
      $(this).find('.support-avatar').remove();
      $(this).find('.user-avatar').remove();
      $(this).find('.content').addClass('no-caret');
    } else {
      $(this).css('margin-top', '20px');
    }
  });

  $("#popup-inner-container").scrollTop($("#popup-inner-container")[0].scrollHeight);
}
$("#popup-send-area .send").click(function(e){
  e.preventDefault();
  var text = $("#popup-send-area textarea").val().replace(/\n/g, "<br/>");
  $.ajax({
    type: "POST",
    url: "{{ url('support/addmessage') }}",
    data: {
      'message': text,
      'type': 'i',
      'user': "{{ curr_user }}"
    },
    dataType: "json",
    success: function(data){
      $("#popup-send-area textarea").val("");
      beautifyMessages();
    },
    error: function(x, t, m) {
  		printAjaxError(x, t, m);
    }
  });
});
$("#confirm-end-chat").click(function(e){
  $.ajax({
    type: "POST",
    url: "{{ url('support/deletechat') }}",
    data: {
      'user': "{{ curr_user }}"
    },
    dataType: "json",
    success: function(data){
      window.location = "{{ url('support/index') }}";
    },
    error: function(x, t, m) {
  		printAjaxError(x, t, m);
    }
  });
});
{% endif %}

function updateState() {
  var chats = [];
  var user = "{{ curr_user }}";
  var lines = 0;

  // Get current chats available on left columns
  $('.listed-chat').each(function(){
    chats.push([$(this).data('user'), $(this).data('lines')]);
    if ($(this).data('user') == user) {
      lines = $(this).data('lines');
    }
  });

  // Ajax to update state
  $.ajax({
    type: "POST",
    url: "{{ url('support/updatestate') }}",
    data: {
      user:  user,
      lines: lines
    },
    dataType: "json",
    success: function(data){
      // If new messaages, append to content and "beautify" them
      {% if curr_user != '' %}
      if (data['new_msg'] != '') {
        $("#popup-content").append(data['new_msg']);
        beautifyMessages();
      }
      {% endif %}

      // Check available chats
      var needSort = false;
      for (var i = 0; i < data['chats'].length; i++) {
        var curr_user = data['chats'][i];
        var curr_li   = $("#" + curr_user['user']);

        // If this chat is already available
        if (curr_li.length > 0) {
          // Update led activity
          if (curr_user['isonline']) {
            curr_li.find('.led-green').show();
          } else {
            curr_li.find('.led-green').hide();
          }

          // If this user is the one chatting, update his activity leds
          if (curr_user['user'] == "{{ curr_user }}") {
            if (curr_user['isonline']) {
              $('.popup-message .led-green').show();
            } else {
              $('.popup-message .led-green').hide();
            }
          }

          // Check if there are new messages
          var diff = curr_user['lines'] - curr_li.data('lines');
          if (diff > 0) {
            if (curr_user['user'] != user) {
              var initial_diff = curr_user['lines'] - curr_li.data('initial-lines');
              curr_li.find('.new-lines').html("(" + initial_diff + ")");
              curr_li.find('a').css('font-weight', 'bold');
            }
            curr_li.data('lines', curr_user['lines']);
          }
        } else {
          // If this chat is new append to left column and sort
          $(".nav.side-menu").append(getTemplateLi(curr_user));
          needSort = true;
        }
      }

      // Sort chats
      if (needSort) {
        $(".nav.side-menu li").sort(orderLiElements).appendTo('.nav.side-menu');
      }
    },
    complete: function() {
      // schedule the next request *only* when the current one is complete:
      setTimeout(updateState, 1500);
    },
    error: function(x, t, m) {
  		printAjaxError(x, t, m);
    }
  });
}

</script>
