<!-- Custom Theme Scripts -->
{# {{ javascript_include("js/vendor/owl.carousel.min.js") }} #}
{{ javascript_include("js/custom.js") }}

<script>
    $(function () {
        $('.change-language').click(function () {
            const language = $(this).data('lang');
            $('#country').val(language);

            $.ajax({
                type: 'POST',
                url: "{{ url('session/changelanguage') }}",
                dataType: 'json',
                data: {
                    language: language
                }
            }).done(function (data) {
                window.location.reload();
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });
        function validateInputsInSlide(slide) {
            let valid = true;
            $(':input', slide).each((idx, el) => {
                if (el.checkValidity()) {
                    $(el).removeClass('is-invalid');
                } else {
                    valid = false;
                    $(el).addClass('is-invalid');
                }
            });
            return valid;
        }
        $('.request-access').click(function () {
            $('#request-access-box').toggle();
            $('.pwm-field-icon').toggle();
        });
        $('#request-access-btn').click(function (e) {
            $(".msg-error").hide();
            $(".msg-success").hide();
            const btn = $(e.currentTarget);
            btn.prop('disabled', true).append('<i class="fa fa-fw fa-spinner fa-spin"></i>');
            var descri = $('#businessname').val();
            var dsetic = $('#signboard').val();
            var ivacfi = $('#vatcode').val();
            var indema = $('#email').val();
            var numtel = $('#telephone').val();
            var indiri = $('#address').val();
            var capind = $('#cap').val();
            var ccitta = $('#city').val();
            var dsnazi = $('#country option:selected').html();
            var provin = $('#province').val();
            // Marco 12.09.2022
            var codsid = $('#sidcode').val();
            var emapec = $('#emailpec').val();
            // Leonardo 15.11.2023
            var refname = $('#refname').val();
            var refnote = $('#refnote').val();
            var refemail = $('#refemail').val();
            var refntel = $('#refntel').val();

            // Samuele 28.06.2023
            var desragsoc1 = $('#desragsoc1').val();
            var desindi1 = $('#desindi1').val();
            var descap1 = $('#descap1').val();
            var descitta1 = $('#descitta1').val();
            var desdsnazi1 = $('#desdsnazi1 option:selected').html();
            var desprov1 = $('#desprov1').val();

            var desragsoc2 = $('#desragsoc2').val();
            var desindi2 = $('#desindi2').val();
            var descap2 = $('#descap2').val();
            var descitta2 = $('#descitta2').val();
            var desdsnazi2 = $('#desdsnazi2 option:selected').html();
            var desprov2 = $('#desprov2').val();

            var desragsoc3 = $('#desragsoc3').val();
            var desindi3 = $('#desindi3').val();
            var descap3 = $('#descap3').val();
            var descitta3 = $('#descitta3').val();
            var desdsnazi3 = $('#desdsnazi3 option:selected').html();
            var desprov3 = $('#desprov3').val();

            // Leonardo 22/11/2023
            // Prima facevamo un check sui valori dell'indirizzo di destinazione ... ora invece ho chiamato la funzione che chiamiamo per ogni step
            // if (descri == "" || ivacfi == "" || indema == "" || indiri == "" || ccitta == "" || provin == "" || desindi1 == "" || descitta1 == "" || desdsnazi1 == "" || desprov1 == "") {
            //     alert('invalid form');
            // } else {

            const slide = $(this).closest('.slide');
            if (validateInputsInSlide(slide)) {
                $.ajax({
                    type: 'POST',
                    url: "{{ url('session/saverequest') }}",
                    dataType: 'json',
                    data: {
                        descri: descri,
                        dsetic: dsetic,
                        ivacfi: ivacfi,
                        indema: indema,
                        numtel: numtel,
                        indiri: indiri,
                        capind: capind,
                        ccitta: ccitta,
                        dsnazi: dsnazi,
                        provin: provin,
                        codsid: codsid,
                        emapec: emapec,
                        refname: refname,
                        refnote: refnote,
                        refemail: refemail,
                        refntel: refntel,
                        desragsoc1: desragsoc1,
                        desindi1: desindi1,
                        descap1: descap1,
                        descitta1: descitta1,
                        desdsnazi1: desdsnazi1,
                        desprov1: desprov1,
                        desragsoc2: desragsoc2,
                        desindi2: desindi2,
                        descap2: descap2,
                        descitta2: descitta2,
                        desdsnazi2: desdsnazi2,
                        desprov2: desprov2,
                        desragsoc3: desragsoc3,
                        desindi3: desindi3,
                        descap3: descap3,
                        descitta3: descitta3,
                        desdsnazi3: desdsnazi3,
                        desprov3: desprov3
                    }
                }).done(function (data) {
                    // *********************************
                    // questo lo facciamo mandare da php
                    // facciamo un parametro sendMailNewRequestAccess -> mailtojs o PHP
                    // *********************************
                    {% if config.release.user == 'bed' %}
                    showTemporary(".msg-success", 5000, {gravity: 'top', style: {fontSize: '20px'}});
                    {% else %}
                    showTemporary(".msg-success", 5000, {gravity: 'top'});
                    {% endif %}
                    // Resettiamo il form e lo slider
                    $("#registration-request-form").get(0).reset();
                    $("#registration-request-form .registration-slider").data('step', 0);
                    $("#registration-request-form .slide:eq(0)").addClass('active').siblings('.active').removeClass('active');
                    btn.prop('disabled', false).find('.fa-spinner').remove();
                    {% if sendmailnewrequestaccess == 0 %}
                    var emailBody = "{{ mt._('account.customer.businessname') }}: " + descri + "\n";
                    emailBody += "{{ mt._('account.customer.signboard') }}: " + dsetic + "\n";
                    emailBody += "{{ mt._('account.customer.vatcode') }}: " + ivacfi + "\n";
                    emailBody += "Email: " + indema + "\n";
                    emailBody += "{{ mt._('account.customer.telephone') }}: " + numtel + "\n";
                    emailBody += "{{ mt._('account.customer.address') }}: " + indiri + "\n";
                    emailBody += "{{ mt._('account.customer.capzip') }}: " + capind + "\n";
                    emailBody += "{{ mt._('account.customer.city') }}: " + ccitta + "\n";
                    emailBody += "{{ mt._('account.customer.country') }}: " + dsnazi + "\n";
                    emailBody += "{{ mt._('account.customer.province') }}: " + provin + "\n";
                    emailBody += "{{ mt._('account.customer.sidcode') }}: " + codsid + "\n";
                    emailBody += "{{ mt._('account.customer.emailpec') }}: " + emapec + "\n";
                    emailBody += "***********************************************\n\n";
                    emailBody += "{{ mt._('account.customer.businessname') }}: " + desragsoc1 + "\n";
                    emailBody += "{{ mt._('account.customer.address') }}: " + desindi1 + "\n";
                    emailBody += "{{ mt._('account.customer.capzip') }}: " + descap1 + "\n";
                    emailBody += "{{ mt._('account.customer.city') }}: " + descitta1 + "\n";
                    emailBody += "{{ mt._('account.customer.province') }}: " + desprov1 + "\n";
                    emailBody += "{{ mt._('account.customer.country') }}: " + desdsnazi1 + "\n";
                    emailBody += "***********************************************\n\n";
                    emailBody += "{{ mt._('account.customer.businessname') }}: " + desragsoc2 + "\n";
                    emailBody += "{{ mt._('account.customer.address') }}: " + desindi2 + "\n";
                    emailBody += "{{ mt._('account.customer.capzip') }}: " + descap2 + "\n";
                    emailBody += "{{ mt._('account.customer.city') }}: " + descitta2 + "\n";
                    emailBody += "{{ mt._('account.customer.province') }}: " + desprov2 + "\n";
                    emailBody += "{{ mt._('account.customer.country') }}: " + desdsnazi2 + "\n";
                    emailBody += "***********************************************\n\n";
                    emailBody += "{{ mt._('account.customer.businessname') }}: " + desragsoc3 + "\n";
                    emailBody += "{{ mt._('account.customer.address') }}: " + desindi3 + "\n";
                    emailBody += "{{ mt._('account.customer.capzip') }}: " + descap3 + "\n";
                    emailBody += "{{ mt._('account.customer.city') }}: " + descitta3 + "\n";
                    emailBody += "{{ mt._('account.customer.province') }}: " + desprov3 + "\n";
                    emailBody += "{{ mt._('account.customer.country') }}: " + desdsnazi3 + "\n";
                    emailBody += "***********************************************\n\n";
                    emailBody += "{{ mt._('account.customer.autogenerated') }}";

                    window.location = 'mailto:' + indema + '?subject=' + encodeURIComponent("{{ mt._('login.requestregistration') }}") + '&body=' + encodeURIComponent(emailBody);
                    window.location = 'mailto:' + companyemail + '?subject=' + encodeURIComponent("{{ mt._('login.requestregistration') }}") + '&body=' + encodeURIComponent(emailBody);
                    {% else %}
                    /**
                     $.ajax({
                     type: 'POST',
                     url: "{{ url('session/emailrequestaccess') }}",
                     dataType: 'json',
                     data: {
                     emailBody: emailBody
                     }
                     }).done(function (data) {
                     showTemporary(".msg-success", 5000);
                     });
                     **/
                    {% endif %}
                }).error(function (x, t, m) {
                    printAjaxError(x, t, m);
                    {% if config.release.user == 'bed' %}
                    showTemporary(".msg-error", 5000, {gravity: 'top', style: {fontSize: '20px'}});
                    {% else %}
                    showTemporary(".msg-error", 5000, {gravity: 'top'});
                    {% endif %}
                    btn.prop('disabled', false).find('.fa-spinner').remove();
                });
            } else {
                btn.prop('disabled', false).find('.fa-spinner').remove();
            }
        });
        const slider = $('.registration-slider');
        slider
            .on('click', '.next-step,.prev-step', function (e) {
                const currentStep = parseInt(slider.data('step')) || 0;
                const btn = $(e.currentTarget);
                let goTo = currentStep;
                if (btn.hasClass('next-step')) {
                    const slide = $(btn).closest('.slide');
                    if (validateInputsInSlide(slide)) {
                        goTo = currentStep + 1;
                    }
                } else if ($(e.currentTarget).hasClass('prev-step')) {
                    goTo = currentStep - 1;
                }
                const slide = $(`> .slide:eq(${goTo})`, slider);
                if (slide.length > 0) {
                    slider.data('step', goTo);
                    slide.addClass('active').siblings('.active').removeClass('active');
                }
            })
            .on('click', '.copy-from-business', function (e) {
                const row = $(e.currentTarget).closest('.row');
                row.find('.control-businessname').val($('#businessname').val());
                row.find('.control-address').val($('#address').val());
                row.find('.control-cap').val($('#cap').val());
                row.find('.control-city').val($('#city').val());
                row.find('.control-country').val($('#country').val());
                row.find('.control-province').val($('#province').val());
            });
        $('#add-destination').click(function (e) {
            const row = $(e.currentTarget).closest('.row');
            row.siblings('.destination-template')
            const template = row.siblings('.destination-template');
            let currentDestinations = parseInt(template.data('count'));
            if (currentDestinations < 3) {
                currentDestinations++;
                template.data('count', currentDestinations);
                const clonedElement = template.clone();
                clonedElement.removeClass('destination-template');
                clonedElement.find('.destination-title .var').text(`#${currentDestinations}`);
                clonedElement.find(':input').each((idx, el) => {
                    const inputEl = $(el);
                    inputEl.val('');
                    inputEl.prop('required', false);
                    inputEl.prop('id', inputEl.prop('id').replace(/1/, currentDestinations));
                    inputEl.prop('name', inputEl.prop('name').replace(/1/, currentDestinations));
                });
                clonedElement.find('label').each((idx, el) => {
                    const labelEl = $(el);
                    labelEl.text(labelEl.text().replace(/\*/, ''));
                    labelEl.prop('for', labelEl.prop('for').replace(/1/, currentDestinations));
                });
                clonedElement.insertBefore(row);
            }

            if (currentDestinations > 2) {
                $(e.currentTarget).hide();
            }
        });
    });
</script>
