{% if exist_video %}
{{ javascript_include("https://vjs.zencdn.net/6.4.0/video.js", false) }}
{% endif %}

{% if not common['isOrder'] %}
{% include "scripts/common/new_order.volt" %}
{% endif %}

<script>
var jsInfo = {
	"cdartn":		"{{ model.cdartn }}",
	"currency":	"{{ common['currency'] }}",
	"isOrder": 	{{ common['isOrder'] ? 'true' : 'false' }},
	"videoExists": {{ exist_video ? 'true' : 'false' }},
	"currentColor": "{{ currentColor }}",
	"modelDetailStyle": {{ common['modelDetailStyle'] }},

	"loadRelatedUrl": "{{ url('model/ajax/loadRelated') }}",
	"loadRecentsUrl": "{{ url('model/ajax/loadRecents') }}",
	"getArticleImagesPreviewUrl": "{{ url('model/ajax/getArticleImagesPreview') }}",
	"getColorImagesPreviewUrl":		"{{ url('model/ajax/getColorImagesPreview') }}",
	"getCustomConfigurationWizardUrl": "{{ url('model/ajax/getCustomConfigurationWizard') }}",
	"getComponentImagesUrl": 		"{{ url('model/ajax/getComponentImages') }}",
	"getComponentMaterialUrl": 	"{{ url('model/ajax/getComponentMaterial') }}",
	"collectionUrl":						"{{ url('catalog/collection') }}",
	"loadFiltersUrl":						"{{ url('catalog/loadFiltersCollection') }}"
};
</script>
{{ javascript_include("js/custom/model_wizard.js") }}

<script>
{% if common['isOrder'] %}

{% if common['modelDetailStyle'] == 2 or common['modelDetailStyle'] == 4 %}

$('#current-fabric,#current-color,#current-variant').change(function(){
  if ($('#current-fabric').val() == '') {
    $('#current-configuration').html("-");
  } else {
    if ($('#current-color').val() == '') {
      $('#current-configuration').html("{{ mt._('_common.tissue') }}: " + $('#current-fabric').val());
    } else {
      if ($('#current-variant').val() == '') {
        $('#current-configuration').html("{{ mt._('_common.tissue') }}: " + $('#current-fabric').val() +
          " - {{ mt._('_common.colors') }}: " + $('#current-color').val());
      } else {
        $('#current-configuration').html("{{ mt._('_common.tissue') }}: " + $('#current-fabric').val() +
          " - {{ mt._('_common.colors') }}: " + $('#current-color').val() +
          " - {{ mt._('_common.variations') }}: " + $('#current-variant').val());
      }
    }
  }
});
$("#selected-fabric-image").bind("load", function() {
  if ($(this).attr('src') != '') {
    $('#selected-fabric-box').show();
  }
}).each(function() {
  if(this.complete) {
    //$(this).load(); // For jQuery < 3.0
    $(this).trigger('load'); // For jQuery >= 3.0
  }
});
$('#selected-fabric-link').click(function(){
  var href = $(this).find('a').attr('href');
  location.href = href;
});

$('.fabric-box').click(function(){

  {% if common['modelDetailStyle'] == 2 %}

  if ($('.fabric-box.selected').length == 0 || $(this).data('cdpers') != $('.fabric-box.selected').data('cdpers')) {
    $('.fabric-box.selected').removeClass('selected');
    $(this).addClass('selected');
    $('#current-fabric').val($(this).data('cdpers')).change();
    $('#next-step').removeClass('disabled');
    $('.color-box').hide();
    $('.color-box[data-cdpers="' + $(this).data('cdpers') + '"]').show();
    // Set selected fabric image
    $('#selected-fabric-image').prop('src', $(this).find('img').prop('src'));
    $('#selected-fabric-code').html($(this).find('.description').html());
    //$('#selected-fabric-composition span').prop('title', $(this).find('.composition span').data('original-title'));
    $('#selected-fabric-composition span').attr('data-original-title', $(this).find('.composition span').data('original-title'));
    $('#selected-fabric-link a').prop('href', '{{ url("catalog/fabricDetail") }}/' + $(this).data('cdpers'));
    $('[data-toggle="tooltip"]').tooltip();
    //$('#selected-fabric-box').show();
  } else {
    $(this).removeClass('selected');
    $('#current-fabric').val('').change();
    $('#next-step').addClass('disabled');
    $('.color-box').hide();
    // Remove selected fabric image
    $('#selected-fabric-image').prop('src', '');
    $('#selected-fabric-code').html('');
    $('#selected-fabric-composition span').prop('title', '');
    $('#selected-fabric-box').hide();
  }

  {% elseif common['modelDetailStyle'] == 4 %}

  var cdarti = $(this).data('cdarti');
  var cdpers = $(this).data('cdpers');
  if ($('.fabric-box.selected').length == 0 || $(this).data('cdpers') != $('.fabric-box.selected').data('cdpers')) {
    // Remove other selected fabric
    $('.fabric-box.selected').removeClass('selected');
    // Select clicked fabric
    $(this).addClass('selected');
    // Hide article previews and show color previews (only the one for current fabric)
    $('#article-previews').hide();
    $('#color-previews').show();
    $('#color-previews .preview-color-box').hide();
    $('#color-previews .preview-color-box[data-cdarti="' + cdarti + '"]').show();
    // Load article images for current fabric
    var element = $('.preview-fabric-box[data-cdarti="' + cdarti + '"]')
    loadArticleImages(element);
    // Set current fabric to form
    $('#current-fabric').val(cdpers).change();
    $('#next-step').removeClass('disabled');
    $('.color-box').hide();
    $('.color-box[data-cdpers="' + cdpers + '"]').show();
    // Set selected fabric image
    $('#selected-fabric-image').prop('src', $(this).find('img').prop('src'));
    $('#selected-fabric-code').html($(this).find('.description').html());
    //$('#selected-fabric-composition span').prop('title', $(this).find('.composition span').data('original-title'));
    $('#selected-fabric-composition span').attr('data-original-title', $(this).find('.composition span').data('original-title'));
    $('#selected-fabric-link a').prop('href', '{{ url("catalog/fabricDetail") }}/' + cdpers);
    $('[data-toggle="tooltip"]').tooltip();
    //$('#selected-fabric-box').show();
		{% if common['quickNavigation'] == 1 %}
		$('#next-step').click();
		{% endif %}
  } else {
    // Unselect current fabric
    $(this).removeClass('selected');
    // Hide color previews and show article previews
    $('#color-previews').hide();
    $('#article-previews').show();
    // Hide main image for colors and articles and show for model
    $('#article-images').hide();
    $('#color-images').hide();
    $('#images-preloader').hide();
    $('#model-images').show();
    // Unset fabric
    $('#current-fabric').val('').change();
    $('#next-step').addClass('disabled');
    $('.color-box').hide();
    // Remove selected fabric image
    $('#selected-fabric-image').prop('src', '');
    $('#selected-fabric-code').html('');
    $('#selected-fabric-composition span').prop('title', '');
    $('#selected-fabric-box').hide();
  }
  {% endif %}
});

$('.color-box').click(function(){
  var id = $(this).find('img').data('id');
  if ($(this).hasClass('selected')) {
    $('#little-' + id).hide();
    $(this).removeClass('selected');
  } else {
    $('#little-' + id).show();
    $(this).addClass('selected');
  }

  if ($('.color-box.selected').length == 0) {
    $('#current-color').val('').change();
    $('#next-step').addClass('disabled');
  } else {
    $('#tot-colors').html($('.color-box.selected').length + " " + ($('.color-box.selected').length == 1 ? "{{ mt._('_common.article') }}" : "{{ mt._('_common.articles') }}"));
    var colors = '';
    $('.color-box.selected').each(function(){
      colors += $(this).data('cdcolo') + ', ';
    });
    $('#current-color').val(colors.slice(0,-2)).change();
    $('#next-step').removeClass('disabled');
  }
});
$('.variant-box').click(function(){
  var currentTpvari = $(this).data('tpvari');

  if ($(this).hasClass('selected')) {
    $(this).removeClass('selected');
  } else {
    $('.variant-box[data-tpvari="' + currentTpvari + '"]').removeClass('selected');
    $(this).addClass('selected');
  }

  if ($('.variant-box.selected').length == 0) {
    $('#current-variant').val('').change();
  } else {
    var variants = '';
    $('.variant-box.selected').each(function(){
      variants += $(this).data('cdvari');
    });
    $('#current-variant').val(variants).change();
  }
});

$('#previous-step').click(function(){
  var currentStep = $('.main-step:visible').data('step');
  var currentTarget = $('.main-step:visible').data('target');

  var prevStep = currentStep - 1;
  var prevStepHeader = $('.main-step[data-step=' + prevStep + ']');
  if (prevStepHeader.length == 1) {
    var prevTarget = prevStepHeader.data('target');

    $('.' + currentTarget + '-box').removeClass('selected');
    $('#current-' + currentTarget).val('').change();

    $('.step-header-' + currentTarget).hide();
    $('.step-header-' + prevTarget).show();

    $('#' + currentTarget + '-selector').hide();
    $('#' + prevTarget + '-selector').show();

    $('.stepper.step-' + currentTarget).removeClass('selected').addClass('disabled');
    $('.stepper.step-' + prevTarget).removeClass('disabled').addClass('selected');

    $('#next-step').html("{{ mt._('_common.forward') }}");
    $('#next-step').removeClass('disabled');
    if (prevStep == 1) {
      $('#selected-color-box img').hide();
      $('#previous-step').addClass('disabled');
    }
  }
});
$('#next-step').click(function(){
  var currentStep = $('.main-step:visible').data('step');
  var currentTarget = $('.main-step:visible').data('target');

  // If current step is different from 'variant', selection must be not empty
  if (currentTarget == 'variant' || ($('#current-' + currentTarget).val() != null && $('#current-' + currentTarget).val() != '')) {
    var nextStep = currentStep + 1;
    var nextStepHeader = $('.main-step[data-step=' + nextStep + ']');
    if (nextStepHeader.length == 1) {
      var nextTarget = nextStepHeader.data('target');

      $('.step-header-' + currentTarget).hide();
      $('.step-header-' + nextTarget).show();

      $('#' + currentTarget + '-selector').hide();
      $('#' + nextTarget + '-selector').show();

      $('.stepper.step-' + currentTarget).removeClass('selected');
      $('.stepper.step-' + nextTarget).removeClass('disabled').addClass('selected');

      $('#previous-step').removeClass('disabled');

      var nextNextStep = nextStep + 1;
      if ($('.main-step[data-step=' + nextNextStep + ']').length == 0) {
        $('#next-step').html("{{ mt._('_common.addtocart') }}");

        loadSizeContent();
      } else if (nextTarget != 'variant') {
        $('#next-step').addClass('disabled');
      }
    }
  } else if (currentTarget == 'size') {
    // Add to cart button
    var success = $('.wizard-stepper .success-box');
    var error = $('.wizard-stepper .unsuccess-box');
    success.hide();
    error.hide()

    var cdpers = $('#current-fabric').val();
    var cdvari = $('#current-variant').val();

    var qtamin = {{ regqtm['qtamin'] }};
    var qtamul = {{ regqtm['qtamul'] }};

		var occorp = [];
    var ocasso = [];
    var regqtmError = false;
    $('.wizard-list-row').each(function(){
			var octagl = [];
      var ocasso = [];
      var totQty = 0;
      $(this).find('.input-number').each(function(){
        var input = $(this);
				var isSize = $(this).data('issize');
				var looseQty = input.val() > 0 ? (isSize ? parseInt(input.val()) : $(this).data('quanti') * parseInt(input.val())) : 0;
				var assortmentQty = input.val() > 0 ? parseInt(input.val()) : 0;
        totQty += parseInt(looseQty);
				if (isSize) {
					octagl.push({
						taglia: input.data('taglia'),
						prezzo: input.data('prezzo'),
						quanti: looseQty,
						sconto: input.data('sconto')
					});
				} else {
					ocasso.push({
						cdasso: input.data('cdasso'),
						quanti: assortmentQty
					});
				}
      });

      if (totQty == 0 || (totQty >= qtamin && ((totQty - qtamin) % qtamul == 0))) {
        occorp.push({
          cdcolo: $(this).data('cdcolo'),
          quanti: totQty,
          octagl: octagl,
					ocasso: ocasso
        });
      } else {
        regqtmError = true;
        $('.modal-wizard-regqtm').modal('show');
        return false;
      }
    });

    // Accept empty rows, Check rules if rows are not empty
    if (!regqtmError) {
      $.ajax({
        type: "POST",
        url: "{{ url('model/ajax/saveOrderRowsFromFabricWizard') }}",
        dataType: "json",
        data: {
          nuordc: "{{ common['order_info'].nuordc }}",
          cdcata: "{{ common['order_info'].cdcata }}",
          cdartn: "{{ model.cdartn }}",
          occorp: occorp,
          cdpers: cdpers,
          cdvari: cdvari,
        }
      }).done(function(data) {
        if (data != 'OC' && data != 'DT' && data != 'NT' && data != 'OA') {
          success.fadeIn();
          setTimeout( function(){
            success.fadeOut();
          }, 10000 );
          updateShoppingBag(data['tot']);
        }
      }).error(function(x, t, m) {
        printAjaxError(x, t, m);
        error.fadeIn();
        setTimeout( function(){
          error.fadeOut();
        }, 10000 );
      });
    }
  }
});

$("#back-to-catalog").click(function(){
  $('#warning-action').val('BKCT');
});
$("#new-configuration").click(function(){
  $('#warning-action').val('NWCF');
});
$("#btn-confirm-wizard").click(function(){
  if ($('#warning-action').val() =='BKCT') {
  {% if common['catalogAccessType'] == 0 %}
    {% if currentFabric != '' %}
    location.href = "{{ url('catalog/fabricDetail/' ~ currentFabric.cdpers) }}";
    {% else %}
      {% set catalogUrl = 'catalog/collection' ~ (ctg_vt != "all" ? "/" ~ ctg_br : "") ~ (ctg_vt == "linmod" ? "/" ~ ctg_ln : "") %}
    location.href = "{{ url(catalogUrl) }}";
    {% endif %}
  {% else %}
    location.href = "{{ url('catalog/list') }}";
  {% endif %}
  } else if ($('#warning-action').val() =='NWCF') {
    $('.modal-wizard-warning').modal('hide');
    goToFabricStep(true);
  }
});

$('.step-fabric').click(function(){
  if (!$(this).hasClass('disabled')) {
    goToFabricStep(false);
  }
});
$('.step-color').click(function(){
  if (!$(this).hasClass('disabled')) {
    goToColorStep();
  }
});
$('.step-variant').click(function(){
  if (!$(this).hasClass('disabled')) {
    goToVariantStep();
  }
});

function goToFabricStep(resetFabric) {
  $('.color-box').removeClass('selected');
  $('#current-color').val('').change();
  $('.variant-box').removeClass('selected');
  $('#current-variant').val('').change();
  $('.size-box').removeClass('selected');
  $('#current-size').val('').change();

  $('#selected-color-box img').hide();

  if (resetFabric) {
    $('.fabric-box').removeClass('selected');
    $('#current-fabric').val('').change();
  }

  $('.step-header-color').hide();
  $('.step-header-variant').hide();
  $('.step-header-size').hide();
  $('.step-header-fabric').show();

  $('#color-selector').hide();
  $('#variant-selector').hide();
  $('#size-selector').hide();
  $('#fabric-selector').show();

  $('.stepper.step-color').removeClass('selected').addClass('disabled');
  $('.stepper.step-variant').removeClass('selected').addClass('disabled');
  $('.stepper.step-size').removeClass('selected').addClass('disabled');
  $('.stepper.step-fabric').removeClass('disabled').addClass('selected');

  $('#next-step').html("{{ mt._('_common.forward') }}");
  $('#next-step').removeClass('disabled');
  $('#previous-step').addClass('disabled');
}
function goToColorStep() {
  $('.variant-box').removeClass('selected');
  $('#current-variant').val('').change();
  $('.size-box').removeClass('selected');
  $('#current-size').val('').change();

  $('.step-header-variant').hide();
  $('.step-header-size').hide();
  $('.step-header-color').show();

  $('#variant-selector').hide();
  $('#size-selector').hide();
  $('#color-selector').show();

  $('.stepper.step-variant').removeClass('selected').addClass('disabled');
  $('.stepper.step-size').removeClass('selected').addClass('disabled');
  $('.stepper.step-color').removeClass('disabled').addClass('selected');

  $('#next-step').html("{{ mt._('_common.forward') }}");
  $('#next-step').removeClass('disabled');
  $('#previous-step').removeClass('disabled');
}
function goToVariantStep() {
  $('.size-box').removeClass('selected');
  $('#current-size').val('').change();

  $('.step-header-size').hide();
  $('.step-header-variant').show();

  $('#size-selector').hide();
  $('#variant-selector').show();

  $('.stepper.step-size').removeClass('selected').addClass('disabled');
  $('.stepper.step-variant').removeClass('disabled').addClass('selected');

  $('#next-step').html("{{ mt._('_common.forward') }}");
  $('#next-step').removeClass('disabled');
  $('#previous-step').removeClass('disabled');
}
function loadSizeContent() {
  $('#size-content').html('');
	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/getSizesForFabricWizard') }}",
		dataType: "json",
		data: {
      cdpers: $('#current-fabric').val(),
      cdcolo: $('#current-color').val(),
      cdartn: "{{ model.cdartn }}",
      cdvari: $('#current-variant').length == 1 ? $('#current-variant').val() : '',
		}
	}).done(function(data) {
    if (data['response'] == 'OK') {
      $('#size-content').html(data['html']);
			$('[data-toggle="tooltip"]').tooltip();
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
}

{% elseif common['modelDetailStyle'] in [3, 5] %}

function updateColors() {
  if ($('.little-color-box:visible').length == 0) {
    $('#current-color').val('').change();
    $('#next-step').addClass('disabled');
  } else {
    var colors = '';
    $('.little-color-box:visible').each(function(){
      {% if common['modelDetailStyle'] == 3 %}
      if ($(this).hasClass('no-img')) {
        colors += $(this).data('dsarti') + ', ';
      } else {
        colors += $(this).data('cdcolo') + ', ';
      }
      {% else %}
      colors += $(this).data('cdarti') + ', ';
      {% endif %}
    });
    $('#current-color').val(colors.slice(0,-2)).change();
    $('#next-step').removeClass('disabled');
  }
}

$('#current-color').change(function(){
  if ($('#current-color').val() == '') {
    $('#current-configuration').html("-");
  } else {
    $('#current-configuration').html("{{ mt._('_common.variations') }}: " + $('#current-color').val());
  }
});
$('#all-variants-container').on('click', '.color-box', function(){
  if ($(this).hasClass('ask-delete')) {
    $('.modal-delete-order-row').modal('show');
    $('#delete-row-cdarti').val($(this).data('cdarti'));
  } else {
    var id = $(this).data('id');
    if ($(this).hasClass('selected')) {
      $('#little-' + id).hide();
      $(this).removeClass('selected');
    } else {
      $('#little-' + id).show();
      $(this).addClass('selected');
    }

    updateColors();
  }
});
$('#btn-confirm-delete-row').click(function(){
  var cdarti = $('#delete-row-cdarti').val();
  $.ajax({
    type: "POST",
    url: "{{ url('model/ajax/deleteOrderRowFromArticleWizard') }}",
    dataType: "json",
    data: {
      nuordc: "{{ common['order_info'].nuordc }}",
      cdarti: cdarti,
    }
  }).done(function(data) {
    $('.color-box[data-cdarti="' + cdarti + '"]').removeClass('selected');
    $('.color-box[data-cdarti="' + cdarti + '"]').removeClass('ask-delete');
    $('.little-color-box[data-cdarti="' + cdarti + '"]').hide();
    $('.modal-delete-order-row').modal('hide');
    updateColors();
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
    error.fadeIn();
    setTimeout( function(){
      error.fadeOut();
    }, 10000 );
  });
});
$('#selected-color-box').on('click', '.little-color-box', function(){
  if (!$(this).hasClass('disabled') && !$(this).hasClass('selected')) {
    $('.little-color-box').removeClass('selected');
    $(this).addClass('selected');
    $('.color-features').hide();
    $('#feature-' + $(this).data('id')).show();
  }
});

function checkStep(step) {
  if (step == 1) {
    $('#create-anaart').show();
  } else {
    $('#create-anaart').hide();
  }

  if (step == 2) {
    var preview = $('#selected-color-box').find('.little-color-box:visible:first');
    preview.addClass('selected');
    {% if common['modelDetailStyle'] == 3 %}
    var code = preview.hasClass('no-img') ? preview.data('cdarti') : preview.data('cdcolo');
    {% else %}
    var code = preview.data('cdarti');
    {% endif %}
    $('#feature-' + code).show();
    $('.little-color-box').removeClass('disabled');
  } else {
    $('.little-color-box').removeClass('selected');
    $('.color-features').hide();
    $('.little-color-box').addClass('disabled');
  }
}

$('#previous-step').click(function(){
  var currentStep = $('.main-step:visible').data('step');
  var currentTarget = $('.main-step:visible').data('target');

  var prevStep = currentStep - 1;
  var prevStepHeader = $('.main-step[data-step=' + prevStep + ']');
  if (prevStepHeader.length == 1) {
    var prevTarget = prevStepHeader.data('target');

    $('.' + currentTarget + '-box').removeClass('selected');
    $('#current-' + currentTarget).val('').change();

    $('.step-header-' + currentTarget).hide();
    $('.step-header-' + prevTarget).show();

    $('#' + currentTarget + '-selector').hide();
    $('#' + prevTarget + '-selector').show();

		{% if common['modelDetailStyle'] == 3 %}
		if (prevTarget == 'color') {
			$("#search-article-wizard").closest('.menu-icon').show();
		}
		{% endif %}

    $('.stepper.step-' + currentTarget).removeClass('selected').addClass('disabled');
    $('.stepper.step-' + prevTarget).removeClass('disabled').addClass('selected');

    $('#next-step').html("{{ mt._('_common.forward') }}");
    $('#next-step').removeClass('disabled');

    checkStep(prevStep);
  }
});
$('#next-step').click(function(){
  var currentStep = $('.main-step:visible').data('step');
  var currentTarget = $('.main-step:visible').data('target');

	{% if common['modelDetailStyle'] == 3 %}
	$("#search-article-wizard").closest('.menu-icon').hide();
	{% endif %}

  if (currentTarget == 'size') {
    // Add to cart button
    var success = $('.wizard-stepper .success-box');
    var error = $('.wizard-stepper .unsuccess-box');
    success.hide();
    error.hide()

    var colors = $('#current-color').val();

    var qtamin = {{ regqtm['qtamin'] }};
    var qtamul = {{ regqtm['qtamul'] }};

    var occorp = [];
    var regqtmError = false;
    $('.wizard-list-row').each(function(){
			var octagl = [];
      var ocasso = [];
      var totQty = 0;
      $(this).find('.input-number').each(function(){
        var input = $(this);
				var isSize = $(this).data('issize');
				var looseQty = input.val() > 0 ? (isSize ? parseInt(input.val()) : $(this).data('quanti') * parseInt(input.val())) : 0;
				var assortmentQty = input.val() > 0 ? parseInt(input.val()) : 0;
        totQty += parseInt(looseQty);
				if (isSize) {
					octagl.push({
						taglia: input.data('taglia'),
						prezzo: input.data('prezzo'),
						quanti: looseQty,
						sconto: input.data('sconto')
					});
				} else {
					ocasso.push({
						cdasso: input.data('cdasso'),
						quanti: assortmentQty
					});
				}
      });

      if (totQty == 0 || (totQty >= qtamin && ((totQty - qtamin) % qtamul == 0))) {
        occorp.push({
          cdarti: $(this).data('cdarti'),
          cdcolo: $(this).data('cdcolo'),
          quanti: totQty,
					octagl: octagl,
          ocasso: ocasso
        });
      } else {
        regqtmError = true;
        $('.modal-wizard-regqtm').modal('show');
        return false;
      }
    });

    // Accept empty rows, Check rules if rows are not empty
    if (!regqtmError) {
      $.ajax({
        type: "POST",
        url: "{{ url('model/ajax/saveOrderRowsFromArticleWizard') }}",
        dataType: "json",
        data: {
          nuordc: "{{ common['order_info'].nuordc }}",
          cdcata: "{{ common['order_info'].cdcata }}",
          cdartn: "{{ model.cdartn }}",
          occorp: occorp,
					fldbrw: {{ common['order_info'].fldbrw }},
        }
      }).done(function(data) {
        if (data != 'OC' && data != 'DT' && data != 'NT' && data != 'OA') {
          success.fadeIn();
          setTimeout( function(){
            success.fadeOut();
          }, 10000 );
          updateShoppingBag(data['tot']);
        }
      }).error(function(x, t, m) {
        printAjaxError(x, t, m);
        error.fadeIn();
        setTimeout( function(){
          error.fadeOut();
        }, 10000 );
      });
    }
  } else {
    {% if common['modelDetailStyle'] == 5 %}
    $('#feature-custom').hide();
    $('#all-variants-container').show();
    {% endif %}

    var nextStep = currentStep + 1;
    var nextStepHeader = $('.main-step[data-step=' + nextStep + ']');
    if (nextStepHeader.length == 1) {
      var nextTarget = nextStepHeader.data('target');

      $('.step-header-' + currentTarget).hide();
      $('.step-header-' + nextTarget).show();

      $('#' + currentTarget + '-selector').hide();
      $('#' + nextTarget + '-selector').show();

      $('.stepper.step-' + currentTarget).removeClass('selected');
      $('.stepper.step-' + nextTarget).removeClass('disabled').addClass('selected');

      $('#previous-step').removeClass('disabled');

      checkStep(nextStep);

      var nextNextStep = nextStep + 1;
      if ($('.main-step[data-step=' + nextNextStep + ']').length == 0) {
        $('#next-step').html("{{ mt._('_common.addtocart') }}");
        loadSizeContent();
      } else if (nextTarget != 'feature') {
        $('#next-step').addClass('disabled');
      }
    }
  }
});

{% if common['modelDetailStyle'] == 3 %}

$('#save-custom').click(function(){
  saveNewCustom();
});
function getNewCustomFeatures() {
  var features = [];
  $('.custom-feature').each(function(){
    if ($(this).val() != '') {
      features.push([
        $(this).data('tpcomp'),
        $(this).val(),
        $(this).data('dscomp')
      ]);
    }
  });

  return features;
}
function saveNewCustom() {
  $('.custom-feature-result').hide();
  var cdcolo = $('.little-color-box:first').data('cdcolo');

  $.ajax({
    type: "POST",
    url: "{{ url('model/ajax/saveCustomArticle') }}",
    dataType: "json",
    data: {
      cdartn: "{{ model.cdartn }}",
      cdcolo: cdcolo,
      features: getNewCustomFeatures()
    }
  }).done(function(data) {
    if (data['response'] == 'OK') {
      addCustom(data['cdarti'], data['dsarti'], cdcolo);
		  $('#variants-title').show();
		  $('#personalization-title').hide();
		  $('#personalization-detail').hide();
			$('#color-selector .title').show();
    }
  }).error(function(x, t, m) {
    showTemporary('.msg-error.custom-feature-result', 5000);
    printAjaxError(x, t, m);
  });
}
function addCustom(cdarti, dsarti, cdcolo) {
  // Update features descriptions panel
  var html = "<div id='feature-" + cdarti + "' class='color-features' style='display:none'>";
  html += "<div class='row m-0'>";
  html += "<div class='col-12 text-center font-weight-bold'>{{ mt._('_common.variant') }} " + dsarti + "</div>";
  html += "</div>";
  var features = getNewCustomFeatures();
  var title = '';
  for (var i = 0; i < features.length; i++) {
    title += '<b>' + features[i][2] + ':</b> ' + $('<div/>').text(features[i][1]).html();
    title += i != features.length - 1 ? '<br/>' : '';

    html += '<div class="row m-0">';
    html += '<div class="col-3 text-right">' + features[i][2] + '</div>';
    html += '<div class="col-9 font-weight-bold">' + features[i][1] + '</div>';
    html += '</div>';
  }
  html += "</div>";
  $('#feature-selector').append(html);

  // Update all-variants container
  var description = "{{ mt._('_common.variant') }} " + dsarti;
  html = '<div class="color-box selected" data-id="' + cdarti + '" data-cdcolo="' + cdcolo + '" data-cdarti="' + cdarti + '">';
  html += '<div class="check"><i class="fa fa-check"></i></div>';
  html += '<div class="no-img" data-toggle="tooltip" data-placement="top" title="' + title + '"><div>' + dsarti + '</div></div>';
  html += '<div class="description" title="' + description + '">' + description + '</div>';
  html += '</div>';
  $('#all-variants-container').append(html);
  $('[data-toggle="tooltip"]').tooltip({ html: true });

  // Update little boxes
  html = "<div id='little-" + cdarti + "' class='little-color-box no-img disabled' ";
  html += "data-id='" + cdarti + "' data-cdcolo='" + cdcolo + "' data-dsarti='{{ mt._('_common.variant') }} " + dsarti + "' ";
  html += "data-cdarti='" + cdarti + "'>";
  html += dsarti + "</div>";
  $('.little-color-box').removeClass('selected');
  $('#selected-color-box').append(html);
  updateColors();

  // Hide form and show all variants
  $('#feature-custom').hide();
  $('#feature-custom').find('input').val('');
  $('#all-variants-container').show();
}
function fillExistingCustom() {
  $('#existing-custom').find('.row').hide();

  var selectedOption = $('#existing-variant').find('option:selected');
  var numFeatures = selectedOption.data('num-features');

  for (var i = 0; i < numFeatures; i++) {
    $('#ex-' + selectedOption.data('tpcomp' + i)).show();
    $('#ex-' + selectedOption.data('tpcomp' + i)).find('.existing-value').html(selectedOption.data('valore' + i));
  }
}
function addExistingCustom(cdarti, dsarti) {
  addCustom(cdarti, dsarti, false);

  // Remove current existing custom from select
  $('#existing-variant').find('option[value="' + $('#existing-variant').val() + '"]').hide();
  $('#existing-variant').find('option[value="' + $('#existing-variant').val() + '"]').addClass('disabled');
  $('#existing-variant').find('option:not(".disabled"):first').prop('selected', true);
  if ($('#existing-variant').find('option:not(".disabled")').length == 0) {
    $('#existing-variant').val('');
    $('#cancel-custom').hide();
    $('#save-custom').hide();
  }
  $('#existing-variant').change();
}

$('#existing-variant').change(function(){
  fillExistingCustom();
});

function loadSizeContent() {
  $('#size-content').html('');
  var articles = [];
  $('.little-color-box:visible').each(function(){
    articles.push($(this).data('cdarti'));
  });

	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/getSizesForArticleWizard') }}",
		dataType: "json",
		data: {
      cdartn: "{{ model.cdartn }}",
      articles: articles
		}
	}).done(function(data) {
    if (data['response'] == 'OK') {
      // Set size content min and max width to fit sizes
      var minWidth = 60 + ((data['sizes']) * 50) + 60 + 120;
      $('#size-content').css('min-width', minWidth + 'px');
      // Set size content
      $('#size-content').html(data['html']);
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
}

$("#btn-confirm-wizard").click(function(){
{% if common['catalogAccessType'] == 0 %}
  {% set catalogUrl = 'catalog/collection' ~ (ctg_vt != "all" ? "/" ~ ctg_br : "") ~ (ctg_vt == "linmod" ? "/" ~ ctg_ln : "") %}
  location.href = "{{ url(catalogUrl) }}";
{% else %}
  location.href = "{{ url('catalog/list') }}";
{% endif %}
});

{% else %}{# else common['modelDetailStyle'] != 5 #}

$('#save-custom').click(function(){
  $('.custom-feature-result').hide();
  var ocperc = [];
  $('.selector-component-container').each(function(){
    var element = '';
    var tpcomp = $(this).data('tpcomp');

    if ($(this).data('checkable') != 0) {
      if ($(this).data('multilevel') != 1) {
        if ($(this).find('select.selectpicker option:selected').length == 1) {
          element = $(this).find('select.selectpicker option:selected');
        } else if ($(this).find('.component-box.selected').length == 1) {
          element = $(this).find('.component-box.selected');
        }
      } else {
        var cdmatn = $(this).find('select.selectpicker option:selected').data('code');
        element = $(this).find('.selector-component-container[data-cdmatn="' + cdmatn + '"] .component-box.selected');
      }
      var cdmate = $(element).data('code');
      ocperc.push({ tpcomp, cdmate });
    }
  });

	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/saveNewCustomFromConfigurator') }}",
		dataType: "json",
		data: {
      nuordc: "{{ common['order_info'].nuordc }}",
      cdartn: "{{ model.cdartn }}",
      ocperc: ocperc
		}
	}).done(function(data) {
    if (data['response'] == 'OK') {
      addCustom(data['seqrap'], data['prezzo'], data['components']);
    } else if (data['response'] == 'DP') {
      showTemporary('.msg-error.custom-feature-result', 5000);
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});
function addCustom(seqrap, prezzo, components) {
  // Update features descriptions panel
  var html = "<div id='feature-{{ model.cdartn }}-C" + seqrap + "' class='color-features' style='display:none'>";
  html += "<div class='row m-0'>";
  html += "<div class='col-12 text-center font-weight-bold'>{{ model.cdartn }}-C" + seqrap + "</div>";
  html += "</div>";

  var title = '';
  for (var i = 0; i < components.length; i++) {
    var dsmate = $('<div/>').text(components[i].dsmate).html();
    title += '<b>' + components[i].dscomp + ':</b> ' + dsmate;
    title += i != components.length - 1 ? '<br/>' : '';

    html += '<div class="row m-0">';
    html += '<div class="col-4 text-right">' + components[i].dscomp + '</div>';
    html += '<div class="col-8">';
    html += '<div class="float-left pr-15x">' + components[i].flimagHtml + '</div>';
    html += '<div class="float-left font-weight-bold">' + dsmate + '</div>';
    html += '</div>';
    html += '</div>';
  }
  html += "</div>";
  $('#feature-selector').append(html);

  // Update all-variants container
  html = '<div class="color-box selected" data-id="{{ model.cdartn }}-C' + seqrap + '" ';
  html += 'data-cdcolo="{{ model.cdartn }}-C' + seqrap + '" data-cdarti="{{ model.cdartn }}-C' + seqrap + '">';
  html += '<div class="check"><i class="fa fa-check"></i></div>';
  html += '<img src="{{ elements.getModelImageUrl(model.flimag) }}" alt="{{ model.cdartn }}-C' + seqrap + '" ';
  html += 'data-toggle="tooltip" data-placement="top" title="' + title + '">';
  html += '<div class="description" style="line-height:20px" title="{{ model.cdartn }}-C' + seqrap + '">{{ model.cdartn }}-C' + seqrap + '<br/>';
  html += prezzo.formatMoney(2, ",", ".") + " {{ currency }}" + '</div>';
  html += '</div>';
  $('#all-variants-container').append(html);
  $('[data-toggle="tooltip"]').tooltip({ html: true });

  // Update little boxes
  html = "<div id='little-{{ model.cdartn }}-C" + seqrap + "' class='little-color-box disabled' ";
  html += "data-id='{{ model.cdartn }}-C" + seqrap + "' data-cdcolo='{{ model.cdartn }}-C" + seqrap + "' data-cdarti='{{ model.cdartn }}-C" + seqrap + "'>";
  html += "<img src='{{ elements.getModelImageUrl(model.flimag) }}' alt='{{ model.cdartn }}-C" + seqrap + "' ";
  html += "title='{{ model.cdartn }}-C" + seqrap + "' style='margin:0'></div>";

  $('.little-color-box').removeClass('selected');
  $('#selected-color-box').append(html);
  updateColors();

  // Hide form and show all variants
  $('#feature-custom').hide();
  $('#all-variants-container').show();
	$('#color-selector .title').show();
}
function loadSizeContent() {
  $('#size-content').html('');
  var articles = [];
  $('.little-color-box:visible').each(function(){
    articles.push($(this).data('cdarti'));
  });

	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/getSizesForConfiguratorWizard') }}",
		dataType: "json",
		data: {
      cdartn: "{{ model.cdartn }}",
      articles: articles
		}
	}).done(function(data) {
    if (data['response'] == 'OK') {
      // Set size content min and max width to fit sizes
      var minWidth = 50 + 50 + ((data['sizes']) * 40) + 50 + 100;
      $('#size-content').css('min-width', minWidth + 'px');
      // Set size content
      $('#size-content').html(data['html']);
      $('[data-toggle="tooltip"]').tooltip({ html: true });
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
}

{% endif %}{# endif common['modelDetailStyle'] != 5 #}

{% endif %}{# endif common['modelDetailStyle'] in [3, 5] #}

{% endif %}{# endif common['isOrder'] #}
</script>
