{% if exist_video %}
{{ javascript_include("https://vjs.zencdn.net/6.4.0/video.js", false) }}
{{ javascript_include("js/model_index_video.js") }}
{% endif %}

{#
{{ javascript_include("js/blowup.js") }}
#}

{% if not common['isOrder'] %}
{% include "scripts/common/new_order.volt" %}
{% else %}
{% include "scripts/common/barcode.volt" %}
{% endif %}

<script>
var jsInfo = {
	"nuordc": "{{ common['isOrder'] ? common['order_info'].nuordc : '' }}",
	"cdcata": "{{ common['isOrder'] ? common['order_info'].cdcata : '' }}",
	"cdartn": "{{ model.cdartn }}",
	"cdarti": "{{ model.cdarti is defined ? model.cdarti : '' }}",
	"tppers": "{{ model.tppers }}",
	"cdtagl": "{{ model.cdtagl }}",
	"cdcolo": "{{ cdcolo is defined ? cdcolo : '' }}",
	"videoExists": {{ exist_video ? 'true' : 'false' }},
	"modelDetailStyle": {{ common['modelDetailStyle'] }},
	"isOrder": {{ common['isOrder'] ? 'true' : 'false' }},
	"isAvailability": {{ common['isOrder'] and common['order_info'].tpordc == 0 ? 'true' : 'false' }},
	"hideAvailability": {{ common['hideAvailability'] == 1 ? 'true' : 'false' }},
	"availableText":	"{{ mt._('_common.available') }}",
	"availablesText":	"{{ mt._('_common.availables') }}",
	"deliveryText":	"{{ mt._('_common.delivery') }}",
	"catalogProductType":	{{ common['catalogProductType'] }},
	"defaultImage":	{{ common['defaultImage'] }},
	"changeModelPreview":	{{ common['changeModelPreview'] }},

	"loadRelatedUrl": "{{ url('model/ajax/loadRelated') }}",
	"loadRecentsUrl": "{{ url('model/ajax/loadRecents') }}",
	"loadLinkedBuyUrl": "{{ url('model/ajax/loadLinkedBuy') }}",
	"getSizesFromColorUrl":	"{{ url('model/ajax/getSizesFromColor') }}",
	"saveOrderRowUrl": "{{ url('model/ajax/saveOrderRow') }}",
	"fullscreenvarUrl": "{{ url('model/fullscreenvar/var') }}",
	"fullscreenUrl": "{{ url('model/fullscreen/' ~ (common['catalogProductType'] == 0 ? model.cdartn : model.cdarti)) }}",
};
</script>
{{ javascript_include("js/custom/model_index.js") }}

<script>
{% if common['catalogProductType'] == 0 and model.tppers == "PT" %}
var backward_color_ongoing = [{% for anaart in model.anaart %}false,{% endfor %}];
var forward_color_ongoing = [{% for anaart in model.anaart %}false,{% endfor %}];
{% endif %}

jQuery(document).ready(function($) {
  {% if common['modelDetailStyle'] not in [1, 6, 7, 8, 9] %}

  //region Resize slider for anaart
	var num_variants  = $('.variant-box').length;
	var single_width  = $(".variant-box img").width();
	$("#slider-variants").width(num_variants * (single_width + 10) - 10);
	var slider_width  = $('.slide-variants').width();
	// If slider objects not fill the space, hide the arrows
	if (slider_width >= (num_variants * single_width + (num_variants - 1) * 10)) {
		$('#backward-slider-variants').hide();
		$('#forward-slider-variants').hide();
		$('.slide-variants').css('margin-left', '50px');
	}
	// Handling arrows actions
	$('#backward-slider-variants').click(function(){
    if (!backward_ongoing) {
      backward_ongoing = true;

      var left_val = $('#slider-variants').css('left');
      left_val = left_val.substr(0, left_val.length - 2);

      var width_move = single_width + 10;
      var opacity = false;

      if (parseInt(left_val) + single_width + 10 >= 0) {
        width_move = -1 * left_val;
        opacity = true;
      }

      $('#slider-variants').animate({
        left: parseInt(left_val) + parseInt(width_move)
      }, 200, 'linear', function(){
        backward_ongoing = false;
        handleArrowsOpacity(opacity, false);
      });
    }
  });
  $('#forward-slider-variants').click(function(){
    if (!forward_ongoing) {
      forward_ongoing = true;

      var left_val = $('#slider-variants').css('left');
      left_val = left_val.substr(0, left_val.length - 2);

      var width_move = single_width + 10;
      var opacity = false;

      if (slider_width >= ($('#slider-variants').width() + parseInt(left_val) - (single_width + 10))) {
        width_move = ($('#slider-variants').width() + parseInt(left_val)) - slider_width;
        opacity = true;
      }

      $('#slider-variants').animate({
        left: "-=" + width_move
      }, 200, 'linear', function(){
        forward_ongoing = false;
        handleArrowsOpacity(false, opacity);
      });
    }
  });
	//endregion

    {% if model.tppers == "PT" %}
	//region Resize every slider for artcol
	$('.slider-color-variants').each(function() {
		$(this).width($(this).find('.color-variant-box').length * (single_width + 10) - 10);
	});
	// If slider objects not fill the space, hide the arrows
	var slide_color_variants = 0;
  $('.slide-color-variants').each(function(){
    var root = $(this).closest('.slide-color-variants-container');
    var num_color_variants = root.find('.color-variant-box').length;
		slide_color_variants = slide_color_variants == 0 ? $(this).width() : slide_color_variants; // slider hidden has width=0, so take the first visible
		if (slide_color_variants > (num_color_variants * single_width + (num_color_variants - 1 ) * 10)) {
      root.find('.backward-slider-color-variants').hide();
      root.find('.forward-slider-color-variants').hide();
      root.find('.slide-color-variants').css('margin-left', '50px');
    }
  });
	// Handling arrows actions
  $('.backward-slider-color-variants').click(function(){
    var index = $(this).data('index') - 1;
    var root = $(this).closest('.slide-color-variants-container');
    if (!backward_color_ongoing[index]) {
      backward_color_ongoing[index] = true;

      var left_val = root.find('.slider-color-variants').css('left');
      left_val = left_val.substr(0, left_val.length - 2);

      var width_move = single_width + 10;
      var opacity = false;

      if (parseInt(left_val) + single_width + 10 >= 0) {
        width_move = -1 * left_val;
        opacity = true;
      }

      root.find('.slider-color-variants').animate({
        left: parseInt(left_val) + parseInt(width_move)
      }, 200, 'linear', function(){
        backward_color_ongoing[index] = false;
				root.find('.backward-slider-color-variants').css('opacity', opacity ? '0.5' : '1');
        root.find('.forward-slider-color-variants').css('opacity', '1');
      });
    }
  });
  $('.forward-slider-color-variants').click(function(){
    var index = $(this).data('index') - 1;
    var root = $(this).closest('.slide-color-variants-container');
    if (!forward_color_ongoing[index]) {
      forward_color_ongoing[index] = true;

      var left_val = root.find('.slider-color-variants').css('left');
      left_val = left_val.substr(0, left_val.length - 2);

      var width_move = single_width + 10;
      var opacity = false;
      var slider_color_width = root.find('.slide-color-variants').width();

      if (slider_color_width >= (root.find('.slider-color-variants').width() + parseInt(left_val) - (single_width + 10))) {
        width_move = (root.find('.slider-color-variants').width() + parseInt(left_val)) - slider_color_width;
        opacity = true;
      }

      root.find('.slider-color-variants').animate({
        left: "-=" + width_move
      }, 200, 'linear', function(){
        forward_color_ongoing[index] = false;
				root.find('.forward-slider-color-variants').css('opacity', opacity ? '0.5' : '1');
        root.find('.backward-slider-color-variants').css('opacity', '1');
      });
    }
  });
	//endregion
    {% endif %}

  //region Select first variant/tissue/color
	{% if cdpers is defined %}
	var selectedArticle = $('.variant-box[data-code="{{ cdpers }}"]');
	{% else %}
	var selectedArticle = $('.variant-box:first');
	{% endif %}
	selectedArticle.addClass('selected');

  {% if common['defaultImage'] == 1 and common['catalogProductType'] == 0 and model.anaart|length > 0 %}
  $('.big_article_image').attr('src', $('.variant-box.selected').find('img').attr('src'));
  $('.big_article_image').attr('alt', $('.variant-box.selected').find('img').attr('alt'));
  {% endif %}

	$("#selected-article").html(selectedArticle.data("code"));
	$("#selected-article").data("cdarti", selectedArticle.data("cdarti"));

	{% if model.tppers != "PT" %}
	$("#selected-article").data("cdcolo", $('.variant-box:first').data("cdcolo"));
	{% else %}
	$('.slide-color-variants-container').hide();
	$('#slide-color-' + selectedArticle.data('loop')).show();
		{% if cdcolo is defined %}
	var selectedColor = $('#slide-color-' + selectedArticle.data('loop') + ' .color-variant-box[data-code="{{ cdcolo }}"]');
		{% else %}
	var selectedColor = $('#slide-color-' + selectedArticle.data('loop') + ' .color-variant-box:first');
		{% endif %}
	selectedColor.addClass('selected');
	$("#selected-color").html(selectedColor.data("code"));
	{% endif %}
	//endregion

	//region Insert quantity panel
	{% if common['isOrder'] %}
	updateInsertQuantityPanel();
	{% endif %}
	//endregion
	{% endif %}

  {% if exist_video %}
  //region Video resize
  central_pos_width = $('.carousel-cell').width();
  central_pos_height = $('.carousel-cell').height();
  resizeVideo();
  //endregion
  {% endif %}

	{% if common['isOrder'] and common['order_info'].tpordc == 0 %}
	//region Init notify modal
	$("#open-modal-notify-product").click(function(){
		$.ajax({
			type: "POST",
			url: "{{ url('model/ajax/getCurrentDesiderata') }}",
			dataType: "json",
			data: {
				cdartn: "{{ model.cdartn }}",
				tppers: "{{ model.tppers }}"
			}
		}).done(function(data) {
			$('#modal-notify-header').html(data);
			$('#modal-notify-product').modal({ show: false});
			$('#modal-notify-product').modal('show');
			{% if model.tppers == "PT" %}
			checkArtcol();
			checkArtvar();
			{% endif %}
			loadNotifyQuantityBox();
		}).error(function(x, t, m) {
			printAjaxError(x, t, m);
		});
	});
	//endregion
	{% endif %}

{#
	let blowup_attributes = {
    width: 300,
    height: 300,
    zIndex: 999999,
    scale: 1.5,
    cursor: false,
    round:false,
  };

  let i = 0;

  {% if model.imgart|length > 0 %}
  $('.model-gallery .fullscreen_slider_image').each(function(){
    $(this).blowup(blowup_attributes, i++);
    $(this).hide();
  });
  $('#preview0 img').show();
  {% else %}
  $('#preview0 img').blowup(blowup_attributes, i++);
  {% endif %}

  {% if common['catalogProductType'] == 0 and model.anaart|length > 0 %}
  $(".article-gallery .big_article_image").blowup(blowup_attributes, i++);
  {% endif %}
#}
});/*Document Ready End*/

{% if common['modelDetailStyle'] not in [1, 6, 7, 8, 9] %}

//region Update article selection and insert quantity panel if needed
$('.variant-box').click(function(){
	var index   = $(this).data('loop');
	$('.variant-box').removeClass('selected');
	$(this).addClass('selected');
  {% if common['defaultImage'] == 1 and common['catalogProductType'] == 0 and model.anaart|length > 0  %}
  $('.big_article_image').attr('src', $(this).find('img').attr('src'));
  $('.big_article_image').attr('alt', $(this).find('img').attr('alt'));
  {% endif %}
	$("#selected-article").html($(this).data("code"));
	$("#selected-article").data("cdarti", $(this).data("cdarti"));

	{% if model.tppers != "PT" %}
	$("#selected-article").data("cdcolo", $(this).data("cdcolo"));
	{% endif %}

	{% if model.tppers == "PT" %}
	$('.color-variant-box').removeClass('selected');
	$('.slide-color-variants-container').hide();
	$('#slide-color-' + index).show();
	$('#slide-color-' + index + ' .color-variant-box:first').addClass('selected');
	$("#selected-color").html($('#slide-color-' + index + ' .color-variant-box:first').data("code"));
	{% endif %}

	{% if common['isOrder'] %}
	updateInsertQuantityPanel();
	{% endif %}
});
$('.color-variant-box').click(function(){
	$('.color-variant-box').removeClass('selected');
	$("#selected-color").html($(this).data("code"));
	$(this).addClass('selected');

	{% if common['isOrder'] %}
	updateInsertQuantityPanel();
	{% endif %}
});
//endregion

  {% if common['isOrder'] %}
    {% if common['order_info'].tpordc == 0 %}
//region Notify availability modal
$('.modal-body').on('change', '#notify_anaart', function(){
	{% if model.tppers == "PT" %}
	checkArtcol();
	checkArtvar();
	{% endif %}
	loadNotifyQuantityBox();
});
	{% if model.tppers == "PT" %}
function checkArtcol() {
	var currAnaart = $("#notify_anaart").val();
	$("#notify_artcol option").hide();
	$("#notify_artcol option[data-cdarti='" + currAnaart + "']").show();
	var stop = 0;
	$("#notify_artcol option").each(function(){
		if ($(this).css('display') == 'block' && stop != 1) {
			$("#notify_artcol").val($(this).val());
			stop = 1;
		}
	});
	if (stop == 0) {
		$("#notify_artcol").val("");
	}
}
function checkArtvar() {
	var currAnaart = $("#notify_anaart").val();
	$("#notify_artvar option[data-all='false']").hide();
	$("#notify_artvar option[data-cdarti='" + currAnaart + "']").show();
	var stop = 0;
	$("#notify_artvar option").each(function(){
		if ($(this).css('display') == 'block' && stop != 1) {
			$("#notify_artvar").val($(this).val());
			stop = 1;
		}
	});
	if (stop == 0) {
		$("#notify_artvar").val("");
	}
}
	{% endif %}
function loadNotifyQuantityBox() {
	{% if model.tppers == "PT" %}
	$('#notify-me').show();
	if ($("#notify_artcol").val()) {
		var preagg = $('#notify_artvar').length == 1 ? $('#notify_artvar option:selected').data('preagg') : 0;
	{% else %}
	var preagg = 0;
	{% endif %}
	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/getCurrentDesiderataSizes') }}",
		dataType: "json",
		data: {
			cdarti: $("#notify_anaart").val(),
			cdtagl: "{{ model.cdtagl }}",
			preagg: preagg
		}
	}).done(function(data) {
		$('#modal-notify-body').html(data);
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
	{% if model.tppers == "PT" %}
	} else {
		$('#modal-notify-body').html('');
		$('#notify-me').hide();
	}
	{% endif %}
}

$('#notify-me').click(function(){
	$('#notify-success').hide();
	$('#notify-error').hide();
	var sizes = [];
	$('.modal-body .insert-quantity-row').each(function(){
		if ($(this).find('.input-number').val() != '' && $(this).find('.input-notify-number').val() > 0) {
			sizes.push({
				'taglia': $(this).find('.taglia').html(),
				'prezzo': $(this).find('.price').data('price'),
				'quanti': $(this).find('.input-notify-number').val(),
			})
		}
	});

	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/savedesiderataqty') }}",
		dataType: "json",
		data: {
			cdarti: $("#notify_anaart").val(),
			cdcolo: $("#notify_artcol").length == 1 ? $("#notify_artcol").val() : '',
			cdvari: $("#notify_artvar").length == 1 ? $("#notify_artvar").val() : '',
			sizes:	sizes
		}
	}).done(function(data) {
		$('#notify-success').show();
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
		$('#notify-error').show();
	});
});

$("#modal-notify-body").on('click', '.btn-notify-number', function(e){
	e.preventDefault();

  var type   	= $(this).attr('data-type');
	var parent 	= $(this).closest(".insert-quantity-row");
	var input		= parent.find("input");
  var currentVal = input.val() != '' ? parseInt(input.val()) : 0;
	if (!isNaN(currentVal)) {
		if (type == 'minus' && currentVal != '') {
			input.val(currentVal - 1 == 0 ? "" : currentVal - 1).change();
		} else if (type == 'plus') {
			input.val(parseInt(currentVal) + 1).change();
		}
	}
});
$("#modal-notify-body").on('focusin', '.input-notify-number', function(){
	$(this).data('old_value', $(this).val());
});
$("#modal-notify-body").on('change', '.input-notify-number', function() {
	if ($(this).val() == 0) {
		$(this).val("");
	}

  var valueCurrent = $(this).val() != '' ? parseInt($(this).val()) : 0;
	var parent 	= $(this).closest(".insert-quantity-row");
	var min_btn	= parent.find(".minus-qty");
	var plu_btn	= parent.find(".plus-qty");
	var input		= parent.find("input");

	if (parseInt(input.val()) == 0 || input.val() == '') {
		min_btn.addClass('disabled');
		min_btn.removeClass('enabled');
	} else {
		min_btn.addClass('enabled');
		min_btn.removeClass('disabled');
	}
});
$("#modal-notify-body").on('keydown', '.input-notify-number', function (e) {
	// Allow: backspace, delete, tab, escape, enter and .
  if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 190]) !== -1 ||
  	// Allow: Ctrl+A
    (e.keyCode == 65 && e.ctrlKey === true) ||
    // Allow: home, end, left, right
    (e.keyCode >= 35 && e.keyCode <= 39)) {
    // let it happen, don't do anything
    	return;
  }
  // Ensure that it is a number and stop the keypress
  if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
  	e.preventDefault();
  }
});
//endregion
    {% endif %}

//region Insert quantity
$(document).on('click', 'a[href^="#quantity"]', function (event) {
	event.preventDefault();
	var shiftOffset = $(window).width() >= 1024 ? 180 : 120;
	$('html, body').animate({
		scrollTop: $('a[name=quantity]').offset().top - shiftOffset
	}, 500);
});

function updateInsertQuantityPanel() {
	var tglini = {{ model.tglini }};
	var tglfin = {{ model.tglfin }};
	var scalaCompleta = {{ common['hideBlockedItems'] is defined and common['hideBlockedItems'] == 0 ? '1' : '0' }};

	{% if model.tppers == "PT" %}
	var cdarti = $('.variant-box.selected').data("cdarti");
	var cdcolo = $('#selected-color').html();
	var doProcede = $('.variant-box.selected').data("available") != 0 &&
									$('.color-variant-box.selected').data("available") != 0;
	{% else %}
	var cdarti = $('#selected-article').data("cdarti");
	var cdcolo = $('#selected-article').data("cdcolo");
	var doProcede = $('.variant-box.selected').data("available") != 0;
	{% endif %}

	if (doProcede) {
		$.ajax({
			type: "POST",
			url: "{{ url('model/ajax/getCurrentArticle') }}",
			dataType: "json",
			data: {
				cdarti: cdarti,
				cdcolo: cdcolo,
				cdtagl: "{{ model.cdtagl }}",
				tppers: "{{ model.tppers }}",
			}
		}).done(function(data) {
			$("#insert_quantity").html(data);
			{% if model.tppers != "PT" %}
			$('[data-toggle="tooltip"]').tooltip();
			{% endif %}
			{% if model.tppers != "PT" and
				((common['order_info'].tpordc == 0 and (common['dateTypeAvaOrder'] == 2 or common['dateTypeAvaOrder'] == 3)) or
				 (common['order_info'].tpordc == 1 and (common['dateTypeResOrder'] == 2 or common['dateTypeResOrder'] == 3))) %}
			$.datepicker.setDefaults($.datepicker.regional.{{ session.get('language') }});
			$('.dtmcli').datepicker({ dateFormat: 'dd/mm/yy', minDate: 0,
				onSelect: function(dateText, inst) {
					var index = $(this).data("index");
					var pieces = dateText.split("/");
					$("#row-" + index).data("dtmcli", pieces.length > 0 ? pieces[2] + "-" + pieces[1] + "-" + pieces[0] : "");
				}
			});
			{% endif %}

			if (scalaCompleta != 0) {
				// Hide size with position less than tglini or greater than tglfin
				$('.insert-quantity-block').each(function () {
					var index = 1;
					$(this).find('.is-size').each(function () {
						if ((index < tglini && tglini != 0) ||
								(index > tglfin && tglfin != 0)) {
							$(this).addClass('size-disabled');
							$(this).find('.col-4').html('&nbsp;');
						} else {
							$(this).removeClass('size-disabled');
						}
						index++;
					})
				});
			}

			if ($("#row-3").closest(".insert-quantity-block").css("display") != "none") {
				$("#btn-add-1").css("display", "none");
				$("#btn-add-2").css("display", "none");
				$("#btn-show-2").css("display", "none");
			} else if ($("#row-2").closest(".insert-quantity-block").css("display") != "none") {
				$("#btn-add-1").css("display", "none");
			}
		}).error(function(x, t, m) {
			printAjaxError(x, t, m);
		});
	} else {
		$("#insert_quantity").html("");
	}
}

{% set btn_target = '#insert_quantity' %}
{% include 'scripts/common/qty_btn.volt' %}

$("#insert_quantity").on('click', ".info-order-row", function(){
	var row = $(this).closest('.header-insert-block');
	var index = row.attr('id');
	var indorc = row.data('indorc');
	var dsnoco = row.data('dsnoco');
	var sgrifc = row.data('sgrifc');
	$("#row-index-info").val(index);
	$("#indorc-info").val(indorc);
	$("#dsnoco-info").val(dsnoco);
	$("#sgrifc-info").val(sgrifc);
});
$("#insert_quantity").on('click', ".add-to-cart", function(e){
	e.preventDefault();
	var header = $(this).closest('.insert-quantity-block').find('.header-insert-block');
	var nuordc = "{{ common['order_info'].nuordc }}";
	var nurorc = header.data('nurorc');
	var cdarti = $("#selected-article").data("cdarti");
	var cdcolo = {{ model.tppers == "PT" ? '$("#selected-color").html()' : '$("#selected-article").data("cdcolo")' }};
	var cdvari = header.data('cdvari');
	var cdcata = "{{ common['order_info'].cdcata }}";
	var quanti = 0;
	var seqdet = header.prop('id').replace("row-", "");
  if (jsInfo['isAvailability']){
    var dtmcli = header.data('dtmcli');
  } else {
    {% if common['visible_delivery'] >= 2 %}
      var dtmcli = header.find('.dtmcli').val();
    {% else %}
      var dtmcli = header.data('dtmcli');
    {% endif %}
  }
	var sgrifc = header.data('sgrifc');
	var indorc = header.data('indorc');
	var dsnoco = header.data('dsnoco');

	var success = $(this).closest('.insert-quantity-block').find('.success-box');
	var error = $(this).closest('.insert-quantity-block').find('.unsuccess-box');
	error.find('span').html("{{ mt._('quantity.insert.unsuccess') }}");
	success.hide();
	error.hide();

	var octagl = [];
	$(this).closest('.insert-quantity-block').find('.insert-quantity-row.is-size').each(function(){
		var curr_quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
		quanti += curr_quanti;
		octagl.push([
			$(this).data('taglia'),
			$(this).data('prezzo'),
			curr_quanti,
			$(this).data('sconto'),
		]);
	});

	var ocasso = [];
	$(this).closest('.insert-quantity-block').find('.insert-quantity-row.is-asso').each(function(){
		var curr_quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
		quanti += (curr_quanti * $(this).data("qtasso"));
		ocasso.push([
			$(this).data('cdasso'),
			curr_quanti
		]);
	});

	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/saveOrderRow') }}",
		dataType: "json",
		data: {
			nuordc: nuordc,
			nurorc: nurorc,
			cdarti: cdarti,
			cdcolo: cdcolo,
			cdvari: cdvari,
			cdcata: cdcata,
			quanti: quanti,
			seqdet: seqdet,
			dtmcli: dtmcli,
			sgrifc: sgrifc,
			indorc: indorc,
			dsnoco: dsnoco,
			octagl: octagl,
			ocasso: ocasso
		}
	}).done(function(data) {
		if (data['response'] == 'RM') {
			error.find('span').html("{{ mt._('quantity.warning.regqtm.bis') }}");
			error.find('span.min').html(data['min']);
			error.find('span.mul').html(data['mul']);
		  error.fadeIn();
		  setTimeout( function(){
		  	error.fadeOut();
		  }, 10000 );
		} else {
			if (data['response'] != 'OC' && data['response'] != 'DT' && data['response'] != 'NT' && data['response'] != 'OA') {
				header.data('nurorc', data['nurorc']);
				$(".totals_arti[data-id='tot_" + cdarti + "']").html(data['tot_arti']);
				$(".highlight{{ model.tppers == 'PT' ? '-pt' : '' }}[data-id='" + cdarti + "']").removeClass('d-none');
				$(".highlight{{ model.tppers == 'PT' ? '-pt' : '' }}[data-id='" + cdarti + "']").siblings('.variant-code').addClass('highlight-txt');
				{% if model.tppers == 'PT' %}
				$(".highlight-cl-pt[data-id='" + cdcolo + "']").removeClass('d-none');
				$(".highlight-cl-pt[data-id='" + cdcolo + "']").siblings('.color-code').addClass('highlight-txt');
				{% endif %}
				$("#tot_tipolo").html(data['tot_artn']);
				updateShoppingBag(data['tot']);
			}
			success.fadeIn();
			setTimeout( function(){
				success.fadeOut();
			}, 10000 );
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
		error.fadeIn();
		setTimeout( function(){
			error.fadeOut();
		}, 10000 );
	});
});
{% if model.tppers != "PT" and
	((common['order_info'].tpordc == 0 and (common['dateTypeAvaOrder'] == 2 or common['dateTypeAvaOrder'] == 3)) or
	 (common['order_info'].tpordc == 1 and (common['dateTypeResOrder'] == 2 or common['dateTypeResOrder'] == 3))) %}
$("#insert_quantity").on('change', ".dtmcli", function() {
	var index = $(this).data("index");
	var value = $(this).val();
	$("#row-" + index).data("dtmcli", value);
});
{% endif %}
$("#insert_quantity").on('click', ".btn-add-delete", function(){
	var id = $(this).prop('id');
	$(this).hide();
	switch (id) {
	case 'btn-add-1':
	$("#row-2").closest(".insert-quantity-block").show();
		$("html, body").animate({ scrollTop: $('#row-2').offset().top - 180}, 1000, function(){
			$("#btn-add-2").show();
			$("#btn-delete-2").show();
		});
		break;
	case 'btn-add-2':
		$("#row-3").closest(".insert-quantity-block").show();
		$("html, body").animate({ scrollTop: $('#row-3').offset().top - 180}, 1000, function(){
			$("#btn-delete-2").hide();
			$("#btn-add-3").show();
		});
		break;
	case 'btn-delete-2':
		$("#btn-add-1").show();
		var block = $(this).closest(".insert-quantity-block");
		$("html, body").animate({ scrollTop: $('#row-1').offset().top - 180}, 1000, function(){
			block.hide();
		});
	  break;
	case 'btn-delete-3':
		$("#btn-add-2").show();
		$("#btn-delete-2").show();
		var block = $(this).closest(".insert-quantity-block");
		$("html, body").animate({ scrollTop: $('#row-2').offset().top - 180}, 1000, function(){
			block.hide();
		});
		break;
	}
});

$(".save-row-order-info").click(function(){
	var index = $("#row-index-info").val();
	$("#" + index).data('indorc', $("#indorc-info").val());
	$("#" + index).data('dsnoco', $("#dsnoco-info").val());
	$("#" + index).data('sgrifc', $("#sgrifc-info").val());
	$(".modal-info-row").modal('hide');
});
//endregion
  {% endif %}

{% else %}

//region Change color
{% if common['isOrder'] %}
$("#add-to-cart-size").click(function(e){
	e.preventDefault();
	var header = $('#model-sizes-content .model-color-sizes');
	var nuordc = "{{ common['order_info'].nuordc }}";
	var nurorc = header.data('nurorc');
	var cdarti = header.data('cdarti');
	var cdcolo = header.data('cdcolo');
	var cdcata = "{{ common['order_info'].cdcata }}";
  var quanti = 0;
  var seqdet = 0;
	var dtmcli = header.data('dtmcli');
	var sgrifc = header.data('sgrifc');
	var indorc = header.data('indorc');
	var dsnoco = header.data('dsnoco');

  if (header.data('action') == true) {
    $('#go-to-cart').show();
    $('#dont-go-to-cart').hide();
  } else {
    $('#go-to-cart').hide();
    $('#dont-go-to-cart').show();
  }
	var success = $('#model-insert-quantity .success-box');
	var error = $('#model-insert-quantity .unsuccess-box');
	success.hide();
	error.hide();

  var octagl = [];
  var ocasso = [];
  $('.color-size').each(function(){
    var issize = $(this).data('issize');
    var curr_quanti = 0;
    if ($(this).hasClass('selected')) {
      curr_quanti = $('.input-number').val() != '' && $('.input-number').val() != 0 ? $('.input-number').val() : 1;
    } else {
      curr_quanti = $(this).data('quanti');
    }
    if (issize) {
      quanti += parseInt(curr_quanti);
      octagl.push([
        $(this).data('taglia'),
        $(this).data('prezzo'),
        curr_quanti,
        $(this).data('sconto'),
      ]);
    } else {
      quanti += parseInt(curr_quanti) * $(this).data('qtasso');
      ocasso.push([
        $(this).data('cdasso'),
        curr_quanti
      ]);
    }
  });

  $.ajax({
		type: "POST",
		url: "{{ url('model/ajax/saveOrderRow') }}",
		dataType: "json",
		data: {
			nuordc: nuordc,
      nurorc: nurorc,
      cdarti: cdarti,
      cdcolo: cdcolo,
      cdvari: '',
      cdcata: cdcata,
      quanti: quanti,
      seqdet: seqdet,
      dtmcli: dtmcli,
      sgrifc: sgrifc,
      indorc: indorc,
      dsnoco: dsnoco,
      octagl: octagl,
      ocasso: ocasso
		}
	}).done(function(data) {
		if (data != 'OC' && data != 'DT' && data != 'NT' && data != 'OA') {
			header.data('nurorc', data['nurorc']);
      $('.color-size.selected').data('quanti', $('.input-number').val() != '' ? $('.input-number').val() : 0);
      updateShoppingBag(data['tot']);
		}
    // Update input values
    updateSizesFromColor(1);
		success.fadeIn();
		setTimeout( function(){
			success.fadeOut();
		}, 10000 );
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
		error.fadeIn();
		setTimeout( function(){
			error.fadeOut();
		}, 10000 );
	});
});
$(".modal-fast-buy .modal-content").on('click', '#add-to-cart-modal', function(e){
  e.preventDefault();
	var header = $('#model-sizes-content .model-color-sizes');
  var nuordc = "{{ common['order_info'].nuordc }}";
	var nurorc = header.data('nurorc');
	var cdarti = header.data("cdarti");
	var cdcolo = header.data("cdcolo");
  var cdcata = "{{ common['order_info'].cdcata }}";
  var quanti = 0;
  var seqdet = 0;
  var dtmcli = header.data('dtmcli');
  var sgrifc = header.data('sgrifc');
  var indorc = header.data('indorc');
  var dsnoco = $('#dsnoco-info').val();

  var success = $('.modal-fast-buy .modal-content .success-box');
  var error = $('.modal-fast-buy .modal-content .unsuccess-box');
  success.hide();
  error.hide()

  var octagl = [];
  $('.modal-fast-buy .modal-content .insert-quantity-row.is-size').each(function(){
    var curr_quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
    quanti += curr_quanti;
    octagl.push([
      $(this).data('taglia'),
      $(this).data('prezzo'),
      curr_quanti,
      $(this).data('sconto'),
    ]);
  });

  var ocasso = [];
  $('.modal-fast-buy .modal-content .insert-quantity-row.is-asso').each(function(){
    var curr_quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
    quanti += (curr_quanti * $(this).data("qtasso"));
    ocasso.push([
      $(this).data('cdasso'),
      curr_quanti
    ]);
  });

  $.ajax({
    type: "POST",
    url: "{{ url('model/ajax/saveOrderRow') }}",
    dataType: "json",
    data: {
      nuordc: nuordc,
      nurorc: nurorc,
      cdarti: cdarti,
      cdcolo: cdcolo,
      cdvari: '',
      cdcata: cdcata,
      quanti: quanti,
      seqdet: seqdet,
      dtmcli: dtmcli,
      sgrifc: sgrifc,
      indorc: indorc,
      dsnoco: dsnoco,
      octagl: octagl,
      ocasso: ocasso
    }
  }).done(function(data) {
    if (data != 'OC' && data != 'DT' && data != 'NT' && data != 'OA') {
      header.data('nurorc', data['nurorc']);

      $('.modal-fast-buy .modal-content .insert-quantity-row.is-size').each(function(){
        var quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
        var taglia = $(this).data('taglia');
        $('.color-size[data-taglia="' + taglia + '"]').data('quanti', quanti);
      });
      $('.modal-fast-buy .modal-content .insert-quantity-row.is-asso').each(function(){
        var quanti = $(this).find(".input-number").val() > 0 ? parseInt($(this).find(".input-number").val()) : 0
        var cdasso = $(this).data('cdasso');
        $('.color-size[data-cdasso="' + cdasso + '"]').data('quanti', quanti);
      });
      updateShoppingBag(data['tot']);
    }
    // Update input values
    updateSizesFromColor(2);

		{% if common['closeQtyModal'] %}
		$('.modal-fast-buy').modal('hide');
		{% else %}
    success.fadeIn();
    setTimeout( function(){
      success.fadeOut();
    }, 10000 );
		{% endif %}
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
    error.fadeIn();
    setTimeout( function(){
      error.fadeOut();
    }, 10000 );
  });
});

{% set btn_target = '#model-insert-quantity,.modal-fast-buy .modal-content' %}
{% include 'scripts/common/qty_btn.volt' %}

{% endif %}
//endregion

{% endif %}

//region Resize functions
{% if exist_video %}
function resizeVideo(){
	if ($('.carousel-cell').length > 0) {
		$('video').attr('width', central_pos_width);
		$('video').attr('height', central_pos_height);
		$("#video-box").css('width', central_pos_width + 'px')
		$("#video-box").css('margin-left', (($(window).width() - central_pos_width)/2) + 'px')
	}
}
{% endif %}
$(window).resize(function() {
	central_pos_width = $('.product-gallery .active').width();
	central_pos_height = $('.product-gallery .active').height();
  {% if exist_video %}
  resizeVideo();
  {% endif %}
	resizeDescrSection();
});
//endregion
</script>
