<!-- Custom Theme Scripts -->
{{ javascript_include("js/custom.js") }}
<script>
$('#sync').click(function(e){
  e.preventDefault();

  if ($('#sync').hasClass('disabled'))
    return;

  $('#sync').addClass('disabled');
  $('.sync-progress').show();

  $.ajax({
    type: "POST",
    url: "{{ url('admin/sync') }}",
    dataType: "json"
  }).done(function(data) {
    $('.sync-progress').hide();
    $('#sync').removeClass('disabled');
    showMessageTemporary("#sync-time", "{{ mt._('admin.syncdone') }} " + data + " {{ mt._('admin.syncminutes') }}", 3000);
  }).error(function(x, t, m) {
    $('.sync-progress').hide();
    $('#sync').removeClass('disabled');
    showMessageTemporary("#sync-time", "{{ mt._('admin.syncerror') }}", 3000);
		printAjaxError(x, t, m);
  });
});
</script>
{{ javascript_include("vendors/jquery-ui-1.12.1.custom/datepicker-" ~ session.get('language') ~ ".js") }}
{% if router.getActionName() in ["agentsList", "availability", "brands", "catalogDetail", "catalogManager",
  "catalogSorting", "conditions", "createCatalog", "devices", "downloadImageXlsTemplate", "downloadSortingCatalogXls",
  "editDevice", "editLookbook", "editPromo", "expirations", "lines", "lookbookManager", "promo", "seasons", "series", "sizes"] %}
  {{ partial("scripts/gomanagement/" ~ router.getActionName()) }}
{% endif %}
