<script>
    $(document).ready(function () {

        $('body').on('input', '#ajax_search_field, #ajax_search_field_mobile, #ajax_search_fabric_field', (e) => {
            const $searchField = $(e.currentTarget);
            if ($($searchField).val().length > 1) {
                delay(function () {
                    if ($searchField.is('#ajax_search_fabric_field')) {
                        requestSearchFabricResults();
                    } else {
                        requestSearchResults();
                    }
                }, 100);
            } else {
                $("#ajax_search_results,#ajax_search_results_mobile").html("").hide();
            }
        });

        $('#ajax_search_fabric_img').click(function () {
            window.location = "{{ url('catalog/resultsfabric') }}?search=" + $("#ajax_search_fabric_field").val();
        });

        $("#ajax_search_fabric_field").keypress(function (e) {
            const $searchField = $(e.currentTarget);
            if (e.which === 13 && $searchField.val().length > 1) {
                window.location = "{{ url('catalog/resultsfabric') }}?search=" + $searchField.val();
            }
        });

        var doSearch = true;
        var doSearchFabric = true;
        var pendentRequests = 0;
        var pendentFabricRequests = 0;

        function requestSearchResults() {
            if (!doSearch) {
                pendentRequests++;
            } else {
                const $searchField = $("#ajax_search_field:visible,#ajax_search_field_mobile:visible");
                if ($searchField.length) {
                    doSearch = false;
                    $.ajax({
                        type: "POST",
                        url: "{{ url('catalog/search') }}",
                        dataType: "json",
                        async: "false",
                        data: {
                            search_term: $searchField.val(),
                            catalog: "{{ common['selected_catalog'].cdcata }}",
                        }
                    }).done(function (data) {
                        if ($searchField.val().length > 1) {
                            $("#ajax_search_results,#ajax_search_results_mobile").html(data + (data == 1 ? " {{ mt._('_common.searchresult') }}" : " {{ mt._('_common.searchresults') }}")).css("display", "inline-block");
                        } else {
                            $("#ajax_search_results,#ajax_search_results_mobile").html("").hide();
                        }
                        doSearch = true;
                        if (pendentRequests > 0) {
                            pendentRequests = 0;
                            requestSearchResults();
                        }
                    }).error(function (x, t, m) {
                        printAjaxError(x, t, m);
                        doSearch = true;
                        if (pendentRequests > 0) {
                            pendentRequests = 0;
                            requestSearchResults();
                        }
                    });
                }
            }
        }

        function requestSearchFabricResults() {
            if (!doSearchFabric) {
                pendentFabricRequests++;
            } else {
                const $searchField = $("#ajax_search_fabric_field");
                doSearchFabric = false;
                $.ajax({
                    type: "POST",
                    url: "{{ url('catalog/searchFabric') }}",
                    dataType: "json",
                    async: "false",
                    data: {
                        search_term: $searchField.val(),
                        catalog: "{{ common['selected_catalog'].cdcata }}",
                    }
                }).done(function (data) {
                    if ($searchField.val().length > 1) {
                        $("#ajax_search_fabric_results").html(data + (data == 1 ? " {{ mt._('_common.searchresult') }}" : " {{ mt._('_common.searchresults') }}")).css("display", "inline-block");
                    } else {
                        $("#ajax_search_fabric_results").html("").hide();
                    }
                    doSearchFabric = true;
                    if (pendentFabricRequests > 0) {
                        pendentFabricRequests = 0;
                        requestSearchResults();
                    }
                }).error(function (x, t, m) {
                    printAjaxError(x, t, m);
                    doSearchFabric = true;
                    if (pendentFabricRequests > 0) {
                        pendentFabricRequests = 0;
                        requestSearchFabricResults();
                    }
                });
            }
        }

        $('#search-slider').sliiide({
            toggle: ".toggle-src-sidebar",
            exit_selector: ".slider-exit",
            animation_duration: "0.5s",
            place: "right",
            animation_curve: "cubic-bezier(0.54, 0.01, 0.57, 1.03)",
            body_slide: true,
            no_scroll: false,
            auto_close: false
        });

        {#
        /*
        Questa era una prima implementazione dei barcode direttamente nella ricerca base
        la lascio solo perché se volessimo fare la modale come chiede Matteo possiamo partire da qui.
        */
        $('body').on('submit', '.search-model-form', (e) => {;
            const $form = $(e.currentTarget);
            if ($form.data('confirmed') !== true) {
                const barcode = $form.serializeArray().find((el) => el.name === 'search')?.value ?? null;
                if (barcode) {
                    e.preventDefault();
                    $.ajax({
                        type: "POST",
                        url: "{{ url('catalog/getarticlefrombarcode') }}",
                        dataType: "json",
                        data: {
                            barcode: barcode,
                        },
                    }).done(function (data) {
                        if (data['response'] === 'OK') {
                            if (data['cdpers'] !== '' && data['cdcolo'] !== '') {
                                location.href = "{{ url('model') }}/" + data['cdartn'] + "/" + data['cdpers'] + "/" + data['cdcolo'];
                            } else {
                                location.href = "{{ url('model') }}/" + data['cdartn'];
                            }
                        } else {
                            $form.data('confirmed', true).trigger('submit');
                        }
                    }).error(function (x, t, m) {
                        printAjaxError(x, t, m);
                        $form.data('confirmed', true).trigger('submit');
                    });
                } else {
                    $form.data('confirmed', true).trigger('submit');
                }

                // setTimeout(() => $form.data('confirmed', true).trigger('submit'), 500);
                // $('#alpine-quicksearch').get(0)._x_dataStack[0].openModal('P24PAB1417ABFA0000');
                // $('#list-mode').get(0)._x_dataStack[0].openModal('P24PAB1417ABFA0000');
            }
        });
        #}
    });
</script>
