<script>
$(document).ready(function(){
  startChat();
});

function startChat() {
  $.ajax({
    type: "POST",
    url: "{{ url('chat/startchat') }}",
    data: {

    },
    dataType: "json",
    success: function(data){
      // Set initial chat content
      $("#popup-content").html(data['chat']);
      // Set initial line counters
      $("#popup-chat").data('lines', data['lines']);
      $("#popup-chat").data('initial-lines', data['lines']);
      // Clear new messages fields
      $("#popup-new-msg").html("");
      // Layout messages
      beautifyMessages();
      // Start checking for new messages
      setTimeout(updateState, 1500);
    },
    error: function(x, t, m) {
  		printAjaxError(x, t, m);
    }
  });
}
function updateState() {
  var lines = $("#popup-chat").data('lines');

  $.ajax({
    type: "POST",
    url: "{{ url('chat/updatechat') }}",
    data: {
      lines: lines
    },
    dataType: "json",
    success: function(data){
      // Update total number of lines
      $("#popup-chat").data('lines', data['curr_lines']);

      // Append new messages
      if (data['new_msg'] != '') {
        $("#popup-content").append(data['new_msg']);
        beautifyMessages();
      }

      // If there are new message and chat is closed, update new message counter
      if (data['curr_lines'] > $("#popup-chat").data('initial-lines')) {
        if ($("#popup-chat").height() < 50) {
          $("#popup-new-msg").html("(" + (data['curr_lines'] - $("#popup-chat").data('initial-lines')) + ")");
        }
      }
    },
    complete: function() {
      // schedule the next request *only* when the current one is complete:
      setTimeout(updateState, 1500);
    },
    error: function(x, t, m) {
  		printAjaxError(x, t, m);
    }
  });
}
function beautifyMessages(){
  $('.popup-message').each(function(){
    if ($(this).prev().data('verse') == $(this).data('verse')) {
      $(this).find('.support-avatar').remove();
      $(this).find('.user-avatar').remove();
      $(this).find('.content').addClass('no-caret');
    } else {
      $(this).css('margin-top', '20px');
    }
  });

  $("#popup-inner-container").scrollTop($("#popup-inner-container")[0].scrollHeight);
}

function getTemplateMessage(message){
  var longname = "{{ session.get('auth')['username'] }}";
  var shortname = longname.substring(0, 1).toUpperCase();
  var dt = new Date();
  var dtHours = dt.getHours() < 10 ? "0" + dt.getHours().toString() : dt.getHours();
  var dtMinutes = dt.getMinutes() < 10 ? "0" + dt.getMinutes().toString() : dt.getMinutes();
  var dtDate = dt.getDate() < 10 ? "0" + dt.getDate().toString() : dt.getDate();
  var dtMonth = dt.getMonth() < 9 ? "0" + (parseInt(dt.getMonth()) + 1).toString() : parseInt(dt.getMonth()) + 1;
  var currentTime = dtHours + ":" + dtMinutes + " " + dtDate + "-" + dtMonth + "-" + dt.getFullYear();
  var html = "<div class='popup-message' data-verse='out'><div class='user-avatar'>";
  html += "<div class='short-name'>" + shortname + "</div><div class='long-name'>" + longname + "</div>";
  html += "</div><div class='content out'><div class='message'>" + message + "</div>";
  html += "<div class='date'>" + currentTime + "</div></div></div>";

  return html;
}

$("#toggle-chat").click(function(){
  if ($("#popup-chat").height() < 50) {
    $("#popup-chat").animate({
      height: 350,
    }, 500, function() {
      // Animation complete.
      $("#popup-head-right .fa").removeClass("fa-caret-up");
      $("#popup-head-right .fa").addClass("fa-caret-down");
      $("#popup-chat").data('initial-lines', $("#popup-chat").data('lines'));
      $("#popup-new-msg").html("");
    });
  } else {
    $("#popup-chat").animate({
      height: 32,
    }, 500, function() {
      // Animation complete.
      $("#popup-head-right .fa").removeClass("fa-caret-down");
      $("#popup-head-right .fa").addClass("fa-caret-up");
    });
  }
});

$("#popup-send-area .send").click(function(e){
  e.preventDefault();
  var text = $("#popup-send-area textarea").val().replace(/\n/g, "<br/>");
  $.ajax({
    type: "POST",
    url: "{{ url('chat/addmessage') }}",
    data: {
      'message': text
    },
    dataType: "json",
    success: function(data){
      // Append new message
      $("#popup-content").append(getTemplateMessage(text));
      // Reset input textarea
      $("#popup-send-area textarea").val("");
      // Update counters
      $("#popup-chat").data('lines', $("#popup-chat").data('lines') + 1);
      $("#popup-chat").data('initial-lines', $("#popup-chat").data('lines') + 1);
      beautifyMessages();
    },
    error: function(x, t, m) {
  		printAjaxError(x, t, m);
    }
  });
});
</script>
