{% if session.get('auth')['type'] != 3 or common['customers']|length > 0 %}

<script>

const newOrderCatalogs = [
  {% if common['catalogs']|length > 0 %}
    {% for cttest in common['catalogs'] %}
      {"cdcata": {{ cttest.cdcata|json_encode }}, "dscata": {{ cttest.dscata|json_encode }}, "fltipo": {{ cttest.fltipo|json_encode }}},
    {% endfor %}
  {% endif %}
];

const newOrderTypes = [
  {% if common['orderTypeChoice'] == 3  %}
    {% for tipord in common['tipologieOrdine'] %}
    {"codice": {{ tipord.codice|json_encode }}, "descri": {{ tipord.descri|json_encode }}, "fldisp": {{ tipord.fldisp }}},
    {% endfor %}
  {% endif %}
];

const newOrderInfo = {
  'createOrderUrl': "{{ url('cart/createOrder') }}",
  'downloadXlsTemplateUrl': "{{ url('cart/downloadxlstemplate') }}",
  'createOrderLocationUrl': "{{ url(common['newOrderLanding'] == 1 or (common['newOrderLanding'] == -1 and common['homepage'] == 1) ? 'catalog/collection' : 'catalog/index') }}",
  'getDestinationsOptionsUrl': "{{ url('cart/getDestinationsOptions') }}",
  'getAnaregOptionsRulesUrl': "{{ url('cart/getAnaregOptionsRules') }}",
  'getDeliveryPeriodsOptionsUrl': "{{ url('cart/getDeliveryPeriodsOptions') }}",

  'dateTypeResOrder': {{ common['dateTypeResOrder'] }},
  'dateTypeAvaOrder': {{ common['dateTypeAvaOrder'] }},
  'dateOffset':       {{ common['dateOffset'] }},
  'defaultShipping':  {{ common['defaultShipping'] }},
  'hideDeliveryDate': {{ common['hideDeliveryDate'] }},
  'orderTypeChoice':  {{ common['orderTypeChoice'] }},
  'enableXlsOrder':   {{ common['enableXlsOrder'] }},
  'choosePriceList':  {{ common['choosePriceList'] }},
  'manageIndicative': {{ common['manageIndicative'] }},
  'authType':         {{ session.get('auth')['type'] }},
  'doubleRowsNewOrder': {{ common['doubleRowsNewOrder'] }},
  i18n: {
    'destinationSelectTitle': {{ i18n._('cart.select.destination.title')|json_encode }},
    'neworder.errors.customer.mandatory': {{ i18n._('neworder.errors.customer.mandatory')|json_encode }},
    'neworder.errors.cddesm.mandatory': {{ i18n._('neworder.errors.cddesm.mandatory')|json_encode }},
    'neworder.errors.cdcata.mandatory': {{ i18n._('neworder.errors.cdcata.mandatory')|json_encode }},
    'neworder.errors.nulist.mandatory': {{ i18n._('neworder.errors.nulist.mandatory')|json_encode }},
    'neworder.errors.tipord.mandatory': {{ i18n._('neworder.errors.tipord.mandatory')|json_encode }},
    'neworder.errors.fldisp.mandatory': {{ i18n._('neworder.errors.fldisp.mandatory')|json_encode }},
    'neworder.errors.dtmcli.mandatory': {{ i18n._('neworder.errors.dtmcli.mandatory')|json_encode }},
    'neworder.errors.nuordc.mandatory': {{ i18n._('neworder.errors.nuordc.mandatory')|json_encode }},
  }
};
</script>
{{ javascript_include("js/custom/common_neworder.js") }}

{% if common['hideDeliveryDate'] != 1 and common['dateTypeResOrder'] == 4 %}
<script>
$(document).ready(function(){
  $('#frd-res').daterangepicker({
    opens: "center",
    drops: "up",
    autoUpdateInput: false,
    startDate: "{{ common['modelDetailStyle'] == 3 ? common['zanStartDate'] : '01/02/2021' }}",
    endDate: "{{ common['modelDetailStyle'] == 3 ? common['zanEndDate'] : '01/02/2021' }}",
    minDate: '01/01/2020',
    locale: {
      format: "DD/MM/YYYY",
      separator: " - ",
      applyLabel: {{ mt._('drp.apply')|json_encode }},
      cancelLabel: {{ mt._('drp.cancel')|json_encode }},
      fromLabel: {{ mt._('drp.from')|json_encode }},
      toLabel: {{ mt._('drp.to')|json_encode }},
      customRangeLabel: {{ mt._('drp.period')|json_encode }},
      daysOfWeek: [
          {{ mt._('drp.sunday')|json_encode }},
          {{ mt._('drp.monday')|json_encode }},
          {{ mt._('drp.tuesday')|json_encode }},
          {{ mt._('drp.wednesday')|json_encode }},
          {{ mt._('drp.thursday')|json_encode }},
          {{ mt._('drp.friday')|json_encode }},
          {{ mt._('drp.saturday')|json_encode }}
      ],
      "monthNames": [
          {{ mt._('drp.january')|json_encode }},
          {{ mt._('drp.february')|json_encode }},
          {{ mt._('drp.march')|json_encode }},
          {{ mt._('drp.april')|json_encode }},
          {{ mt._('drp.may')|json_encode }},
          {{ mt._('drp.june')|json_encode }},
          {{ mt._('drp.july')|json_encode }},
          {{ mt._('drp.august')|json_encode }},
          {{ mt._('drp.september')|json_encode }},
          {{ mt._('drp.october')|json_encode }},
          {{ mt._('drp.november')|json_encode }},
          {{ mt._('drp.december')|json_encode }}
      ],
      "firstDay": 1
    }
  }, function(start, end, label) {
    $('#frd-res').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'))
  });
});
</script>
{% endif %}

<script>

{% if common['hideDeliveryDate'] != 1 and
    ( (common['dateTypeResOrder'] > 1 and common['dateTypeResOrder'] != 4) or
      (common['enableXlsOrder'] == 1 or common['enableXlsOrder'] == 3) or
      (common['dateTypeAvaOrder'] > 1 and common['dateTypeAvaOrder'] != 4) ) %}
$.datepicker.setDefaults($.datepicker.regional.{{ session.get('language') }});
$('.datepicker').datepicker({ dateFormat: 'dd/mm/yy', minDate: 0 });
{% endif %}

</script>

{% endif %}
