<script>
var infoOrderInfo = {
  'changeIndicativeUrl':       "{{ url('cart/changeIndicative') }}",
  'cancelOrderLocationUrl':    "{{ url(common['homepage'] == 0 ? 'catalog/index' : 'catalog/collection') }}",
  'deleteCurrentOrderUrl':     "{{ url('cart/deleteCurrentOrder') }}",
  'setCurrentOrderDateUrl':    "{{ url('cart/setCurrentOrderDate') }}",
  'recalculateOrderPricesUrl': "{{ url('cart/recalculateOrderPrices') }}",

  'tpordc': "{{ common['order_info'].tpordc }}",
  'nuordc': "{{ common['order_info'].nuordc }}",
  'nulist': "{{ common['order_info'].nulist }}",
  'cdvalu': "{{ common['order_info'].cdvalu }}",

  'hideDeliveryDate': {{ common['hideDeliveryDate'] }},
  'dateTypeResOrder': {{ common['dateTypeResOrder'] }},
  'dateTypeAvaOrder': {{ common['dateTypeAvaOrder'] }},
  'changePriceList':  {{ common['changePriceList'] }},
  'manageIndicative': {{ common['manageIndicative'] }},
  'authType':         {{ session.get('auth')['type'] }},
};
$.datepicker.setDefaults($.datepicker.regional.{{ session.get('language') }});
</script>
{{ javascript_include("js/custom/common_infoorder.js") }}

{% if common['hideDeliveryDate'] != 1 and common['dateTypeResOrder'] == 4 %}
<script>
$(document).ready(function(){
  $('#date-range-order').daterangepicker({
    opens: "center",
    drops: "up",
    autoUpdateInput: false,
    locale: {
      format: "DD/MM/YYYY",
      separator: " - ",
      applyLabel: {{ mt._('drp.apply')|json_encode }},
      cancelLabel: {{ mt._('drp.cancel')|json_encode }},
      fromLabel: {{ mt._('drp.from')|json_encode }},
      toLabel: {{ mt._('drp.to')|json_encode }},
      customRangeLabel: {{ mt._('drp.period')|json_encode }},
      daysOfWeek: [
            {{ mt._('drp.sunday')|json_encode }},
            {{ mt._('drp.monday')|json_encode }},
            {{ mt._('drp.tuesday')|json_encode }},
            {{ mt._('drp.wednesday')|json_encode }},
            {{ mt._('drp.thursday')|json_encode }},
            {{ mt._('drp.friday')|json_encode }},
            {{ mt._('drp.saturday')|json_encode }}
        ],
        "monthNames": [
            {{ mt._('drp.january')|json_encode }},
            {{ mt._('drp.february')|json_encode }},
            {{ mt._('drp.march')|json_encode }},
            {{ mt._('drp.april')|json_encode }},
            {{ mt._('drp.may')|json_encode }},
            {{ mt._('drp.june')|json_encode }},
            {{ mt._('drp.july')|json_encode }},
            {{ mt._('drp.august')|json_encode }},
            {{ mt._('drp.september')|json_encode }},
            {{ mt._('drp.october')|json_encode }},
            {{ mt._('drp.november')|json_encode }},
            {{ mt._('drp.december')|json_encode }}
        ],
      "firstDay": 1
    }
  }, function(start, end, label) {
    $('#date-range-order').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    $.ajax({
      type: "POST",
      url: "{{ url('cart/setCurrentOrderDates') }}",
      dataType: "json",
      data: {
        dtmcoi: start.format('YYYY-MM-DD'),
        dtmcof: end.format('YYYY-MM-DD'),
        nuordc: "{{ common['order_info'].nuordc }}",
      }
    }).done(function(data) {
      window.location.reload();
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });
  });
});
</script>
{% endif %}
