<script>

$('#result').on('focusin', '.size-qty', function(){
    $(this).data('val', $(this).val());
});

$('#result').on('change', '.size-qty', function(){
  var prev = $(this).data('val');
  var value = $(this).val();
  var qtamin = $(this).data('qtamin');
  var qtamul = $(this).data('qtamul');

  if (value < qtamin) {
    $(this).val('');
  } else if (value > qtamin && (value - qtamin) % qtamul != 0) {
    $(this).val(prev);
  }

  if (value < qtamin) {
    $(this).prop('step', qtamin);
  } else {
    $(this).prop('step', qtamul);
  }
});


$("#search-model").keypress(function(e) {
  if (e.which == 13) {
    searchModel();
  }
});

$("#search").click(function() {
  searchModel();
});

function searchModel() {
  if ($("#search-model").val().length > 1) {
    $('#loading-quickorder').show();
    $("#result").html("");
    $('.add-to-cart').hide();

    $.ajax({
      type: "POST",
      url: "{{ url('catalog/searchForQuickOrder') }}",
      dataType: "json",
      data: {
        cdartn: $("#search-model").val(),
      }
    }).done(function(data) {
      if (data['response'] == 'OK') {
        $('#loading-quickorder').hide();
        $("#result").html(data["html"]);
        if (data['html'] != '') {
          $('.add-to-cart').show();
        }
      }
    }).error(function(x, t, m) {
      printAjaxError(x, t, m);
    });
  }
}

$('.add-to-cart').click(function(){
  var articles = [];
  $('.article-list-row').each(function(){
    var cdarti = $(this).data('cdarti');
    var cdcolo = $(this).data('cdcolo');
    var nurorc = $(this).data('nurorc');

    var octagl = [];
    var quanti = 0;
    $(this).find('.size-qty').each(function(){
      var curr_quanti = $(this).val() > 0 ? parseInt($(this).val()) : 0
      quanti += curr_quanti;
      octagl.push([
        $(this).data('taglia'),
        $(this).data('prezzo'),
        curr_quanti,
        $(this).data('sconto')
      ]);
    });

    if (quanti > 0) {
      articles.push([
        nurorc,
        cdarti,
        cdcolo,
        quanti,
        octagl
      ]);
    }
  });

	$.ajax({
		type: "POST",
		url: "{{ url('model/ajax/saveOrderRows') }}",
		dataType: "json",
		data: {
			nuordc: "{{ common['order_info'].nuordc }}",
			articles: articles,
			cdcata: "{{ common['order_info'].cdcata }}",
		}
	}).done(function(data) {
		if (data != 'OC' && data != 'DT' && data != 'NT' && data != 'OA') {
      $('.articles-list-row').each(function(){
        var cdarti = $(this).data('cdarti');
        $(this).data('nurorc', data['cdarti'][cdarti]);
      });
      updateShoppingBag(data['tot']);
		}
	}).error(function(x, t, m) {
		printAjaxError(x, t, m);
	});
});

</script>
