<script>
    document.addEventListener('alpine:init', () => {
        Alpine.data('quickBuy', (lang = false) => ({
            open: false,
            loading: false,
            selectedModel: null,
            visualizationType: '1',
            bulkValues: {},
            selectedArticle: null,
            isOrder: {{ common['isOrder']|json_encode }},
            orderType: {{ common['order_info'] is defined ? common['order_info'].tpordc|json_encode : 'null' }},
            rowDateMode: {{ common['visible_delivery'] is defined ? common['visible_delivery'] : '0' }},
            rowNoteMode: {{ common['visible_notes'] is defined ? common['visible_notes'] : '0' }},
            lang: lang ?? {{ lang is defined ? lang|json_encode() : 'it' }},
            isSizeVisible(size) {
                // console.log(this.selectedModel, size);
                const inizioTaglie = parseInt(this.selectedModel?.tglini) || 1;
                const fineTaglie = parseInt(this.selectedModel?.tglfin) || 99;
                const posizioneAttuale = parseInt(size?.postgl);
                // console.log(posizioneAttuale, inizioTaglie, fineTaglie, posizioneAttuale && posizioneAttuale >= inizioTaglie && posizioneAttuale <= fineTaglie);
                return posizioneAttuale && posizioneAttuale >= inizioTaglie && posizioneAttuale <= fineTaglie;
            },
            openModal(cdartn) {
                document.querySelector('.content').style.transform = 'none'
                this.open = true
                this.fetchData(cdartn)
            },
            closeModal() {
                this.open = false
                this.reset()
            },
            toggleModal() {
                this.open = !this.open
            },
            reset() {
                this.selectedModel = null
                this.selectedArticle = null
                this.bulkValues = {}
            },
            fetchData(cdartn) {
                this.loading = true
                $.ajax({
                    type: "POST",
                    url: '/model/ajax/getCurrentArticleJson',
                    dataType: "json",
                    data: {cdartn}
                }).done((data) => {
                    this.selectedModel = data.model
                    this.selectedArticle = data.model.articles[0] ?? null
                    this.visualizationType = data.visualizationType
                }).error((x, t, m) => {
                    console.error({x, t, m})
                }).complete(() => {
                    this.loading = false
                });
            },
            applyBulkValues() {
                this.selectedModel.articles = this.selectedModel.articles.map(article => {
                    article.sizes = article.sizes.map(size => {
                        // aggiorno la quantità solo le il size non é disabilitato o se l'articolo non é flaggato per
                        // l'acquisto senza quantità
                        if (!article.orderWithoutQuantity) {
                            let newQuantity = parseInt(this.bulkValues[size.taglia]) || 0;
                            if (this.orderType === '0') {
                                newQuantity = Math.min(size.availability, newQuantity);
                            }

                            size.quantity = newQuantity;
                        }

                        return size;
                    })

                    return article;
                })
            },
            setSelectedArticle(newArticle) {
                this.selectedArticle = newArticle
            },
            handleChildInput(size) {
                size.quantity = size.quantity.startsWith('0') ? parseInt(size.quantity.slice(1), 10) : parseInt(size.quantity, 10)
            },
            handleBulkInput(taglia) {
                this.bulkValues[taglia] = this.bulkValues[taglia].length > 1 && this.bulkValues[taglia].startsWith('0') ? parseInt(this.bulkValues[taglia].slice(1), 10) : (parseInt(this.bulkValues[taglia], 10) || 0)
            },
            submit() {
                $.ajax({
                    type: "POST",
                    url: '/model/ajax/saveOrderRowsFromCurrentArticleJson',
                    dataType: "json",
                    data: this.selectedModel
                }).done((data) => {
                    console.log(data)
                    if (data.success) {
                        this.open = false;
                        if (window.location.pathname.includes('/results')) {
                            $("#ajax_search_field:visible,#ajax_search_field_mobile:visible").focus();
                        }
                        updateShoppingBag(data?.tot ?? {});
                        setTimeout(() => showTemporary(null, 3000, {
                            text: data.message,
                            className: 'alert alert-success',
                            position: 'center'
                        }), 250)
                    } else if (data.error !== undefined && data.message != null) {
                        showTemporary(null, 3000, {
                            text: data.message,
                            className: 'alert alert-danger',
                            position: 'center'
                        });
                    }
                }).error((x, t, m) => {
                    console.error({x, t, m});
                    showTemporary(null, 3000, {
                        text: {{ mt._('_common.error')|json_encode }},
                        className: 'alert alert-danger',
                        position: 'center'
                    });
                }).complete(() => {
                    this.loading = false
                });
            },
            getLanguageCode() {
                switch (this.lang) {
                    case 'it':
                        return 'it-IT'
                    case 'en':
                        return 'en-GB'
                    case 'es':
                        return 'es-ES'
                    case 'de':
                        return 'de-DE'
                    case 'fr':
                        return 'fr-FR'
                }
            },
        }))

        Alpine.data('article', (article) => ({
            article: article,
            orderWithoutQuantity: false,
            toggleOrderWithoutQuantity(event) {
                if (event?.target?.checked) {
                    for (const posizioneTaglia in this.article.sizes) {
                        this.article.sizes[posizioneTaglia].quantity = 0;
                    }
                }
            }
        }))

        Alpine.data('size', (size) => ({
            orderType: {{ common['order_info'] is defined ? common['order_info'].tpordc|json_encode : 'null' }},
            size: size,
            onSale: size.prezzoScontato !== size.prezzo,
            handleInput(event) {
                let futureValue = parseInt(((event && event.target) ? event.target.value : this.size.quantity), 10) || 0;

                if (this.orderType === '0' && futureValue > this.size.availability) {
                    futureValue = this.size.availability
                }

                if (futureValue < 0) {
                    futureValue = 0
                }
                this.size.quantity = futureValue
            },
            decrement() {
                if ((this.orderType === '0' && !this.size.availability) || this.size.flbloc > 0) return;
                this.size.quantity = this.size.quantity > 1 ? this.size.quantity - 1 : 0
            },
            increment() {
                if ((this.orderType === '0' && !this.size.availability) || this.size.flbloc > 0) return;
                let nextVal = this.size.quantity ? this.size.quantity + 1 : 1;
                if (this.orderType === '0') {
                    nextVal = Math.min(nextVal, this.size.availability);
                }
                this.size.quantity = nextVal;
            },
            getPrice(salePrice = false) {
                const formatter = new Intl.NumberFormat(this.getLanguageCode(), {
                    style: 'currency',
                    currency: this.size.cdvalu,
                });
                return formatter.format(!salePrice ? this.size.prezzo : this.size.prezzoScontato)
            },
            fillNext() {
                const article = this.article ?? this.selectedArticle // valid for both visualizations
                const currentSizeIndex = article.sizes.findIndex(size => size.taglia === this.size.taglia)
                // update next size with current value
                if (currentSizeIndex < article.sizes.length - 1) {
                    // article.sizes[currentSizeIndex + 1].quantity = this.size.quantity
                    // and focus on it
                    let inputEl;
                    let i = 1;
                    do {
                        const taglia = article.sizes[currentSizeIndex + i]?.taglia ?? '';
                        if (taglia !== '') {
                            inputEl = document.querySelector(`#size-${taglia}-${article.cdcolo}:not([disabled])`);
                        }
                    } while (i++ < 20 && inputEl == null)

                    if (inputEl != null) {
                        inputEl.value = this.size.quantity
                        inputEl.focus();
                        inputEl.dispatchEvent(new Event('input', {'bubbles': false}));
                    }
                }
            }
        }))
    })
</script>
