<script>
    (function(){
        $("button[attr-sync]").click(function (e){
            var buttons = $("button[attr-sync]");
            buttons.prop('disabled', true);

            var button = $(this);
            var icon = button.find('i');
            var originalClass = icon.attr('class');

            icon.attr('class', 'fa fa-refresh fa-spin');

            console.log(e.currentTarget.getAttribute('attr-sync'));
            $.ajax({
                type: "POST",
                url: "{{ url('admin/sync') }}",
                dataType: "json",
                data: {sync: e.currentTarget.getAttribute('attr-sync')}
            }).done(function(data) {
                $('.sync-progress').hide();
                buttons.prop('disabled', false);
                icon.attr('class', originalClass);
                showMessageTemporary("#sync-time", "{{ mt._('admin.syncdone') }} " + data + " {{ mt._('admin.syncminutes') }}", 3000);
            }).error(function(x, t, m) {
                $('.sync-progress').hide();
                buttons.prop('disabled', false);
                icon.attr('class', originalClass);
                showMessageTemporary("#sync-time", "{{ mt._('admin.syncerror') }}", 3000);
                printAjaxError(x, t, m);
            });
        });
    })();



</script>