<!-- DropZone -->
{{ javascript_include("vendors/dropzone/dist/min/dropzone.min.js") }}
<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/bootstrap-select.min.js"></script>
<!-- (Optional) Latest compiled and minified JavaScript translation files -->
{% if session.get('language') == 'it' %}{% set lang = 'it_IT' %}
{% elseif session.get('language') == 'en' %}{% set lang = 'en_US' %}
{% elseif session.get('language') == 'fr' %}{% set lang = 'fr_FR' %}
{% elseif session.get('language') == 'es' %}{% set lang = 'es_ES' %}
{% elseif session.get('language') == 'de' %}{% set lang = 'de_DE' %}{% endif %}
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/i18n/defaults-{{ lang }}.min.js"></script>
<script type="text/javascript">// Immediately after the js include
  Dropzone.autoDiscover = false;
  $('#dropzone-change-image').dropzone({
    init: function() {
      this.on("maxfilesexceeded", function(file) {
        this.removeAllFiles();
        this.addFile(file);
      });
      this.on("complete", function(file) {
        this.removeAllFiles(true);
      })
    },
    acceptedFiles: 'image/jpeg',
    dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles')}}",
    dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
    dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
    success: function (response) {
      console.log(response);
      $('#current-image').prop('src', '../../public/upload/' + response.name);
      $('#current-image').data('iscustom', '1');
    },
    addRemoveLinks: true,
    maxFiles: 1,
    removedfile: function(file) {
      var _ref; // Remove file on clicking the 'Remove file' button
      return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
    }
  });
</script>
<script>
var jsInfo = {
  "colspan": "{{ colspan }}",
  "editSpecialSelectionUrl": "{{ url('admin/editSpecialSelection') }}",
  "deleteText": "{{ mt._('_common.delete') }}",
  "defaultImageText": "{{ mt._('admin.catalog.img.default') }}",
  "changeImageText": "{{ mt._('_common.image.change') }}",
};
</script>
{{ javascript_include("js/custom/admin_specialselectiondetail.js") }}
