<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/bootstrap-select.min.js"></script>
<!-- (Optional) Latest compiled and minified JavaScript translation files -->
{% if session.get('language') == 'it' %}{% set lang = 'it_IT' %}
{% elseif session.get('language') == 'en' %}{% set lang = 'en_US' %}
{% elseif session.get('language') == 'fr' %}{% set lang = 'fr_FR' %}
{% elseif session.get('language') == 'es' %}{% set lang = 'es_ES' %}
{% elseif session.get('language') == 'de' %}{% set lang = 'de_DE' %}{% endif %}
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/i18n/defaults-{{ lang }}.min.js"></script>

<script>
var tableConfig = {
  'order': [],
  'pageLength': 100,
  'columns': [
    { "orderable": true },
    { "orderable": true },
    { "orderable": false },
    { "orderable": false },
    { "orderable": false },
    { "orderable": false }
  ],
  {% include 'scripts/common/table_language.volt' %}
};
$(document).ready(function(){
  $('#table-model').DataTable(tableConfig);
});

$('#load-items').click(function(){
  var catalogs = $('#catalogs-select').val();
  var lines    = $('#lines-select').val();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/getItemsForRules') }}",
    dataType: 'json',
    data: {
      catalogs: catalogs,
      lines: lines,
    }
  }).done(function(data) {
    if (data['response'] == "OK") {
      //checkTabs();
      fillDataInVisibleTabs(data);
    }
  }).error(function(x, t, m) {
  	printAjaxError(x, t, m);
  });
});

var tableModel;
function fillDataInVisibleTabs(data) {
  $('#table-model').DataTable().clear();
  $('#table-model').DataTable().destroy();
  $('#table-model tbody').html(data['tipolo']);
  tableModel = $('#table-model').DataTable(tableConfig);
}

$('.save-rules').click(function(){
  var items = [];
  $(tableModel.rows().nodes()).each(function(){
    var ra_qtamin  = $(this).find('.regqta-qtamin').val();
    var ra_qtamul  = $(this).find('.regqta-qtamul').val();
    var rm_qtamin  = $(this).find('.regqtm-qtamin').val();
    var rm_qtamul  = $(this).find('.regqtm-qtamul').val();
    if (ra_qtamin > 0 || ra_qtamul > 0 || rm_qtamin > 0 || rm_qtamul > 0) {
      items.push({
        'ra_qtamin': ra_qtamin,
        'ra_qtamul': ra_qtamul,
        'rm_qtamin': rm_qtamin,
        'rm_qtamul': rm_qtamul,
        'cdartn': $(this).closest('tr').data('code')
      });
    }
  });

  var catalogs = $('#catalogs-select').val();
  var lines    = $('#lines-select').val();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/saveRules') }}",
    dataType: 'json',
    data: {
      items: items,
      catalogs: catalogs,
      lines: lines,
    }
  }).done(function(data) {
    window.location.reload();
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
</script>
