<!-- DropZone -->
{{ javascript_include("vendors/dropzone/dist/min/dropzone.min.js") }}
<script type="text/javascript">// Immediately after the js include
  Dropzone.autoDiscover = false;
</script>
<script>
{% if utils is defined and utils|length > 0 %}
{% for util in utils %}
{% if util.param == 'logo_image' %}
$('#dropzone-logo-image').dropzone({
  init: function() {
    /*
    var img = "{{ util.value }}";
    var mockFile = { name: img, size: 12345 };
    this.emit("addedfile", mockFile);
    this.emit("thumbnail", mockFile, "../../upload/" + img);
    this.emit("complete", mockFile);*/
  },
  acceptedFiles: 'image/jpeg',
  dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles')}}",
  dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
  dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
  success: function (response) {
    $("#logo_image").val(response["name"]);
  },
  addRemoveLinks: true,
  maxFiles: 1,
  removedfile: function(file) {
    var _ref; // Remove file on clicking the 'Remove file' button
    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
  }
});
{% endif %}
{% endfor %}
{% endif %}
$('#save-params').click(function(){
  var utils = [];
  $(".util").each(function(){
    var param = $(this).find(".param").html();
    var value = $(this).find(".value").val();

    utils.push({param, value});
  });

  if (utils.length > 0) {
    $("#save-params").prop("disabled",true);
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/updateUtils') }}",
      dataType: 'json',
      data: {
        utils:  utils,
      }
    }).done(function(data) {
      if (data == "OK") {
        $(".msg-error").hide();
        showTemporary(".msg-success", 2000);
        setTimeout( function(){
          location.href = "{{ url('admin/params') }}";
        }, 2000 );
      } else {
        $(".msg-success").hide();
        showTemporary(".msg-error", 2000);
      }
      $("#save-params").prop("disabled",false);
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
      $("#save-params").prop("disabled",false);
    });
  }
});
</script>
