<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("vendors/bootstrap-daterangepicker/daterangepicker.js") }}
<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/bootstrap-select.min.js"></script>
<!-- (Optional) Latest compiled and minified JavaScript translation files -->
{% if session.get('language') == 'it' %}{% set lang = 'it_IT' %}
{% elseif session.get('language') == 'en' %}{% set lang = 'en_US' %}
{% elseif session.get('language') == 'fr' %}{% set lang = 'fr_FR' %}
{% elseif session.get('language') == 'es' %}{% set lang = 'es_ES' %}
{% elseif session.get('language') == 'de' %}{% set lang = 'de_DE' %}{% endif %}
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.5/js/i18n/defaults-{{ lang }}.min.js"></script>
<script>
$(document).ready(function(){
  $('#load').click();

  var drpConfig5 = {
    startDate: {{ not isLatest and cookieDtiniz != '' ? '"' ~ cookieDtiniz ~ '"' : "moment().subtract(29, 'days')" }},
    endDate: {{ not isLatest and cookieDtfine != '' ? '"' ~ cookieDtfine ~ '"' : "moment()" }},
    showDropdowns: true,
    timePicker: false,
    autoUpdateInput: true,
    ranges: {
      {{ mt._("drp.today")|json_encode }}: [moment(), moment()],
      {{ mt._("drp.yesterday")|json_encode }}: [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      {{ mt._("drp.last7dd")|json_encode }}: [moment().subtract(6, 'days'), moment()],
      {{ mt._("drp.last30dd")|json_encode }}: [moment().subtract(29, 'days'), moment()],
      {{ mt._("drp.thismonth")|json_encode }}: [moment().startOf('month'), moment().endOf('month')],
      {{ mt._("drp.lastmonth")|json_encode }}: [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    },
    opens: 'right',
    drops: 'down',
    linkedCalendars: false,
    buttonClasses: ['btn btn-default'],
    applyClass: 'btn-small btn-primary',
    cancelClass: 'btn-small',
    separator: ' {{ mt._("drp.to") }} ',
    {% include "scripts/common/daterangepicker_locale.volt" %}
  };
  var drp = $('#season-period-box').daterangepicker(drpConfig5, function(start, end, label) {
    $('#season-period-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    $('#season-period').attr('value', start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
  });

  {% if isLatest %}
  var startDate = moment().subtract(29, 'days').format('DD/MM/YYYY');
  var endDate = moment().format('DD/MM/YYYY');
  $('#season-period-box span').html(startDate + ' - ' + endDate);
  $('#season-period').attr('value', startDate + ' - ' + endDate);
  {% else %}
  $('#season-period-box span').html('{{ cookieDtiniz }} - {{ cookieDtfine }}');
  $('#season-period').attr('value', '{{ cookieDtiniz }} - {{ cookieDtfine }}');
  {% endif %}

  {% if enableDuplicate %}
  $('.selectpicker').selectpicker();
  {% endif %}
});

$(document).mouseup(function(e) {
  var container = $(".row-tool-box");

  // if the target of the click isn't the container nor a descendant of the container
  if (!container.is(e.target) && container.has(e.target).length === 0)  {
    container.removeClass('open');
  }
});

$('#orders-filter').on('click', '.order-tool-box-title', function(){
  var container = $(this).closest(".row-tool-box");

  if (container.hasClass('open')) {
    container.removeClass('open');
  } else {
    $(".row-tool-box").removeClass('open');
    container.addClass('open');
  }
});

$('input[name=type]').change(function(){
  if ($('input[name=type]:checked').val() == 'latest') {
    $('#period-panel').hide();
  } else if ($('input[name=type]:checked').val() == 'periodagent') {
    $('#period-panel').show();
  }
});

$('input[name=whose]').change(function(){
  $('#whose-set-all').prop('checked', true);
  $('#whose-set-selection').prop('checked', false);
  $('#select-whose-set').hide();
  $('#total-selected').hide();

  if ($('input[name=whose]:checked').val() == 'agents') {
    $('#tot-selected-agents').show();
    $('#tot-selected-customers').hide();
  } else if ($('input[name=whose]:checked').val() == 'customers') {
    $('#tot-selected-agents').hide();
    $('#tot-selected-customers').show();
  }
});

$('input[name=whose-set]').change(function(){
  // Reset selected elements
  $('#num-customers').html(0);
  $('#num-agents').html(0);
  $('#whose-modal-content').html('');
  $('#selected-whose-list').val('');

  if ($('input[name=whose-set]:checked').val() == 'all') {
    $('#select-whose-set').hide();
    $('#total-selected').hide();
  } else if ($('input[name=whose-set]:checked').val() == 'selection') {
    $('#select-whose-set').show();
    $('#total-selected').show();

    if ($('input[name=whose]:checked').val() == 'agents') {
      $('#tot-selected-agents').show();
      $('#tot-selected-customers').hide();
    } else if ($('input[name=whose]:checked').val() == 'customers') {
      $('#tot-selected-agents').hide();
      $('#tot-selected-customers').show();
    }
  }
});

$('#select-whose-set').click(function(){
  if ($('input[name=whose]:checked').val() == 'agents') {
    $('.modal-whose-set .modal-title').html("{{ mt._('statistics.select.agent') }}");
  } else if ($('input[name=whose]:checked').val() == 'customers') {
    $('.modal-whose-set .modal-title').html("{{ mt._('statistics.select.customer') }}");
  }

  $.ajax({
    type: "POST",
    url: "{{ url('admin/getWhoseForOrders') }}",
    dataType: "json",
    data: {
      whose: $('input[name=whose]:checked').val(),
    }
  }).done(function(data) {
    $('#whose-modal-content').html(data);
    var array = $('#selected-whose-list').val().split(',');
    for (var i = 0; i < array.length; i++) {
      $('input[name="whose-checkbox[]"][value="' + array[i] + '"]').prop('checked', true);
    }
    $('.modal-whose-set').modal('show');
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

$("#whose-search-field").keyup(function() {
  if ($("#whose-search-field").val().length > 1) {
    delay( function() { requestSearchResults(); }, 100 );
  } else {
    $("#whose-search-field").html("");
    $(".whose-row").show();
  }
});

function requestSearchResults() {
  var searchText = $("#whose-search-field").val();
  $(".whose-row").hide();
  $(".whose-row > .code:contains('" + searchText + "')" ).closest(".whose-row").show();
  $(".whose-row > .desc:contains('" + searchText + "')" ).closest(".whose-row").show();
  $(".whose-row > .code:contains('" + capitalize(searchText) + "')" ).closest(".whose-row").show();
  $(".whose-row > .desc:contains('" + capitalize(searchText) + "')" ).closest(".whose-row").show();
  $(".whose-row > .code:contains('" + searchText.toLowerCase() + "')" ).closest(".whose-row").show();
  $(".whose-row > .desc:contains('" + searchText.toLowerCase() + "')" ).closest(".whose-row").show();
  $(".whose-row > .code:contains('" + searchText.toUpperCase() + "')" ).closest(".whose-row").show();
  $(".whose-row > .desc:contains('" + searchText.toUpperCase() + "')" ).closest(".whose-row").show();
}

$('#confirm-whose').click(function(){
  var num = $('input[name="whose-checkbox[]"]:checked').length;
  var value = '';
  $('input[name="whose-checkbox[]"]:checked').each(function(){
    value += $(this).val() + ",";
  });
  $('#selected-whose-list').val(value);
  $('#num-customers').html(num);
  $('#num-agents').html(num);
});

function resetErrors() {
  $("#season-period-box").css("border", "1px solid #ccc");
}

{% if seasons|length > 0 %}
$('input[name=which-season-set]').change(function(){
  // Reset selected elements
  $('#num-seasons').html(0);

  if ($('input[name=which-season-set]:checked').val() == 'all') {
    $('#select-which-season-set').hide();
    $('#total-selected-seasons').hide();
  } else if ($('input[name=which-season-set]:checked').val() == 'selection') {
    $('#select-which-season-set').show();
    $('#total-selected-seasons').show();
  }
});

$('#confirm-which-season').click(function(){
  var num = $('input[name="which-season-checkbox[]"]:checked').length;
  var value = '';
  $('input[name="which-season-checkbox[]"]:checked').each(function(){
    value += $(this).val() + ",";
  });
  $('#selected-which-season-list').val(value);
  $('#num-seasons').html(num);
});
{% endif %}

var fltTable = $('#datatable-filter-orders');
fltTable.DataTable({
  'order': [[ 0, 'desc' ]],
  'pageLength': 100,
  'autoWidth': false,
  'columnDefs': [
    { "width": "8%", "type": "num-fmt", "targets": 0 },
    { "width": "16%", "targets": 1 },
    { "width": "9%", "targets": 2 },
    { "width": "13%", "targets": 3 },
    { "width": "7%", "targets": 4 },
    { "width": "7%", "targets": 5 },
    { "width": "7%", "targets": 6 },
    { "width": "6%", "type": "num-fmt", "targets": 7 },
    { "width": "8%", "type": "numeric-comma", "targets": 8 },
    { "width": "8%", "targets": 9 },
    { "width": "8%", "targets": 10, "orderable": false, "className": "center" },
    { "width": "3%", "targets": 11, "orderable": false, "className": "center" }
  ],
  {% include 'scripts/common/table_language.volt' %}
});
$.fn.dataTable.ext.type.order['numeric-comma-asc']  = function(a,b) {
  var x = a.replace(".", "");
  var y = b.replace(".", "");
  x = x.replace(",", ".");
  y = y.replace(",", ".");

  x = parseFloat( x );
  y = parseFloat( y );

  return ((x < y) ? -1 : ((x > y) ?  1 : 0));
};
$.fn.dataTable.ext.type.order['numeric-comma-desc'] = function(a,b) {
  var x = a.replace(".", "");
  var y = b.replace(".", "");
  x = x.replace(",", ".");
  y = y.replace(",", ".");

  x = parseFloat( x );
  y = parseFloat( y );

  return ((x < y) ?  1 : ((x > y) ? -1 : 0));
};

function getFilterSettings(filter) {
  if ($('input[name=type]:checked').val() == 'periodagent') {
    filter.type = 'periodagent';

    if ($("#season-period").val() == "") {
      $("#season-period-box").css("border", "1px solid red");
      filter.error = true;
    } else {
      // check dates validity
      var dates   = $("#season-period").val().split(" - ");
      var tok_min = dates[0].split("/");
      var tok_max = dates[1].split("/");
      filter.dtiniz = tok_min[2] + "-" + tok_min[1] + "-" + tok_min[0];
      filter.dtfine = tok_max[2] + "-" + tok_max[1] + "-" + tok_max[0];
    }
  }

  if ($('input[name=whose]:checked').val() == 'agents') {
    filter.whose = 'agents';
  } else if ($('input[name=whose]:checked').val() == 'customers') {
    filter.whose = 'customers';
  }

  if ($('input[name=whose-set]:checked').val() == 'all') {
    filter.whoseSet = "-1";
  } else if ($('input[name=whose-set]:checked').val() == 'selection') {
    filter.whoseSet = $('#selected-whose-list').val();
  }

  if ($('input[name=which-season-set]').length > 0) {
    if ($('input[name=which-season-set]:checked').val() == 'all') {
      filter.whichSeason = "-1";
    } else if ($('input[name=which-season-set]:checked').val() == 'selection') {
      filter.whichSeason = $('#selected-which-season-list').val();
    }
  }

  $("input[name='status-type[]']:checked").each(function(){
    filter.status.push(parseInt($(this).val()));
  });

  $("input[name='order-type[]']:checked").each(function(){
    filter.types.push($(this).val());
  });

  {% if checkOrderPrices %}
  $("input[name='prices[]']:checked").each(function(){
    filter.prices.push($(this).val());
  });
  {% endif %}
}

$("#load").click(function(e){
  e.preventDefault();

  resetErrors();
  $('#orderresults-panel').hide();

  var filter = {
    type:     'latest',
    error:    false,
    dtiniz:   '0000-00-00',
    dtfine:   '0000-00-00',
    whose:    'customers',
    whoseSet: '',
    whichSeason: '',
    status:   [],
    types:    [],
    prices:   [],
  };

  getFilterSettings(filter);

  if (!filter.error) {
    $.ajax({
      type: "POST",
      url: "{{ url('admin/getFilteredOrders') }}",
      dataType: "json",
      data: {
        type:     filter.type,
        dtiniz:   filter.dtiniz,
        dtfine:   filter.dtfine,
        whose:    filter.whose,
        whoseSet: filter.whoseSet,
        whichSeason: filter.whichSeason,
        status:   filter.status,
        types:    filter.types,
        prices:   filter.prices,
      }
    }).done(function(data) {
      fltTable.DataTable().clear();
      $('#orderresults-panel').show();
      if (data['response'] == 'OK') {
        fltTable.DataTable().clear();
        fltTable.DataTable().rows.add( data['rows_num'] );
        fltTable.DataTable().columns.adjust().draw();

        $('#orders-error').hide();
        $('#datatable-filter-orders').show();
      } else {
        $('#datatable-filter-orders').hide();
        $('#orders-error').show();
      }
    }).error(function(x, t, m) {
      printAjaxError(x, t, m);
    });
  }
});

{% if enableExport %}
$('#export-all-orders').click(function(){
  var filter = {
    type:     'latest',
    error:    false,
    dtiniz:   '0000-00-00',
    dtfine:   '0000-00-00',
    whose:    'customers',
    whoseSet: '',
    status:   [],
    types:    [],
    prices:   [],
  };

  getFilterSettings(filter);

  if (!filter.error) {
    var newForm = $('<form>', { 'action': '{{ url("admin/downloadAllOrdersXls") }}', 'method': 'post', 'target': '_blank' })
      .append($('<input>', { 'name': 'type',      'value': filter.type,     'type': 'hidden'}))
      .append($('<input>', { 'name': 'dtiniz',    'value': filter.dtiniz,   'type': 'hidden'}))
      .append($('<input>', { 'name': 'dtfine',    'value': filter.dtfine,   'type': 'hidden'}))
      .append($('<input>', { 'name': 'whose',     'value': filter.whose,    'type': 'hidden'}))
      .append($('<input>', { 'name': 'whoseSet',  'value': filter.whoseSet, 'type': 'hidden'}))
      .append($('<input>', { 'name': 'status',    'value': filter.status,   'type': 'hidden'}))
      .append($('<input>', { 'name': 'types',     'value': filter.types,    'type': 'hidden'}))
      .append($('<input>', { 'name': 'prices',    'value': filter.prices,   'type': 'hidden'}));
  	newForm.appendTo('body').submit();
  }
});
{% endif %}

$('#datatable-filter-orders').on('click', '.edit-btn', function(e){
  if ($(this).closest('.order-list-btn').hasClass('disabled')) {
    e.preventDefault();
  }
});

// XLS management
$('#datatable-filter-orders').on('click', '.xls-btn', function(e){
  e.preventDefault();
  if (!$(this).closest('.order-list-btn').hasClass('disabled')) {
    var nuordc = $(this).closest('.row-tool-box').data('nuordc');
    $('#modal-xls-nuordc').html(nuordc);
    $('.modal-xls-order').modal('show');
  }
});

$('#datatable-filter-orders').on('click', '.download-xls-btn', function(e){
  e.preventDefault();
  var nuordc = $(this).closest('.row-tool-box').data('nuordc');
  var newForm = $('<form>', { 'action': '{{ url("admin/downloadOrderXlsTemplate") }}', 'method': 'post', 'target': '_blank' })
    .append($('<input>', { 'name': 'nuordc', 'value': nuordc, 'type': 'hidden'}))
    .append($('<input>', { 'name': 'permissions', 'value': 'read', 'type': 'hidden'}));
  newForm.appendTo('body').submit();
});

$('#xls-action').change(function(){
  if ($(this).val() == 0) {
    $('.xls-upload-info').css('opacity', 0);
    $('#xls-download-template').show();
    $('#xls-load-order').hide();
  } else {
    $('.xls-upload-info').css('opacity', 1);
    $('#xls-download-template').hide();
    $('#xls-load-order').show();
  }
});

$('#xls-download-template').click(function(){
  var newForm = $('<form>', { 'action': '{{ url("admin/downloadOrderXlsTemplate") }}', 'method': 'post', 'target': '_blank' })
      .append($('<input>', { 'name': 'nuordc', 'value': $('#modal-xls-nuordc').html(), 'type': 'hidden'}))
      .append($('<input>', { 'name': 'permissions', 'value': 'write', 'type': 'hidden'}));
	newForm.appendTo('body').submit();
});

$('#xls-load-order').click(function(){
  if ($('#xls_file').val() != '') {
    $(this).prop('disabled', true);
    $('#load-xls-template').submit();
  }
});

{% if enableJoorExport %}
$('#datatable-filter-orders').on('click', '.joor-btn', function(e){
  e.preventDefault();
  var nuordc = $(this).closest('.row-tool-box').data('nuordc');
  var newForm = $('<form>', { 'action': '{{ url("admin/downloadJoorXlsOrder") }}', 'method': 'post', 'target': '_blank' })
    .append($('<input>', { 'name': 'nuordc', 'value': nuordc, 'type': 'hidden'}));
  newForm.appendTo('body').submit();
});
{% endif %}

{% if enableDuplicate %}
$('#datatable-filter-orders').on('click', '.duplicate-btn', function(e){
  e.preventDefault();
  var nuordc = $(this).closest('.row-tool-box').data('nuordc');
  $('#duplicate-order-nuordc').val(nuordc);
  $('#order-to-duplicate').html(nuordc);

  $('.modal-duplicate-order').modal('show');

  getShippings();
});
$('#customer-selector').change(function(){
  getShippings();
});
function getShippings(){
  $('#destination-container').hide();
  $('#destination-selector').html('');
  var cdanag = $('#customer-selector option:selected').data('cdanag');
  var tpanag = $('#customer-selector option:selected').data('tpanag');
  $.ajax({
    type: "POST",
    url: "{{ url('admin/getShippingsForDuplicateOrder') }}",
    dataType: "json",
    data: {
      cdanag: cdanag,
      tpanag: tpanag,
    }
  }).done(function(data) {
    if (data != '') {
      $('#destination-selector').html(data);
      $('#destination-container').show();
      $('.selectpicker').selectpicker('refresh');
    }
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
}
$('#confirm-duplicate-order').click(function(){
  var cdanag = $('#customer-selector option:selected').data('cdanag');
  var tpanag = $('#customer-selector option:selected').data('tpanag');
  var cddesm = $('#destination-selector').val() ? $('#destination-selector').val() : '';
  var nuordc = $('#duplicate-order-nuordc').val();
  $.ajax({
    type: "POST",
    url: "{{ url('admin/duplicateOrder') }}",
    dataType: "json",
    data: {
      cdanag: cdanag,
      tpanag: tpanag,
      cddesm: cddesm,
      nuordc: nuordc,
    }
  }).done(function(data) {
    window.location.reload();
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});
{% endif %}

// PDF management
$('#datatable-filter-orders').on('click', '.see-pdf', function(e){
	e.preventDefault();

  var nuordc = $(this).closest('.row-tool-box').data('nuordc');
	var link = $(this).siblings(".link-pdf");

  $.ajax({
    type: "POST",
    url: "{{ url('pdf/orderFromAdmin') }}",
    dataType: "json",
    data: {
      nuordc: nuordc,
    }
  }).done(function(data) {
		link[0].click();
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});

// Send order
var text  = "<div class='bold'><span class='sts2'>&#9679; </span> {{ orderStateMgmt ? mt._('account.order.processed') : mt._('account.order.sent') }}</div>";
var row   = "";
$('#datatable-filter-orders').on('click', '.send-order', function(e){
  e.preventDefault();
  if (!$(this).closest('.order-list-btn').hasClass('disabled')) {
    var nuordc = $(this).closest('.row-tool-box').data('nuordc');
    var tr     = $(this).closest('tr');
    $('#order-to-send').val(nuordc);
    $('#order-to-send-txt').html(nuordc);
  }
});
$('#confirm-send-order').click(function(e){
  e.preventDefault();
  $('#confirm-send-order').hide();
  $('#confirm-send-order-loader').show();

  var nuordc = $('#order-to-send').val();
  var tr = $('.row-tool-box[data-nuordc="' + nuordc + '"]').closest('tr');

  $.ajax({
    type: "POST",
    url: "{{ url('admin/sendOrder') }}",
    dataType: "json",
    data: {
      nuordc: nuordc,
    }
  }).done(function(data) {
    //window.location.reload();
    if (data == "OK") {
      var text = "{{ orderStateMgmt ? mt._('account.order.processed') : mt._('account.order.sent') }}";
      tr.find('.status .status-dot').removeClass().addClass('status-dot sts2');
      tr.find('.status .status-descr').html(text);
      tr.find('.edit-btn').addClass('disabled');
      tr.find('.edit-btn').find('a').prop('href', '#');
      tr.find('.send-order').closest('.order-list-btn').addClass('disabled');
      tr.find('.xls-btn').removeClass('xls-btn').addClass('download-xls-btn');
      $('#confirm-send-order-loader').hide();
      $('#confirm-send-order').show();
      $(".modal-send-order").modal('hide');
    } else {
      let text = '';
      if (data === "LE1") {
        text = '{{ mt._('cart.error.limit.qtamin', ['value': cart_limit_mode])|escape_js }}';
      } else if (data === "LE2") {
        text = '{{ mt._('cart.error.limit.spendmin', ['value': cart_limit_min_value])|escape_js }}';
      } else if (data === "OE") {
        text = '{{ mt._('_common.update.error')|escape_js }}';
      } else {
        text = '{{ mt._('_common.generic.db.error')|escape_js }}';
      }
      showTemporary(null, 5000, {className: 'alert alert-danger', text});
    }
  }).error(function(x, t, m) {
	 printAjaxError(x, t, m);
     showTemporary(null, 5000, {className: 'alert alert-danger', text: '{{ mt._('_common.generic.db.error')|escape_js }}'});
  });
});

// Delete order
$('#datatable-filter-orders').on('click', '.delete-order', function(e){
	e.preventDefault();

  var nuordc = $(this).closest('tr').find('.row-tool-box').data('nuordc');
  $('#order-to-delete').val(nuordc);
  $('#order-to-delete-txt').html(nuordc);
});
$('#confirm-delete-order').click(function(e){
  e.preventDefault();
  $.ajax({
    type: "POST",
    url: "{{ url('admin/deleteOrder') }}",
    dataType: "json",
    data: {
      nuordc: $('#order-to-delete').val(),
    }
  }).done(function(data) {
    window.location.reload();
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
</script>
