<script>
{% if mode == 'w' %}
function updateStateClass() {
  var newClass = $('#order-state-select option:selected').prop('class');
  var isActive = $('#order-state-select').hasClass('active');
  $('#order-state-select').removeClass();
  $('#order-state-select').addClass(newClass);
  if (isActive) {
    $('#order-state-select').addClass('active');
  }
}
$('#order-state-select').change(function(){
  updateStateClass();
  updateOrderStateIfNeeded();
});

function updateOrderStateIfNeeded() {
  var state = 1;
  if ($('#order-state-select').hasClass('active')) {
    state = $('#order-state-select').val();
  } else {
    state = 5;
  }
  $.ajax({
    type: "POST",
    url: "{{ url('admin/updateOrderState') }}",
    dataType: "json",
    data: {
      nuordc: "{{ order.nuordc }}",
      flstat: state
    }
  }).done(function(data) {
    //$('#current-flstat').val(state);
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
}

$('#save-order-header').click(function(){
  $(".msg-error").hide();
  $(".msg-success").hide();

  $.ajax({
    type: "POST",
    url: "{{ url('admin/updateOrderHeader') }}",
    dataType: "json",
    data: {
      nuordc: "{{ order.nuordc }}",
      cddesm: $('#address').val(),
      tppaga: $('#payment').val(),
      tpport: $('#shipping').val(),
      notcli: $('#notcli').val(),
      notazi: $('#notazi').val(),
    }
  }).done(function(data) {
    $(".msg-error").hide();
    showTemporary(".msg-success", 2000);
  }).error(function(x, t, m) {
    $(".msg-success").hide();
    showTemporary(".msg-error", 2000);
    printAjaxError(x, t, m);
  });
})

// Notes management
$('.dsnoco-row').click(function(){
  var dsnoco = $(this).find('.notes-text').html();
  var nurorc = $(this).closest('.order-detail-rows-line').data('nurorc');
  $('#dsnoco-nurorc').val(nurorc);
  $('#dsnoco').val(dsnoco);
});

$('#save-notes').click(function(){
  var nurorc = $('#dsnoco-nurorc').val();
  var dsnoco = $('#dsnoco').val();

  $.ajax({
    type: "POST",
    url: "{{ url('admin/updateOrderRowNotes') }}",
    dataType: "json",
    data: {
      nurorc: nurorc,
      dsnoco: dsnoco
    }
  }).done(function(data) {
    var currLine = $('.order-detail-rows-line[data-nurorc=' + nurorc + ']');
    currLine.find('.notes-text').html(dsnoco);
    if (dsnoco != '') {
      currLine.find('.glyphicon-plus').hide();
      currLine.find('.glyphicon-bookmark').show();
    } else {
      currLine.find('.glyphicon-plus').show();
      currLine.find('.glyphicon-bookmark').hide();
    }
    $('.modal-modify-row-notes').modal('hide');
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

// Variants management
$('.cdvari-row').click(function(){
  var cdvari = $(this).html();
  var nurorc = $(this).closest('.order-detail-rows-line').data('nurorc');
  var cdartn = $(this).closest('.order-detail-rows-line').data('cdartn');
  var tpmode = $(this).closest('.order-detail-rows-line').data('tpmode');
  $('#cdvari-nurorc').val(nurorc);
  $('#modal-cdvari').html(cdvari);
  $('#modal-prezzo').html('-');

  $('#modal-cdvari-selector').html('');

  $.ajax({
    type: "POST",
    url: "{{ url('admin/getOrderRowAvailableVariants') }}",
    dataType: "json",
    data: {
      cdvari: cdvari,
      cdartn: cdartn,
      tpmode: tpmode,
      cdcata: "{{ order.cdcata }}",
    }
  }).done(function(data) {
    if (data['response'] == 'OK') {
      $('#modal-cdvari-selector').html(data['html']);

      var prezzo = 0;
      $('.cdvari-selector option:selected').each(function(){
        prezzo += parseFloat($(this).data('prezzo'));
      });
      if (prezzo > 0) {
        $('#modal-prezzo').html('+' + parseFloat(prezzo).formatMoney(2, ",", ".") + " {{ currency }}");
      } else {
        $('#modal-prezzo').html('-');
      }
      $('#cdvari-old-prezzo').val(prezzo);
      $('#cdvari-new-prezzo').val(prezzo);
    }
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

$('#modal-cdvari-selector').on('change', '.cdvari-selector', function(){
  var newCdvari = '';
  $('.cdvari-selector').each(function(){
    if ($(this).val() != '-1') {
      newCdvari += $(this).val();
    }
    $('#modal-cdvari').html(newCdvari);
  });

  var prezzo = 0;
  $('.cdvari-selector option:selected').each(function(){
    prezzo += parseFloat($(this).data('prezzo'));
  });
  $('#cdvari-new-prezzo').val(prezzo);

  if (prezzo > 0) {
    $('#modal-prezzo').html('+' + parseFloat(prezzo).formatMoney(2, ",", ".") + " {{ currency }}");
  } else {
    $('#modal-prezzo').html('-');
  }
});

$('#save-cdvari').click(function(){
  var nurorc = $('#cdvari-nurorc').val();
  var deltaPrice = $('#cdvari-new-prezzo').val() - $('#cdvari-old-prezzo').val();
  var cdvari = $('#modal-cdvari').html();
  var newPrice = parseFloat($('.order-detail-rows-line[data-nurorc=' + nurorc + ']').data('prezzo') + deltaPrice);

  $.ajax({
    type: "POST",
    url: "{{ url('admin/updateOrderRowVariants') }}",
    dataType: "json",
    data: {
      nurorc: nurorc,
      delta:  deltaPrice,
      cdvari: cdvari,
    }
  }).done(function(data) {
    var currLine = $('.order-detail-rows-line[data-nurorc=' + nurorc + ']');
    currLine.data('prezzo', newPrice);
    var y = currLine.data('y');
    $('#prc_' + y).html(parseFloat(newPrice).formatMoney(2, ",", ".") + " {{ currency }}");
    updateTotAmountForLine(y);
    updateTotalForOrder();
    $('.modal-change-variants').modal('hide');
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

{% if showVariants %}
var availableArticles = [
  {% if selectableArticles is defined and selectableArticles|length > 0 %}
  {% for el in selectableArticles %}
  "{{ el.cdarti }}",
  {% endfor %}
  {% endif %}
];
var availableColors = [];
$(function() {
  $("#modal-add-row-cdarti").autocomplete({
    minLength: 3,
    source: function(request, response) {
      var results = $.ui.autocomplete.filter(availableArticles, request.term);
      response(results.slice(0, 10));
    }
  });
});
function backToStep1() {
  $('#modal-add-row-cdcolo').val('');
  $('#step2warning').hide();
  $('#step2').hide();

  $('#modal-selected-article').html('');
  $('#step1completed').hide();

  $('#step1warning').hide();
  $('#step1').show();
}
function showStep2(cdarti) {
  $('#modal-back-to-select-article').show();
  $('#modal-selected-article').html(cdarti);
  $('#step1').hide();
  $('#step1completed').show();
  $('#step2').show();
}
function backToStep2() {
  $('#step3').html('');
  $('#step3').hide();

  $('#modal-selected-color').html('');
  $('#step2completed').hide();

  $('#step2warning').hide();
  $('#step2').show();

  $('#modal-back-to-select-article').show();
}
function showStep3(cdcolo, html) {
  $('#modal-back-to-select-article').hide();

  $('#modal-selected-color').html(cdcolo);
  $('#step2').hide();
  $('#step2completed').show();

  $('#step3').html(html);
  $('#step3').show();
  $('#add-row').show();
}
$('#modal-select-article').click(function(){
  backToStep1();
  var cdarti = $('#modal-add-row-cdarti').val();

  $.ajax({
    type: "POST",
    url: "{{ url('admin/getColorsForCurrentArticle') }}",
    dataType: "json",
    data: {
      cdarti: cdarti,
    }
  }).done(function(data) {
    if (data['colors'].length == 0) {
      backToStep1();
      $('#step1warning').show();
    } else {
      availableColors = [];
      for (var i = 0; i < data['colors'].length; i++) {
        availableColors.push(data['colors'][i]['cdcolo']);
      }
      $("#modal-add-row-cdcolo").autocomplete({
        source: availableColors
      });
      showStep2(cdarti);
    }
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});
$('#modal-back-to-select-article').click(function(){
  backToStep1();
});
$('#modal-select-color').click(function(){
  backToStep2();
  var cdarti = $('#modal-add-row-cdarti').val();
  var cdcolo = $('#modal-add-row-cdcolo').val();

  $.ajax({
    type: "POST",
    url: "{{ url('admin/getVariantsForCurrentArticleAndColor') }}",
    dataType: "json",
    data: {
      cdcata: "{{ order.cdcata }}",
      cdarti: cdarti,
      cdcolo: cdcolo,
    }
  }).done(function(data) {
    if (data['error']) {
      backToStep2();
      $('#step2warning').show();
    } else {
      showStep3(cdcolo, data['html']);
    }
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});
$('#modal-back-to-select-color').click(function(){
  backToStep2();
});
$(document).on('hide.bs.modal', '.modal-add-row', function (e) {
  backToStep2();
  backToStep1();
  $('#modal-add-row-cdarti').val('');
  $('#add-row').hide();
});
$('#add-row').click(function() {
  var cdarti = $('#modal-add-row-cdarti').val();
  var cdcolo = $('#modal-add-row-cdcolo').val();
  var cdvari = '';
  $('.variant-selector').each(function(){
    cdvari += '' + $(this).val();
  });
  var octagl = [];
  $('#step3 input[type="number"]').each(function(){
    octagl.push([
      $(this).data('dstagl'),
      $(this).val()
    ]);
  });
  $.ajax({
    type: "POST",
    url: "{{ url('admin/addRowToOrder') }}",
    dataType: "json",
    data: {
      nuordc: "{{ order.nuordc }}",
      cdcata: "{{ order.cdcata }}",
      cdarti: cdarti,
      cdcolo: cdcolo,
      cdvari: cdvari,
      octagl: octagl,
    }
  }).done(function(data) {
    location.href = "{{ url('admin/order/w/' ~ order.nuordc ~ '/b') }}"
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
})
{% endif %}

{% if dateMgmt > 1 %}
// Date management
$.datepicker.setDefaults($.datepicker.regional.{{ session.get('language') }});
$('.datepicker-row-dtmcli').datepicker({ dateFormat: 'dd/mm/yy', minDate: 0, autoOpen: false,
  onSelect: function(dateText, inst) {
    var dtmcli = dateText;
    var nurorc = $(this).closest('.order-detail-rows-line').data('nurorc');

    $.ajax({
      type: "POST",
      url: "{{ url('admin/updateOrderRowDate') }}",
      dataType: "json",
      data: {
        nurorc: nurorc,
        dtmcli: dtmcli,
      }
    }).done(function(data) {

    }).error(function(x, t, m) {
      printAjaxError(x, t, m);
    });
  }
});
{% endif %}

// Multiple update
$('input[name="nurorc-checkbox[]"]').change(function(){
  var total = $('input[name="nurorc-checkbox[]"]:checked').length;

  if (total == 1) {
    // First checkbox is checked -> hide all checkboxes for lines with different cdtagl
    var currCdtagl = $(this).closest('.order-detail-rows-line').data('cdtagl');
    $('.order-detail-rows-line').each(function(){
      if ($(this).data('cdtagl') != currCdtagl) {
        $(this).find('input[name="nurorc-checkbox[]"]').hide();
      }
    });
    $('.delete-edit').removeClass('disabled');
    $('.multiple-edit').removeClass('disabled');
  } else if (total == 0) {
    // Show all checkboxes
    $('.order-detail-rows-line input[name="nurorc-checkbox[]"]').hide();
    $('.delete-edit').addClass('disabled');
    $('.multiple-edit').addClass('disabled');
  }
});

{% if dateMgmt > 1 %}
$('#multiple-dtmcli').datepicker({ dateFormat: 'dd/mm/yy', minDate: 0, autoOpen: false });
{% endif %}

$('.multiple-edit').click(function(){
  if (!$(this).hasClass('disabled')) {
    var multipleNurorc = '';
    $('input[name="nurorc-checkbox[]"]:checked').closest('.order-detail-rows-line').each(function(){
      multipleNurorc += $(this).data('nurorc') + ',';
    });
    $('#modal-multiple-nurorc').val(multipleNurorc.slice(0,-1));

    var cdtagl = $('input[name="nurorc-checkbox[]"]:checked').closest('.order-detail-rows-line').data('cdtagl');

    $('#multiple-sizes').html('');
    $('#multiple-dtmcli').html('');
    $('#multiple-scont1').html('');
    $('#multiple-scont2').html('');
    $('#multiple-scont3').html('');
    $('#multiple-dsnoco').html('');

    $.ajax({
      type: "POST",
      url: "{{ url('admin/getOrderRowSizes') }}",
      dataType: "json",
      data: {
        cdtagl: cdtagl
      }
    }).done(function(data) {
      $('#multiple-sizes').html(data['html']);
      $('.modal-multiple-edit').modal('show');
    }).error(function(x, t, m) {
      printAjaxError(x, t, m);
    });
  }
});

$('#save-multiple').click(function(){
  // Nurorc's
  var nurorcs = $('#modal-multiple-nurorc').val().split(',')

  // Sizes
  var octagl = [];
  $('.multiple-quanti input').each(function(){
    octagl.push([
      $(this).data('dstagl'),
      $(this).val() != '' ? $(this).val() : 0
    ]);
  });

  // Dtmcli
  var dtmcli = $('#multiple-dtmcli').val() != '' ? $('#multiple-dtmcli').val() : '00/00/0000';

  // Discounts
  var scont1 = $('#multiple-scont1').val() != '' ? $('#multiple-scont1').val() : 0;
  var scont2 = $('#multiple-scont2').val() != '' ? $('#multiple-scont2').val() : 0;
  var scont3 = $('#multiple-scont3').val() != '' ? $('#multiple-scont3').val() : 0;

  // Notes
  var dsnoco = $('#multiple-dsnoco').val();

  $.ajax({
    type: "POST",
    url: "{{ url('admin/updateMultipleOrderRows') }}",
    dataType: "json",
    data: {
      nurorc: nurorcs,
      octagl: octagl,
      dtmcli: dtmcli,
      scont1: scont1,
      scont2: scont2,
      scont3: scont3,
      dsnoco: dsnoco,
    }
  }).done(function(data) {
    for (var i = 0; i < nurorcs.length; i++) {
      var currNurorc = nurorcs[i];
      var currLine = $('.order-detail-rows-line[data-nurorc=' + nurorcs[i] + ']');
      var currY = currLine.data('y');

      // Update date
      currLine.find('.datepicker-row-dtmcli').val(dtmcli != '00/00/0000' ? dtmcli : '');

      // Update notes
      currLine.find('.notes-text').html(dsnoco);
      if (dsnoco != '') {
        currLine.find('.glyphicon-plus').hide();
        currLine.find('.glyphicon-bookmark').show();
      } else {
        currLine.find('.glyphicon-plus').show();
        currLine.find('.glyphicon-bookmark').hide();
      }

      // Update sizes
      for (var j = 0; j < octagl.length; j++) {
        var currSize = $('#' + j + '_' + currY);
        currSize.find('.read-quanti').html(octagl[j][1]);
        currSize.find('.edit-quanti input').val(octagl[j][1]);
      }

      // Update total row quantity
      updateTotQuantityForLine(currY);

      // Update discounts
      $('#dsc1_' + currY).val(scont1);
      $('#dsc1_' + currY).closest('.order-detail-rows-cell.edit').find('.read-discount').html(scont1);
      $('#dsc2_' + currY).val(scont2);
      $('#dsc2_' + currY).closest('.order-detail-rows-cell.edit').find('.read-discount').html(scont2);
      $('#dsc3_' + currY).val(scont3);
      $('#dsc3_' + currY).closest('.order-detail-rows-cell.edit').find('.read-discount').html(scont3);

      // Update total row value
      updateTotAmountForLine(currY);

      $('.modal-multiple-edit').modal('hide');
    }

    // Update total value for order
    updateTotalForOrder();
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

$('#delete-multiple').click(function(){
  var nurorcs = $("input:checkbox[name='nurorc-checkbox[]']:checked").map(function(){return $(this).val()}).get();
  $.ajax({
    type: "POST",
    url: "{{ url('admin/deleteMultipleOrderRows') }}",
    dataType: "json",
    data: {
      nurorc: nurorcs,
    }
  }).done(function(data) {
    location.reload();
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

$('#delete-no-qty').click(function(){
  $.ajax({
    type: "POST",
    url: "{{ url('admin/deleteOrderRowsWithNoQuantity') }}",
    dataType: "json",
    data: {
      nuordc: "{{ nuordc }}",
    }
  }).done(function(data) {
    location.reload();
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

// Bind size quantity input to size quantity div
$('.order-detail-size-box .edit-quanti input').change(function(){
  var quanti = $.isNumeric($(this).val()) ? $(this).val() : 0;
  $(this).val(quanti);
  $(this).closest('.order-detail-size-box').find('.read-quanti').html(quanti);
});

// Click on size boxes
$('.order-detail-size-box.edit').click(function(){
  if ($('.order-detail-size-box.edit.selected').length == 1) {
    checkQuantityChanged($('.order-detail-size-box.edit.selected').data('y'));
  }
  $('.order-detail-rows-cell.edit').removeClass('selected');
  $('.order-detail-size-box.edit').removeClass('selected');
  $(this).addClass('selected');
  $(this).find('input').focus();
  $(this).find('input').select();
});
// Click on discount boxes
$('.order-detail-rows-cell.edit').click(function(){
  $('.order-detail-size-box.edit').removeClass('selected');
  $('.order-detail-rows-cell.edit').removeClass('selected');
  $(this).addClass('selected');
  $(this).find('input').focus();
  $(this).find('input').select();
});
// Click outside size or discount boxes
$(document).mouseup(function(e) {
  var container = $(".order-detail-size-box,.order-detail-rows-cell");

  var y = $('.order-detail-size-box.edit.selected').data('y');

  // if the target of the click isn't the container nor a descendant of the container
  if (!container.is(e.target) && container.has(e.target).length === 0) {
    checkQuantityChanged(y)
    container.removeClass('selected');
  }
});
// Handle keyboard commands
$(document).keydown(function(e) {
  if ($('#tab_content_bdy').hasClass('active')) {
    if ($('.order-detail-size-box.edit.selected').length == 1) {
      handleKeyPressOnSizes(e);
    } else if ($('.order-detail-rows-cell.edit.selected').length == 1) {
      handleKeyPressOnDiscounts(e);
    }
  }
});

// Handle keyboard commands for sizes
function handleKeyPressOnSizes(e) {
  var currElement = $('.order-detail-size-box.edit.selected');
  var x = currElement.data('x');
  var y = currElement.data('y');
  switch(e.which) {
    case 37: // left
      e.preventDefault(); // prevent the default action (scroll / move caret)
      changeSizeBoxSelected(true, false, x, y);
      break;

    case 38: // up
      e.preventDefault(); // prevent the default action (scroll / move caret)
      changeSizeBoxSelected(false, false, x, y);
      break;

    case 13: // enter
    case 39: // right
      e.preventDefault(); // prevent the default action (scroll / move caret)
      changeSizeBoxSelected(true, true, x, y);
      break;

    case 40: // down
      e.preventDefault(); // prevent the default action (scroll / move caret)
      changeSizeBoxSelected(false, true, x, y);
      break;

    default: return; // exit this handler for other keys
  }
}
function checkQuantityChanged(y) {
  var newValue = $('.order-detail-size-box.edit.selected input').val();
  var oldValue = $('.order-detail-size-box.edit.selected .read-quanti').html();

  if (newValue != oldValue) {
    var dstagl = $('.order-detail-size-box.edit.selected input').data('dstagl');
    var nurorc = $('.order-detail-rows-line[data-y=' + y + ']').data('nurorc');

    // Update database
    updateSizeQuantityOnDatabase(nurorc, dstagl, newValue);

    // Update total row quantity
    updateTotQuantityForLine(y);

    // Update total row value
    updateTotAmountForLine(y);

    // Update total value for order
    updateTotalForOrder();
  }
}
function changeSizeBoxSelected(isChangingX, isNext, x, y) {
  checkQuantityChanged(y);

  // Remove border
  $('.order-detail-size-box.edit.selected').removeClass('selected');

  // Check where border is needed
  var lastRow = $('#last-row');
  if (isChangingX) {
    if (isNext) {
      if ($('#' + (x + 1) + '_' + y).length == 1) {
        $('#' + (x + 1) + '_' + y).addClass('selected');
      } else if ($('#0_' + (y + 1)).length == 1) {
        $('#0_' + (y + 1)).addClass('selected');
      } else if ($('#0_0').length == 1) {
        $('#0_0').addClass('selected');
      }
    } else {
      var previousRow = $('.order-detail-rows-line[data-y=' + (y - 1) + ']').length == 1
        ? $('.order-detail-rows-line[data-y=' + (y - 1) + ']')
        : $('#last-row');
      if ($('#' + (x - 1) + '_' + y).length == 1) {
        $('#' + (x - 1) + '_' + y).addClass('selected');
      } else if ($('#' + previousRow.data('x') + '_' + (y - 1)).length == 1) {
        $('#' + previousRow.data('x') + '_' + (y - 1)).addClass('selected');
      } else if ($('#' + lastRow.data('x') + '_' + lastRow.data('y')).length == 1) {
          $('#' + lastRow.data('x') + '_' + lastRow.data('y')).addClass('selected');
      }
    }
  } else {
    if (isNext) {
      var nextRow = $('.order-detail-rows-line[data-y=' + (y + 1) + ']').length == 1
        ? $('.order-detail-rows-line[data-y=' + (y + 1) + ']')
        : $('.order-detail-rows-line[data-y=0]');
      if ($('#' + x + '_' + nextRow.data('y')).length == 1) {
        $('#' + x + '_' + nextRow.data('y')).addClass('selected');
      } else if ($('#' + nextRow.data('x') + '_' + nextRow.data('y')).length == 1) {
        $('#' + nextRow.data('x') + '_' + nextRow.data('y')).addClass('selected');
      }
    } else {
      var previousRow = $('.order-detail-rows-line[data-y=' + (y - 1) + ']').length == 1
        ? $('.order-detail-rows-line[data-y=' + (y - 1) + ']')
        : $('#last-row');
      if ($('#' + x + '_' + previousRow.data('y')).length == 1) {
        $('#' + x + '_' + previousRow.data('y')).addClass('selected');
      } else if ($('#' + previousRow.data('x') + '_' + previousRow.data('y')).length == 1) {
        $('#' + previousRow.data('x') + '_' + previousRow.data('y')).addClass('selected');
      }
    }
  }

  // Focus input field
  $('.order-detail-size-box.edit.selected input').focus();
  $('.order-detail-size-box.edit.selected input').select();
}

// Handle Keyboard commands for discounts
function handleKeyPressOnDiscounts(e) {
  var currElement = $('.order-detail-rows-cell.edit.selected input');
  var x = currElement.data('x');
  var y = currElement.data('y');
  switch(e.which) {
    case 37: // left
      e.preventDefault(); // prevent the default action (scroll / move caret)
      changeDiscountBoxSelected(true, false, x, y);
      break;

    case 38: // up
      e.preventDefault(); // prevent the default action (scroll / move caret)
      changeDiscountBoxSelected(false, false, x, y);
      break;

    case 13: // enter
    case 39: // right
      e.preventDefault(); // prevent the default action (scroll / move caret)
      changeDiscountBoxSelected(true, true, x, y);
      break;

    case 40: // down
      e.preventDefault(); // prevent the default action (scroll / move caret)
      changeDiscountBoxSelected(false, true, x, y);
      break;

    default: return; // exit this handler for other keys
  }
}
function changeDiscountBoxSelected(isChangingX, isNext, x, y) {
  var newValue = $('.order-detail-rows-cell.edit.selected input').val() != '' ? $('.order-detail-rows-cell.edit.selected input').val() : 0;
  $('.order-detail-rows-cell.edit.selected input').val(newValue);
  var oldValue = $('.order-detail-rows-cell.edit.selected .read-discount').html();

  if (newValue != oldValue) {
    var field = $('.order-detail-rows-cell.edit.selected input').data('field');
    var nurorc = $('.order-detail-rows-line[data-y=' + y + ']').data('nurorc');

    // Update database
    updateDiscountOnDatabase(nurorc, field, newValue);

    // Update current size box value
    $('.order-detail-rows-cell.edit.selected .read-discount').html(newValue);

    // Update total row value
    updateTotAmountForLine(y);

    // Update total value for order
    updateTotalForOrder();
  }

  // Remove border
  $('.order-detail-rows-cell.edit.selected').removeClass('selected');

  // Check where border is needed
  var lastY = $('#last-row').data('y');
  var currDiscount = x + 1;
  if (isChangingX) {
    if (isNext) {
      if (currDiscount < 3) {
        $('#dsc' + (currDiscount + 1) + '_' + y).closest('.order-detail-rows-cell.edit').addClass('selected');
      } else if (y < lastY) {
        $('#dsc1_' + (y + 1)).closest('.order-detail-rows-cell.edit').addClass('selected');
      } else {
        $('#dsc1_0').closest('.order-detail-rows-cell.edit').addClass('selected');
      }
    } else {
      if (currDiscount > 1) {
        $('#dsc' + (currDiscount - 1) + '_' + y).closest('.order-detail-rows-cell.edit').addClass('selected');
      } else if (y > 0) {
        $('#dsc3_' + (y - 1)).closest('.order-detail-rows-cell.edit').addClass('selected');
      } else {
        $('#dsc3_' + lastY).closest('.order-detail-rows-cell.edit').addClass('selected');
      }
    }
  } else {
    if (isNext) {
      if (y < lastY) {
        $('#dsc' + currDiscount + '_' + (y + 1)).closest('.order-detail-rows-cell.edit').addClass('selected');
      } else {
        $('#dsc' + currDiscount + '_0').closest('.order-detail-rows-cell.edit').addClass('selected');
      }
    } else {if (y > 0) {
        $('#dsc' + currDiscount + '_' + (y - 1)).closest('.order-detail-rows-cell.edit').addClass('selected');
      } else {
        $('#dsc' + currDiscount + '_' + lastY).closest('.order-detail-rows-cell.edit').addClass('selected');
      }
    }
  }

  // Focus input field
  $('.order-detail-rows-cell.edit.selected input').focus();
  $('.order-detail-rows-cell.edit.selected input').select();
}

// Common functions
function updateSizeQuantityOnDatabase(nurorc, dstagl, newValue) {

  $.ajax({
    type: "POST",
    url: "{{ url('admin/updateOrderRowSize') }}",
    dataType: "json",
    data: {
      nurorc: nurorc,
      dstagl: dstagl,
      value:  newValue,
    }
  }).done(function(data) {
    if (data['statusChanged']) {
      console.log('status changed');
    }
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
}
function updateDiscountOnDatabase(nurorc, field, newValue) {
  $.ajax({
    type: "POST",
    url: "{{ url('admin/updateOrderRowDiscount') }}",
    dataType: "json",
    data: {
      nurorc: nurorc,
      field:  field,
      value:  newValue,
    }
  }).done(function(data) {

  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
}
function updateTotQuantityForLine(y) {
  var totValue = 0;
  $('.order-detail-size-box[data-y=' + y + '] input').each(function(){
    totValue += parseInt($(this).val());
  });
  $('#tot_' + y).html(totValue);
}
function updateTotAmountForLine(y) {
  var totValue = parseFloat($('#tot_' + y).html());
  var prezzo = parseFloat($('.order-detail-rows-line[data-y=' + y + ']').data('prezzo'));
  var scont1 = parseFloat($('#dsc1_' + y).val());
  var scont2 = parseFloat($('#dsc2_' + y).val());
  var scont3 = parseFloat($('#dsc3_' + y).val());
  var totale = totValue * prezzo * (1 - (scont1 / 100)) * (1 - (scont2 / 100)) * (1 - (scont3 / 100));
  $('#amt_' + y).html(parseFloat(totale).formatMoney(2, ",", ".") + " {{ currency }}");
}
function updateTotalForOrder() {
  var totOrder = 0;
  var isWaitingQuantity = true;
  $('.order-detail-rows-line').each(function(){
    var currY = $(this).data('y');
    var prezzo = $(this).data('prezzo');
    var quanti = parseInt($('#tot_' + currY).html());
    var scont1 = parseFloat($('#dsc1_' + currY).val());
    var scont2 = parseFloat($('#dsc2_' + currY).val());
    var scont3 = parseFloat($('#dsc3_' + currY).val());
    totOrder += parseFloat(prezzo * quanti * (1 - (scont1 / 100)) * (1 - (scont2 / 100)) * (1 - (scont3 / 100)));
    isWaitingQuantity &= parseInt(quanti) == 0;
  });
  $('.order-total').html(parseFloat(totOrder).formatMoney(2, ",", ".") + " {{ currency }}");
  if (isWaitingQuantity) {
    $('#order-state-text').show();
    $('#order-state-select').hide();
    $('#order-state-select').removeClass('active');
  } else {
    $('#order-state-text').hide();
    $('#order-state-select').show();
    $('#order-state-select').addClass('active');
  }
  updateStateClass();
  updateOrderStateIfNeeded();
}
{% endif %}
</script>
