<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
$(document).ready(function() {
  $('#table-customers').DataTable({
    'order': [],
    'otherOptions': {},
    'bPaginate': false,
    'bInfo': false, // hide showing entries
    'columns': [
      { "orderable": true, "width": "16%" },
      { "orderable": true, "width": "16%" },
      { "orderable": true, "width": "34%" },
      { "orderable": true, "width": "18%" },
      { "orderable": true, "width": "11%" },
      { "orderable": false, "width": "5%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});

$('#show-provisional').click(function() {
  if ($(this).is(':checked')) {
    $('tr[data-type="CN"]').show();
  } else {
    $('tr[data-type="CN"]').hide();
  }
});

$('#show-final').click(function() {
  if ($(this).is(':checked')) {
    $('tr[data-type="CL"]').show();
  } else {
    $('tr[data-type="CL"]').hide();
  }
});

$('.see-detail').click(function(){
  var tpanag = $(this).closest('tr').data('tpanag');
  var cdanag = $(this).closest('tr').data('cdanag');

  $.ajax({
    type: "POST",
    url: "{{ url('admin/getCustomerDetail') }}",
    dataType: "json",
    data: {
      tpanag: tpanag,
      cdanag: cdanag,
    }
  }).done(function(data) {
    $('#modal-newcod').html(data['tpanag'] == 'CN' ? data['cdanag'] : data['newcod']);
    $('#modal-cdanag').html(data['tpanag'] == 'CN' ? '' : data['cdanag']);
    $('#modal-descri').html(data['descri']);
    $('#modal-desvid').html(data['desvid']);
    $('#modal-pariva').html(data['pariva']);
    $('#modal-codfis').html(data['codfis']);
    $('#modal-codupr').html(data['codupr']);
    $('#modal-uffipa').html(data['uffipa']);
    $('#modal-indiri').html(data['indiri']);
    $('#modal-ccitta').html(data['ccitta']);
    $('#modal-codcap').html(data['codcap']);
    $('#modal-provin').html(data['provin']);
    $('#modal-dsnazi').html(data['dsnazi']);
    $('#modal-dszona').html(data['dszona']);
    $('#modal-intern').html(data['intern']);
    $('#modal-numtel').html(data['numtel']);
    $('#modal-numcel').html(data['numcel']);
    $('#modal-numfax').html(data['numfax']);
    $('#modal-indema').html(data['indema']);
    $('#modal-indem2').html(data['indem2']);
    $('#modal-codabi').html(data['codabi']);
    $('#modal-codcab').html(data['codcab']);
    $('#modal-cdiban').html(data['cdiban']);
    $('#modal-dspaga').html(data['dspaga']);
    $('#modal-dstpor').html(data['dstpor']);
    $('#modal-dsvett').html(data['dsvett']);
    $('#modal-dsagen').html(data['dsagen']);
    $('.modal-customer-detail').modal('show');
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

$('.delete-customer').click(function(){
  var cdanag = $(this).closest('tr').data('cdanag');
  $('#modal-delete-cdanag').val(cdanag);
});

$('#delete-customer').click(function() {
  $.ajax({
    type: "POST",
    url: "{{ url('admin/deleteNewCustomer') }}",
    dataType: "json",
    data: {
      cdanag: $('#modal-delete-cdanag').val()
    }
  }).done(function(data) {
    window.location.reload();
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

$('#send-email').click(function() {
  $('.msg-error').hide();
  $('.msg-success').hide();

  $.ajax({
    type: "POST",
    url: "{{ url('admin/sendNewCustomersEmail') }}",
    dataType: "json",
  }).done(function(data) {
    showTemporary(".msg-success", 2000);
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});
</script>
