<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
$(document).ready(function() {
  $('#table-agents').DataTable({
    'pageLength': 100,
    'order': [],
    'columns': [
      { "orderable": false, "width": "4%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "36%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "20%" }
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
  $('#table-headoffices').DataTable({
    'bInfo': false,
    'bPaginate': false,
    'searching': false,
    'order': [],
    'columns': [
      { "orderable": false, "width": "4%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "36%" },
      { "orderable": true, "width": "20%" },
      { "orderable": true, "width": "20%" }
    ],
    'pageLength': 100,
    {% include 'scripts/common/table_language.volt' %}
  });
  $('#table-customers').DataTable({
    'pageLength': 100,
    'order': [],
    'columns': [
      { "orderable": false },
      { "orderable": true },
      { "orderable": true },
      { "orderable": true },
      { "orderable": true }
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
  $('#table-shippings').DataTable({
    'pageLength': 100,
    'order': [],
    'columns': [
      { "orderable": false },
      { "orderable": true },
      { "orderable": true },
      { "orderable": true },
      { "orderable": true },
      { "orderable": true },
      { "orderable": true }
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});
$('#select-all-agents').click(function() {
  if ($(this).is(':checked')) {
    $('.checkbox-agent input').prop('checked', true);
  } else {
    $('.checkbox-agent input').prop('checked', false);
  }
});
$('.checkbox-agent input').click(function(){
  if ($('.checkbox-agent input:checked').length == $('.checkbox-agent input').length) {
    $('#select-all-agents').prop('checked', true);
  } else {
    $('#select-all-agents').prop('checked', false);
  }
});
$('#select-all-customers').click(function() {
  if ($(this).is(':checked')) {
    $('.checkbox-customer input').prop('checked', true);
  } else {
    $('.checkbox-customer input').prop('checked', false);
  }
});
$('.checkbox-customer input').click(function(){
  if ($('.checkbox-customer input:checked').length == $('.checkbox-customer input').length) {
    $('#select-all-customers').prop('checked', true);
  } else {
    $('#select-all-customers').prop('checked', false);
  }
});
$('#select-all-shippings').click(function() {
  if ($(this).is(':checked')) {
    $('.checkbox-shipping input').prop('checked', true);
  } else {
    $('.checkbox-shipping input').prop('checked', false);
  }
});
$('.checkbox-shipping input').click(function(){
  if ($('.checkbox-shipping input:checked').length == $('.checkbox-shipping input').length) {
    $('#select-all-shippings').prop('checked', true);
  } else {
    $('#select-all-shippings').prop('checked', false);
  }
});
$('.link-catalogs').click(function(){
  var idusrs = new Array();
  $("input[name='status-checkbox[]']:checked").each(function(){
    idusrs.push($(this).val());
  });

  var cdcatas = new Array();
  $("input[name='catalogs[]']:checked").each(function(){
    cdcatas.push($(this).val());
  });

  var mode = $('input[name="radio-mode"]:checked').val();

  if (cdcatas.length == 0) {
    showMessageTemporary(".msg-form-error", "{{ mt._('admin.linkcatalogs.missingcatalog') }}", 10000);
  } else if (idusrs.length == 0) {
    showMessageTemporary(".msg-form-error", "{{ mt._('admin.linkcatalogs.missinguser') }}", 10000);
  } else {
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/dolinkcatalogs') }}",
      dataType: 'json',
      data: {
        cdcatas:  cdcatas,
        idusrs:   idusrs,
        mode:     mode,
      }
    }).done(function(data) {
      location.href = "{{ url('admin/linkcatalogs') }}";
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });
  }
});
$('.link-catalogs-to-all').click(function(){
  var idusrs = new Array();
  $("#table-agents").dataTable().$('tr', {"filter":"applied"}).each(function(){
    idusrs.push($(this).find("input[name='status-checkbox[]']").val());
  });
  $("#table-headoffices").dataTable().$('tr', {"filter":"applied"}).each(function(){
    idusrs.push($(this).find("input[name='status-checkbox[]']").val());
  });
  $("#table-customers").dataTable().$('tr', {"filter":"applied"}).each(function(){
    idusrs.push($(this).find("input[name='status-checkbox[]']").val());
  });
  $("#table-shippings").dataTable().$('tr', {"filter":"applied"}).each(function(){
    idusrs.push($(this).find("input[name='status-checkbox[]']").val());
  });

  var cdcatas = new Array();
  $("input[name='catalogs[]']:checked").each(function(){
    cdcatas.push($(this).val());
  });

  var mode = $('input[name="radio-mode"]:checked').val();

  if (cdcatas.length == 0) {
    showMessageTemporary(".msg-all-error", "{{ mt._('admin.linkcatalogs.missingcatalog') }}", 10000);
  } else {
    $('.link-catalogs-to-all-container').addClass('loading');
    showMessageTemporary(".msg-all-error", "{{ mt._('admin.menu.syncwarning') }}", 10000);

    $.ajax({
      type: 'POST',
      url: "{{ url('admin/dolinkcatalogs') }}",
      dataType: 'json',
      data: {
        cdcatas:  cdcatas,
        idusrs:   idusrs,
        mode: mode
      }
    }).done(function(data) {
      location.href = "{{ url('admin/linkcatalogs') }}";
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });
  }
});
</script>
