<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}

<script>
$(document).ready(function(){
  $('#datatable-keytable').DataTable({
    'order': [[ 0, 'asc' ]],
    'pageLength': 100,
    'columns': [
      { "orderable": true, "width": "14%" },
      { "orderable": false, "width": "8%" },
      { "orderable": false, "width": "8%" },
      { "orderable": false, "width": "14%" },
      { "orderable": false, "width": "14%" },
      { "orderable": false, "width": "14%" },
      { "orderable": false, "width": "14%" },
      { "orderable": false, "width": "14%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});

$('.save-visibility').click(function(){
  $('.msg-success').hide();
  $('.msg-error').hide();

  var flvisi = [];
  $('#datatable-keytable tbody tr').each(function(){
    var codic1 = $(this).data('codic1');
    var codic2 = $(this).data('codic2');
    var flbloc = $(this).find('input[type="checkbox"]').is(':checked') ? 1 : 0;
    var des_it = $(this).find('input[name="des_it"]').val();
    var des_en = $(this).find('input[name="des_en"]').val();
    var des_es = $(this).find('input[name="des_es"]').val();
    var des_de = $(this).find('input[name="des_de"]').val();
    var des_fr = $(this).find('input[name="des_fr"]').val();
    var seqrap = $(this).find('input[name="seqrap"]').val();
    flvisi.push({ codic1, codic2, flbloc, des_it, des_en, des_es, des_de, des_fr, seqrap });
  });

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/saveFilterVisibility') }}",
    dataType: 'json',
    data: {
      flvisi: flvisi
    }
  }).done(function(data) {
    $('.msg-error').hide();
    showTemporary(".msg-success", 2000);
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
    $('.msg-success').hide();
    showTemporary(".msg-error", 2000);
  });
});

</script>
