<!-- BootStrapDualListBox -->
{{ javascript_include("vendors/bootstrap-duallistbox-master/dist/jquery.bootstrap-duallistbox.js") }}
<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
<!-- DropZone -->
{{ javascript_include("vendors/dropzone/dist/min/dropzone.min.js") }}
<script type="text/javascript">// Immediately after the js include
    Dropzone.autoDiscover = false;
</script>
<script>
    $(document).ready(function () {
        loadHomepageCatalog();
    });

    // Logo
    $('#dropzone-logo-image').dropzone({
        init: function () {
            this.on("maxfilesexceeded", function (file) {
                this.removeAllFiles();
                this.addFile(file);
            });
            this.on("complete", function (file) {
                this.removeAllFiles(true);
            })
        },
        acceptedFiles: 'image/jpeg',
        dictDefaultMessage: "{{ mt._('_common.image.change') }}",
        dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
        dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
        success: function (response) {
            $('input[name=logo][value=1]').prop('checked', true);
            $('#custom-logo-preview').prop('src', '../img/' + response.name);
            $('#custom-logo-flimag').val(response.name);
        },
        addRemoveLinks: true,
        maxFiles: 1,
        removedfile: function (file) {
            var _ref; // Remove file on clicking the 'Remove file' button
            return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
        }
    });

    // FIRST PANEL: save default catalog
    $('#save-default-catalog').click(function (e) {
        e.preventDefault();
        $("#msg-default-ctl-error").hide();
        $("#msg-default-ctl-success").hide();
        var btn = $(this);

        btn.prop("disabled", true);
        $.ajax({
            type: 'POST',
            url: "{{ url('admin/saveDefaultCatalog') }}",
            dataType: 'json',
            data: {
                cdcata: $("#defaultcatalog").val(),
            }
        }).done(function (data) {
            if (data == "OK") {
                showTemporary("#msg-default-ctl-success", 2000);
            } else {
                $('#msg-ctl-error').show();
            }
            btn.prop("disabled", false);
        }).error(function (x, t, m) {
            printAjaxError(x, t, m);
            btn.prop("disabled", false);
        });
    });

    // SECOND PANEL: banner slider
    function checkFileExt(filename) {
        filename = filename.toLowerCase();
        return filename.split('.').pop();
    }

    $('.dropzone-slide').dropzone({
        init: function () {
            this.on("maxfilesexceeded", function (file) {
                this.removeAllFiles();
                this.addFile(file);
            });
        },
        acceptedFiles: 'image/jpeg, video/mp4',
        dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles') }}",
        dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
        dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
        success: function (response) {
            console.log(response);
            var ext = checkFileExt(response.name); // Get extension
            var newimage = "";

            // Check extension
            if (ext != 'png' && ext != 'jpg' && ext != 'jpeg') {
                newimage = response.name + ".jpg";
                console.log(newimage);
            }

            response.previewElement.querySelector("img").src = '../upload/' + newimage;
        },
        addRemoveLinks: true,
        maxFiles: 1,
        removedfile: function (file) {
            var _ref; // Remove file on clicking the 'Remove file' button
            return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
        }
    });

    // SECOND PANEL: blocks
    $("#homepage-catalog").change(function () {
        $("#homepage-ctl-loading").show();
        loadHomepageCatalog();
        $(".error-input").removeClass("error-input");
        $('.msg-homepage-ctl-success').hide();
        $('.msg-homepage-ctl-error').hide();
    });

    $('.new-block').click(function () {
        var indexes = $(".homepage-block-container").map(function () {
            return parseInt($(this).attr("data-index"));
        }).get();
        var index = indexes.length > 0 ? Math.max.apply(null, indexes) + 1 : 1;

        $.ajax({
            type: 'POST',
            url: "{{ url('admin/getNewBlockForHomepage') }}",
            dataType: 'json',
            data: {
                index: index,
            }
        }).done(function (data) {
            $('#hpcorp-content').append(data);
            updateDropzoneForBlock(index);
        }).error(function (x, t, m) {
            printAjaxError(x, t, m);
        });
    });

    function setDropzoneImage(element, img, mockFile) {
        Dropzone.forElement(element).removeAllFiles(true);
        Dropzone.forElement(element).emit("addedfile", mockFile);
        Dropzone.forElement(element).emit("thumbnail", mockFile, "../upload/" + img + (img.substr(-3) != 'mp4' ? '' : ".jpg"));
        Dropzone.forElement(element).emit("complete", mockFile);
        Dropzone.forElement(element).files.push(mockFile); // file must be added manually
    }

    var dropzoneInit = {
        init: function () {
            this.on("maxfilesexceeded", function (file) {
                this.removeAllFiles();
                this.addFile(file);
            });
        },
        acceptedFiles: 'image/jpeg',
        dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles') }}",
        dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
        dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
        success: function (response) {
            console.log(response);
        },
        addRemoveLinks: true,
        maxFiles: 1,
        removedfile: function (file) {
            var _ref; // Remove file on clicking the 'Remove file' button
            return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
        }
    };

    function updateDropzoneForBlock(index) {
        var y = index;
        var block = $(".homepage-block-container[data-index=" + y + "]");
        block.find('.blockbox').each(function () {
            var x = $(this).data('index');
            if ($(this).find(".dropzone-box .dz-default").length == 0) {
                $(this).find(".dropzone-box").dropzone(dropzoneInit);
            }
            if ($(this).data('flimag') != '') {
                var mockFile = {name: $(this).data('flimag'), size: 12345};
                setDropzoneImage('.homepage-block-container[data-index="' + y + '"] .box-' + x + ' .dropzone-box', $(this).data('flimag'), mockFile);
            }
        });
    }

    function toggleBox(box, show) {
        box.find(".hiddenbox").prop("checked", show);
        box.find(".hiddenbox").change();
    }

    function resetBox(box) {
        box.find(".descr-it").val("");
        box.find(".descr-en").val("");
        box.find(".descr-es").val("");
        box.find(".descr-de").val("");
        box.find(".descr-fr").val("");
        box.find(".element-select").val("NO");
        box.find(".code-select").val("");
    }

    $('#hpcorp-content').on('click', '.delete-block', function () {
        var index = $(this).closest('.homepage-block-container').data('index');
        $('#modal-delete-index').val(index);
    });
    $('#delete-index').click(function () {
        var index = $('#modal-delete-index').val();
        $('.homepage-block-container[data-index="' + index + '"]').remove();
        $('.homepage-block-container').each(function () {
            var currIndex = $(this).data('index');
            if (currIndex > index) {
                var newIndex = currIndex - 1;
                $('.homepage-block-container[data-index="' + currIndex + '"]').find('.title-index').html(newIndex);
                $('.homepage-block-container[data-index="' + currIndex + '"]').data('index', newIndex);
                $('.homepage-block-container[data-index="' + currIndex + '"]').attr('data-index', newIndex);
            }
        });
    })

    $('#hpcorp-content').on('change', '.block-select', function () {
        const selectedVal = parseInt($(this).val()) ?? 0;
        const xContent = $(this).closest(".x_content");
        const box1 = xContent.find(".box-1");
        const box2 = xContent.find(".box-2");
        const box3 = xContent.find(".box-3");
        const box4 = xContent.find(".box-4");

        box1.removeClass(function (index, className) {
            return (className.match(/\bcol-\S+/g) || []).join(' ');
        });
        box2.removeClass(function (index, className) {
            return (className.match(/\bcol-\S+/g) || []).join(' ');
        });
        box3.removeClass(function (index, className) {
            return (className.match(/\bcol-\S+/g) || []).join(' ');
        });
        box4.removeClass(function (index, className) {
            return (className.match(/\bcol-\S+/g) || []).join(' ');
        });

        xContent.find(".sizeimg").hide();
        xContent.find(".sizeimg" + selectedVal).show();

        switch (selectedVal) {
            case 0:
                box1.addClass("col-md-12 col-sm-12 col-xs-12");
                box2.hide();
                box3.hide();
                box4.hide();
                break;
            case 1:
                box1.addClass("col-md-6 col-sm-6 col-xs-6");
                box2.addClass("col-md-6 col-sm-6 col-xs-6");
                box2.show();
                box3.hide();
                box4.hide();
                break;
            case 2:
                box1.addClass("col-md-4 col-sm-4 col-xs-4");
                box2.addClass("col-md-4 col-sm-4 col-xs-4");
                box2.show();
                box3.addClass("col-md-4 col-sm-4 col-xs-4");
                box3.show();
                box4.hide();
                break;
            case 3:
                box1.addClass("col-4 col-sm-4 col-xs-4");
                box2.addClass("col-8 col-sm-8 col-xs-8");
                box2.show();
                box3.hide();
                box4.hide();
                break;
            case 4:
                box1.addClass("col-8 col-sm-8 col-xs-8");
                box2.addClass("col-4 col-sm-4 col-xs-4");
                box2.show();
                box3.hide();
                box4.hide();
                break;
            case 5:
                box1.addClass("col-md-3 col-sm-3 col-xs-3");
                box2.addClass("col-md-3 col-sm-3 col-xs-3");
                box2.show();
                box3.addClass("col-md-3 col-sm-3 col-xs-3");
                box3.show();
                box4.addClass("col-md-3 col-sm-3 col-xs-3");
                box4.show();
                break;
            case 6:
                box1.addClass("col-md-3 col-sm-3 col-xs-3");
                box2.addClass("col-md-9 col-sm-9 col-xs-9");
                box2.show();
                box3.hide();
                box4.hide();
                break;
            case 7:
                box1.addClass("col-md-9 col-sm-9 col-xs-9");
                box2.addClass("col-md-3 col-sm-3 col-xs-3");
                box2.show();
                box3.hide();
                box4.hide();
                break;
        }
    });
    $('#hpcorp-content').on('change', '.hiddenbox', function () {
        if ($(this).is(":checked")) {
            $(this).closest(".blockbox").find(".error-input").removeClass("error-input");

            $(this).closest(".blockbox").find("div.opacity").css("opacity", "0.5");
            $(this).closest(".blockbox").find("div.opacity").css("filter", "alpha(opacity=50)");
            $(this).closest(".blockbox").find("input").prop("disabled", true);
            $(this).closest(".blockbox").find("select").prop("disabled", true);
            $(this).closest(".blockbox").find(".fake-dropzone").show();
            $(this).closest(".blockbox").find("form.dropzone-box").hide();
        } else {
            $(this).closest(".blockbox").find("div.opacity").css("opacity", "1");
            $(this).closest(".blockbox").find("div.opacity").css("filter", "alpha(opacity=100)");
            $(this).closest(".blockbox").find("input").prop("disabled", false);
            $(this).closest(".blockbox").find("select").prop("disabled", false);
            $(this).closest(".blockbox").find(".fake-dropzone").hide();
            $(this).closest(".blockbox").find("form.dropzone-box").show();
        }
        $(this).closest(".blockbox").find("input.hiddenbox").prop("disabled", false);
    });
    $('#hpcorp-content').on('change', '.element-select', function () {
        updateElementSelect($(this));
    });

    function updateElementSelect(elementSelect) {
        var code_select = elementSelect.closest(".blockbox").find(".code-select");
        var url_input = elementSelect.closest(".blockbox").find(".url-input");
        var tpbloc = elementSelect.val();
        var codice = elementSelect.data('codice');

        // Empty old options
        code_select.html("");
        url_input.val("");

        if (tpbloc == 'SL') {
            code_select.hide();
            url_input.hide();
        } else if (tpbloc == 'UR') {
            code_select.hide();
            url_input.show();
            url_input.val(codice);
        } else {
            url_input.hide();
            code_select.show();

            // Get new options
            $.ajax({
                type: 'POST',
                url: "{{ url('admin/getBlockElements') }}",
                dataType: 'json',
                data: {
                    cdcata: $("#homepage-catalog").val(),
                    tpbloc: tpbloc,
                }
            }).done(function (data) {
                code_select.html(data['html']);
                code_select.val(codice);
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        }
    }

    function loadHomepageCatalog() {
        var cdcata = $("#homepage-catalog").val();

        Dropzone.forElement("#dropzone-slide-1").removeAllFiles(true);
        Dropzone.forElement("#dropzone-slide-2").removeAllFiles(true);
        Dropzone.forElement("#dropzone-slide-3").removeAllFiles(true);

        $.ajax({
            type: 'POST',
            url: "{{ url('admin/loadHomepageCatalog') }}",
            dataType: 'json',
            data: {
                cdcata: cdcata,
            }
        }).done(function (data) {
            $("#homepage-ctl-loading").hide();
            if (data != null) {
                if (data['customLogo'] != '') {
                    $('input[name=logo][value=1]').prop('checked', true);
                    $('#custom-logo-preview').prop('src', '../img/' + data['customLogo']);
                    $('#custom-logo-flimag').val(data['customLogo']);
                } else {
                    $('input[name=logo][value=0]').prop('checked', true);
                }

                var hptest = data["hptest"];
                var hpcorp = data["hpcorp"];

                // Update home page header
                if (hptest) {
                    if (hptest["flimg1"] != '') {
                        var mockFile = {name: hptest["flimg1"], size: 12345};
                        setDropzoneImage("#dropzone-slide-1", hptest["flimg1"], mockFile);
                    }

                    if (hptest["flimg2"] != '') {
                        var mockFile = {name: hptest["flimg2"], size: 12345};
                        setDropzoneImage("#dropzone-slide-2", hptest["flimg2"], mockFile);
                    }

                    if (hptest["flimg3"] != '') {
                        var mockFile = {name: hptest["flimg3"], size: 12345};
                        setDropzoneImage("#dropzone-slide-3", hptest["flimg3"], mockFile);
                    }
                }

                // Update home page body
                $('#hpcorp-content').html(hpcorp);
                $(".homepage-block-container").each(function () {
                    var index = $(this).data('index');
                    $(this).find('.block-select').change();
                    $(this).find('.hiddenbox').change();
                    updateDropzoneForBlock(index);
                });
                updateBlock(1);
            } else {
                loadFeaturedModels();
            }
        }).error(function (x, t, m) {
            printAjaxError(x, t, m);
            $("#homepage-ctl-loading").hide();
        });
    }

    function updateBlock(index) {
        var block = $('.homepage-block-container[data-index="' + index + '"]');
        if (block.length == 1 && block.data('new') == 0) {
            updateBox(1, index);
        } else {
            loadFeaturedModels();
        }
    }

    function updateBox(x, y) {
        if (x <= 4) {
            var box = $('.homepage-block-container[data-index="' + y + '"] .box-' + x);
            var tpbloc = box.find(".element-select").val();
            var code_select = box.find(".code-select");
            var url_input = box.find(".url-input");
            var codice = tpbloc != 'UR' ? code_select.data('codice') : url_input.val();

            if (tpbloc == 'SL' || tpbloc == 'UR') {
                code_select.hide();
                x++;

                if (tpbloc == 'SL') {
                    url_input.hide();
                } else {
                    url_input.show();
                    url_input.val(codice);
                }

                updateBox(x, y);
            } else {
                url_input.hide();
                code_select.show();

                // Get new options
                $.ajax({
                    type: 'POST',
                    url: "{{ url('admin/getBlockElements') }}",
                    dataType: 'json',
                    data: {
                        cdcata: $("#homepage-catalog").val(),
                        tpbloc: tpbloc,
                    }
                }).done(function (data) {
                    code_select.html(data['html']);
                    code_select.val(codice);
                    x++;
                    updateBox(x, y);
                }).error(function (x, t, m) {
                    printAjaxError(x, t, m);
                });

            }
        } else {
            y++;
            updateBlock(y);
        }
    }

    $(".save-homepage-catalog").click(function (e) {
        e.preventDefault();
        $("#homepage-ctl-loading").show();
        $('.msg-homepage-ctl-success').hide();
        $('.msg-homepage-ctl-error').hide();

        $(".error-input").removeClass("error-input");
        var btn = $(".save-homepage-catalog");

        var cdartn = [];
        $("select[name='duallistbox_modevi'] option:selected").each(function () {
            cdartn.push($(this).val());
        });

        var customLogo = $('input[name=logo]:checked').val() == 0 ? '' : $('#custom-logo-flimag').val();

        var cdcata = $("#homepage-catalog").val();
        var modevi = {"cdcata": cdcata, "cdartn": cdartn};
        var error = false;

        //if ($("#dropzone-slide-1").find(".dz-filename span").html() == "" || $("#dropzone-slide-1").find(".dz-filename span").html() == null) {
        //  $("#dropzone-slide-1").addClass("error-input");
        //  error = true;
        //}

        var hptest = {
            'cdcata': cdcata,
            'flimg1': $("#dropzone-slide-1").find(".dz-filename span").html(),
            'flimg2': $("#dropzone-slide-2").find(".dz-filename span").html(),
            'flimg3': $("#dropzone-slide-3").find(".dz-filename span").html(),
        };
        var hpcorp = [];

        $('.blockbox').each(function () {
            //nuhpbl
            var box_cdcata = cdcata;
            var box_nubloc = $(this).closest('.homepage-block-container').data('index');
            var box_blsize = parseInt($(this).closest('.x_content').find('.block-select').val()) ?? 0;
            var box_seqrap = parseInt($(this).data('index'));
            var box_des_it = $(this).find('.hiddenbox').is(':checked') ? '' : $(this).find('input.descr-it').val();
            var box_des_en = $(this).find('.hiddenbox').is(':checked') ? '' : $(this).find('input.descr-en').val();
            var box_des_es = $(this).find('.hiddenbox').is(':checked') ? '' : $(this).find('input.descr-es').val();
            var box_des_de = $(this).find('.hiddenbox').is(':checked') ? '' : $(this).find('input.descr-de').val();
            var box_des_fr = $(this).find('.hiddenbox').is(':checked') ? '' : $(this).find('input.descr-fr').val();
            var box_tpbloc = $(this).find('.hiddenbox').is(':checked') ? 'NO' : $(this).find('.element-select').val();
            var box_codice = $(this).find('.hiddenbox').is(':checked') ? '' : (box_tpbloc != 'UR' ? $(this).find('.code-select').val() : $(this).find('.url-input').val());
            var box_flimag = $(this).find('.hiddenbox').is(':checked') ? '' : $(this).find('.dropzone-box .dz-filename span').html();

            // Check if we need to add this block
            if (
                box_seqrap === 1 || // Box 1 sempre visibile
                (box_seqrap === 2 && box_blsize > 0) ||  // Box 2 visibile tranne che se = 0
                (box_seqrap === 3 && [2,5].includes(box_blsize)) ||  // Box 3 visibile solo se 2 o 5
                (box_seqrap === 4 && box_blsize === 5) // Box 4 visibile solo se 5
                // (box_seqrap != 3 || box_blsize == 2 || box_blsize == 5) &&
                // (box_seqrap != 4 || box_blsize == 5)
            ) {
                if (!$(this).find(".hiddenbox").is(":checked")) {
                    if (box_des_it == "") {
                        $(this).find("input.descr-it").addClass("error-input");
                        error = true;
                    }
                    if (box_des_en == "") {
                        $(this).find("input.descr-en").addClass("error-input");
                        error = true;
                    }
                    if (box_des_es == "") {
                        $(this).find("input.descr-es").addClass("error-input");
                        error = true;
                    }
                    if (box_des_de == "") {
                        $(this).find("input.descr-de").addClass("error-input");
                        error = true;
                    }
                    if (box_des_fr == "") {
                        $(this).find("input.descr-fr").addClass("error-input");
                        error = true;
                    }
                    if (box_tpbloc == "NO") {
                        $(this).find(".element-select").addClass("error-input");
                        error = true;
                    }
                    if (box_tpbloc != "SL" && box_tpbloc != 'UR' && (box_codice == "" || box_codice == null)) {
                        $(this).find(".code-select").addClass("error-input");
                        error = true;
                    }
                    if (box_tpbloc == 'UR' && (box_codice == "" || box_codice == null)) {
                        $(this).find(".url-input").addClass("error-input");
                        error = true;
                    }
                    if (box_flimag == "" || box_flimag == null) {
                        $(this).find(".dropzone-box").addClass("error-input");
                        error = true;
                    }
                }

                hpcorp.push({
                    'cdcata': box_cdcata,
                    'nubloc': box_nubloc,
                    'blsize': box_blsize,
                    'seqrap': box_seqrap,
                    'des_it': box_des_it,
                    'des_en': box_des_en,
                    'des_es': box_des_es,
                    'des_de': box_des_de,
                    'des_fr': box_des_fr,
                    'tpbloc': box_tpbloc,
                    'codice': box_codice,
                    'flimag': box_flimag,
                });
            }
        });

        if (!error) {
            btn.prop("disabled", true);
            $.ajax({
                type: 'POST',
                url: "{{ url('admin/saveCatalogHomepage') }}",
                dataType: 'json',
                data: {
                    modevi: modevi,
                    hptest: hptest,
                    hpcorp: hpcorp,
                    flimag: customLogo,
                }
            }).done(function (data) {
                $("#homepage-ctl-loading").hide();
                if (data == "OK") {
                    showTemporary(".msg-homepage-ctl-success", 2000);
                } else {
                    $('.msg-homepage-ctl-error').show();
                }
                btn.prop("disabled", false);
            }).error(function (x, t, m) {
                $("#homepage-ctl-loading").hide();
                printAjaxError(x, t, m);
                btn.prop("disabled", false);
            });
        } else {
            $('.msg-homepage-ctl-error').show();
            $("#homepage-ctl-loading").hide();
            btn.prop("disabled", false);
        }
    });

    // THIRD PANEL: featured models
    var duallist = $('select[name="duallistbox_modevi"]');
    var bootstrapInit = {
        filterTextClear: "{{ mt._('admin.dbl.showall') }}",
        filterPlaceHolder: "{{ mt._('admin.dbl.filter') }}",
        moveSelectedLabel: "{{ mt._('admin.dbl.moveselected') }}",
        moveAllLabel: "{{ mt._('admin.dbl.moveall') }}",
        removeSelectedLabel: "{{ mt._('admin.dbl.removeselected') }}",
        removeAllLabel: "{{ mt._('admin.dbl.removeall') }}",
        infoText: "{{ mt._('admin.dbl.showingall') }} {0}",
        infoTextFiltered: "<span class='label label-warning'>{{ mt._('admin.dbl.filtered') }}</span> {0} {{ mt._('admin.dbl.from') }} {1}",
        infoTextEmpty: "{{ mt._('admin.dbl.emptylist') }}",
        preserveSelectionOnMove: "moved"
    };

    function loadFeaturedModels() {
        duallist.html("");

        $.ajax({
            type: 'POST',
            url: "{{ url('admin/loadModels') }}",
            dataType: 'json',
            data: {
                cdcata: $("#homepage-catalog").val(),
            }
        }).done(function (data) {
            var options = "";
            for (var i = 0; i < data.length; i++) {
                {% if catalogProductType == 0 %}
                options += "<option value='" + data[i].cdartn + "' " + (data[i].exist == 1 ? "selected" : "") + ">" + data[i].cdartn + " - " + data[i].dsartn + "</option>";
                {% elseif catalogProductType == 1 %}
                options += "<option value='" + data[i].cdarti + "' " + (data[i].exist == 1 ? "selected" : "") + ">" + data[i].cdarti + " - " + data[i].dsarti + "</option>";
                {% elseif catalogProductType == 2 %}
                options += "<option value='" + data[i].cdarti + "' " + (data[i].exist == 1 ? "selected" : "") + ">" + data[i].cdarti + " - " + data[i].dsarti + "</option>";
                {% endif %}
            }
            duallist.html(options);
            duallist.bootstrapDualListbox(bootstrapInit);
            duallist.bootstrapDualListbox('refresh', true);
            $('#featured-models-box').show();
        }).error(function (x, t, m) {
            printAjaxError(x, t, m);
        });
    }

    duallist.on('change', function () {
        var size = duallist.find(":selected").size();
        if (size > 8) {
            duallist.find(":selected").each(function (ind, sel) {
                if (ind > 7)
                    $(this).prop("selected", false)
            })
            duallist.bootstrapDualListbox('refresh', true);
        }
    })
</script>
