<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("js/datepicker/daterangepicker.js") }}
<script>
$(document).ready(function() {
  $('#default-period').daterangepicker({
    locale: {
      format: "DD-MM-YYYY",
      separator: " - ",
      applyLabel: "{{ mt._('drp.apply') }}",
      cancelLabel: "{{ mt._('drp.cancel') }}",
      fromLabel: "{{ mt._('drp.from') }}",
      toLabel: "{{ mt._('drp.to') }}",
      customRangeLabel: "{{ mt._('drp.customrange') }}",
      daysOfWeek: ["{{ mt._('drp.sunday') }}", "{{ mt._('drp.monday') }}", "{{ mt._('drp.tuesday') }}",
                   "{{ mt._('drp.wednesday') }}", "{{ mt._('drp.thursday') }}", "{{ mt._('drp.friday') }}",
                   "{{ mt._('drp.saturday') }}"],
      "monthNames": ["{{ mt._('drp.january') }}", "{{ mt._('drp.february') }}", "{{ mt._('drp.march') }}", "{{ mt._('drp.april') }}",
                     "{{ mt._('drp.may') }}", "{{ mt._('drp.june') }}", "{{ mt._('drp.july') }}", "{{ mt._('drp.august') }}",
                     "{{ mt._('drp.september') }}", "{{ mt._('drp.october') }}", "{{ mt._('drp.november') }}", "{{ mt._('drp.december') }}"],
      "firstDay": 1
    }
  }, function(start, end, label) {
    console.log(start.toISOString(), end.toISOString(), label);
  });
});
$('#save-defaults').click(function(){
  $('.msg-success').hide();
  $('.msg-error').hide();
  var period = $('#default-period').val().split(' - ');
  var startTokens = period[0].split('/');
  var endTokens = period[1].split('/');
  var startDate = startTokens[2] + '-' + startTokens[1] + '-' + startTokens[0];
  var endDate = endTokens[2] + '-' + endTokens[1] + '-' + endTokens[0];
  var tpindo = $('#default-ind').length > 0 ? $('#default-ind').val() : '';

  $.ajax({
    type: "POST",
    url: "{{ url('admin/setDefaultConditions') }}",
    dataType: "json",
    data: {
      startDate: startDate,
      endDate: endDate,
      tpindo: tpindo,
    }
  }).done(function(data) {
    if (data == 'OK') {
      showTemporary($('.msg-success'), 2000);
    }
  }).error(function(x, t, m) {
    showTemporary($('.msg-error'), 2000);
  	printAjaxError(x, t, m);
  });
});
</script>
