{{ javascript_include("vendors/Chart.js/dist/Chart.bundle.min.js") }}
<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("vendors/bootstrap-daterangepicker/daterangepicker.js") }}
<script>
function updateDashboard() {
  let cdstag = $('#season-box').val();
  let dtiniz = $("#period").val().split(' - ')[0];
  let dtfine = $("#period").val().split(' - ')[1];

  $.ajax({
    type: "POST",
    url: "{{ url('admin/updateDashboard') }}",
    dataType: "json",
    data: {
      dtiniz: dtiniz,
      dtfine: dtfine,
      cdstag: cdstag,
    }
  }).done(function(data) {
    // second row - overall analysis
    $('#ord').html(data['anl']['ord'] > 0 && data['anl']['ord'] != '' ? data['anl']['ord'] : 0);
    $('#qty').html(data['anl']['qty'] > 0 && data['anl']['qty'] != '' ? data['anl']['qty'] : 0);
    $('#aqo').html(parseFloat(data['anl']['aqo']).formatMoney(2, ",", "."));
    $('#val').html(parseFloat(parseFloat(data['anl']['val']) > 0 ? data['anl']['val'] : 0).formatMoney(2, ",", ".") + " €");
    $('#avo').html(data['anl']['avo'] != "" ? parseFloat(data['anl']['avo']).formatMoney(2, ",", ".") + " €" : data['anl']['avo']);
    $('#avp').html(data['anl']['avp'] != "" ? parseFloat(data['anl']['avp']).formatMoney(2, ",", ".") + " €" : data['anl']['avp']);

    // third row - trends
    $('#canvas-trn').remove();
    $('#trend-container').append('<canvas id="canvas-trn" width="200" height="200"><canvas>');
    var labels = [];
    var arr_dts_qty = [];
    var arr_dts_val = [];
    for (var i = 0; i < data['trends'].length; i++) {
      labels.push(data['trends'][i]['step']);
      arr_dts_qty.push(parseFloat(data['trends'][i]['qty']).toFixed(3));
      arr_dts_val.push(parseFloat(data['trends'][i]['val']).toFixed(3));
    }

    var lineChartData = {
      "labels": labels,
      "datasets": [{
        "label": "{{ mt._('_common.quantity') }}",
        "borderColor":"rgb(96, 96, 96)",
        "backgroundColor": "rgba(96, 96, 96, 0.8)",
        "fill": false,
        "data": arr_dts_qty,
        "yAxisID": "y-axis-1",
      }, {
        "label": "{{ mt._('_common.value') }}",
        "borderColor": "rgb(0, 168, 204)",
        "backgroundColor": "rgba(0, 168, 204, 0.8)",
        "fill": false,
        "data": arr_dts_val,
        "yAxisID": "y-axis-2"
      }]
    };

    new Chart(document.getElementById("canvas-trn"),{
      "type":"line",
      "data": lineChartData,
      "options": {
        "responsive": true,
        "hoverMode": 'index',
        "stacked": false,
        "maintainAspectRatio": false,
        "scales": {
          "yAxes": [{
            "type": "linear", // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
            "display": true,
            "position": "left",
            "id": "y-axis-1",
          }, {
            "type": "linear", // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
            "display": true,
            "position": "right",
            "id": "y-axis-2",

            // grid line settings
            "gridLines": {
              "drawOnChartArea": false, // only want the grid lines for one axis to show up
            },
          }],
        }
      }
    });
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
}
{% include "scripts/common/daterangepicker_config.volt" %}
$('#period-box').daterangepicker(drpConfig, function(start, end, label) {
  $('#period-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
  $('#period').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
  updateDashboard();
});

$('#season-box').change(function(){
  updateDashboard();
});

$(document).ready(function($) {
  let startDate = moment().subtract(29, 'days');
  let endDate = moment();
  $('#period-box span').html(startDate.format('DD/MM/YYYY') + ' - ' + endDate.format('DD/MM/YYYY'));
  $('#period').val(startDate.format('DD/MM/YYYY') + ' - ' + endDate.format('DD/MM/YYYY'));

  var labels = [{% for trend in trends %}'{{ trend["step"] }}',{% endfor %}];

  var arr_dts_qty = [{% for trend in trends %}parseFloat({{ trend['qty'] }}).toFixed(3),{% endfor %}];
  var arr_dts_val = [{% for trend in trends %}parseFloat({{ trend['val'] }}).toFixed(3),{% endfor %}];

  var lineChartData = {
    "labels": labels,
    "datasets": [{
      "label": "{{ mt._('_common.quantity') }}",
      "borderColor":"rgb(96, 96, 96)",
      "backgroundColor": "rgba(96, 96, 96, 0.8)",
      "fill": false,
      "data": arr_dts_qty,
      "yAxisID": "y-axis-1",
    }, {
      "label": "{{ mt._('_common.value') }}",
      "borderColor": "rgb(0, 168, 204)",
      "backgroundColor": "rgba(0, 168, 204, 0.8)",
      "fill": false,
      "data": arr_dts_val,
      "yAxisID": "y-axis-2"
    }]
  };

  new Chart(document.getElementById("canvas-trn"),{
    "type":"line",
    "data": lineChartData,
    "options": {
      "responsive": true,
      "hoverMode": 'index',
      "stacked": false,
      "maintainAspectRatio": false,
      "scales": {
        "yAxes": [{
          "type": "linear", // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
          "display": true,
          "position": "left",
          "id": "y-axis-1",
        }, {
          "type": "linear", // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
          "display": true,
          "position": "right",
          "id": "y-axis-2",

          // grid line settings
          "gridLines": {
            "drawOnChartArea": false, // only want the grid lines for one axis to show up
          },
        }],
      }
    }
  });
});

$("tbody").on("click", "td:nth-child(1)", function(){
  var nuordc = $(this).html();

  if ($(this).hasClass("dataTables_empty"))
    return;

  $.ajax({
    type: "POST",
    url: "{{ url('admin/getOrderDetail') }}",
    dataType: "json",
    data: {
      nuordc: nuordc,
    }
  }).done(function(data) {
    if (data["order_info"] != null) {
      $("#md-nuordc").html(data["order_info"]["nuordc"]);
      if (data["order_info"]["dtmcoi"] != null && data["order_info"]["dtmcoi"] != '00/00/0000' &&
          data["order_info"]["dtmcof"] != null && data["order_info"]["dtmcof"] != '00/00/0000') {
        $("#md-dtmcli").html(data["order_info"]["dtmcoi"] + " - " + data["order_info"]["dtmcof"]);
      } else {
        $("#md-dtmcli").html(data["order_info"]["dtmcli"]);
      }
      $("#md-dsagen").html(data["order_info"]["cdagen"] + " - " + data["order_info"]["dsagen"]);
      $("#md-dslist").html(data["order_info"]["dslist"]);
      $("#md-dsanag").html(data["order_info"]["cdanag"] + " - " + data["order_info"]["descri"]);
      $("#md-dsdesm").html(data["order_info"]["desvid"]);
      $("#md-dscata").html(data["order_info"]["dscata"]);
      $("#md-dspaga").html(data["order_info"]["dspaga"]);
      $("#md-dstpor").html(data["order_info"]["dstpor"]);
      $("#md-dsnota").html((data["order_info"]["notazi"] != null ? data["order_info"]["notazi"] + "<br/>" : '') +
        (data["order_info"]["notcli"] != null ? data["order_info"]["notcli"] : ''));
      $("#tot-dtmcli").html(data["order_info"]["dtmcli"]);
    }

    var rows = "";
    if (data["order_rows"] != null) {
      var glb_tot_qty = 0;
      var glb_tot_net = 0;
      var glb_tot_grs = 0;
      for (var i = 0; i < data["order_rows"].length; i++) {
        glb_tot_grs += parseFloat(data["order_rows"][i].totgrs);
        glb_tot_net += parseFloat(data["order_rows"][i].totnet);
        glb_tot_qty += parseInt(data["order_rows"][i].quanti);

        var tot_dsc = 100 * (1 - (data["order_rows"][i].totnet / data["order_rows"][i].totgrs));
        tot_dsc = tot_dsc > 0 ? tot_dsc + "%" : "&nbsp;";

        rows += "<div class='row-order-detail'>";
        rows += "<div class='row-cdarti'>" + data["order_rows"][i].cdarti + "</div>";
        rows += "<div class='row-dsarti'>" + data["order_rows"][i].dsarti + "</div>";
        rows += "<div class='row-dtmcli'>" + (data["order_rows"][i].dtmcli != '00/00/0000' ? data["order_rows"][i].dtmcli : data["order_info"]["dtmcli"]) + "</div>";
        rows += "<div class='row-quanti'>" + data["order_rows"][i].quanti + "</div>";
        rows += "<div class='row-prezzo'>" + parseFloat(data["order_rows"][i].totgrs).formatMoney(2, ",", ".") + "</div>";
        rows += "<div class='row-sconto'>" + tot_dsc + "</div>";
        rows += "<div class='row-totale'>" + parseFloat(data["order_rows"][i].totnet).formatMoney(2, ",", ".") + "</div>";
        rows += "</div>";
      }
      $("#order-detail-rows").html(rows);

      var glb_tot_dsc = "";

      if (glb_tot_grs != glb_tot_net) {
        glb_tot_dsc = (100 * (1 - (glb_tot_net / glb_tot_grs))) + "%";
      }

      $("#tot-ordrow").html(data["order_rows"].length);
      $("#tot-quanti").html(glb_tot_qty);
      $("#tot-prezzo").html(parseFloat(glb_tot_grs).formatMoney(2, ",", "."));
      $("#tot-sconto").html(glb_tot_dsc);
      $("#tot-totale").html(parseFloat(glb_tot_net).formatMoney(2, ",", "."));
    } else {
      $("#tot-ordrow").html("0");
      $("#tot-quanti").html("0");
      $("#tot-prezzo").html("0");
      $("#tot-sconto").html("&nbsp;");
      $("#tot-totale").html("0");
    }

    $("#modal-order-detail").modal("show");
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});

$('#btn-print-order').click(function(e){
  e.preventDefault();
  var w = window.open();
  var content = $('#modal-order-detail').html();
  //var mywindow = window.open('', 'my div', 'height=400,width=600');

  $("#order-detail-printable").html(content);
  $("#order-detail-printable > div").css("font-size", "10px");
  $("#order-detail-printable .modal-footer").remove();
  $("#order-detail-printable button").remove();
  $("#order-detail-printable .modal-dialog.modal-sm").css("width","100%").removeClass("modal-dialog").removeClass("modal-sm");
  $("#order-detail-printable .modal-content").removeClass("modal-content");

  content = $("#order-detail-printable").html();

  w.document.write('<html><head>');
  w.document.write('<link rel="stylesheet" type="text/css" href="{{ config.application.baseUri }}css/custom.min.css" />');
  w.document.write('<link rel="stylesheet" type="text/css" href="{{ config.application.baseUri }}vendors/bootstrap/dist/css/bootstrap.min.css" />');
  w.document.write('</head>');
  w.document.write(content  + '</body></html>');
  w.document.close();

  $( w.document).ready(function(){
    //set this timeout longer if you have many resources to load
    setTimeout(function(){
       w.focus();
       w.print();
    },1000);
  });

  //w.window.print();
  return false;
});

</script>
