<!-- BootStrapDualListBox -->
{{ javascript_include("vendors/bootstrap-duallistbox-master/dist/jquery.bootstrap-duallistbox.js") }}
<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
$(document).ready(function() {
  $('#table-custom').DataTable({
    'order': [],
    'pageLength': 100,
    'columns': [
      { "orderable": true, "width": "6%" },
      { "orderable": true, "width": "16%" },
      { "orderable": true, "width": "8%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "10%" },
      { "orderable": true, "width": "12%" },
      { "orderable": true, "width": "6%" },
      { "orderable": true, "width": "6%" },
      { "orderable": true, "width": "6%" },
      { "orderable": false, "width": "6%" },
    ],
    {% include 'scripts/common/table_language.volt' %}
  });
});

var tpmvarTable = $('select[name="duallistbox_tpmode"]');
var modvarTable = $('select[name="duallistbox_cdartn"]');

$('.see-custom').click(function(){
  var row = $(this).closest('tr');
  $('#modal-manage-cdvari').val(row.data('cdvari'));
  loadCustomDetail(row.data('cdvari'));
});

$('#save-custom').click(function(){
  var cdartn = [];
  $("select[name='duallistbox_cdartn'] option:selected").each(function(){
    cdartn.push($(this).val());
  });
  var tpmode = [];
  $("select[name='duallistbox_tpmode'] option:selected").each(function(){
    tpmode.push($(this).val());
  });

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/saveCustomDetail') }}",
    dataType: 'json',
    data: {
      cdregv: "{{ family.cdregv }}",
      cdvari: $('#modal-manage-cdvari').val(),
      cdartn: cdartn,
      tpmode: tpmode,
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customvar/' ~ family.cdregv ~ '/' ~ family.tpvari) }}";
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});

var bootstrapInit = {
  filterTextClear:          "{{ mt._('admin.dbl.showall') }}",
  filterPlaceHolder:	      "{{ mt._('admin.dbl.filter') }}",
  moveSelectedLabel:        "{{ mt._('admin.dbl.moveselected') }}",
  moveAllLabel:	            "{{ mt._('admin.dbl.moveall') }}",
  removeSelectedLabel:      "{{ mt._('admin.dbl.removeselected') }}",
  removeAllLabel:           "{{ mt._('admin.dbl.removeall') }}",
  infoText:	                "{{ mt._('admin.dbl.showingall') }} {0}",
  infoTextFiltered:	        "<span class='label label-warning'>{{ mt._('admin.dbl.filtered') }}</span> {0} {{ mt._('admin.dbl.from') }} {1}",
  infoTextEmpty:            "{{ mt._('admin.dbl.emptylist') }}",
  preserveSelectionOnMove:  "moved"
};

function loadCustomDetail(cdvari) {
  tpmvarTable.html("");
  modvarTable.html("");

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/loadCustomDetail') }}",
    dataType: 'json',
    data: {
      cdregv: "{{ family.cdregv }}",
      cdvari: cdvari,
    }
  }).done(function(data) {
    var options = "";
    for (var i = 0; i < data['cdartn'].length; i++) {
      options += "<option value='" + data['cdartn'][i].cdartn + "' " + (data['cdartn'][i].exist == 1 ? "selected" : "") + ">";
      options += data['cdartn'][i].cdartn + " - " + data['cdartn'][i].dsartn;
      options += "</option>";
    }
    modvarTable.html(options);
    modvarTable.bootstrapDualListbox(bootstrapInit);
    modvarTable.bootstrapDualListbox('refresh', true);
    options = "";
    for (var i = 0; i < data['tpmode'].length; i++) {
      options += "<option value='" + data['tpmode'][i].tpmode + "' " + (data['tpmode'][i].exist == 1 ? "selected" : "") + ">";
      options += data['tpmode'][i].tpmode + " - " + data['tpmode'][i].dstmod;
      options += "</option>";
    }
    tpmvarTable.html(options);
    tpmvarTable.bootstrapDualListbox(bootstrapInit);
    tpmvarTable.bootstrapDualListbox('refresh', true);
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
}

$('#modal-modify-flimag').on("change", function(){
  var form_data = new FormData();

  var file_data = $(this).prop('files')[0];
  form_data.append('file', file_data);

  $.ajax({
    type:'POST',
    method:'POST',
    url: "{{ url('admin/uploadVariantImage') }}",
    data: form_data,
    cache: false,
    contentType: false,
    processData: false,
    success:function(){ },
    error: function(x,t,m){ }
  });
});
$('#new-custom').click(function(){
  $('#modal-modify-mode').val('i');
  $('#modal-modify-cdvari').val('');
  $('#modal-modify-cdvari').prop('disabled', false);
  $('#modal-modify-dsvari').val('');
  $('#modal-modify-seqrap').val('');
  $('#modal-modify-prezzo').val('');
  $('#modal-modify-flgene').prop('checked', false);
  $('#modal-modify-flbloc').prop('checked', false);
  $('#modal-modify-ntvari').val('');
  $('#modal-modify-flimag').val('');
  $('#modal-modify-current-flimag').hide();
  $('#modal-modify-current-flimag').html('');
  $('#modal-modify-old-flimag').val('');
  $('#modal-modify-title').html("{{ mt._('admin.customfamily.newcustom') }}");
});
$('.modify-custom').click(function(){
  var row = $(this).closest('tr');
  $('#modal-modify-mode').val('u');
  $('#modal-modify-cdvari').val(row.data('cdvari'));
  $('#modal-modify-cdvari').prop('disabled', true);
  $('#modal-modify-dsvari').val(row.data('dsvari'));
  $('#modal-modify-seqrap').val(row.data('seqrap'));
  $('#modal-modify-prezzo').val(row.data('prezzo'));
  $('#modal-modify-flgene').prop('checked', row.data('flgene') == 1);
  $('#modal-modify-flbloc').prop('checked', row.data('flbloc') == 1);
  $('#modal-modify-ntvari').val(row.data('ntvari'));
  $('#modal-modify-flimag').val('');
  $('#modal-modify-current-flimag').show();
  $('#modal-modify-current-flimag').html("{{ mt._('_common.image.current') }}: " + row.data('flimag'));
  $('#modal-modify-old-flimag').val(row.data('flimag'));
  $('#modal-modify-title').html("{{ mt._('admin.customfamily.modifycustom') }}");
});
$('#modify-custom').click(function(e){
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/editCustomVar') }}",
    dataType: 'json',
    data: {
      mode: $('#modal-modify-mode').val(),
      cdregv: "{{ family.cdregv }}",
      tpvari: "{{ family.tpvari }}",
      cdvari: $('#modal-modify-cdvari').val(),
      dsvari: $('#modal-modify-dsvari').val(),
      seqrap: $('#modal-modify-seqrap').val(),
      prezzo: $('#modal-modify-prezzo').val(),
      flgene: $('#modal-modify-flgene').prop('checked') ? 1 : 0,
      flbloc: $('#modal-modify-flbloc').prop('checked') ? 1 : 0,
      ntvari: $('#modal-modify-ntvari').val(),
      flimag: $('#modal-modify-flimag').prop('files').length == 1 ? $('#modal-modify-flimag').prop('files')[0].name : $('#modal-modify-old-flimag').val()
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customvar/' ~ family.cdregv ~ '/' ~ family.tpvari) }}";
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$('.delete-custom').click(function(e){
  var row = $(this).closest('tr');
  $('#modal-delete-cdvari').val(row.data('cdvari'));
});
$('#delete-custom').click(function(e){
  var cdvari = $('#modal-delete-cdvari').val();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/deleteCustomVar') }}",
    dataType: 'json',
    data: {
      cdregv: "{{ family.cdregv }}",
      tpvari: "{{ family.tpvari }}",
      cdvari: cdvari,
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customvar/' ~ family.cdregv ~ '/' ~ family.tpvari) }}";
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});

</script>
