<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
var tb_fltest_conf = {
  'bInfo': false,
  'pageLength': 100,
  'bPaginate': false,
  'searching': false,
  'order': [],
  'columns': [
    { "orderable": true, "width": "17%" },
    { "orderable": true, "width": "17%" },
    { "orderable": true, "width": "17%" },
    { "orderable": true, "width": "17%" },
    { "orderable": true, "width": "17%" },
    { "orderable": false, "width": "15%" }
  ],
  {% include 'scripts/common/table_language.volt' %}
};
var tb_flcorp_conf = {
  'bInfo': false,
  'pageLength': 100,
  'bPaginate': false,
  'searching': false,
  'order': [],
  'columns': [
    { "orderable": true, "width": "80%" },
    { "orderable": false, "width": "20%" }
  ],
  {% include 'scripts/common/table_language.volt' %}
};

var tableFltest = $('#table-fltest');
var tableFlcorp = $('#table-flcorp');
$('#type').change(function(){
  refreshTables();
});
function refreshTables() {
  if ($('type').val() != 'none') {
    // Load fltest
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/getCustomFilters') }}",
      dataType: 'json',
      data: {
        data: $('#type').val()
      }
    }).done(function(data) {
      if (data['response'] == "OK") {
        tableFltest.DataTable().destroy();
        tableFlcorp.DataTable().destroy();
        $('#table-fltest tbody').html(data['fltest']);
        $('#table-fltest tfoot').html(data['fltest_foot']);
        $('#table-flcorp tbody').html(data['flcorp']);
        tableFltest.DataTable(tb_fltest_conf);
        tableFlcorp.DataTable(tb_flcorp_conf);
      }
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });

    $('#fltest').show();
    $('#flcorp').show();
  } else {
    $('#fltest').hide();
    $('#flcorp').hide();
  }
}
$('#table-fltest tfoot').on('click', '.save-new-fltest', function(){
  $('#des_it').css('background-color', 'white');
  $('#des_es').css('background-color', 'white');
  $('#des_en').css('background-color', 'white');
  $('#des_de').css('background-color', 'white');
  $('#des_fr').css('background-color', 'white');
  $('.msg-error').hide();
  var des_it = $('#des_it').val();
  var des_es = $('#des_es').val();
  var des_en = $('#des_en').val();
  var des_fr = $('#des_fr').val();
  var des_de = $('#des_de').val();
  var tpfilt = $('#type').val();

  if (des_it == '' || des_en == '' || des_es == '' || des_de == '' || des_fr == '') {
    if (des_it == '') {
      $('#des_it').css('background-color', 'red');
    }
    if (des_en == '') {
      $('#des_en').css('background-color', 'red');
    }
    if (des_es == '') {
      $('#des_es').css('background-color', 'red');
    }
    if (des_de == '') {
      $('#des_de').css('background-color', 'red');
    }
    if (des_fr == '') {
      $('#des_fr').css('background-color', 'red');
    }
    $('.msg-error').show();
  } else {
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/saveCustomFilter') }}",
      dataType: 'json',
      data: {
        tpfilt: tpfilt,
        des_it: des_it,
        des_en: des_en,
        des_es: des_es,
        des_de: des_de,
        des_fr: des_fr,
      }
    }).done(function(data) {
      location.href = "{{ url('admin/customflt') }}/" + $('#type').val();
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });
  }
});
$('#table-fltest tbody').on('click', '.edit-fltest', function(){
  $(this).closest('tr').find('span').hide();
  $(this).closest('tr').find('input').show();
  $(this).closest('tr').find('.edit-fltest').hide();
  $(this).closest('tr').find('.delete-fltest').hide();
  $(this).closest('tr').find('.save-fltest').show();
  $(this).closest('tr').find('.cancel-fltest').show();
});
$('#table-fltest tbody').on('click', '.cancel-fltest', function(){
  $(this).closest('tr').find('span').show();
  $(this).closest('tr').find('input').hide();
  $(this).closest('tr').find('.edit-fltest').show();
  $(this).closest('tr').find('.delete-fltest').show();
  $(this).closest('tr').find('.save-fltest').hide();
  $(this).closest('tr').find('.cancel-fltest').hide();
});
$('#table-fltest tbody').on('click', '.save-fltest', function(){
  var row = $(this).closest('tr');
  row.find('input').css('background-color', 'white');
  row.find('.msg-error').hide();

  var des_it = row.find('.des_it').val();
  var des_es = row.find('.des_es').val();
  var des_en = row.find('.des_en').val();
  var des_fr = row.find('.des_fr').val();
  var des_de = row.find('.des_de').val();
  var tpfilt = row.data('tpfilt');
  var nutpfl = row.data('nutpfl');

  if (des_it == '' || des_en == '' || des_es == '' || des_de == '' || des_fr == '') {
    if (des_it == '') {
      row.find('.des_it').css('background-color', 'red');
    }
    if (des_en == '') {
      row.find('.des_en').css('background-color', 'red');
    }
    if (des_es == '') {
      row.find('.des_es').css('background-color', 'red');
    }
    if (des_de == '') {
      row.find('.des_de').css('background-color', 'red');
    }
    if (des_fr == '') {
      row.find('.des_fr').css('background-color', 'red');
    }
    row.find('.msg-error').show();
  } else {
    $.ajax({
      type: 'POST',
      url: "{{ url('admin/modifyCustomFilter') }}",
      dataType: 'json',
      data: {
        nutpfl: nutpfl,
        tpfilt: tpfilt,
        des_it: des_it,
        des_en: des_en,
        des_es: des_es,
        des_de: des_de,
        des_fr: des_fr,
      }
    }).done(function(data) {
      row.find('.txt_des_it').html(row.find('.des_it').val());
      row.find('.txt_des_en').html(row.find('.des_en').val());
      row.find('.txt_des_es').html(row.find('.des_es').val());
      row.find('.txt_des_de').html(row.find('.des_de').val());
      row.find('.txt_des_fr').html(row.find('.des_fr').val());
      row.find('span').show();
      row.find('input').hide();
      row.find('.edit-fltest').show();
      row.find('.delete-fltest').show();
      row.find('.save-fltest').hide();
      row.find('.cancel-fltest').hide();
    }).error(function(x, t, m) {
  		printAjaxError(x, t, m);
    });
  }
});
$('#table-fltest tbody').on('click', '.delete-fltest', function(){
  var row = $(this).closest('tr');
  row.find('input').css('background-color', 'white');
  row.find('.msg-error').hide();

  var nutpfl = row.data('nutpfl');
  $('#modal-fltest-nutpfl').val(nutpfl);
  $('.modal-delete-fltest').modal('show');
});
$('#delete-fltest').click(function(){
  $.ajax({
    type: 'POST',
    url: "{{ url('admin/deleteCustomFilter') }}",
    dataType: 'json',
    data: {
      nutpfl: $('#modal-fltest-nutpfl').val(),
    }
  }).done(function(data) {
    location.href = "{{ url('admin/customflt') }}/" + $('#type').val();
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$('#table-flcorp tbody').on('change', 'select.fltest', function(){
  var row = $(this).closest('tr');

  var numfil = row.data('numfil');
  var codice = row.data('codice');
  var nutpfl = $(this).val();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/saveCustomFilterBody') }}",
    dataType: 'json',
    data: {
      numfil: numfil,
      codice: codice,
      nutpfl: nutpfl
    }
  }).done(function(data) {
    if (data['response'] == 'OK') {
      row.data('numfil', data['numfil']);
    }
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$(document).ready(function(){
  tableFltest.DataTable(tb_fltest_conf);
  tableFlcorp.DataTable(tb_flcorp_conf);

  {% if tpfilt != '' %}
  refreshTables();
  {% endif %}
});
</script>
