<!-- DropZone -->
{{ javascript_include("vendors/dropzone/dist/min/dropzone.min.js") }}
<script type="text/javascript">// Immediately after the js include
  Dropzone.autoDiscover = false;
</script>
<script>
var configDropzone = {
  init: function() {
    this.on("maxfilesexceeded", function(file) {
      this.removeAllFiles();
      this.addFile(file);
    });
  },
  acceptedFiles: 'image/jpeg',
  dictDefaultMessage: "{{ mt._('dropzone.dragdropfiles')}}",
  dictRemoveFile: "{{ mt._('dropzone.removeimage') }}",
  dictMaxFilesExceeded: "{{ mt._('dropzone.maxfilesexceeded') }}",
  success: function (response) {
    console.log(response);
  },
  addRemoveLinks: true,
  maxFiles: 1,
  removedfile: function(file) {
    var _ref; // Remove file on clicking the 'Remove file' button
    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
  }
};
$('.dropzone-slide').dropzone(configDropzone);

{% if b2bctim|length > 0 %}
  {% for catalog in b2bctim %}
var mockFile = { name: "{{ catalog.flimag }}", size: 12345 };
Dropzone.forElement("#box-ct{{ catalog.cdcata }}-sr{{ catalog.seqrap }}").emit("addedfile", mockFile);
Dropzone.forElement("#box-ct{{ catalog.cdcata }}-sr{{ catalog.seqrap }}").emit("thumbnail", mockFile, "../upload/{{ catalog.flimag }}");
Dropzone.forElement("#box-ct{{ catalog.cdcata }}-sr{{ catalog.seqrap }}").emit("complete", mockFile);
Dropzone.forElement("#box-ct{{ catalog.cdcata }}-sr{{ catalog.seqrap }}").files.push( mockFile ); // file must be added manually
  {% endfor %}
{% endif %}
$('#add').click(function(){
  $('.msg-success').hide();
  $('.msg-error').hide();

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/newCatalogPresentationBox') }}",
    dataType: 'json',
    data: { }
  }).done(function(data) {
    $('#catalog-box-container').append(data);
    $('.catalog-box').last().find('.dropzone-slide').dropzone(configDropzone);
  }).error(function(x, t, m) {
		printAjaxError(x, t, m);
  });
});
$('#save').click(function(){
  $('.msg-success').hide();
  $('.msg-error').hide();

  var b2bctim = [];
  var i = 1;
  $('.catalog-box').each(function(){
    b2bctim.push({cdcata: $(this).find('.catalog-pres').val(), seqrap: i, flimag: $(this).find(".dz-filename span").html()});
    i++;
  });

  $.ajax({
    type: 'POST',
    url: "{{ url('admin/saveCatalogPresentationBox') }}",
    dataType: 'json',
    data: {
      b2bctim: b2bctim
    }
  }).done(function(data) {
    showTemporary(".msg-success", 2000);
  }).error(function(x, t, m) {
    showTemporary(".msg-error", 2000);
  	printAjaxError(x, t, m);
  });
});
$('#catalog-box-container').on('click', '.delete-catalog-box', function(){
  $(this).closest('.catalog-box').remove();
});
</script>
