{{ javascript_include("vendors/Chart.js/dist/Chart.bundle.min.js") }}
<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("vendors/bootstrap-daterangepicker/daterangepicker.js") }}
<!-- eCharts -->
{{ javascript_include("vendors/echarts/dist/echarts.min.js") }}
<!-- JQVMap -->
{{ javascript_include("vendors/jqvmap/dist/jquery.vmap.js") }}
{{ javascript_include("vendors/jqvmap/dist/maps/jquery.vmap.world.js") }}
<!-- DataTable -->
{{ javascript_include("vendors/datatables.net/js/jquery.dataTables.min.js") }}
{{ javascript_include("vendors/datatables.net-bs/js/dataTables.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/dataTables.buttons.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons-bs/js/buttons.bootstrap.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.flash.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.html5.min.js") }}
{{ javascript_include("vendors/datatables.net-buttons/js/buttons.print.min.js") }}
{{ javascript_include("vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js") }}
{{ javascript_include("vendors/datatables.net-keytable/js/dataTables.keyTable.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive/js/dataTables.responsive.min.js") }}
{{ javascript_include("vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js") }}
{{ javascript_include("vendors/datatables.net-scroller/js/dataTables.scroller.min.js") }}
<script>
var jsInfo = {
  "getSalesAnalysisUrl": "{{ url('admin/getSalesAnalysis') }}",
  "downloadAnalysisXlsUrl": "{{ url('admin/downloadAnalysisXls') }}"
};
</script>
{{ javascript_include("js/custom/admin_analysis.js") }}
<script>
var gr1CusTable = $('#datatable-gr1-cus');
var gr1AgeTable = $('#datatable-gr1-age');
var gr2CusTable = $('#datatable-gr2-cus');
var gr2AgeTable = $('#datatable-gr2-age');
var gr3CusTable = $('#datatable-gr3-cus');
var gr3AgeTable = $('#datatable-gr3-age');
var tipCusTable = $('#datatable-tip-cus');
var tipAgeTable = $('#datatable-tip-age');
var genCusTable = $('#datatable-gen-cus');
var genAgeTable = $('#datatable-gen-age');
var qtyCusTable = $('#datatable-qty-cus');
var qtyAgeTable = $('#datatable-qty-age');
var valCusTable = $('#datatable-val-cus');
var valAgeTable = $('#datatable-val-age');
var nazCusTable = $('#datatable-naz-cus');
var nazAgeTable = $('#datatable-naz-age');
var ageTable = $('#datatable-age');

var dtConf = {
  'pageLength': 100,
  'order': [],
  'orderable': true,
  'bInfo': false,
  'pageLength': 100,
  'bPaginate': false,
  'searching': false,
  'columns': [
    { "orderable": true, "width": "60%" },
    { "orderable": true, "width": "20%" },
    { "orderable": true, "width": "20%" },
  ],
  {% include 'scripts/common/table_language.volt' %}
};

var dtConf2 = {
  'pageLength': 100,
  'order': [],
  'orderable': true,
  'bInfo': false,
  'pageLength': 100,
  'bPaginate': false,
  'searching': false,
  'columns': [
    { "orderable": true, "width": "4%" },
    { "orderable": true, "width": "18%" },
    { "orderable": true, "width": "13%", "className": 'right' },
    { "orderable": true, "width": "13%", "className": 'right' },
    { "orderable": true, "width": "13%", "className": 'right' },
    { "orderable": true, "width": "13%", "className": 'right' },
    { "orderable": true, "width": "13%", "className": 'right' },
    { "orderable": true, "width": "13%", "className": 'right' },
  ],
  {% include 'scripts/common/table_language.volt' %}
};

var theme = {
  color: [ '#26B99A', '#34495E', '#BDC3C7', '#3498DB', '#9B59B6', '#8abb6f', '#759c6a', '#bfd3b7' ],
  title: { itemGap: 8, textStyle: { fontWeight: 'normal', color: '#408829' } },
  dataRange: { color: ['#1f610a', '#97b58d'] },
  toolbox: { color: ['#408829', '#408829', '#408829', '#408829'] },
  tooltip: {
    backgroundColor: 'rgba(0,0,0,0.5)',
    axisPointer: {
      type: 'line',
      lineStyle: { color: '#408829', type: 'dashed' },
      crossStyle: { color: '#408829' },
      shadowStyle: { color: 'rgba(200,200,200,0.3)' }
    }
  },
  dataZoom: {
    dataBackgroundColor: '#eee',
    fillerColor: 'rgba(64,136,41,0.2)',
    handleColor: '#408829'
  },
  grid: { borderWidth: 0 },
  categoryAxis: {
    axisLine: { lineStyle: { color: '#408829' } },
    splitLine: { lineStyle: { color: ['#eee'] } }
  },
  valueAxis: {
    axisLine: { lineStyle: { color: '#408829' } },
    splitArea: { show: true, areaStyle: { color: ['rgba(250,250,250,0.1)', 'rgba(200,200,200,0.1)'] } },
    splitLine: { lineStyle: { color: ['#eee'] } }
  }
};

var donutOptions = {
  tooltip: { trigger: 'item', formatter: "{a} <br/>{b} : {c} ({d}%)" },
  calculable: true,
  toolbox: { show: false },
  series: [{
    type: 'pie',
    radius: ['35%', '55%'],
    itemStyle: {
      normal: { label: { show: true }, labelLine: { show: true } },
      emphasis: { label: { show: true, position: 'center', textStyle: { fontSize: '14', fontWeight: 'normal' } } }
    },
  }]
};

var top10Config = {
  "type":"horizontalBar",
  "data":{
    "datasets":[{
      "label": "{{ mt._('_common.value') }}",
      "fill":false,
      "backgroundColor": "rgba(0, 168, 204, 0.8)",
      "borderColor":"rgb(0, 168, 204)",
      "borderWidth":1
    }]
  },
  "options":{
    "legend":{"display": false},
    "scales":{"xAxes":[{"ticks":{"beginAtZero":true}}]},
    "maintainAspectRatio": false,
  }
};

var lineChartData = {
  "datasets": [{
    "label": "{{ mt._('_common.quantity') }}",
    "borderColor":"rgb(96, 96, 96)",
    "backgroundColor": "rgba(96, 96, 96, 0.8)",
    "fill": false,
    "yAxisID": "y-axis-1",
  }, {
    "label": "{{ mt._('_common.value') }}",
    "borderColor": "rgb(0, 168, 204)",
    "backgroundColor": "rgba(0, 168, 204, 0.8)",
    "fill": false,
    "yAxisID": "y-axis-2"
  }]
};

var lineChartConfig = {
  "type":"line",
  "options": {
    "responsive": true,
    "hoverMode": 'index',
    "stacked": false,
    "maintainAspectRatio": false,
    "scales": {
      "yAxes": [{
        "type": "linear", // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
        "display": true,
        "position": "left",
        "id": "y-axis-1",
      }, {
        "type": "linear", // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
        "display": true,
        "position": "right",
        "id": "y-axis-2",

        // grid line settings
        "gridLines": {
          "drawOnChartArea": false, // only want the grid lines for one axis to show up
        },
      }],
    }
  }
}

var mapData = [];
var mapConfig = {
  map: 'world_en',
  backgroundColor: null,
  color: '#ffffff',
  hoverOpacity: 0.7,
  selectedColor: '#666666',
  enableZoom: true,
  showTooltip: true,
  scaleColors: ['#E6F2F0', '#149B7E'],
  normalizeFunction: 'polynomial',
  onRegionOver: function (event, code, region) {
    event.preventDefault();
  },
  onLabelShow: function(event, label, code) {
    if (mapData[code] !== undefined) {
      label.text(mapData[code]);
    }
  },
};

function init_daterangepicker() {
  {% include "scripts/common/daterangepicker_config.volt" %}
	if( typeof ($.fn.daterangepicker) === 'undefined'){ return; }

	$('#period-cus-box').daterangepicker(drpConfig, function(start, end, label) {
	  $('#period-cus-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	  $('#period-cus').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	});
	$('#period-age-box').daterangepicker(drpConfig, function(start, end, label) {
	  $('#period-age-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	  $('#period-age').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	});
	$('#period-com-1-box').daterangepicker(drpConfig, function(start, end, label) {
	  $('#period-com-1-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	  $('#period-com-1').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	});
	$('#period-com-2-box').daterangepicker(drpConfig, function(start, end, label) {
	  $('#period-com-2-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	  $('#period-com-2').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	});
	$('#period-com-3-box').daterangepicker(drpConfig, function(start, end, label) {
	  $('#period-com-3-box span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	  $('#period-com-3').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
	});
}

function init_JQVmap_cus(data){
	if(typeof (jQuery.fn.vectorMap) === 'undefined'){ return; }

	if ($('#world-map-cus').length){
    mapConfig['values'] = data;
		$('#world-map-cus').vectorMap(mapConfig);
	}
};

function init_JQVmap_age(data){
	if(typeof (jQuery.fn.vectorMap) === 'undefined'){ return; }

	if ($('#world-map-age').length){
    mapConfig['values'] = data;
		$('#world-map-age').vectorMap(mapConfig);
	}
};

$(document).ready(function(){
  gr1CusTable.DataTable(dtConf);
  gr1AgeTable.DataTable(dtConf);
  gr2CusTable.DataTable(dtConf);
  gr2AgeTable.DataTable(dtConf);
  gr3CusTable.DataTable(dtConf);
  gr3AgeTable.DataTable(dtConf);
  tipCusTable.DataTable(dtConf);
  tipAgeTable.DataTable(dtConf);
  genCusTable.DataTable(dtConf);
  genAgeTable.DataTable(dtConf);
  qtyCusTable.DataTable(dtConf);
  qtyAgeTable.DataTable(dtConf);
  valCusTable.DataTable(dtConf);
  valAgeTable.DataTable(dtConf);
  nazCusTable.DataTable(dtConf);
  nazAgeTable.DataTable(dtConf);
  ageTable.DataTable(dtConf2);
  init_daterangepicker();
});

//region Confirm buttons
$('#confirm-cus-cat').click(function(){
  var cnt = $('input[name="cus-cat-checkbox[]"]:checked').length;
  $('#lbl-cus-cat').html("{{ mt._('_common.catalogs') }} " + (cnt > 0 ? '(' + cnt + ')' : ''));
});
$('#confirm-cus-cus').click(function(){
  var cnt = $('input[name="cus-cus-checkbox[]"]:checked').length;
  $('#lbl-cus-cus').html("{{ mt._('_common.customers') }} " + (cnt > 0 ? '(' + cnt + ')' : ''));
});
$('#confirm-age-cat').click(function(){
  var cnt = $('input[name="age-cat-checkbox[]"]:checked').length;
  $('#lbl-age-cat').html("{{ mt._('_common.catalogs') }} " + (cnt > 0 ? '(' + cnt + ')' : ''));
});
$('#confirm-age-age').click(function(){
  var cnt = $('input[name="age-age-checkbox[]"]:checked').length;
  $('#lbl-age-age').html("{{ mt._('_common.agents') }} " + (cnt > 0 ? '(' + cnt + ')' : ''));
});
//endregion

//region Elaborate stats
$('#analysis-grp-cus').change(function(){
  var value = $(this).val();
  $('#gr1-cus').hide();
  $('#gr2-cus').hide();
  $('#gr3-cus').hide();
  $('#gr' + value + "-cus").show();
});
$('#analysis-grp-age').change(function(){
  var value = $(this).val();
  $('#gr1-age').hide();
  $('#gr2-age').hide();
  $('#gr3-age').hide();
  $('#gr' + value + "-age").show();
});

$('#get-stats-cus').click(function(){
  $('#cus-analysis-loader').show();
  $('#cus-analysis').hide();
  var catalogs  = [];
  var customers = [];
  var dtiniz    = "";
  var dtfine    = "";

  $("input:checkbox[name='cus-cat-checkbox[]']:checked").each(function(){
    catalogs.push($(this).val());
  });

  $("input:checkbox[name='cus-cus-checkbox[]']:checked").each(function(){
    customers.push($(this).val());
  });

  var period = $('#period-cus').val();
  if (period != "") {
    dtiniz = period.split(' - ')[0];
    dtfine = period.split(' - ')[1];
  }

  $.ajax({
    type: "POST",
    url: "{{ url('admin/getAnalysisForCustomer') }}",
    dataType: "json",
    data: {
      catalogs:   catalogs,
      customers:  customers,
      dtiniz:     dtiniz,
      dtfine:     dtfine,
    }
  }).done(function(data) {
    $('#cus-analysis-loader').hide();
    // overall analysis
    $('#cus-ord').html(data['anl']['ord']);
    $('#cus-qty').html(data['anl']['qty']);
    $('#cus-aqo').html(parseFloat(data['anl']['aqo']).formatMoney(2, ",", "."));
    $('#cus-val').html(parseFloat(data['anl']['val']) > 0 ? parseFloat(data['anl']['val']).formatMoney(2, ",", ".") + " €" : "-");
    $('#cus-avo').html(data['anl']['avo'] != "" ? parseFloat(data['anl']['avo']).formatMoney(2, ",", ".") + " €" : data['anl']['avo']);
    $('#cus-avp').html(data['anl']['avp'] != "" ? parseFloat(data['anl']['avp']).formatMoney(2, ",", ".") + " €" : data['anl']['avp']);
    $('#cus-analysis').show();

    // donuts
    var echartDonut1 = echarts.init(document.getElementById('echart_donut_gr1_cus'), theme);
    var echartDonut2 = echarts.init(document.getElementById('echart_donut_gr2_cus'), theme);
    var echartDonut3 = echarts.init(document.getElementById('echart_donut_gr3_cus'), theme);
    var echartDonut4 = echarts.init(document.getElementById('echart_donut_tip_cus'), theme);
    var echartDonut5 = echarts.init(document.getElementById('echart_donut_gen_cus'), theme);

    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revforbrand") }}';
    donutOptions['series'][0]['data'] = data['don']['gr1'];
    echartDonut1.setOption(donutOptions);
    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revforline") }}';
    donutOptions['series'][0]['data'] = data['don']['gr2'];
    echartDonut2.setOption(donutOptions);
    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revforseries") }}';
    donutOptions['series'][0]['data'] = data['don']['gr3'];
    echartDonut3.setOption(donutOptions);
    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revformodeltype") }}';
    donutOptions['series'][0]['data'] = data['don']['tip'];
    echartDonut4.setOption(donutOptions);
    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revforgenre") }}';
    donutOptions['series'][0]['data'] = data['don']['gen'];
    echartDonut5.setOption(donutOptions);

    $('#gr1-cus').show();
    $('#gr2-cus').hide();
    $('#gr3-cus').hide();
    gr1CusTable.DataTable().clear();
    gr2CusTable.DataTable().clear();
    gr3CusTable.DataTable().clear();
    tipCusTable.DataTable().clear();
    genCusTable.DataTable().clear();

    var rows_gr1 = [];
    for (var i = 0; i < data['don']['gr1'].length; i++) {
      rows_gr1.push([data['don']['gr1'][i]['name'], data['don']['gr1'][i]['qty'], parseFloat(data['don']['gr1'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    gr1CusTable.DataTable().rows.add(rows_gr1).draw();

    var rows_gr2 = [];
    for (var i = 0; i < data['don']['gr2'].length; i++) {
      rows_gr2.push([data['don']['gr2'][i]['name'], data['don']['gr2'][i]['qty'], parseFloat(data['don']['gr2'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    gr2CusTable.DataTable().rows.add(rows_gr2).draw();

    var rows_gr3 = [];
    for (var i = 0; i < data['don']['gr3'].length; i++) {
      rows_gr3.push([data['don']['gr3'][i]['name'], data['don']['gr3'][i]['qty'], parseFloat(data['don']['gr3'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    gr3CusTable.DataTable().rows.add(rows_gr3).draw();

    var rows_tip = [];
    for (var i = 0; i < data['don']['tip'].length; i++) {
      rows_tip.push([data['don']['tip'][i]['name'], data['don']['tip'][i]['qty'], parseFloat(data['don']['tip'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    tipCusTable.DataTable().rows.add(rows_tip).draw();

    var rows_gen = [];
    for (var i = 0; i < data['don']['gen'].length; i++) {
      rows_gen.push([data['don']['gen'][i]['name'], data['don']['gen'][i]['qty'], parseFloat(data['don']['gen'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    genCusTable.DataTable().rows.add(rows_gen).draw();

    // top 20
    qtyCusTable.DataTable().clear();
    valCusTable.DataTable().clear();
    var labels1   = [];
    var dataset1  = [];
    for (var i = 0; i < data['t20']['qty'].length && i < 10; i++) {
      labels1.push(data['t20']['qty'][i]['cdanag'] + " - " + data['t20']['qty'][i]['descri']);
      dataset1.push(data['t20']['qty'][i]['qty']);
    }
    top10Config['data']['labels'] = labels1;
    top10Config['data']['datasets'][0]['data'] = dataset1;
    new Chart(document.getElementById("canvas-qty-cus"), top10Config);

    var labels2   = [];
    var dataset2  = [];
    for (var i = 0; i < data['t20']['val'].length && i < 10; i++) {
      labels2.push(data['t20']['val'][i]['cdanag'] + " - " + data['t20']['val'][i]['descri']);
      dataset2.push(data['t20']['val'][i]['val']);
    }
    top10Config['data']['labels'] = labels2;
    top10Config['data']['datasets'][0]['data'] = dataset2;
    new Chart(document.getElementById("canvas-val-cus"), top10Config);

    var rows_qty = [];
    for (var i = 0; i < data['t20']['qty'].length; i++) {
      rows_qty.push([data['t20']['qty'][i]['cdanag'], data['t20']['qty'][i]['descri'], data['t20']['qty'][i]['qty']]);
    }
    qtyCusTable.DataTable().rows.add(rows_qty).draw();

    var rows_val = [];
    for (var i = 0; i < data['t20']['val'].length; i++) {
      rows_val.push([data['t20']['val'][i]['cdanag'], data['t20']['val'][i]['descri'], parseFloat(data['t20']['val'][i]['val']).formatMoney(2, ",", ".") + " €"]);
    }
    valCusTable.DataTable().rows.add(rows_val).draw();

    // trends
    $('#canvas-trn-cus').remove();
    $('#trend-container-cus').append('<canvas id="canvas-trn-cus" width="200" height="200"><canvas>');
    var labels = [];
    var arr_dts_qty = [];
    var arr_dts_val = [];
    for (var i = 0; i < data['trn'].length; i++) {
      labels.push(data['trn'][i]['step']);
      arr_dts_qty.push(parseFloat(data['trn'][i]['qty']).toFixed(3));
      arr_dts_val.push(parseFloat(data['trn'][i]['val']).toFixed(3));
    }
    lineChartData['labels'] = labels;
    lineChartData['datasets'][0]['data'] = arr_dts_qty;
    lineChartData['datasets'][1]['data'] = arr_dts_val;
    lineChartConfig['data'] = lineChartData;
    new Chart(document.getElementById("canvas-trn-cus"),lineChartConfig);

    // map
    init_JQVmap_cus(data['map']);
    nazCusTable.DataTable().clear();

    var rows_naz = [];
    for (var i = 0; i < data['naz'].length; i++) {
      mapData[data['naz'][i]['cdnazi']] = data['naz'][i]['dsnazi'] + ": {{ mt._('_common.quantity') }}: " + data['naz'][i]['qty'] + ", {{ mt._('_common.amount') }}: " + parseFloat(data['naz'][i]['value']).formatMoney(2, ",", ".") + " €";
      rows_naz.push([data['naz'][i]['dsnazi'], data['naz'][i]['qty'], parseFloat(data['naz'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    nazCusTable.DataTable().rows.add(rows_naz).draw();
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});
$('#get-stats-age').click(function(){
  $('#age-analysis-loader').show();
  $('#age-analysis').hide();
  var catalogs  = [];
  var agents    = [];
  var dtiniz    = "";
  var dtfine    = "";

  $("input:checkbox[name='age-cat-checkbox[]']:checked").each(function(){
    catalogs.push($(this).val());
  });

  $("input:checkbox[name='age-age-checkbox[]']:checked").each(function(){
    agents.push();
  });

  var period = $('#period-age').val();
  if (period != "") {
    dtiniz = period.split(' - ')[0];
    dtfine = period.split(' - ')[1];
  }

  $.ajax({
    type: "POST",
    url: "{{ url('admin/getAnalysisForAgent') }}",
    dataType: "json",
    data: {
      catalogs:   catalogs,
      agents:     agents,
      dtiniz:     dtiniz,
      dtfine:     dtfine,
    }
  }).done(function(data) {
    $('#age-analysis-loader').hide();
    // overall analysis
    $('#age-ord').html(data['anl']['ord']);
    $('#age-qty').html(data['anl']['qty']);
    $('#age-aqo').html(parseFloat(data['anl']['aqo']).formatMoney(2, ",", "."));
    $('#age-val').html(parseFloat(data['anl']['val']) > 0 ? parseFloat(data['anl']['val']).formatMoney(2, ",", ".") + " €" : "-");
    $('#age-avo').html(data['anl']['avo'] != "" ? parseFloat(data['anl']['avo']).formatMoney(2, ",", ".") + " €" : data['anl']['avo']);
    $('#age-avp').html(data['anl']['avp'] != "" ? parseFloat(data['anl']['avp']).formatMoney(2, ",", ".") + " €" : data['anl']['avp']);
    $('#age-analysis').show();

    // donuts
    var echartDonut1 = echarts.init(document.getElementById('echart_donut_gr1_age'), theme);
    var echartDonut2 = echarts.init(document.getElementById('echart_donut_gr2_age'), theme);
    var echartDonut3 = echarts.init(document.getElementById('echart_donut_gr3_age'), theme);
    var echartDonut4 = echarts.init(document.getElementById('echart_donut_tip_age'), theme);
    var echartDonut5 = echarts.init(document.getElementById('echart_donut_gen_age'), theme);

    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revforbrand") }}';
    donutOptions['series'][0]['data'] = data['don']['gr1'];
    echartDonut1.setOption(donutOptions);
    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revforline") }}';
    donutOptions['series'][0]['data'] = data['don']['gr2'];
    echartDonut2.setOption(donutOptions);
    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revforseries") }}';
    donutOptions['series'][0]['data'] = data['don']['gr3'];
    echartDonut3.setOption(donutOptions);
    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revformodeltype") }}';
    donutOptions['series'][0]['data'] = data['don']['tip'];
    echartDonut4.setOption(donutOptions);
    donutOptions['series'][0]['name'] = '{{ mt._("admin.analysis.revforgenre") }}';
    donutOptions['series'][0]['data'] = data['don']['gen'];
    echartDonut5.setOption(donutOptions);

    $('#gr1-age').show();
    $('#gr2-age').hide();
    $('#gr3-age').hide();
    gr1AgeTable.DataTable().clear();
    gr2AgeTable.DataTable().clear();
    gr3AgeTable.DataTable().clear();
    tipAgeTable.DataTable().clear();
    genAgeTable.DataTable().clear();

    var rows_gr1 = [];
    for (var i = 0; i < data['don']['gr1'].length; i++) {
      rows_gr1.push([data['don']['gr1'][i]['name'], data['don']['gr1'][i]['qty'], parseFloat(data['don']['gr1'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    gr1AgeTable.DataTable().rows.add(rows_gr1).draw();

    var rows_gr2 = [];
    for (var i = 0; i < data['don']['gr2'].length; i++) {
      rows_gr2.push([data['don']['gr2'][i]['name'], data['don']['gr2'][i]['qty'], parseFloat(data['don']['gr2'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    gr2AgeTable.DataTable().rows.add(rows_gr2).draw();

    var rows_gr3 = [];
    for (var i = 0; i < data['don']['gr3'].length; i++) {
      rows_gr3.push([data['don']['gr3'][i]['name'], data['don']['gr3'][i]['qty'], parseFloat(data['don']['gr3'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    gr3AgeTable.DataTable().rows.add(rows_gr3).draw();

    var rows_tip = [];
    for (var i = 0; i < data['don']['tip'].length; i++) {
      rows_tip.push([data['don']['tip'][i]['name'], data['don']['tip'][i]['qty'], parseFloat(data['don']['tip'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    tipAgeTable.DataTable().rows.add(rows_tip).draw();

    var rows_gen = [];
    for (var i = 0; i < data['don']['gen'].length; i++) {
      rows_gen.push([data['don']['gen'][i]['name'], data['don']['gen'][i]['qty'], parseFloat(data['don']['gen'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    genAgeTable.DataTable().rows.add(rows_gen).draw();

    // agents
    ageTable.DataTable().clear();
    var rows_age = [];
    for (var i = 0; i < data['age'].length; i++) {
      rows_age.push([
        data['age'][i]['cdagen'],
        data['age'][i]['dsagen'],
        data['age'][i]['totord'],
        data['age'][i]['qty'],
        parseFloat(data['age'][i]['qty'] / data['age'][i]['totord']).formatMoney(2, ",", "."),
        parseFloat(data['age'][i]['val']).formatMoney(2, ",", ".") + " €",
        parseFloat(data['age'][i]['val'] / data['age'][i]['totord']).formatMoney(2, ",", ".") + " €",
        parseFloat(data['age'][i]['val'] / data['age'][i]['qty']).formatMoney(2, ",", ".") + " €"
      ]);
    }
    ageTable.DataTable().rows.add(rows_age).draw();

    // top 20
    var rows_qty = [];
    for (var i = 0; i < data['t20']['qty'].length; i++) {
      rows_qty.push([data['t20']['qty'][i]['cdagen'], data['t20']['qty'][i]['dsagen'], data['t20']['qty'][i]['qty']]);
    }
    qtyAgeTable.DataTable().rows.add(rows_qty).draw();

    var rows_val = [];
    for (var i = 0; i < data['t20']['val'].length; i++) {
      rows_val.push([data['t20']['val'][i]['cdagen'], data['t20']['val'][i]['dsagen'], parseFloat(data['t20']['val'][i]['val']).formatMoney(2, ",", ".") + " €"]);
    }
    valAgeTable.DataTable().rows.add(rows_val).draw();

    // trends
    $('#canvas-trn-age').remove();
    $('#trend-container-age').append('<canvas id="canvas-trn-age" width="200" height="200"><canvas>');
    var labels = [];
    var arr_dts_qty = [];
    var arr_dts_val = [];
    for (var i = 0; i < data['trn'].length; i++) {
      labels.push(data['trn'][i]['step']);
      arr_dts_qty.push(parseFloat(data['trn'][i]['qty']).toFixed(3));
      arr_dts_val.push(parseFloat(data['trn'][i]['val']).toFixed(3));
    }
    lineChartData['labels'] = labels;
    lineChartData['datasets'][0]['data'] = arr_dts_qty;
    lineChartData['datasets'][1]['data'] = arr_dts_val;
    lineChartConfig['data'] = lineChartData;
    new Chart(document.getElementById("canvas-trn-age"),lineChartConfig);

    // map
    init_JQVmap_age(data['map']);
    nazAgeTable.DataTable().clear();

    var rows_naz = [];
    for (var i = 0; i < data['naz'].length; i++) {
      rows_naz.push([data['naz'][i]['dsnazi'], data['naz'][i]['qty'], parseFloat(data['naz'][i]['value']).formatMoney(2, ",", ".") + " €"]);
    }
    nazAgeTable.DataTable().rows.add(rows_naz).draw();
  }).error(function(x, t, m) {
    printAjaxError(x, t, m);
  });
});
//endregion

//region Compare stats
$("#elaborate").click(function(){
  var type  = $("#grouping").val();
  var age   = [];
  var brn   = [];
  var cat   = [];
  var cus   = [];
  var lin   = [];
  var cou   = [];
  var ser   = [];
  var mot   = [];
  var ort   = [];
  var gen   = [];
  var per1  = $("#period-com-1").val();
  var per2  = $("#period-com-2").val();
  var per3  = $("#period-com-3").val();

  $(".age-row input:checked").each(function(){age.push($(this).val());});
  $(".brn-row input:checked").each(function(){brn.push($(this).val());});
  $(".cat-row input:checked").each(function(){cat.push($(this).val());});
  $(".cus-row input:checked").each(function(){cus.push({tpanag: $(this).data("tpanag"), cdanag: $(this).data("cdanag")});});
  $(".lin-row input:checked").each(function(){lin.push($(this).val());});
  $(".cou-row input:checked").each(function(){cou.push($(this).val());});
  $(".ser-row input:checked").each(function(){ser.push({cdlinm: $(this).data("cdlinm"), cdserm: $(this).data("cdserm")});});
  $(".mot-row input:checked").each(function(){mot.push($(this).val());});
  $(".ort-row input:checked").each(function(){ort.push($(this).val());});
  $(".gen-row input:checked").each(function(){gen.push($(this).val());});

  if (per1 == "") {
    showTemporary(".msg-error", 5000);
    $("#period-com-1").css("background-color","#ffeeee");
    setTimeout( function(){
      $("#period-com-1").css("background-color","white");
    }, 5000 );
  } else {
    $('.msg-error').hide();
    $("#period-com-1").css("background-color","white");

    $.ajax({
      type: "POST",
      url: "{{ url('admin/elaborateAnalysis') }}",
      dataType: "json",
      data: {
        type: type,
        per1: per1,
        per2: per2,
        per3: per3,
        age:  age,
        brn:  brn,
        cat:  cat,
        cus:  cus,
        cou:  cou,
        gen:  gen,
        lin:  lin,
        mot:  mot,
        ort:  ort,
        ser:  ser,
      }
    }).done(function(data) {
      if (data.hasOwnProperty('content') && data.hasOwnProperty('modal')) {
        $('#analysis-select').slideUp();
        $('#analysis-detail').slideDown();

        $('#stats_content').html(data['content']);
        $('#info_modal').html(data['modal']);
      }
    }).error(function(x, t, m) {
      printAjaxError(x, t, m);
    });
  }
});

$('#close-detail').click(function(){
  $('#analysis-detail').slideUp();
  $('#analysis-select').slideDown(400, function(){
    $('#tab_det').removeClass('active').removeClass('in');
    $('a[href="#tab_det"]').closest('li').removeClass('active');
    $('a[href="#tab_syn"]').closest('li').addClass('active');
  });
});

$('#stats_content').on('click', '.sortable', function () {
  var $divs = $("div.stat-row");
  var type = $(this).data('type');
  var verse = $(this).data('verse');
  var alphabeticallyOrderedDivs = '';
  if (type != 'colq' && type != 'colv') {
    alphabeticallyOrderedDivs = $divs.sort(function (a, b) {
      return verse == 'up'
        ? String.prototype.localeCompare.call($(a).find('.' + type).html().toLowerCase(), $(b).find('.' + type).html().toLowerCase())
        : String.prototype.localeCompare.call($(b).find('.' + type).html().toLowerCase(), $(a).find('.' + type).html().toLowerCase());
    });
  } else if (type == 'colq') {
    alphabeticallyOrderedDivs = $divs.sort(function (a, b) {
      var aVal = $(a).find('.colq').text().toLowerCase();
      var bVal = $(b).find('.colq').text().toLowerCase();
      return verse == 'up' ? parseInt(aVal) - parseInt(bVal) : parseInt(bVal) - parseInt(aVal);
    });
  } else if (type == 'colv') {
    alphabeticallyOrderedDivs = $divs.sort(function (a, b) {
      var aVal = $(a).find('.colv').text().toLowerCase();
      var bVal = $(b).find('.colv').text().toLowerCase();
      aVal = aVal.substring(0, aVal.length - 2).replace(",", "").replace(".", "");
      bVal = bVal.substring(0, bVal.length - 2).replace(",", "").replace(".", "");
      return verse == 'up' ? parseInt(aVal) - parseInt(bVal) : parseInt(bVal) - parseInt(aVal);
    });
  }
  $("#stat-rows").html(alphabeticallyOrderedDivs);
  $("#stat-rows").data("ordering", type);
  $("#stat-rows").data("direction", verse);
});
//endregion

//region Print pdf
function stopLoading (){
  $('#pdf-stats').find(".loading").remove();
};
function isNotLoading (){
  return ($('#pdf-stats').find(".loading").length == 0);
};
$('#stats_content').on('click', '#pdf-stats', function(e) {
  e.preventDefault();

  if (isNotLoading()) {
    $(this).append('<span class="loading">{{ image("assets/img/loading.gif", "style": "height:20px;float:left") }}</span>');

    var info = {
      type: $("#info-type").text(),
      period1: $("#info-time").data('period1'),
      period2: $("#info-time").data('period2'),
      period3: $("#info-time").data('period3'),
      filter: $("#info-filter").text()
    };

    $.ajax({
      type: "POST",
      url: "{{ url('admin/createXlsForStats') }}",
      dataType: "json",
      data: {
        info:   info,
      }
    }).done(function(data) {
      stopLoading();

      // download
      var link = document.createElement('a');
      link.href = "../public/io/stats/" + data;
      link.download = data;
      document.body.appendChild(link);
      link.click();
    }).error(function(x, t, m) {
      printAjaxError(x, t, m);
    });
  }
});
//endregion
</script>
