{{ javascript_include("js/sliiide.min.js") }}
{{ javascript_include("vendors/jquery-ui-1.12.1.custom/datepicker-it.js") }}
<!-- document ready -->
<script>
    $(document).ready(function ($) {
        $('[data-toggle="tooltip"]').tooltip();
        {% if common['popup'] and not common['isOrder'] %}
        $('.new-order span').click();
        {% endif %}

        $('#order-history-filter').keyup(function () {
            delay(function () {
                filterOrdersHistory();
            }, 100);
        });
        addOrdersHistoryListeners();

        $('#date-flt-orh').daterangepicker({
            opens: "center",
            drops: "down",
            autoUpdateInput: true,
            startDate: "{{ common['modelDetailStyle'] == 3 ? common['zanStartDate'] : date('d/m/Y', strtotime('today -7days')) }}",
            endDate: "{{ common['modelDetailStyle'] == 3 ? common['zanEndDate'] : date('d/m/Y') }}",
            minDate: '01/01/2000',
            locale: {
                format: "DD/MM/YYYY",
                separator: " - ",
                applyLabel: {{ mt._('drp.apply')|json_encode }},
                cancelLabel: {{ mt._('drp.cancel')|json_encode }},
                fromLabel: {{ mt._('drp.from')|json_encode }},
                toLabel: {{ mt._('drp.to')|json_encode }},
                customRangeLabel: {{ mt._('drp.period')|json_encode }},
                daysOfWeek: [
                    {{ mt._('drp.sunday')|json_encode }},
                    {{ mt._('drp.monday')|json_encode }},
                    {{ mt._('drp.tuesday')|json_encode }},
                    {{ mt._('drp.wednesday')|json_encode }},
                    {{ mt._('drp.thursday')|json_encode }},
                    {{ mt._('drp.friday')|json_encode }},
                    {{ mt._('drp.saturday')|json_encode }}
                ],
                "monthNames": [
                    {{ mt._('drp.january')|json_encode }},
                    {{ mt._('drp.february')|json_encode }},
                    {{ mt._('drp.march')|json_encode }},
                    {{ mt._('drp.april')|json_encode }},
                    {{ mt._('drp.may')|json_encode }},
                    {{ mt._('drp.june')|json_encode }},
                    {{ mt._('drp.july')|json_encode }},
                    {{ mt._('drp.august')|json_encode }},
                    {{ mt._('drp.september')|json_encode }},
                    {{ mt._('drp.october')|json_encode }},
                    {{ mt._('drp.november')|json_encode }},
                    {{ mt._('drp.december')|json_encode }}
                ],
                "firstDay": 1
            }
        }, function (start, end, label) {
            $('#date-flt-orh').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'))
        });
        $('#date-flt-orh').on('apply.daterangepicker', function () {
            filterOrdersHistory();
        });
// ----------------------------------------------------
        $('#transdoc-history-filter').keyup(function () {
            delay(function () {
                filterTransDocHistory();
            }, 100);
        });
        addTransDocHistoryListeners();

        $('#date-flt-tdh').daterangepicker({
            opens: "center",
            drops: "down",
            autoUpdateInput: true,
            startDate: "{{ common['modelDetailStyle'] == 3 ? common['zanStartDate'] : date('d/m/Y', strtotime('today -7days')) }}",
            endDate: "{{ common['modelDetailStyle'] == 3 ? common['zanEndDate'] : date('d/m/Y') }}",
            minDate: '01/01/2000',
            locale: {
                format: "DD/MM/YYYY",
                separator: " - ",
                applyLabel: "{{ mt._('drp.apply') }}",
                cancelLabel: "{{ mt._('drp.cancel') }}",
                fromLabel: "{{ mt._('drp.from') }}",
                toLabel: "{{ mt._('drp.to') }}",
                customRangeLabel: "{{ mt._('drp.period') }}",
               daysOfWeek: [
                    {{ mt._('drp.sunday')|json_encode }},
                    {{ mt._('drp.monday')|json_encode }},
                    {{ mt._('drp.tuesday')|json_encode }},
                    {{ mt._('drp.wednesday')|json_encode }},
                    {{ mt._('drp.thursday')|json_encode }},
                    {{ mt._('drp.friday')|json_encode }},
                    {{ mt._('drp.saturday')|json_encode }}
                ],
                "monthNames": [
                    {{ mt._('drp.january')|json_encode }},
                    {{ mt._('drp.february')|json_encode }},
                    {{ mt._('drp.march')|json_encode }},
                    {{ mt._('drp.april')|json_encode }},
                    {{ mt._('drp.may')|json_encode }},
                    {{ mt._('drp.june')|json_encode }},
                    {{ mt._('drp.july')|json_encode }},
                    {{ mt._('drp.august')|json_encode }},
                    {{ mt._('drp.september')|json_encode }},
                    {{ mt._('drp.october')|json_encode }},
                    {{ mt._('drp.november')|json_encode }},
                    {{ mt._('drp.december')|json_encode }}
                ],
                "firstDay": 1
            }
        }, function (start, end, label) {
            $('#date-flt-tdh').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'))
        });
        $('#date-flt-tdh').on('apply.daterangepicker', function () {
            filterTransDocHistory();
        });
// ----------------------------------------------------
        $('#invoices-history-filter').keyup(function () {
            delay(function () {
                filterInvoicesHistory();
            }, 100);
        });
        addInvoicesHistoryListeners();

        $('#date-flt-inh').daterangepicker({
            opens: "center",
            drops: "down",
            autoUpdateInput: true,
            startDate: "{{ common['modelDetailStyle'] == 3 ? common['zanStartDate'] : date('d/m/Y', strtotime('today -7days')) }}",
            endDate: "{{ common['modelDetailStyle'] == 3 ? common['zanEndDate'] : date('d/m/Y') }}",
            minDate: '01/01/2000',
            locale: {
                format: "DD/MM/YYYY",
                separator: " - ",
                applyLabel: "{{ mt._('drp.apply') }}",
                cancelLabel: "{{ mt._('drp.cancel') }}",
                fromLabel: "{{ mt._('drp.from') }}",
                toLabel: "{{ mt._('drp.to') }}",
                customRangeLabel: "{{ mt._('drp.period') }}",
                daysOfWeek: [
                    {{ mt._('drp.sunday')|json_encode }},
                    {{ mt._('drp.monday')|json_encode }},
                    {{ mt._('drp.tuesday')|json_encode }},
                    {{ mt._('drp.wednesday')|json_encode }},
                    {{ mt._('drp.thursday')|json_encode }},
                    {{ mt._('drp.friday')|json_encode }},
                    {{ mt._('drp.saturday')|json_encode }}
                ],
                "monthNames": [
                    {{ mt._('drp.january')|json_encode }},
                    {{ mt._('drp.february')|json_encode }},
                    {{ mt._('drp.march')|json_encode }},
                    {{ mt._('drp.april')|json_encode }},
                    {{ mt._('drp.may')|json_encode }},
                    {{ mt._('drp.june')|json_encode }},
                    {{ mt._('drp.july')|json_encode }},
                    {{ mt._('drp.august')|json_encode }},
                    {{ mt._('drp.september')|json_encode }},
                    {{ mt._('drp.october')|json_encode }},
                    {{ mt._('drp.november')|json_encode }},
                    {{ mt._('drp.december')|json_encode }}
                ],
                "firstDay": 1
            }
        }, function (start, end, label) {
            $('#date-flt-inh').val(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'))
        });
        $('#date-flt-inh').on('apply.daterangepicker', function () {
            filterInvoicesHistory();
        });
    });
</script>

{% if not common['isOrder'] %}
    {% include "scripts/common/new_order.volt" %}
{% endif %}

{% if router.getActionName() == "info" %}
    {% include "scripts/common/xls_order.volt" %}
    {% include "scripts/support/new_ticket.volt" %}

    <script>
        $(".see-pdf").click(function (e) {
            e.preventDefault();

            var nuordc = $(this).closest('.nuordc').data('nuordc');
            var link = $(this).siblings(".link-pdf");

            $.ajax({
                type: "POST",
                url: "{{ url('pdf/order') }}",
                dataType: "json",
                data: {
                    nuordc: nuordc,
                }
            }).done(function (data) {
                link[0].click();
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });

        var text = "<span class='text-primary'>{{ mt._('account.order.sent') }}</span>";
        var row = "";
        $(document).on('click', '.send-order', function (e) {
            e.preventDefault();
            var nuordc = $(this).closest('.nuordc').data('nuordc');
            row = $(this).closest('.row');
            $('#order-to-send').val(nuordc);
            $('#order-to-send-txt').html(nuordc);
        });
        $(document).on('click', '#confirm-send-order', function (e) {
            e.preventDefault();

            $.ajax({
                type: "POST",
                url: "{{ url('cart/sendOrder') }}",
                dataType: "json",
                data: {
                    nuordc: $('#order-to-send').val(),
                }
            }).done(function (data) {
                if (data == "OK") {
                    location.href = "{{ url('account/info/ord') }}";
                    //row.find(".status").html(text);
                    //row.find(".send-order").closest('div').html("&nbsp;");
                    //row.find(".modify-order").closest('div').html("&nbsp;");
                    //row.find(".delete-order").closest('div').html("&nbsp;");
                    //$(".modal-send-order").modal('hide');
                } else {
                    let text = '';
                    if (data === "LE1") {
                        text = '{{ mt._('cart.error.limit.qtamin', ['value': common['cart_limit_min_value']])|escape_js }}';
                    } else if (data === "LE2") {
                        text = '{{ mt._('cart.error.limit.spendmin', ['value': common['cart_limit_min_value']])|escape_js }}';
                    } else if (data === "OE") {
                        text = '{{ mt._('_common.update.error')|escape_js }}';
                    } else {
                        text = '{{ mt._('_common.generic.db.error')|escape_js }}';
                    }
                    showTemporary(null, 5000, {className: 'alert alert-danger', text});
                }
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });
        $(document).on('click', '.modify-order', function (e) {
            e.preventDefault();
            var nuordc = $(this).closest('.nuordc').data('nuordc');
            $('#order-to-modify').val(nuordc);
            $('#order-to-modify-txt').html(nuordc);
        });
        $(document).on('click', '#confirm-modify-order', function (e) {
            e.preventDefault();

            $.ajax({
                type: "POST",
                url: "{{ url('cart/modifyOrder') }}",
                dataType: "json",
                data: {
                    nuordc: $('#order-to-modify').val(),
                }
            }).done(function (data) {
                window.location = "{{ url(common['homepage'] == 0 ? 'catalog/index' : 'catalog/collection') }}";
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });
        $(document).on('click', '.delete-order', function (e) {
            e.preventDefault();
            var nuordc = $(this).data('nuordc');
            $('#order-to-delete').val(nuordc);
            $('#order-to-delete-txt').html(nuordc);
        });
        $(document).on('click', '#confirm-cancel-order', function () {
            $.ajax({
                type: "POST",
                url: "{{ url('cart/deleteCurrentOrder') }}",
                dataType: "json",
                data: {
                    nuordc: $('#order-to-delete').val(),
                }
            }).done(function (data) {
                window.location = "{{ url('account/info/ord') }}";
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });

        $('#change_tab').change(function () {
            var value = $(this).val();
            $('.tab-pane').removeClass('show active');
            $('#' + value).addClass('show active');
        });

        $(document).mouseup(function (e) {
            var container = $(".row-tool-box");
            // if the target of the click isn't the container nor a descendant of the container
            if (!container.is(e.target) && container.has(e.target).length === 0) {
                container.hide();
            }
        });

        $('.show-tool-box').click(function () {
            $('.row-tool-box').hide();
            $(this).closest('.nuordc').find('.row-tool-box').css('display', 'inline-block');
        });

        {% if common['showProfile'] == 1 %}
        $('#save-password').click(function () {
            $('#div-error-old').removeClass('error');
            $('#error-old').hide();
            $('#div-error-new').removeClass('error');
            $('#error-new').hide();
            $('#div-error-repeat').removeClass('error');
            $('#error-repeat').hide();
            $('#success').hide();

            var old_password = $('#old-password').val();
            var new_password = $('#new-password').val();
            var rpt_password = $('#rpt-password').val();

            if (old_password == '') {
                $('#div-error-old').addClass('error');
                $('#error-old').show();
            } else if (new_password == '') {
                $('#div-error-new').addClass('error');
                $('#error-new').show();
            } else if (new_password != rpt_password) {
                $('#div-error-repeat').addClass('error');
                $('#error-repeat').show();
            } else {
                $.ajax({
                    type: 'POST',
                    url: "{{ url('account/changePassword') }}",
                    dataType: 'json',
                    data: {
                        old_password: old_password,
                        new_password: new_password,
                    }
                }).done(function (data) {
                    if (data == "WP") {
                        $('#div-error-old').addClass('error');
                        $('#error-old').show();
                    } else if (data == "OK") {
                        showTemporary("#success", 2000);
                    }
                }).error(function (x, t, m) {
                    printAjaxError(x, t, m);
                });
            }
        });

        {% endif %}

        {% if common['budgetManagement'] > 0 and session.get('auth')['type'] == 3 %}
        $('#load-budget').click(function () {
            $('#budget-box').html('');
            $('#budget-box').css('display', 'none');
            var index = $('#customer-budget-selector').val();
            $.ajax({
                type: "POST",
                url: "{{ url('account/loadBudgetForCustomer') }}",
                dataType: "json",
                data: {
                    tpanag: $('#customer-budget-' + index).data('tpanag'),
                    cdanag: $('#customer-budget-' + index).data('cdanag'),
                    cdstag: $('#season-budget-selector').val(),
                }
            }).done(function (data) {
                $("#budget-box").html(data["html"]);
                $('#budget-box').css('display', 'block');
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });
        {% endif %}

        function updatePar(numdoc, codart) {
            $('#modal-new-ticket #numdoc_par').val(numdoc);
            $('#modal-new-ticket #codart_par').val(codart);
        }

        {# sposto sotto perche' credo che alcune funzioni siano ricadute in questo if per sbaglio (ad esempio addOrdersHistoryListeners) #}
        {#{% if common['sendmaildatavar'] == 1 %}#}
        function reset_fields() {
            $('[data-oldvalue]').each(function () {
                $(this).val($(this).data('oldvalue'));
            });
        }

        function filterOrdersHistoryChecks() {
            let dafatt = $('#daf-flt-orh:checked').length > 0;
            let dasped = $('#das-flt-orh:checked').length > 0;

            if (!dafatt && !dasped) {
                $('.order-history-row').show();
                $('.row-orh.active').show();
            } else {
                $('.order-history-row').hide();
                $('.order-history-row.selected').show();
                $('.row-orh.active').hide();

                if (dafatt) {
                    $('div.order-history-row[data-filter*="dafatt"]').each(function () {
                        $(this).show();
                    });
                    $('div.row-orh.active[data-filter*="dafatt"]').each(function () {
                        $(this).show();
                    });
                }
                if (dasped) {
                    $('div.order-history-row[data-filter*="dasped"]').each(function () {
                        $(this).show();
                    });
                    $('div.row-orh.active[data-filter*="dasped"]').each(function () {
                        $(this).show();
                    });
                }
            }
        }

        function filterOrdersHistory() {
            let date_filter = $('#date-flt-orh').val().split(' - ');
            let search_filter = $('#order-history-filter').val();

            $.ajax({
                type: "POST",
                url: "{{ url('account/loadHistory') }}",
                dataType: "json",
                data: {
                    type: 'OR',
                    date_start: date_filter[0],
                    date_end: date_filter[1],
                    search: search_filter
                }
            }).done(function (data) {
                console.log('OK');
                $('#orh-content').children().remove();
                $('#orh-content').append(data["html"]);
                addOrdersHistoryListeners();
                filterOrdersHistoryChecks();
            }).error(function (x, t, m) {
                console.log('PHP error');
                printAjaxError(x, t, m);
            });
        }

        function addOrdersHistoryListeners() {
            $('.order-history-row').click(function () {
                var current = $(this);
                let numdoc = current.data('numdoc');

                if (current.hasClass('selected')) {
                    $('.row-orh-' + numdoc).hide();
                    $('.row-orh-' + numdoc).toggleClass('active');
                    current.toggleClass('text-bold');
                    current.toggleClass('selected');
                } else {
                    if ($('.row-orh-' + numdoc).length == 0) {
                        $.ajax({
                            type: "POST",
                            url: "{{ url('account/loadHistoryDetail') }}",
                            dataType: "json",
                            data: {
                                type: 'OR',
                                numdoc: numdoc,
                            }
                        }).done(function (data) {
                            console.log('OK');
                            current.toggleClass('text-bold');
                            current.toggleClass('selected');
                            // QUI INSERISCO LE RIGHE D'ORDINE
                            current.after(data["html"]);
                        }).error(function (x, t, m) {
                            console.log('PHP error');
                            printAjaxError(x, t, m);
                        });
                    } else {
                        $('.row-orh-' + numdoc).show();
                        $('.row-orh-' + numdoc).toggleClass('active');
                        current.toggleClass('text-bold');
                        current.toggleClass('selected');
                    }
                }
                filterOrdersHistoryChecks();
            });
        }

        function filterTransDocHistoryChecks() {
            let dafatt = $('#daf-flt-tdh:checked').length > 0;

            if (!dafatt) {
                $('.transdoc-history-row').show();
                $('.row-tdh.active').show();
            } else {
                $('.transdoc-history-row').hide();
                $('.transdoc-history-row.selected').show();
                $('.row-tdh.active').hide();

                $('div.transdoc-history-row[data-filter*="dafatt"]').each(function () {
                    $(this).show();
                });
                $('div.row-tdh.active[data-filter*="dafatt"]').each(function () {
                    $(this).show();
                });
            }
        }

        function filterTransDocHistory() {
            let date_filter = $('#date-flt-tdh').val().split(' - ');
            let search_filter = $('#transdoc-history-filter').val();

            $.ajax({
                type: "POST",
                url: "{{ url('account/loadHistory') }}",
                dataType: "json",
                data: {
                    type: 'DT',
                    date_start: date_filter[0],
                    date_end: date_filter[1],
                    search: search_filter
                }
            }).done(function (data) {
                console.log('OK');
                $('#tdh-content').children().remove();
                $('#tdh-content').append(data["html"]);
                addTransDocHistoryListeners();
                filterTransDocHistoryChecks();
            }).error(function (x, t, m) {
                console.log('PHP error');
                printAjaxError(x, t, m);
            });
        }

        function addTransDocHistoryListeners() {
            $('.transdoc-history-row').click(function () {
                var current = $(this);
                let numdoc = current.data('numdoc');

                if (current.hasClass('selected')) {
                    $('.row-tdh-' + numdoc).hide();
                    $('.row-tdh-' + numdoc).toggleClass('active');
                    current.toggleClass('text-bold');
                    current.toggleClass('selected');
                } else {
                    if ($('.row-tdh-' + numdoc).length == 0) {
                        $.ajax({
                            type: "POST",
                            url: "{{ url('account/loadHistoryDetail') }}",
                            dataType: "json",
                            data: {
                                type: 'DT',
                                numdoc: numdoc,
                            }
                        }).done(function (data) {
                            console.log('OK');
                            current.toggleClass('text-bold');
                            current.toggleClass('selected');
                            // QUI INSERISCO LE RIGHE D'ORDINE
                            current.after(data["html"]);
                        }).error(function (x, t, m) {
                            console.log('PHP error');
                            printAjaxError(x, t, m);
                        });
                    } else {
                        $('.row-tdh-' + numdoc).show();
                        $('.row-tdh-' + numdoc).toggleClass('active');
                        current.toggleClass('text-bold');
                        current.toggleClass('selected');
                    }
                }
                filterTransDocHistoryChecks();
            });
        }

        function filterInvoicesHistory() {
            let date_filter = $('#date-flt-inh').val().split(' - ');
            let search_filter = $('#invoices-history-filter').val();

            $.ajax({
                type: "POST",
                url: "{{ url('account/loadHistory') }}",
                dataType: "json",
                data: {
                    type: 'FT',
                    date_start: date_filter[0],
                    date_end: date_filter[1],
                    search: search_filter
                }
            }).done(function (data) {
                console.log('OK');
                $('#inh-content').children().remove();
                $('#inh-content').append(data["html"]);
                addInvoicesHistoryListeners();
            }).error(function (x, t, m) {
                console.log('PHP error');
                printAjaxError(x, t, m);
            });
        }

        function addInvoicesHistoryListeners() {
            $('.invoice-history-row').click(function () {
                var current = $(this);
                let numdoc = current.data('numdoc');

                if (current.hasClass('selected')) {
                    $('.row-inh-' + numdoc).hide();
                    $('.row-inh-' + numdoc).toggleClass('active');
                    current.toggleClass('text-bold');
                    current.toggleClass('selected');
                } else {
                    if ($('.row-inh-' + numdoc).length == 0) {
                        $.ajax({
                            type: "POST",
                            url: "{{ url('account/loadHistoryDetail') }}",
                            dataType: "json",
                            data: {
                                type: 'FT',
                                numdoc: numdoc,
                            }
                        }).done(function (data) {
                            console.log('OK');
                            current.toggleClass('text-bold');
                            current.toggleClass('selected');
                            // QUI INSERISCO LE RIGHE D'ORDINE
                            current.after(data["html"]);
                        }).error(function (x, t, m) {
                            console.log('PHP error');
                            printAjaxError(x, t, m);
                        });
                    } else {
                        $('.row-inh-' + numdoc).show();
                        $('.row-inh-' + numdoc).toggleClass('active');
                        current.toggleClass('text-bold');
                        current.toggleClass('selected');
                    }
                }
            });
        }

        // SOLO PER AGENTE
        {% if session.get('auth')['type'] == 3 %}
        function filterDeadlines() {
            if ($('#deadline-filter').val() == "") {
                $('.deadline-row').show();
            } else {
                $('.deadline-row').hide();
                $('div.deadline-row[data-filter^="' + $('#deadline-filter').val() + '"]').show();
                $('div.deadline-row[data-filter^="' + $('#deadline-filter').val().toUpperCase() + '"]').show();
            }
        }
        $('#deadline-filter').keyup(function () {
            delay(function () {
                filterDeadlines();
            }, 100);
        });
        $('#back-to-tickler').click(function () {
            $('#detail-deadline-container').hide();
            $('#deadlines-list-container').show();
        });
        $('.detail-deadline').click(function (e) {
            e.preventDefault();

            var tpanag = $(this).data('tpanag');
            var cdanag = $(this).data('cdanag');
            var descri = $(this).data('descri');

            $.ajax({
                type: "POST",
                url: "{{ url('account/loadDeadlinesForCustomer') }}",
                dataType: "json",
                data: {
                    tpanag: tpanag,
                    cdanag: cdanag,
                }
            }).done(function (data) {
                $('#detail-deadline-container').show();
                $('#deadlines-list-container').hide();

                $('#detail-customer').html(descri);

                if (data.length > 0) {
                    var toExpire = 0;
                    var expired = 0;
                    for (var i = 0; i < data.length; i++) {
                        if (data[i].expired > 0) {
                            expired += parseFloat(data[i].impsca);
                        } else {
                            toExpire += parseFloat(data[i].impsca);
                        }
                    }
                    var total = parseFloat(expired) + parseFloat(toExpire);
                    $('#detail-total').html(parseFloat(total).formatMoney(2, ",", ".") + " {{ common['currency'] }}");
                    $('#detail-expiring').html(parseFloat(toExpire).formatMoney(2, ",", ".") + " {{ common['currency'] }}");
                    $('#detail-expired').html(parseFloat(expired).formatMoney(2, ",", ".") + " {{ common['currency'] }}");

                    var prev_gopart = '';
                    var html = '';

                    for (var i = 0; i < data.length; i++) {
                        html += "<div class='row detail-row' style='";
                        if (i != 0 && data[i].numdoc != prev_gopart.numdoc) {
                            html += "border-top:1px #eee solid;";
                        }
                        if (i == data.length - 1) {
                            html += "border-bottom:1px #eee solid;margin-bottom:50px";
                        }
                        html += "'>";

                        {% if session.get('language') == 'it' %}
                        var descr_lang = data[i].des_it;
                        {% elseif session.get('language') == 'en' %}
                        var descr_lang = data[i].des_en;
                        {% elseif session.get('language') == 'fr' %}
                        var descr_lang = data[i].des_fr;
                        {% elseif session.get('language') == 'es' %}
                        var descr_lang = data[i].des_es;
                        {% elseif session.get('language') == 'de' %}
                        var descr_lang = data[i].des_de;
                        {% endif %}

                        if (i == 0 || data[i].numdoc != prev_gopart.numdoc) {
                            html += "<div class='col-det-dct'>" + data[i].tipdoc + "</div>";
                            html += "<div class='col-det-doc'><span class='my-tooltip' data-toggle='tooltip' title='" + descr_lang + "'>" + data[i].numdoc + "</span></div>";
                            html += "<div class='col-det-dat'>" + data[i].datdoc + "</div>";
                            html += "<div class='col-det-not'>" + (data[i].notpar != "" ? "<span class='my-tooltip' data-toggle='tooltip' title='" + data[i].notpar + "'>{{ mt._('_common.see') }}</span>" : "") + "</div>";
                            html += "<div class='col-det-pay'>" + data[i].despag + "</div>";
                            html += "<div class='col-det-amt'>" + parseFloat(data[i].impdoc).formatMoney(2, ",", ".") + " {{ common['currency'] }}" + "</div>";
                        } else {
                            html += "<div class='col-det-dct'>&nbsp;</div>";
                            html += "<div class='col-det-doc'>&nbsp;</div>";
                            html += "<div class='col-det-dat'>&nbsp;</div>";
                            html += "<div class='col-det-not'>&nbsp;</div>";
                            html += "<div class='col-det-pay'>&nbsp;</div>";
                            html += "<div class='col-det-amt'>&nbsp;</div>";
                        }

                        html += "<div class='col-det-top " + (data[i].expired > 0 ? "text-danger" : "") + "'>" + parseFloat(data[i].impsca).formatMoney(2, ",", ".") + " {{ common['currency'] }}</div>";
                        html += "<div class='col-det-ddl'>" + data[i].datsca + "</div>";
                        html += "<div class='col-det-exp text-danger'>" + (data[i].expired > 0 ? data[i].expired + " {{ mt._('_common.days') }}" : "&nbsp;") + "</div>";

                        html += "</div>";

                        prev_gopart = data[i];
                    }
                    $('#detail-deadlines-list').html(html);

                    $('#pdf-tickler').attr('href', "{{ url('pdf/tickler') }}/" + tpanag + "/" + cdanag);
                    $('[data-toggle="tooltip"]').tooltip();
                } else {
                    $('#detail-total').html("");
                    $('#detail-expiring').html("");
                    $('#detail-expired').html("");
                    $('#detail-deadlines-list').html("");
                }
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });
        $('#load-anagra').click(function () {
            var index = $('#multi-anagra-selector').val();

            $.ajax({
                type: "POST",
                url: "{{ url('account/loadCustomerInfo') }}",
                dataType: "json",
                data: {
                    tpanag: $('#multi-anagra-' + index).data('tpanag'),
                    cdanag: $('#multi-anagra-' + index).data('cdanag'),
                }
            }).done(function (data) {
                $(".customer-card").html(data["anagra"]);
                $("#anagra-desmer").html(data["desmer"]);
                $("#new-desmer").removeClass('d-none')
                //printAnagra(data);
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
            });
        });

        $('#new-desmer').click(function () {
            var index = $('#multi-anagra-selector').val();

            $.ajax({
                type: "POST",
                url: "{{ url('account/loadNewDesmerForm') }}",
                dataType: "json",
                data: {
                    tpanag: $('#multi-anagra-' + index).data('tpanag'),
                    cdanag: $('#multi-anagra-' + index).data('cdanag'),
                }
            }).done(function (data) {
                if (data.hasOwnProperty("desmerForm")) {
                    $("#new-desmer-form").html(data.desmerForm);
                } else {
                    showTemporary(null, 5000, {className: 'alert alert-danger', text: '{{ mt._('_common.generic.db.error')|escape_js }}'});
                }
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
                showTemporary(null, 5000, {className: 'alert alert-danger', text: '{{ mt._('_common.generic.db.error')|escape_js }}'});
            });
        });

        $('#new-desmer').click(function () {
            var index = $('#multi-anagra-selector').val();

            $.ajax({
                type: "POST",
                url: "{{ url('account/loadNewDesmerForm') }}",
                dataType: "json",
                data: {
                    tpanag: $('#multi-anagra-' + index).data('tpanag'),
                    cdanag: $('#multi-anagra-' + index).data('cdanag'),
                }
            }).done(function (data) {
                if (data.hasOwnProperty("desmerForm")) {
                    $("#new-desmer-form").html(data.desmerForm);
                    $("#new-desmer").addClass('d-none')
                } else {
                    showTemporary(null, 5000, {className: 'alert alert-danger', text: '{{ mt._('_common.generic.db.error')|escape_js }}'});
                }
            }).error(function (x, t, m) {
                printAjaxError(x, t, m);
                showTemporary(null, 5000, {className: 'alert alert-danger', text: '{{ mt._('_common.generic.db.error')|escape_js }}'});
            });
        });

        $('#new-desmer-form').on('click', '.desmer-create-new', function (e) {
            const formData = $('#new-desmer-form :input').serializeArray();
            const $selectedOption = $('#multi-anagra-selector :selected');
            if ($selectedOption.length > 0) {
                let data = {
                    tpanag: $selectedOption.data('tpanag'),
                    cdanag: $selectedOption.data('cdanag'),
                };

                for (const i in formData) {
                    data[formData[i].name] = formData[i].value;
                }
                if (data.desvid === "") {
                        showTemporary(null, 5000, {
                            className: 'alert alert-danger',
                            text: '{{ mt._('_common.generic.db.error')|escape_js }}'
                        });
                    return;
                }
                if (data.descri === "") {
                        showTemporary(null, 5000, {
                            className: 'alert alert-danger',
                            text: '{{ mt._('_common.generic.db.error')|escape_js }}'
                        });
                    return;
                }
                if (data.cdnazi === "") {
                        showTemporary(null, 5000, {
                            className: 'alert alert-danger',
                            text: '{{ mt._('_common.generic.db.error')|escape_js }}'
                        });
                        return;
                }

                console.log(data);

                $.ajax({
                    type: "POST",
                    url: "{{ url('account/createNewDesmer') }}",
                    dataType: "json",
                    data: data
                }).done(function (data) {
                    if (data.hasOwnProperty("desmer")) {
                        $("#new-desmer-form").html("");
                        $("#anagra-desmer").html(data["desmer"]);
                        $("#new-desmer").removeClass('d-none')
                    } else {
                        showTemporary(null, 5000, {className: 'alert alert-danger', text: '{{ mt._('_common.generic.db.error')|escape_js }}'});
                    }
                }).error(function (x, t, m) {
                    printAjaxError(x, t, m);
                    showTemporary(null, 5000, {className: 'alert alert-danger', text: '{{ mt._('_common.generic.db.error')|escape_js }}'});
                });
            } else {
                showTemporary(null, 5000, {className: 'alert alert-danger', text: '{{ mt._('_common.generic.db.error')|escape_js }}'});
            }
        });

        $('#new-anagra').click(function () {
            $('#anagra-selector-header').hide();
            $(".customer-card").hide();
            $("#anagra-desmer").hide();
            $("#new-anagra-box").show();
        });

        $('.cancel-new-anagra').click(function () {
            $("#new-anagra-box").hide();
            $('#anagra-selector-header').show();
            $(".customer-card").show();
            $("#anagra-desmer").show();
        });

        const copyValueAlreadyBox = '<div style="line-height:26px">{{ mt._('account.customer.alreadypresent') }}</div>';
        const textSaveDefault = "{{ mt._('_common.save') }}";
        const templateView = {{ tab_newclient == 1?'true':'false' }};
        const cdanazi = $('#new-anagra-cdnazi');

        if(templateView){
            cdanazi.on('change',function(e) {
                if(e.currentTarget.value == 'null' || e.currentTarget.value == ''){
                    $('#new-anagra-indiri').prop('disabled',true);
                    $('#new-anagra-provin').prop('disabled',true);
                    $('#new-anagra-ccitta').prop('disabled',true);
                    $('#new-anagra-codcap').prop('disabled',true);
                }else{
                    $('#new-anagra-indiri').prop('disabled',false);
                    $('#new-anagra-provin').prop('disabled',false);
                    $('#new-anagra-ccitta').prop('disabled',false);
                    $('#new-anagra-codcap').prop('disabled',false);
                }
            });
        }

        $('.save-new-anagra').click(function () {
            const button = $('.save-new-anagra');

            $('#new-anagra-descri').removeClass('error');
            $('#new-anagra-pariva').removeClass('error');
            $('#new-anagra-codfis').removeClass('error');
            $('#new-anagra-cdnazi').removeClass('error');
            $('#new-anagra-nulist').removeClass('error');

            if(templateView){
                $('#new-anagra-indiri').removeClass('error');
                $('#new-anagra-ccitta').removeClass('error');
                $('#new-anagra-codcap').removeClass('error');
            }

            $('.unsuccess-box').hide();

            var error = false;
            if ($('#new-anagra-descri').val() == '') {
                $('#new-anagra-descri').addClass('error');
                error = true;
            }

            if ($('#new-anagra-pariva').val() == '' && $('#new-anagra-codfis').val() == '') {
                $('#new-anagra-pariva').addClass('error');
                $('#new-anagra-codfis').addClass('error');
                error = true;
            }

            if ($('#new-anagra-indpec').val() == '' && $('#new-anagra-codupr').val() == '') {
                $('#new-anagra-indpec').addClass('error');
                $('#new-anagra-codupr').addClass('error');
                error = true;
            }

            if ($('#new-anagra-cdnazi').val() == 'null') {
                $('#new-anagra-cdnazi').addClass('error');
                error = true;
            }

            // Marco (b2b Centex - Add nulist obbligatorio - Matteo 05.09.2022)
            if ($('#new-anagra-nulist').val() == 'null') {
                $('#new-anagra-nulist').addClass('error');
                error = true;
            }

            if(templateView){
                if ($('#new-anagra-indiri').val() == '') {
                    $('#new-anagra-indiri').addClass('error');
                    error = true;
                }
                if ($('#new-anagra-ccitta').val() == '') {
                    $('#new-anagra-ccitta').addClass('error');
                    error = true;
                }
                if ($('#new-anagra-codcap').val() == '') {
                    $('#new-anagra-codcap').addClass('error');
                    error = true;
                }
            }

            if (!error) {
                button.text('Salvataggio in corso')
                    .addClass('disabled');
                button.prop('disabled', true);

                $.ajax({
                    type: "POST",
                    url: "{{ url('account/saveNewCustomer') }}",
                    dataType: "json",
                    data: {
                        descri: $('#new-anagra-descri').val(),
                        indiri: $('#new-anagra-indiri').val(),
                        ccitta: $('#new-anagra-ccitta').val(),
                        provin: $('#new-anagra-provin').val(),
                        cdnazi: $('#new-anagra-cdnazi').val(),
                        codcap: $('#new-anagra-codcap').val(),
                        codfis: $('#new-anagra-codfis').val(),
                        pariva: $('#new-anagra-pariva').val(),
                        uffipa: $('#new-anagra-pariva').val(),
                        codupr: $('#new-anagra-codupr').length ? $('#new-anagra-codupr').val() : null,
                        desvid: $('#new-anagra-desvid').val(),
                        cdzona: $('#new-anagra-cdzona').length ? $('#new-anagra-cdzona').val() : null,
                        intern: $('#new-anagra-intern').val(),
                        indema: $('#new-anagra-indema').val(),
                        indem2: $('#new-anagra-indem2').val(),
                        numtel: $('#new-anagra-numtel').val(),
                        numte2: $('#new-anagra-numte2').val(),
                        numcel: $('#new-anagra-numcel').val(),
                        numfax: $('#new-anagra-numfax').val(),
                        websit: $('#new-anagra-websit').val(),
                        indpec: $('#new-anagra-indpec').val(),
                        codabi: $('#new-anagra-codabi').val(),
                        codcab: $('#new-anagra-codcab').val(),
                        cdiban: $('#new-anagra-cdiban').val(),
                        tppaga: $('#new-anagra-tppaga').length ? $('#new-anagra-tppaga').val() : null,
                        tpport: $('#new-anagra-tpport').length ? $('#new-anagra-tpport').val() : null,
                        nulist: $('#new-anagra-nulist').val(),
                        cdvett: $('#new-anagra-cdvett').length ? $('#new-anagra-cdvett').val() : null,
                    }
                }).done(function (data) {
                    if (data == 'OK') {
                        window.location.reload();
                    } else if (data == 'AP') {
                        button.text(textSaveDefault)
                            .removeClass('disabled');
                        showTemporary('.unsuccess-box.already-present', 5000);
                    } else {
                        button.text(textSaveDefault);
                        $(".unsuccess-box.already-present").html(
                            '<div style="line-height:26px">' + data + '</div>'
                        );
                        showTemporary('.unsuccess-box.already-present', 5000);
                    }

                    button.prop('disabled', false)
                        .removeClass('disabled');

                }).error(function (x, t, m) {
                    printAjaxError(x, t, m);
                });
            } else {
                showTemporary('.unsuccess-box.empty-fields', 5000);
            }
        });

        $(".customer-card").on('click', '#multi-anagra-require-modify', function (e) {
            e.preventDefault();
            if ($(this).closest('.customer-card').find('.readonly:disabled').length > 0) {
                $(this).closest('.customer-card').find('.readonly').removeAttr('disabled');
                $(this).html("{{ mt._('account.customer.senddata') }}");
            } else {
                var tpanag = $(this).data('tpanag');
                var old_cdanag = $(this).data('cdanag');
                var desvid = $('#multi-anagra-desvid').val() != null ? $('#multi-anagra-desvid').val() : "";
                var indiri = $('#multi-anagra-indiri').val() != null ? $('#multi-anagra-indiri').val() : "";
                var ccitta = $('#multi-anagra-ccitta').val() != null ? $('#multi-anagra-ccitta').val() : "";
                var provin = $('#multi-anagra-provin').val() != null ? $('#multi-anagra-provin').val() : "";
                var codcap = $('#multi-anagra-codcap').val() != null ? $('#multi-anagra-codcap').val() : "";
                var cdnazi = $('#multi-anagra-cdnazi option:selected').val() != "null" ? $('#multi-anagra-cdnazi option:selected').val() : "";
                var dsnazi = $('#multi-anagra-cdnazi option:selected').html() != "&nbsp;" ? $('#multi-anagra-cdnazi option:selected').html() : "";
                var cdzona = $('#multi-anagra-cdzona option:selected').val() != "null" ? $('#multi-anagra-cdzona option:selected').val() : "";
                var dszona = $('#multi-anagra-cdzona option:selected').html() != "&nbsp;" ? $('#multi-anagra-cdzona option:selected').html() : "";
                var intern = $('#multi-anagra-intern').val() != null ? $('#multi-anagra-intern').val() : "";
                var numtel = $('#multi-anagra-numtel').val() != null ? $('#multi-anagra-numtel').val() : "";
                var numcel = $('#multi-anagra-numcel').val() != null ? $('#multi-anagra-numcel').val() : "";
                var numfax = $('#multi-anagra-numfax').val() != null ? $('#multi-anagra-numfax').val() : "";
                var codabi = $('#multi-anagra-codabi').val() != null ? $('#multi-anagra-codabi').val() : "";
                var codcab = $('#multi-anagra-codcab').val() != null ? $('#multi-anagra-codcab').val() : "";
                var cdiban = $('#multi-anagra-cdiban').val() != null ? $('#multi-anagra-cdiban').val() : "";
                var cdvett = $('#multi-anagra-cdvett option:selected').val() != "null" ? $('#multi-anagra-cdvett option:selected').val() : "";
                var dsvett = $('#multi-anagra-cdvett option:selected').html() != "&nbsp;" ? $('#multi-anagra-cdvett option:selected').html() : "";

                var subject = "{{ mt._('account.customer.requestmodify') }}";
                var emailBody = "{{ mt._('account.customer.requestmodify') }} " + old_cdanag + "\n";
                emailBody += "{{ mt._('account.customer.address') }}: " + indiri + "\n";
                emailBody += "{{ mt._('account.customer.city') }}: " + ccitta + "\n";
                emailBody += "{{ mt._('account.customer.province') }}: " + provin + "\n";
                emailBody += "{{ mt._('account.customer.capzip') }}: " + codcap + "\n";
                emailBody += "{{ mt._('account.customer.country') }} ({{ mt._('_common.code') }}): " + cdnazi + "\n";
                emailBody += "{{ mt._('account.customer.country') }}: " + dsnazi + "\n";
                emailBody += "{{ mt._('account.customer.zone') }} ({{ mt._('_common.code') }}): " + cdzona + "\n";
                emailBody += "{{ mt._('account.customer.zone') }}: " + dszona + "\n";
                emailBody += "{{ mt._('account.customer.countrycode') }}: " + intern + "\n";
                emailBody += "{{ mt._('account.customer.telephone') }}: " + numtel + "\n";
                emailBody += "{{ mt._('account.customer.mobilephone') }}: " + numcel + "\n";
                emailBody += "{{ mt._('account.customer.fax') }}: " + numfax + "\n";
                emailBody += "ABI: " + codabi + "\n";
                emailBody += "CAB: " + codcab + "\n";
                emailBody += "IBAN: " + cdiban + "\n";
                emailBody += "{{ mt._('account.customer.carrier') }} ({{ mt._('_common.code') }}): " + cdvett + "\n";
                emailBody += "{{ mt._('account.customer.carrier') }}: " + dsvett + "\n\n";
                emailBody += "***********************************************\n\n";
                emailBody += "{{ mt._('account.customer.autogenerated') }}";

                $.ajax({
                    type: 'POST',
                    url: "{{ url('account/sendEditRequest') }}",
                    dataType: 'json',
                    data: {
                        subject: subject,
                        content: emailBody,
                    }
                }).done(function (data) {
                    $(this).closest('.customer-card').find('.readonly').prop('disabled', true);
                    $(this).html("{{ mt._('account.customer.requiremodify') }}");
                    reset_fields();
                }).error(function (x, t, m) {
                    printAjaxError(x, t, m);
                });
            }
        });

            {% if common['sendmaildatavar'] == 1 %}
                $("#anagra-desmer").on('click', '.desmer-require-modify', function (e) {
                    e.preventDefault();
                    if ($(this).closest('.destination-card').find('.readonly:disabled').length > 0) {
                        $(this).closest('.destination-card').find('.readonly').removeAttr('disabled');
                        $(this).html("{{ mt._('account.customer.senddata') }}");
                    } else {
                        var cddesm = $(this).data('cddesm');
                        var desvid = $(this).data('desvid');
                        var tpanag = $(this).data('tpanag');
                        var cdanag = $(this).data('cdanag');
                        var indiri = $('#' + cddesm + '-indiri').val() != null ? $('#' + cddesm + '-indiri').val() : "";
                        var ccitta = $('#' + cddesm + '-ccitta').val() != null ? $('#' + cddesm + '-ccitta').val() : "";
                        var provin = $('#' + cddesm + '-provin').val() != null ? $('#' + cddesm + '-provin').val() : "";
                        var codcap = $('#' + cddesm + '-codcap').val() != null ? $('#' + cddesm + '-codcap').val() : "";
                        var cdnazi = $('#' + cddesm + '-cdnazi option:selected').val() != "null" ? $('#' + cddesm + '-cdnazi option:selected').val() : "";
                        var dsnazi = $('#' + cddesm + '-cdnazi option:selected').html() != "&nbsp;" ? $('#' + cddesm + '-cdnazi option:selected').html() : "";
                        var cdzona = $('#' + cddesm + '-cdzona option:selected').val() != "null" ? $('#' + cddesm + '-cdzona option:selected').val() : "";
                        var dszona = $('#' + cddesm + '-cdzona option:selected').html() != "&nbsp;" ? $('#' + cddesm + '-cdzona option:selected').html() : "";
                        var intern = $('#' + cddesm + '-intern').val() != null ? $('#' + cddesm + '-intern').val() : "";
                        var numtel = $('#' + cddesm + '-numtel').val() != null ? $('#' + cddesm + '-numtel').val() : "";
                        var numcel = $('#' + cddesm + '-numcel').val() != null ? $('#' + cddesm + '-numcel').val() : "";
                        var numfax = $('#' + cddesm + '-numfax').val() != null ? $('#' + cddesm + '-numfax').val() : "";

                        var subject = "{{ mt._('account.customer.requestmodify') }} " + cddesm + " - " + desvid;
                        var emailBody = "{{ mt._('account.customer.requestmodify') }}\n";
                        emailBody += "{{ mt._('account.customer.address') }}: " + indiri + "\n";
                        emailBody += "{{ mt._('account.customer.city') }}: " + ccitta + "\n";
                        emailBody += "{{ mt._('account.customer.province') }}: " + provin + "\n";
                        emailBody += "{{ mt._('account.customer.capzip') }}: " + codcap + "\n";
                        emailBody += "{{ mt._('account.customer.country') }} ({{ mt._('_common.code') }}): " + cdnazi + "\n";
                        emailBody += "{{ mt._('account.customer.country') }}: " + dsnazi + "\n";
                        emailBody += "{{ mt._('account.customer.zone') }} ({{ mt._('_common.code') }}): " + cdzona + "\n";
                        emailBody += "{{ mt._('account.customer.zone') }}: " + dszona + "\n";
                        emailBody += "{{ mt._('account.customer.countrycode') }}: " + intern + "\n";
                        emailBody += "{{ mt._('account.customer.telephone') }}: " + numtel + "\n";
                        emailBody += "{{ mt._('account.customer.mobilephone') }}: " + numcel + "\n";
                        emailBody += "{{ mt._('account.customer.fax') }}: " + numfax + "\n";
                        emailBody += "***********************************************\n\n";
                        emailBody += "{{ mt._('account.customer.autogenerated') }}";

                        $.ajax({
                            type: 'POST',
                            url: "{{ url('account/sendEditRequest') }}",
                            dataType: 'json',
                            data: {
                                subject: subject,
                                content: emailBody,
                            }
                        }).done(function (data) {
                            $(this).closest('.destination-card').find('.readonly').prop('disabled', true);
                            $(this).html("{{ mt._('account.customer.requiremodify') }}");
                            reset_fields();
                        }).error(function (x, t, m) {
                            printAjaxError(x, t, m);
                        });
                    }
                });
            {% endif %}
        {% else %}
        $('.anagra-require-modify').click(function () {
            if ($(this).closest('.customer-card').find('.readonly:disabled').length > 0) {
                $(this).closest('.customer-card').find('.readonly').removeAttr('disabled');
                $(this).html("{{ mt._('account.customer.senddata') }}");
            } else {
                var tpanag = $(this).data('tpanag');
                var old_cdanag = $(this).data('cdanag');
                var prefix = tpanag + '-' + old_cdanag;
                var cdanag = $('#' + prefix + '-cdanag').val();
                var descri = $('#' + prefix + '-descri').val();
                var cdetic = $('#' + prefix + '-cdetic option:selected').val() != "null" ? $('#' + prefix + '-cdetic option:selected').val() : "";
                var dsetic = $('#' + prefix + '-cdetic option:selected').html() != "&nbsp;" ? $('#' + prefix + '-cdetic option:selected').html() : "";
                var codfis = $('#' + prefix + '-codfis').val() != null ? $('#' + prefix + '-codfis').val() : "";
                var pariva = $('#' + prefix + '-pariva').val() != null ? $('#' + prefix + '-pariva').val() : "";
                var indiri = $('#' + prefix + '-indiri').val() != null ? $('#' + prefix + '-indiri').val() : "";
                var ccitta = $('#' + prefix + '-ccitta').val() != null ? $('#' + prefix + '-ccitta').val() : "";
                var provin = $('#' + prefix + '-provin').val() != null ? $('#' + prefix + '-provin').val() : "";
                var codcap = $('#' + prefix + '-codcap').val() != null ? $('#' + prefix + '-codcap').val() : "";
                var cdnazi = $('#' + prefix + '-cdnazi option:selected').val() != "null" ? $('#' + prefix + '-cdnazi option:selected').val() : "";
                var dsnazi = $('#' + prefix + '-cdnazi option:selected').html() != "&nbsp;" ? $('#' + prefix + '-cdnazi option:selected').html() : "";
                var cdzona = $('#' + prefix + '-cdzona option:selected').val() != "null" ? $('#' + prefix + '-cdzona option:selected').val() : "";
                var dszona = $('#' + prefix + '-cdzona option:selected').html() != "&nbsp;" ? $('#' + prefix + '-cdzona option:selected').html() : "";
                var intern = $('#' + prefix + '-intern').val() != null ? $('#' + prefix + '-intern').val() : "";
                var numtel = $('#' + prefix + '-numtel').val() != null ? $('#' + prefix + '-numtel').val() : "";
                var numcel = $('#' + prefix + '-numcel').val() != null ? $('#' + prefix + '-numcel').val() : "";
                var numfax = $('#' + prefix + '-numfax').val() != null ? $('#' + prefix + '-numfax').val() : "";
                var codabi = $('#' + prefix + '-codabi').val() != null ? $('#' + prefix + '-codabi').val() : "";
                var codcab = $('#' + prefix + '-codcab').val() != null ? $('#' + prefix + '-codcab').val() : "";
                var cdiban = $('#' + prefix + '-cdiban').val() != null ? $('#' + prefix + '-cdiban').val() : "";
                var cdvett = $('#' + prefix + '-cdvett option:selected').val() != "null" ? $('#' + prefix + '-cdvett option:selected').val() : "";
                var dsvett = $('#' + prefix + '-cdvett option:selected').html() != "&nbsp;" ? $('#' + prefix + '-cdvett option:selected').html() : "";

                var subject = "{{ mt._('account.customer.requestmodify') }}";
                var emailBody = "{{ mt._('account.customer.requestmodify') }} " + old_cdanag + "\n";
                emailBody += "tpanag: " + tpanag + "\n";
                emailBody += "cdanag: " + cdanag + "\n";
                emailBody += "descri: " + descri + "\n";
                emailBody += "cdetic: " + cdetic + "\n";
                emailBody += "dsetic: " + dsetic + "\n";
                emailBody += "codfis: " + codfis + "\n";
                emailBody += "pariva: " + pariva + "\n";
                emailBody += "indiri: " + indiri + "\n";
                emailBody += "ccitta: " + ccitta + "\n";
                emailBody += "provin: " + provin + "\n";
                emailBody += "codcap: " + codcap + "\n";
                emailBody += "cdnazi: " + cdnazi + "\n";
                emailBody += "dsnazi: " + dsnazi + "\n";
                emailBody += "cdzona: " + cdzona + "\n";
                emailBody += "dszona: " + dszona + "\n";
                emailBody += "intern: " + intern + "\n";
                emailBody += "numtel: " + numtel + "\n";
                emailBody += "numcel: " + numcel + "\n";
                emailBody += "numfax: " + numfax + "\n";
                emailBody += "codabi: " + codabi + "\n";
                emailBody += "codcab: " + codcab + "\n";
                emailBody += "cdiban: " + cdiban + "\n";
                emailBody += "cdvett: " + cdvett + "\n";
                emailBody += "dsvett: " + dsvett + "\n\n";
                emailBody += "***********************************************\n\n";
                emailBody += "{{ mt._('account.customer.autogenerated') }}";

                $.ajax({
                    type: 'POST',
                    url: "{{ url('account/sendEditRequest') }}",
                    dataType: 'json',
                    data: {
                        subject: subject,
                        content: emailBody,
                    }
                }).done(function (data) {
                    $(this).closest('.customer-card').find('.readonly').prop('disabled', true);
                    $(this).html("{{ mt._('account.customer.requiremodify') }}");
                    reset_fields();
                }).error(function (x, t, m) {
                    printAjaxError(x, t, m);
                });
            }
        });
            {% if common['sendmaildatavar'] == 1 %}
                $('.desmer-require-modify').click(function () {
                    if ($(this).closest('.destination-card').find('.readonly:disabled').length > 0) {
                        $(this).closest('.destination-card').find('.readonly').removeAttr('disabled');
                        $(this).html("{{ mt._('account.customer.senddata') }}");
                    } else {
                        var cddesm = $(this).data('cddesm');
                        var desvid = $(this).data('desvid');
                        var tpanag = $(this).data('tpanag');
                        var cdanag = $(this).data('cdanag');
                        var indiri = $('#' + cddesm + '-indiri').val() != null ? $('#' + cddesm + '-indiri').val() : "";
                        var ccitta = $('#' + cddesm + '-ccitta').val() != null ? $('#' + cddesm + '-ccitta').val() : "";
                        var provin = $('#' + cddesm + '-provin').val() != null ? $('#' + cddesm + '-provin').val() : "";
                        var codcap = $('#' + cddesm + '-codcap').val() != null ? $('#' + cddesm + '-codcap').val() : "";
                        var cdnazi = $('#' + cddesm + '-cdnazi option:selected').val() != "null" ? $('#' + cddesm + '-cdnazi option:selected').val() : "";
                        var dsnazi = $('#' + cddesm + '-cdnazi option:selected').html() != "&nbsp;" ? $('#' + cddesm + '-cdnazi option:selected').html() : "";
                        var cdzona = $('#' + cddesm + '-cdzona option:selected').val() != "null" ? $('#' + cddesm + '-cdzona option:selected').val() : "";
                        var dszona = $('#' + cddesm + '-cdzona option:selected').html() != "&nbsp;" ? $('#' + cddesm + '-cdzona option:selected').html() : "";
                        var intern = $('#' + cddesm + '-intern').val() != null ? $('#' + cddesm + '-intern').val() : "";
                        var numtel = $('#' + cddesm + '-numtel').val() != null ? $('#' + cddesm + '-numtel').val() : "";
                        var numcel = $('#' + cddesm + '-numcel').val() != null ? $('#' + cddesm + '-numcel').val() : "";
                        var numfax = $('#' + cddesm + '-numfax').val() != null ? $('#' + cddesm + '-numfax').val() : "";

                        var subject = "{{ mt._('account.customer.requestmodify') }}";
                        var emailBody = "{{ mt._('account.customer.requestmodify') }}\n";
                        emailBody += "cddesm: " + cddesm + "\n";
                        emailBody += "tpanag: " + tpanag + "\n";
                        emailBody += "cdanag: " + cdanag + "\n";
                        emailBody += "desvid: " + desvid + "\n";
                        emailBody += "indiri: " + indiri + "\n";
                        emailBody += "ccitta: " + ccitta + "\n";
                        emailBody += "provin: " + provin + "\n";
                        emailBody += "codcap: " + codcap + "\n";
                        emailBody += "cdnazi: " + cdnazi + "\n";
                        emailBody += "dsnazi: " + dsnazi + "\n";
                        emailBody += "cdzona: " + cdzona + "\n";
                        emailBody += "dszona: " + dszona + "\n";
                        emailBody += "intern: " + intern + "\n";
                        emailBody += "numtel: " + numtel + "\n";
                        emailBody += "numcel: " + numcel + "\n";
                        emailBody += "numfax: " + numfax + "\n\n";
                        emailBody += "***********************************************\n\n";
                        emailBody += "{{ mt._('account.customer.autogenerated') }}";

                        $.ajax({
                            type: 'POST',
                            url: "{{ url('account/sendEditRequest') }}",
                            dataType: 'json',
                            data: {
                                subject: subject,
                                content: emailBody,
                            }
                        }).done(function (data) {
                            $(this).closest('.destination-card').find('.readonly').prop('disabled', true);
                            $(this).html("{{ mt._('account.customer.requiremodify') }}");
                            reset_fields();
                        }).error(function (x, t, m) {
                            printAjaxError(x, t, m);
                        });
                    }
                });
            {% endif %}
        {% endif %}
    </script>

{% endif %}
