{% extends "base_pdf.volt" %}

{% block body %}
    <?php
    $logo_style = $exist_logo ? 'style="position: absolute; top: 50px; left: 30px; width: 26px; font-weight: bold;"' : '';

    // Testo delle tre righe
    $line1 = "INTERPORTO DI NOLA LOTTO C2 NUMERO 1/5";
    $line2 = "80035 NOLA (NA)-Italy";
    $line3 = "Reg.Imp.C.F. e P.IVA IT 04088251212";

    // Altezza totale del testo
    $total_text_height = 3 * 9; // Ridotto a 12px per il testo

    // Posizione verticale del logo rispetto alle righe di testo
    $logo_vertical_position = $total_text_height + 50; // 30px di distanza tra il testo e il logo
    ?>
    <body id="pdf400" class="sell-conditions">
    <div>
        {% set headerHeight = 343 + 19 %}
        {% set bg = '#e6e6e6' %}
        {% set totqty = 0 %}
        {% set numdsserm =0 %}
        {% for article in articles %}
            {% set rowQuanti = 0 %}
            {% for i in range(1,maxDimension) %}
                {% set indexRange = loop.index %}
                {% for qtaTaglia in article.octagl %}
                    {% if qtaTaglia.quanti > 0 and qtaTaglia.postgl == indexRange %}
                        {% set rowQuanti = rowQuanti + qtaTaglia.quanti %}
                    {% endif %}
                {% endfor %}
            {% endfor %}
            {% set totqty = totqty + rowQuanti %}
            {% set numdsserm +=1 %}
        {% endfor %}
        <!-- First Header -->
        <div class="w100" style="line-height:15px">
            {#<div class="w100" style="height:40px;">&nbsp;</div>#}
            <div class="hdr_col first_row pad fl w30" style="text-align:center">
                <div class="fl w100">
                    {{ exist_logo ? "<img src='../" ~ imgurl ~ "' style='height:55px;margin:0 auto'/>" : '<span style="font-size:45px; line-height:50px;font-weight:bold;">KOCCA Srl</span>' }}
                    <div class="fl w100" style="font-size: 11px;text-align:center"><?php echo $line1; ?></div>
                    <div class="fl w100" style="font-size: 11px;text-align:center"><?php echo $line2; ?></div>
                    <div class="fl w100" style="font-size: 11px;text-align:center"><?php echo $line3; ?></div>
                </div>
            </div>

            <div class="hdr_col first_row pad" style="width:35%;float:right">
                <div class="btop blft bbtm brgt pad">
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.recipient.code.short') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.cddesm : '' }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.recipient.reference.short') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.recipient.businessname.short') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.desvid : anagra.descri }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.address') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.indiri : anagra.indiri }}</div>
                    </div>
                    <div class="fl w25">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.zipcode') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.codcap : anagra.codcap }}</div>
                    </div>
                    <div class="fl w55">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.city') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.ccitta : anagra.ccitta }}</div>
                    </div>
                    <div class="fl w20">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.province.short') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.provin : anagra.provin }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.phone') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.numtel : anagra.numtel }}{{ desmer is defined and desmer.numcel != '' ? ' - ' ~ desmer.numcel : '' }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.fax') }}</div>
                        <div class="fl bold">{{ desmer is defined ? desmer.numfax : anagra.numfax }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.vat.short') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                </div>
            </div>
            <div class="hdr_col first_row pad" style="width:35%;float:right;">
                <div class="btop blft bbtm brgt pad">
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.code.short') }}</div>
                        <div class="fl bold">{{ anagra.cdanag }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.reference.short') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.businessname.short') }}</div>
                        <div class="fl bold">{{ anagra.descri }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.address') }}</div>
                        <div class="fl bold">{{ anagra.indiri }}</div>
                    </div>
                    <div class="fl w25">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.zipcode') }}</div>
                        <div class="fl bold">{{ anagra.codcap }}</div>
                    </div>
                    <div class="fl w55">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.city') }}</div>
                        <div class="fl bold">{{ anagra.ccitta }}</div>
                    </div>
                    <div class="fl w20">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.province.short') }}</div>
                        <div class="fl bold">{{ anagra.provin }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.phone') }}</div>
                        <div class="fl bold">{{ anagra.numtel }}{{ anagra.numcel != '' ? ' - ' ~ anagra.numcel : '' }}</div>
                    </div>
                    <div class="fl w50">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.fax') }}</div>
                        <div class="fl bold">{{ anagra.numfax }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.customer.vat.short') }}</div>
                        <div class="fl bold">{{ anagra.codfis }}
                            {{ anagra.codfis != anagra.pariva and anagra.codfis != '' and anagra.pariva != '' ? ' - ' : '' }}
                            {{ anagra.codfis != anagra.pariva ? anagra.pariva : '' }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Second Header -->
        <div class="w100 mt10" style="line-height:15px">
            <div class="hdr_col second_row pad w35">
                <div class="btop blft bbtm brgt pad">
                    <div class="fl w60">
                        <div class="fl pad mr10">{{ mt._('pdf.brand') }}</div>
                        <div class="fl bold">{{ cttest.cdtitl }}</div>
                    </div>
                    <div class="fl w40">
                        <div class="fl pad mr10">{{ mt._('pdf.reference') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                    <div class="fl w60">
                        <div class="fl pad mr10">{{ mt._('_common.season') }}</div>
                        <div class="fl bold">{{ octest.cdstag }}</div>
                    </div>
                    <div class="fl w40">
                        <div class="fl pad mr10">{{ mt._('pdf.order.date') }}</div>
                        <div class="fl bold">{{ octest.dtcrea }}</div>
                    </div>
                    <div class="fl w60">
                        {% if octest.flstat >= 2 %}
                            <div class="fl pad mr10">{{ mt._('pdf.order.number.short') }}</div>
                            <div class="fl bold">{{ octest.codice_ordine }}</div>
                        {% else %}
                            &nbsp;
                        {% endif %}
                    </div>
                    <div class="fl w40">
                        <div class="fl pad mr10">{{ mt._('_common.agent') }}</div>
                        <div class="fl bold">{{ octest.dsagen }}</div>
                    </div>
                </div>
            </div>
            <div class="hdr_col second_row pad w30">
                <div class="btop blft bbtm brgt pad">
                    <div class="fl w100">
                        <div class="fl pad mr10" style=>{{ mt._('pdf.payment.conditions') }}</div>
                        <div class="fl bold">{{ octest.dspaga }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.delivery.conditions') }}</div>
                        <div class="fl bold">{{ octest.dstpor }}</div>
                    </div>
                    <div class="fl w100">
                        {% if octest.flstat > 2 %}
                            <div class="fl pad mr10">{{ mt._('pdf.delivery') }}</div>
                            {# <div class="fl bold">{{ octest.dsscad != '' ? octest.dsscad : octest.dtmcli }}</div> #}
                            <div class="fl bold">{{ octest.dsscad != '' ? octest.dsscad : octest.dtmcli }}</div>
                        {% else %}
                            &nbsp;
                        {% endif %}
                    </div>
                </div>
            </div>
            <div class="hdr_col second_row pad w35">
                <div class="btop blft bbtm brgt pad fl w60">
                    <div class="fl w100">
                        <div class="fl pad mr10">{{ mt._('pdf.bank') }}</div>
                        <div class="fl bold">&nbsp;</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">ABI:</div>
                        <div class="fl bold">{{ anagra.codabi != 0 ? anagra.codabi : '' }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl pad mr10">CAB:</div>
                        <div class="fl bold">{{ anagra.codcab != 0 ? anagra.codcab : '' }}</div>
                    </div>
                </div>
                <div class="resume_table btop blft bbtm brgt fl w35"
                     style="margin-left: 4.9%"> {# btop blft bbtm brgt pad fl w50 #}
                    <div class="fl w100">
                        <div class="fl w50" style="background-color: #c0c0c0; text-align: left;">Pcs.</div>
                        <div class="fl w50 bold" style="text-align: center;">{{ totqty }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl w50" style="background-color: #c0c0c0; text-align: left;">Items</div>
                        <div class="fl w50 bold" style="text-align: center;">{{ numdsserm }}</div>
                    </div>
                    <div class="fl w100">
                        <div class="fl w50" style="background-color: #c0c0c0; text-align: left;">Groups</div>
                        <div class="fl w50 bold" style="text-align: center;">{{ groupItem|length }}</div>
                    </div>
                </div>
            </div>
        </div>
        {#<div class="w100 mt10" style="line-height:15px">
            <div class="notes_row pad">
                <div class="btop blft bbtm brgt pad w100 fl capitalize">{{ mt._('_common.notes') }}</div>
                <div class="blft bbtm brgt pad w100 fl">{{ octest.notcli }}&nbsp;</div>
            </div>
        </div>#}
        <div class="w100">&nbsp;</div>
        <div class="sell-conditions-content">
            {{ conditionsHtml }}
        </div>

        <div class="w100">{{ mt._('pdf.customer.stampandsignature') }}</div>
        <div class="w100">&nbsp;</div>
        <div class="fl w100">
            <div class="fl bold">{{ anagra.descri }}</div>
        </div>
        <div class="fl w100">
            <div class="fl bold">{{ anagra.indiri }}</div>
        </div>
        <div class="fl w100">
            <div class="fl bold">{{ anagra.codcap }}</div>
            <div class="fl bold">{{ anagra.ccitta }}</div>
        </div>
        <div class="fl w100">
            <div class="fl bold">{{ anagra.provin }}</div>
        </div>

        <div class="w100">&nbsp;</div>
        <div class="fl w100" style="white-space:normal;">
            {{ mt._('pdf.400.customer.signatureacceptation') }}
        </div>

        <div class="w100">&nbsp;</div>
        <div class="w100">{{ mt._('pdf.customer.stampandsignature') }}</div>
        <div class="w100">&nbsp;</div>
        <div class="fl w100">
            <div class="fl bold">{{ anagra.descri }}</div>
        </div>
        <div class="fl w100">
            <div class="fl bold">{{ anagra.indiri }}</div>
        </div>
        <div class="fl w100">
            <div class="fl bold">{{ anagra.codcap }}</div>
            <div class="fl bold">{{ anagra.ccitta }}</div>
        </div>
        <div class="fl w100">
            <div class="fl bold">{{ anagra.provin }}</div>
        </div>

    </div>
    </body>
{% endblock %}
