{% extends "base_pdf.volt" %}

{% block body %}
    {% set rowsOnFirstPage = 4 %}
    {% set rowsOnOtherPages = 5 %}
    {% set pageHeight = 1480 %}

    {% set imgurl = 'img/' ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>

    <body id="pdf200">

    {% set page = 1 %}

    {# Articles rows #}
    {% for article in articles %}

        {% set imgurl_i = "img/temp/resize/model/" ~ article.flimag_i %}
        <?php $exist_i = $article->flimag_i != '' && file_exists($imgurl_i); ?>

        {% if not exist_i and article.flimag_i != '' %}
            {% set imgurl_i = "img/model/" ~ article.flimag_i %}
            <?php $exist_i = file_exists($imgurl_i); ?>
        {% endif %}

        {% if (page == 1 and loop.index % rowsOnFirstPage == 1) or (page > 1 and (loop.index - rowsOnFirstPage) % rowsOnOtherPages == 1) %}

            {# Logo #}
            {% if not specialBehaviour %}
                {% if exist_logo %}
                    <div class="logo-fullwidth"><img src='{{ url(imgurl) }}'/></div>
                {% endif %}
            {% else %}
                <div class="fl center"
                     style="width:1000px;line-height:40px;height:40px;font-size:30px;border:1px solid black;background-color:#aaa">
                    GZ USA, Inc.
                </div>
                <div class="fl center" style="width:1000px;line-height:20px;height:40px;">555 MADISON AVENUE 21st FLOOR,
                    10022 NEW YORK<br/>Tel: (212) 792-4420 E-Mail: erin.iorfida@gzanottiusa.com
                </div>
            {% endif %}

            {# Order and Page number #}
            <div class="header mt10">
                <div class="w50">{{ mt._('_common.order') }}: G2B / {{ octest.nuordc }} - {{ octest.dtcrea }}</div>
                <div class="w50 right">{{ mt._('pdf.page') }} {{ page }}</div>
            </div>

            {% if page == 1 and loop.index % rowsOnFirstPage == 1 %}
                {# Order and customer info header #}
                <div class="header">
                    <div class="w100">{{ mt._('_common.customer') }}: {{ anagra.cdanag }} {{ anagra.descri }}</div>
                </div>
                <div class="header">
                    <div class="w55">{{ anagra.indiri }}</div>
                    <div class="w45">{{ mt._('_common.season') }}: {{ octest.cdstag }}</div>
                </div>
                <div class="header">
                    <div class="w55">{{ anagra.codcap }}
                        - {{ anagra.ccitta }} {{ anagra.provin != '' ? '(' ~ anagra.provin ~ ')' : '' }}</div>
                    <div class="w45">{{ mt._('_common.collection') }}: Giuseppe Zanotti</div>
                </div>
                <div class="header">
                    <div class="w55">{{ anagra.dsnazi }}</div>
                    <div class="w45">{{ mt._('cart.payment') }}: {{ octest.dspaga }}</div>
                </div>
                <div class="header">
                    <div class="w55">{{ mt._('_common.email') }}: {{ anagra.indema }}</div>
                    <div class="w45">{{ mt._('_common.delivery') }}: {{ octest.dtmcoi }} - {{ octest.dtmcof }}</div>
                </div>
                <div class="header">
                    <div class="w55">{{ mt._('_common.telephone.short') }}: {{ anagra.numtel }}</div>
                    <div class="w45">{{ mt._('_common.notes') }}: {{ octest.notcli }}</div>
                </div>
            {% endif %}

            {# Rows header #}
            <div class="art-header">
                <div class="art-width">{{ mt._('_common.article') }}</div>
                <div class="siz-width">{{ mt._('pdf.qty.persize') }}</div>
                <div class="prc-width right">{{ mt._('_common.price') }}</div>
            </div>

        {% endif %}

        <div class="order-row pbi_avoid" style="font-size:11px">
            <div class="art-info">
                <div class="art-width">
                    {% if article.tpvend != 'CUSTOM' %}
                        <span style="font-weight:bold;white-space:pre-wrap">{{ article.cdarti }}</span>&nbsp;
                        <span style="white-space:pre-wrap">{{ article.dsarti }}</span>
                    {% else %}
                        <span style="font-weight:bold;white-space:pre-wrap">{{ article.cdartn }}</span>&nbsp;
                        <span style="white-space:pre-wrap">{{ mt._('_common.variant') }} {{ article.dsarti }}</span>
                    {% endif %}
                </div>
                <div class="siz-width">
                    {% for size in article.octagl %}
                        <div class="size-cell {{ not loop.first ? 'blft' : '' }}">
                            <div class="fl w100 bbtm" style="font-weight:bold">{{ size.taglia }}</div>
                            <div class="fl w100">{{ size.quanti > 0 ? size.quanti : '&nbsp;' }}</div>
                        </div>
                    {% endfor %}
                </div>
                {% if octest.flnosc == 0 %}
                    {% set sconto = article.octagl[0].scont1 != 0
                        ? (1 - (article.octagl[0].scont1 / 100)) * (1 - (article.octagl[0].scont2 / 100)) * (1 - (article.octagl[0].scont3 / 100))
                        : (1 - (octest.anagra_scont1 / 100)) * (1 - (octest.anagra_scont2 / 100)) * (1 - (octest.anagra_scont3 / 100)) %}
                {% else %}
                    {% set sconto = 1 %}
                {% endif %}

                {% set prezzo = article.tpvend != 'CUSTOM'
                    ? (article.octagl[0].prezzo * sconto)|currency ~ ' ' ~ currency
                    : 'tbc' %}
                <div class="prc-width right" style="text-transform:uppercase;text-align:right">
                    <div style="width:100%;text-transform:uppercase;text-align:right">{{ prezzo }}</div>
                    {{ showRP and article.retailPrice != '' ? '<div style="width:100%;text-transform:uppercase;text-align:right">RTL ' ~ article.retailPrice ~ '</div>' : '' }}
                </div>
            </div>

            <div class="art-features">
                <div class="art-img-box">
                    {% if exist_i %}
                        <img src="{{ url(imgurl_i) }}" class="art-img"/>
                    {% else %}
                        &nbsp;
                    {% endif %}
                </div>

                <div class="features-box">
                    <div class="feature-box"
                         style="text-transform:uppercase;text-align:center">{{ mt._('_common.qty.tot') }}<br/><span
                                style="font-weight:bold">{{ article.quanti }}</span></div>
                    {% for feature in article.features %}
                        <div class="feature-box">{{ feature.dscomp }}<br/><span
                                    style="font-weight:bold">{{ feature.valore }}</span></div>
                    {% endfor %}
                </div>
            </div>

        </div>

        {% if (page == 1 and loop.index % rowsOnFirstPage == 0) or (page > 1 and (loop.index - rowsOnFirstPage) % rowsOnOtherPages == 0) %}
            <div class="pb_after" style="float:none">&nbsp;</div>
            {# Increase page number #}
            {% set page = page + 1 %}
        {% endif %}

    {% endfor %}

    {# Header on first page = 300px, on other pages = 180px, every row = 250px. #}
    {% if page == 1 %}
        {% set currentHeight = 300 + (articles|length * 250) %}
    {% else %}
        {% set currentHeight = 180 + (((articles|length - rowsOnFirstPage) % rowsOnOtherPages) * 250) %}
    {% endif %}

    {# Summary height = 20px (margin-top), every summary row = 30px, final summary = 50px (20px margin-top + 30px height), signature = 40px (at least 20px margin-top + 60px height). #}
    {% set summaryHeight = 20 + (summary|length * 30) + 50 %}
    {% set signatureHeight = 80 %}

    {#
    {% if (page == 1 and articles|length % rowsOnFirstPage == 0) or (page > 1 and (articles|length - rowsOnFirstPage) % rowsOnOtherPages == 0) %}
      <div class="logo-fullwidth"><img src='{{ url(imgurl) }}'/></div>
    {% else %}
      <div class="pb_after" style="float:none">&nbsp;</div>
    {% endif %}
    #}

    {% set currentHeight = 100 + summaryHeight %}
    {% set totQty = 0 %}
    {% set totAmt = 0 %}
    {% for line in summary %}
        {% set style = loop.first ? 'margin-top:20px' : '' %}
        {% set totQty = totQty + line['quanti'] %}
        {% set totAmt = totAmt + line['impnet'] %}
        <div class="fl w100" style="font-size:16px;height:30px;line-height:30px;{{ style }}">
            <div class="fl w40">{{ mt._('_common.line') }}: <span style="font-weight:bold">{{ line['descri'] }}</span>
            </div>
            <div class="fl w15">{{ mt._('pdf.total.quantity') }}:</div>
            <div class="fl w15" style="font-weight:bold">{{ line['quanti'] }}</div>
            <div class="fl w15">{{ mt._('pdf.total.value') }}:</div>
            <div class="fl w15" style="font-weight:bold">{{ line['impnet']|currency }} {{ currency }}</div>
        </div>
    {% endfor %}
    <div class="fl w100"
         style="font-size:16px;height:30px;line-height:30px;font-weight:bold;border-top:1px solid #606060;margin-top:10px;padding-top:10px">
        <div class="fl w40">&nbsp;</div>
        <div class="fl w15">{{ mt._('pdf.total.quantity') }}:</div>
        <div class="fl w15">{{ totQty }}</div>
        <div class="fl w15">{{ mt._('pdf.total.value') }}:</div>
        <div class="fl w15">{{ totAmt|currency }} {{ currency }}</div>
    </div>
    {#
    {% set marginTop = 'margin-top:'~ (pageHeight - currentHeight - signatureHeight) ~ 'px' %}
    #}
    <div class="fl w100 center pbi_avoid" style="font-weight:bold;margin-top:60px">
        <div class="fl w100">
            <div class="fl w75" style="height:20px">&nbsp;</div>
            <div class="fl w25" style="height:20px">{{ mt._('pdf.signature') }}</div>
        </div>
        <div class="fl w100">
            <div class="fl w75" style="height:40px">&nbsp;</div>
            <div class="fl w25 bbtm" style="height:40px">&nbsp;</div>
        </div>
    </div>

    {#
    <div class="pb_after" style="float:none">&nbsp;</div>
    #}
    </body>
{% endblock %}
