{% extends "base_pdf.volt" %}

{% block body %}
    {% set imgurl = 'img/' ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>

    {% set hdr_logo = exist_logo
        ? "<div class='w100 fl logo'><img src='" ~ url(imgurl) ~ "'/></div>"
        : "<div class='w100 fl logo'><br/></div>" %}

{% set maxHeight = 870 %}
{% set firstPageOffset = 180 %}
{% set rowHeight = 95 %}
{% set headerHeight = 20 %}
{% set currentOffset = 0 %}

    <body id="pdf2">
    <div class="fl w100" style="height:80px">
        <div class="fl w30">{{ hdr_logo }}</div>
        <div class="fl w35">
            <span style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.customer') }}</span><br/>
            <span>{{ anagra.cdanag }} - {{ anagra.descri }}</span><br/>
            <span>{{ anagra.indiri }} - {{ anagra.ccitta }} {{ anagra.provin != '' ? '(' ~ anagra.provin ~ ')' : '' }}</span><br/>
            <span>{{ anagra.codcap }} - {{ anagra.dsnazi }}</span><br/>
            <span>{{ mt._('account.customer.vatcode.short') ~ " " ~ anagra.pariva }}</span><br/>
            <span>{{ mt._('account.customer.taxcode.short') ~ " " ~ anagra.codfis }}</span>
        </div>
        <div class="fl w35">
            {% if desmer != null %}
                <span style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.destination') }}</span><br/>
                <span>{{ desmer.cddesm }}</span><br/>
                <span>{{ desmer.desvid }}</span><br/>
                <span>{{ desmer.indiri }} - {{ desmer.ccitta }} {{ desmer.provin != '' ? '(' ~ desmer.provin ~ ')' : '' }}</span>
                <br/>
                <span>{{ desmer.codcap }} - {{ desmer.dsnazi }}</span>
            {% endif %}
        </div>
    </div>
    <div class="fl w100" style="height:80px">
        <div class="fl w10"><span style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.season') }}</span>
        </div>
        <div class="fl w20"><span>{{ octest.cdstag != '' ? order.cdstag : '&nbsp;' }}</span></div>
        <div class="fl w10"><span style="font-weight:bold;text-transform:uppercase">{{ mt._('pdf.order.date') }}</span>
        </div>
        <div class="fl w25"><span>{{ octest.dtcrea }}</span></div>
        <div class="fl w10"><span
                    style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.delivery') }}</span></div>
        <div class="fl w25">
            <span>{{ octest.dtmcli != '' ? octest.dtmcli :  octest.dtmcoi ~ ' - ' ~ octest.dtmcof }}</span></div>
        <div class="fl w10"><span style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.agent') }}</span>
        </div>
        <div class="fl w90"><span>{{ octest.cdagen != '' ? octest.cdagen ~ ' - ' ~ octest.dsagen : '' }}</span></div>
        <div class="fl w10"><span
                    style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.payment.cond') }}</span></div>
        <div class="fl w90"><span>{{ octest.dspaga != '' ? octest.dspaga : '&nbsp;' }}</span></div>
        <div class="fl w10"><span
                    style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.shipping.cond') }}</span></div>
        <div class="fl w25"><span>{{ octest.dstpor != '' ? octest.dstpor : '&nbsp;' }}</span></div>
        <div class="fl w10"><span style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.notes') }}</span>
        </div>
        <div class="fl w55">
            <span>{{ octest.notcli }}{{ octest.notcli != '' ? ' ' : '&nbsp;' }}{{ octest.notazi }}</span></div>
        <div class="fl w100">&nbsp;</div>
        <div class="fl w10"><span
                    style="font-weight:bold;text-transform:uppercase">{{ mt._('_common.ordernumber') }}</span></div>
        <div class="fl w90"><span>{{ octest.nuordc }}</span></div>
    </div>

    {% set global_prc_tot = 0 %}
    {% set global_qty_tot = 0 %}

    {% set isFirstPage = true %}
    {% set currentOffset = firstPageOffset %}
    {% set addBorderBottom = false %}
    {% for article in articles %}
        {% set total_qty = 0 %}
        {% set total_prc = 0 %}

        {% if currentOffset + rowHeight > maxHeight or isFirstPage %}
            {{ not isFirstPage ? '<div style="page-break-before:always;height:0;display:block;clear:both;"></div>' : '' }}
            {% set addBorderBottom = isFirstPage ? false : true %}
            <div class="fl w100 {{ isFirstPage ? 'mt20' : '' }}" style="height:{{ headerHeight }}px">
                <div class="row-col padc btop bbtm bg-gray">{{ mt._('_common.row') }}</div>
                <div class="row-img padc btop bbtm bg-gray">{{ mt._('_common.image') }}</div>
                <div class="row-art padc btop bbtm bg-gray">{{ mt._('_common.article') }}</div>
                <div class="row-mat padc btop bbtm bg-gray">{{ mt._('_common.material') }}</div>
                <div class="row-siz padc btop bbtm bg-gray">{{ mt._('pdf.size.subdivision') }}</div>
                <div class="row-qty padc btop bbtm bg-gray">{{ mt._('pdf.qty.total') }}</div>
                <div class="row-prc padc btop bbtm bg-gray">{{ mt._('_common.price.unit') }}</div>
                <div class="row-tot padc btop bbtm bg-gray">{{ mt._('_common.total') }}</div>
            </div>
            {% set currentOffset = headerHeight + (isFirstPage ? currentOffset : 0) %}
            {% set isFirstPage = false %}
        {% endif %}

        {% set imgurl_n = "img/temp/resize/model/" ~ article.flimag_n %}
        <?php $exist_n = $article->flimag_n != '' && file_exists($imgurl_n); ?>

        {% if not exist_n and article.flimag_n != '' %}
            {% set imgurl_n = "img/model/" ~ article.flimag_n %}
            <?php $exist_n = file_exists($imgurl_n); ?>
        {% endif %}

        <div class="fl w100 pbi_avoid" style="height:{{ rowHeight }}px">
            <div class="fl" style="width:1350px;clear:both;height:{{ rowHeight - 20 }}px">
                <div class="row-col padc h100">{{ article.nurorc }}</div>
                <div class="row-img h100 center"
                     style="padding:2px">{{ exist_n ? "<img src='" ~ url(imgurl_n) ~ "' style='height:70px'/>" : "<br/>" }}</div>
                <div class="row-art padc h100">{{ article.cdartn }}</div>
                <div class="row-mat padc h100"
                     style="white-space:pre-wrap">{% if article.components|length > 0 %}{% for component in article.components %}{{ component.cdmate }}{{ substr(component.tpcomp, 0, 2) == '10' ? ' - ' ~ component.dsmate : '' }}{{ not loop.last ? ' / ' : '' }}{% endfor %}{% else %}{{ article.dsarti }}{% endif %}</div>
                <div class="row-siz padc h100">
                    {% for size in article.octagl %}
                        {% set total_qty = total_qty + size.quanti %}
                        {% set total_prc = total_prc + (size.quanti * size.prezzo) %}
                        <div class="fl brgt center h100">
                            <div class="h50 pad">{{ size.taglia }}</div>
                            <div class="h50 pad">{{ size.quanti > 0 ? size.quanti : '&nbsp;' }}</div>
                        </div>
                    {% endfor %}
                    {% set global_prc_tot = global_prc_tot + total_prc %}
                    {% set global_qty_tot = global_qty_tot + total_qty %}
                </div>
                <div class="row-qty padc h100">
                    <div class="fl h100">
                        <div class="h50 pad">&nbsp;</div>
                        <div class="h50 pad">{{ total_qty }}</div>
                    </div>
                </div>
                <div class="row-prc padc h100">
                    <div class="fl h100">
                        <div class="h50 pad">&nbsp;</div>
                        <div class="h50 pad bold">{{ article.octagl[0].prezzo|currency }} {{ currency }}</div>
                    </div>
                </div>
                <div class="row-tot padc h100">
                    <div class="fl h100">
                        <div class="h50 pad">&nbsp;</div>
                        <div class="h50 pad bold">{{ total_prc|currency }} {{ currency }}</div>
                    </div>
                </div>
            </div>
            <div class="fl bbtm btop blft brgt padc" style="width:1349px;clear:both;height:20px">
                <div class="fl w76 fs9 h100">
                    <span class="bold uppercase">{{ mt._('_common.notes') }}</span>&nbsp;
                    {{ article.tpnoco != '' ? article.tpnoco ~ ' - ' ~ article.noccom_dsnoco : article.dsnoco }}&nbsp;
                    {{ article.tpindo != '' ? article.tpindo ~ ' - ' ~ article.dsindo : article.indorc }}
                </div>
                <div class="fl w24 fs9 h100">
                    {{ article.dtmcli != '00/00/0000' ? '<span class="bold uppercase">' ~ mt._("_common.delivery") ~ '</span>&nbsp;' ~ article.dtmcli : '&nbsp;' }}
                </div>
            </div>
        </div>

        {% set currentOffset = currentOffset + rowHeight %}
        {% set addBorderBottom = false %}

    {% endfor %}

    <div class="fl w100 mt30" style="height:20px">
        <div class="fl w10 text-right padc">{{ mt._('pdf.signature') }}</div>
        <div class="fl w40 bbtm padc">&nbsp;</div>
        <div class="fl w15 btop bbtm blft brgt" style="margin:0 5%;line-height:20px">
            <div class="fl w50 padc text-left uppercase">{{ mt._('pdf.total.quantity') }}</div>
            <div class="fl w50 padc text-right bold">{{ global_qty_tot }}</div>
        </div>
        <div class="fl w15 btop bbtm blft brgt" style="margin:0 5%;line-height:20px">
            <div class="fl w50 padc text-left uppercase">{{ mt._('pdf.total.value') }}</div>
            <div class="fl w50 padc text-right bold">{{ global_prc_tot|currency }} {{ currency }}</div>
        </div>
    </div>

    <?php
    $currentConditionFile = '';
    $defaultConditionFile = 'upload/media/pdf_cond_it.jpg';
    $languageConditionFile = 'upload/media/pdf_cond_' . $this->session->get('language') . '.jpg';
    if (file_exists($languageConditionFile)) {
    $currentConditionFile = $languageConditionFile;
    } else if (file_exists(defaultConditionFile)) {
    $currentConditionFile = $defaultConditionFile;
    }
    ?>
    {% if currentConditionFile != '' %}
        <div class="fl w100">
            <img src='{{ url(currentConditionFile) }}' class="w100"/>
        </div>
    {% endif %}
    </body>
{% endblock %}
