{% extends "base_pdf.volt" %}

{% block body %}
    {% set imgurl = "img/" ~ logo %}
    <?php $exist_logo = $logo != '' && file_exists($imgurl); ?>

    <body id="pdf100">
    <div>
        {% set headerHeight = 223 + 19 %}
        {% set bg = '#e6e6e6' %}
        {% set totqty = 0 %}
        {% set totamt = 0 %}
        {% set currentHeight = 0 %}
        {% for article in articles %}
            {% set rowHeight = 38 + (article.cdvari != '' ? 19 : 0) %}
            {% set bg = '#ffffff' %}
            {% if currentHeight + rowHeight > 900 or loop.first %}
                <div class="w100 {{ loop.index0 != 0 ? 'pb_before' : '' }}" style="line-height:15px">
                    <div class="hdr_col first_row pad">
                        {{ exist_logo ? "<img src='" ~ url(imgurl) ~ "' style='width:100%'/>" : "<br/>" }}
                    </div>
                    <div class="hdr_col first_row pad">
                        <div class="btop blft bbtm brgt pad">
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.code.short') }}</div>
                                <div class="fl bold">{{ anagra.cdanag }}</div>
                            </div>
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.reference.short') }}</div>
                                <div class="fl bold">&nbsp;</div>
                            </div>
                            <div class="fl w100">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.businessname.short') }}</div>
                                <div class="fl bold">{{ anagra.descri }}</div>
                            </div>
                            <div class="fl w100">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.address') }}</div>
                                <div class="fl bold">{{ anagra.indiri }}</div>
                            </div>
                            <div class="fl w25">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.zipcode') }}</div>
                                <div class="fl bold">{{ anagra.codcap }}</div>
                            </div>
                            <div class="fl w55">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.city') }}</div>
                                <div class="fl bold">{{ anagra.ccitta }}</div>
                            </div>
                            <div class="fl w20">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.province.short') }}</div>
                                <div class="fl bold">{{ anagra.provin }}</div>
                            </div>
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.phone') }}</div>
                                <div class="fl bold">{{ anagra.numtel }}{{ anagra.numcel != '' ? ' - ' ~ anagra.numcel : '' }}</div>
                            </div>
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.fax') }}</div>
                                <div class="fl bold">{{ anagra.numfax }}</div>
                            </div>
                            <div class="fl w100">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.vat.short') }}</div>
                                <div class="fl bold">{{ anagra.codfis }}
                                    {{ anagra.codfis != anagra.pariva and anagra.codfis != '' and anagra.pariva != '' ? ' - ' : '' }}
                                    {{ anagra.codfis != anagra.pariva ? anagra.pariva : '' }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="hdr_col first_row pad">
                        <div class="btop blft bbtm brgt pad">
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.recipient.code.short') }}</div>
                                <div class="fl bold">{{ desmer is defined ? desmer.cddesm : '' }}</div>
                            </div>
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.recipient.reference.short') }}</div>
                                <div class="fl bold">&nbsp;</div>
                            </div>
                            <div class="fl w100">
                                <div class="fl pad mr10">{{ mt._('pdf.recipient.businessname.short') }}</div>
                                <div class="fl bold">{{ desmer is defined ? desmer.desvid : '' }}</div>
                            </div>
                            <div class="fl w100">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.address') }}</div>
                                <div class="fl bold">{{ desmer is defined ? desmer.indiri : '' }}</div>
                            </div>
                            <div class="fl w25">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.zipcode') }}</div>
                                <div class="fl bold">{{ desmer is defined ? desmer.codcap : '' }}</div>
                            </div>
                            <div class="fl w55">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.city') }}</div>
                                <div class="fl bold">{{ desmer is defined ? desmer.ccitta : '' }}</div>
                            </div>
                            <div class="fl w20">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.province.short') }}</div>
                                <div class="fl bold">{{ desmer is defined ? desmer.provin : '' }}</div>
                            </div>
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.phone') }}</div>
                                <div class="fl bold">{{ desmer is defined ? desmer.numtel : '' }}{{ desmer is defined and desmer.numcel != '' ? ' - ' ~ desmer.numcel : '' }}</div>
                            </div>
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.fax') }}</div>
                                <div class="fl bold">{{ desmer is defined ? desmer.numfax : '' }}</div>
                            </div>
                            <div class="fl w100">
                                <div class="fl pad mr10">{{ mt._('pdf.customer.vat.short') }}</div>
                                <div class="fl bold">&nbsp;</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="w100 mt10" style="line-height:15px">
                    <div class="hdr_col second_row pad">
                        <div class="btop blft bbtm brgt pad">
                            <div class="fl w60">
                                <div class="fl pad mr10">{{ mt._('pdf.brand') }}</div>
                                <div class="fl bold">&nbsp;</div>
                            </div>
                            <div class="fl w40">
                                <div class="fl pad mr10">{{ mt._('pdf.reference') }}</div>
                                <div class="fl bold">&nbsp;</div>
                            </div>
                            <div class="fl w60">
                                <div class="fl pad mr10">{{ mt._('_common.catalog') }}</div>
                                <div class="fl bold">{{ octest.dscata }}</div>
                            </div>
                            <div class="fl w40">
                                <div class="fl pad mr10">{{ mt._('pdf.order.date') }}</div>
                                <div class="fl bold">{{ octest.dtcrea }}</div>
                            </div>
                            <div class="fl w60">
                                <div class="fl pad mr10">{{ mt._('pdf.order.number.short') }}</div>
                                <div class="fl bold">{{ octest.nuordc }}</div>
                            </div>
                            <div class="fl w40">
                                <div class="fl pad mr10">{{ mt._('pdf.code.agent') }}</div>
                                <div class="fl bold">{{ octest.cdagen }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="hdr_col second_row pad">
                        <div class="btop blft bbtm brgt pad">
                            <div class="fl w50">
                                <div class="fl pad mr10">{{ mt._('pdf.payment.conditions') }}</div>
                                <div class="fl bold">{{ octest.dspaga }}</div>
                            </div>
                            <div class="fl w70">
                                <div class="fl pad mr10">{{ mt._('pdf.delivery') }}</div>
                                <div class="fl bold">{{ octest.dsscad != '' ? octest.dsscad : octest.dtmcli }}</div>
                            </div>
                            <div class="fl w30">
                                <div class="fl pad mr10">{{ mt._('pdf.sales') }}</div>
                                <div class="fl bold">&nbsp;</div>
                            </div>
                        </div>
                    </div>
                    <div class="hdr_col second_row pad">
                        <div class="btop blft bbtm brgt pad">
                            <div class="fl w100">
                                <div class="fl pad mr10">{{ mt._('pdf.bank') }}</div>
                                <div class="fl bold">&nbsp;</div>
                            </div>
                            <div class="fl w70">
                                <div class="fl pad mr10">ABI:</div>
                                <div class="fl bold">{{ anagra.codabi != 0 ? anagra.codabi : '' }}</div>
                            </div>
                            <div class="fl w30">
                                <div class="fl pad mr10">CAB:</div>
                                <div class="fl bold">{{ anagra.codcab != 0 ? anagra.codcab : '' }}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="w100 mt10" style="line-height:15px">
                    <div class="notes_row pad">
                        <div class="btop blft bbtm brgt pad w100 fl capitalize">{{ mt._('_common.notes') }}</div>
                        <div class="blft bbtm brgt pad w100 fl">{{ octest.notcli }}&nbsp;</div>
                    </div>
                </div>

                <div class="w100 mt20 btop brgt bbtm blft" style="line-height:18px;padding-right:0px">
                    <div class="mod_col center">{{ mt._('_common.model') }}</div>
                    <div class="art_col center">{{ mt._('_common.article') }}</div>
                    <div class="col_col center">{{ mt._('pdf.color.short') }}</div>
                    <div class="des_col center">{{ mt._('_common.description') }}</div>
                    <div class="siz_col center">{{ mt._('pdf.qty.persize') }}</div>
                    <div class="tqt_col center">{{ mt._('pdf.tot') }}</div>
                    <div class="prc_col center">{{ mt._('pdf.price.short') }}</div>
                    <div class="tam_col center">{{ mt._('pdf.total.taxable.short') }}</div>
                    <div class="dsc_col center">{{ mt._('_common.discount') }}</div>
                </div>
                {% set currentHeight = headerHeight %}
            {% endif %}

            {% set currentHeight = currentHeight + rowHeight %}

            <div class="w100 brgt bbtm blft sizes" style="background-color:#a9a9a9;line-height:18px;padding-right:0px">
                <div class="mod2_col" style="border-right:0">&nbsp;</div>
                <div class="art2_col" style="border-right:0">&nbsp;</div>
                <div class="col2_col"
                     style="font-size:8px;border-right:0">{{ article.dtdrop != '' ? article.dtdrop : '' }}&nbsp;
                </div>
                <div class="des2_col"
                     style="font-size:8px">{{ elements.printAddress(article.cddesm == '' ? anagra : article.shipping, false) }}
                    &nbsp;
                </div>
                <div class="siz2_col" style="font-size:8px">
                    {% set loops = [1..10] %}
                    {% for i in loops[0] %}
                        {% set style = not loop.first ? 'border-left:1px solid black' : '' %}
                        {% set emptyCell = true %}
                        {% for taglia in article.octagl %}
                            {% if taglia.postgl == i %}
                                {% set emptyCell = false %}
                                <div class="fl pad-small" style="{{ style }}">{{ taglia.taglia }}</div>
                            {% endif %}
                        {% endfor %}
                        {% if emptyCell %}
                            <div class="fl pad-small" style="{{ style }}">&nbsp;</div>
                        {% endif %}
                    {% endfor %}
                </div>
                <div class="tqt2_col" style="border-right:0">&nbsp;</div>
                <div class="prc2_col" style="border-right:0">&nbsp;</div>
                <div class="tam2_col" style="border-right:0">&nbsp;</div>
                <div class="dsc2_col">&nbsp;</div>
            </div>

            {% set discount = 100 * (article.octagl[0].scont1 / 100) * (article.octagl[0].scont2 / 100) * (article.octagl[0].scont3 / 100) %}

            <div class="w100 brgt bbtm blft" style="background-color:{{ bg }};line-height:18px;padding-right:0px">
                <div class="mod2_col">{{ article.cdartn }}{{ article.cdvari != '' ? ' (' ~ article.cdvari ~ ')' : '' }}{{ article.addvar is not empty ? ' [' ~ article.addvar ~ ']' : '' }}</div>
                <div class="art2_col">{{ article.cdpers }}</div>
                <div class="col2_col">{{ article.cdcolo }}</div>
                <div class="des2_col">{{ article.dsartn }}</div>
                <div class="siz2_col">
                    {% set loops = [1..10] %}
                    {% set rowQuanti = 0 %}
                    {% for i in loops[0] %}
                        {% set style = not loop.first ? 'border-left:1px solid black' : '' %}
                        {% set emptyCell = true %}
                        {% for taglia in article.octagl %}
                            {% if taglia.postgl == i %}
                                {% set emptyCell = false %}
                                {% set rowQuanti = rowQuanti + taglia.quanti %}
                                <div class="fl pad-small" style="{{ style }}">{{ taglia.quanti }}</div>
                            {% endif %}
                        {% endfor %}
                        {% if emptyCell %}
                            <div class="fl pad-small" style="{{ style }}">&nbsp;</div>
                        {% endif %}
                    {% endfor %}
                </div>
                <div class="tqt2_col center">{{ rowQuanti }}</div>
                <div class="prc2_col right">{{ (article.octagl[0].prezzo)|currency }} {{ currency }}</div>
                <div class="tam2_col right">{{ (rowQuanti * article.octagl[0].prezzo)|currency }} {{ currency }}</div>
                <div class="dsc2_col center">{{ discount > 0 ? discount : '&nbsp;' }}</div>
            </div>
            {% if article.cdvari != '' or article.dsnoco != '' %}
                <div class="w100 brgt bbtm blft pad" style="background-color:{{ bg }};line-height:18px">
                    {{ article.dsvari }}{{ article.cdvari != '' ? ' - '  : '' }}{{ article.dsnoco }}
                </div>
            {% endif %}

            {% set totqty = totqty + rowQuanti %}
            {% set totamt = totamt + (rowQuanti * article.octagl[0].prezzo * (1 - discount)) %}

        {% endfor %}

        {% set bg = bg == '#ffffff' ? '#e6e6e6' : '#ffffff' %}
        <div class="w100 brgt blft" style="background-color:{{ bg }};line-height:18px;padding-right:0px">
            <div class="mod2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="art2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="col2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="des2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="siz2_col pad bold"
                 style="background-color:{{ bg }};text-align:right">{{ mt._('pdf.total.quantity') }}</div>
            <div class="tqt2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="prc2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="tam2_col right" style="background-color:{{ bg }};border-right:0">{{ totqty }}</div>
            <div class="dsc2_col" style="background-color:{{ bg }}">&nbsp;</div>
        </div>
        <div class="w100 brgt bbtm blft" style="background-color:{{ bg }};line-height:18px;padding-right:0px">
            <div class="mod2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="art2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="col2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="des2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="siz2_col pad bold"
                 style="background-color:{{ bg }};text-align:right">{{ mt._('pdf.total.value') }}</div>
            <div class="tqt2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="prc2_col" style="background-color:{{ bg }};border-right:0">&nbsp;</div>
            <div class="tam2_col right"
                 style="background-color:{{ bg }};border-right:0">{{ totamt|currency }} {{ currency }}</div>
            <div class="dsc2_col" style="background-color:{{ bg }}">&nbsp;</div>
        </div>
    </div>
    </body>
{% endblock %}
