{% set fabricsPresence  = model.fabrics|length > 0 and currentFabric == '' %}
{% set colorsPresence   = model.fabrics|length > 0 and model.colors|length > 0 %}
{% set variantsPresence = model.fabrics|length > 0 and model.colors|length > 0 and model.variants|length > 0 %}
{% if common['isOrder'] %}
<div class="row model-info model-wizard pt-0">
  {% set step = 1 %}
  {% if fabricsPresence %}
  <div class="col-6 main-step step-header-fabric" data-step="{{ step }}" data-target="fabric">
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.f', ['i': step]) }}</span><br/>
    <span class="step-header">{{ mt._('model.wizard.step.f.descr') }}</span>
  </div>
    {% set step = step + 1 %}
  {% endif %}
  {% if colorsPresence %}
  <div class="col-6 main-step step-header-color" data-step="{{ step }}" data-target="color" {{ fabricsPresence ? 'style="display:none"' : '' }}>
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.c', ['i': step]) }}</span><br/>
    <span class="step-header">{{ mt._('model.wizard.step.c.descr') }}</span>
  </div>
    {% set step = step + 1 %}
  {% endif %}
  {% if variantsPresence %}
  <div class="col-6 main-step step-header-variant" data-step="{{ step }}" data-target="variant" {{ fabricsPresence or colorsPresence ? 'style="display:none"' : '' }}>
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.v', ['i': step]) }}</span><br/>
    <span class="step-header">{{ mt._('model.wizard.step.v.descr') }}</span>
  </div>
    {% set step = step + 1 %}
  {% endif %}
  <div class="col-6 main-step step-header-size" data-step="{{ step }}" data-target="size" style="display:none">
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.s', ['i': step]) }}</span><br/>
  </div>
  <div class="col-6">
    <span class="step-header font-weight-bold">{{ mt._('model.currentconfiguration') }}</span><br/>
    <span class="step-header" id="current-configuration">{{ currentFabric != '' ? mt._('_common.tissue') ~ ': ' ~ currentFabric.cdpers : '-' }}</span>
    <input type="hidden" id="current-fabric" value="{{ currentFabric != '' ? currentFabric.cdpers : '' }}"/>
    <input type="hidden" id="current-color"/>
    <input type="hidden" id="current-variant"/>
  </div>
  <div class="col-12">
    <div class="row">
      <div class="col-6 col-lg-4" {{ currentFabric == '' ? 'style="display:none"' : '' }} id="selected-fabric-box">
        <div style="float:left;width:80px;text-align:center">
        {% if currentFabric != '' %}
          {{ elements.getModelImgOrDefault(currentFabric.flimag, currentFabric.dspers, ['id': 'selected-fabric-image', 'style': 'width:60px']) }}
        {% else %}
          <img src="" style="width:60px" alt="" id="selected-fabric-image"/>
        {% endif %}
        </div>
        <div id="selected-fabric-code">
          {{ currentFabric != '' ? currentFabric.cdpers : '' }}
        </div>
        <div id="selected-fabric-composition">
          <span data-toggle="tooltip" data-placement="top" title="{{ currentFabric != '' ? currentFabric.compos : '' }}">{{ mt._('_common.composition') }}</span>
        </div>
        <div id="selected-fabric-link" style="text-transform:none">
          <a href="{{ currentFabric != '' ? url('catalog/fabricDetail/' ~ currentFabric.cdpers) : '#' }}">{{ mt._('_common.see.models') }}</a>
        </div>
        {% if currentFabric != '' %}
        <div class="text-capitalize">
          <a href="{{ url('model/wizard/' ~ model.cdartn) }}">{{ mt._('_common.see.fabrics') }}</a>
        </div>
        {% endif %}
      </div>
      <div class="col-12 col-lg-8" id="selected-color-box">
        {% for color in model.colors %}
        {{ elements.getModelImgOrDefault(color['flimag'], color['dscolo'], ['id': 'little-' ~ color['cdcolo'], 'title': color['dscolo'], 'style': 'display:none']) }}
        {% endfor %}
      </div>
    </div>
  </div>
</div>
{% endif %}

<div class="row wizard-selector-box">
  <div class="col-12">
    {% if fabricsPresence %}
    <div class="box-container" id="fabric-selector">
      <div class="font-weight-bold title w-100">{{ mt._('model.available.fabrics') }}</div>
      <div class="row m-0">
        {% for fabric in model.fabrics %}
        <div class="fabric-box" data-cdpers="{{ fabric.cdpers }}" data-cdarti="{{ fabric.cdarti }}">
          <div class="check"><i class="fa fa-check"></i></div>
          <div>{{ elements.getModelImgOrDefault(fabric.flimag, fabric.dspers) }}</div>
          <div class="description" title="{{ fabric.cdpers }}">{{ fabric.cdpers }}</div>
          <div class="composition"><span data-toggle="tooltip" data-placement="top" title="{{ fabric.compos }}">{{ mt._('_common.composition') }}</span></div>
          <div style="line-height:16px">{{ fabric.prezzo|currency }} {{ currency }}</div>
          {% if common['showPublicPrice'] and fabric.preven != 0 %}
          <div class="fabric-public-price">RP {{ fabric.preven|currency }} {{ fabric.currency }}</div>
          {% endif %}
        </div>
        {% endfor %}
      </div>
    </div>
    {% endif %}
    {% if colorsPresence %}
    <div class="box-container" id="color-selector" {{ fabricsPresence ? 'style="display:none"' : '' }}>
      <div class="font-weight-bold title w-100">{{ mt._('model.available.colors') }}</div>
      <div class="row m-0">
        {% for color in model.colors %}
        <div class="color-box" data-cdcolo="{{ color['cdcolo'] }}" data-cdpers="{{ color['cdpers'] }}">
          <div class="check"><i class="fa fa-check"></i></div>
          <div>{{ elements.getModelImgOrDefault(color['flimag'], color['dscolo'], ['data-id': color['cdcolo'], 'title': color['dscolo']]) }}</div>
          {% set description = color['cdcolo'] != color['dscolo'] ? color['cdcolo'] ~ ' - ' ~ color['dscolo'] : color['cdcolo'] %}
          <div class="description" title="{{ description }}">{{ description }}</div>
        </div>
        {% endfor %}
      </div>
    </div>
    {% endif %}
    {% if variantsPresence %}
    <div class="box-container" id="variant-selector" {{ fabricsPresence or colorsPresence ? 'style="display:none"' : '' }}>
      {% set currentVariantType = '' %}
      {% set needDivClosure = false %}
      {% for variant in model.variants %}
        {% if currentVariantType != variant['tpvari'] %}
          {% set currentVariantType = variant['tpvari'] %}
          {{ needDivClosure ? '</div>' : '' }}
      <div class="font-weight-bold title w-100">{{ variant['dstvar'] }}</div>
      <div class="row m-0">
          {% set needDivClosure = true %}
        {% endif %}
        <div class="variant-box" data-cdvari="{{ variant['cdvari'] }}" data-tpvari="{{ variant['tpvari'] }}">
          <div class="check"><i class="fa fa-check"></i></div>
          <div>{{ elements.getVariantImgOrDefault(variant['flimag'], variant['dsvari']) }}</div>
          <div class="cdvari">{{ variant['cdvari'] }}</div>
          <div class="description" title="{{ variant['dsvari'] }}">{{ variant['dsvari'] }}</div>
          <div>+ {{ variant['prezzo']|currency }} {{ currency }}</div>
        </div>
        {% if loop.last %}
      </div>
        {% endif %}
      {% endfor %}
    </div>
    {% endif %}
    <div class="box-container" id="size-selector" style="display:none">
      <div class="font-weight-bold title w-100">{{ mt._('model.size.selector') }}</div>
      <div class="caption w-100">{{ mt._('model.size.caption') }}</div>
      <div class="row m-0" id="size-content">

      </div>
    </div>
  </div>
</div>
