
{% if common['isOrder'] %}
<div class="row model-info model-wizard pt-0">
  <div class="col-5 main-step step-header-color" data-step="1" data-target="color">
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.v', ['i': 1]) }}</span><br/>
    <span class="step-header">{{ mt._('model.wizard.step.v.descr2') }}</span>
  </div>
  <div class="col-5 main-step step-header-feature" data-step="2" data-target="feature" style="display:none">
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.ft', ['i': 2]) }}</span><br/>
    <span class="step-header">{{ mt._('model.wizard.step.ft.descr') }}</span>
  </div>
  <div class="col-5 main-step step-header-size" data-step="3" data-target="size" style="display:none">
    <span class="step-header font-weight-bold">{{ mt._('model.wizard.step.s', ['i': 3]) }}</span><br/>
  </div>
  <div class="col-{{ hasComponents > 0 ? '5' : '7' }}">
    <span class="step-header font-weight-bold">{{ mt._('model.currentconfiguration') }}</span><br/>
    <span class="step-header" id="current-configuration"></span>
    <input type="hidden" id="current-color"/>
  </div>
  {% if hasComponents > 0 %}
  <div class="col-2">
    <a href="#" id="create-anaart" class="font-weight-bold text-capitalize">{{ mt._('model.wizard.customize') }}</a>
  </div>
  {% endif %}
  <div class="col-12">
    <div class="row">
      <div class="col-12" id="selected-color-box">
        <!-- Standard items thumbnails -->
      {% for color in model.colors %}
        <div id="little-{{ color.cdarti }}" class="little-color-box disabled" {{ color.presence < 0 ? 'style="display:none"' : '' }}
          data-id="{{ color.cdarti }}" data-cdcolo="{{ color.cdcolo }}" data-cdarti="{{ color.cdarti }}">
          {{ elements.getModelImgOrDefault(color.flimag, color.dscolo, ['title': color.cdarti, 'style': 'margin:0' ]) }}
        </div>
      {% endfor %}
      {% if model.customColors|length > 0 %}
        {% for color in model.customColors %}
        <div id="little-{{ model.cdartn }}-C{{ color.seqrap }}" class="little-color-box disabled" {{ color.presence < 0 ? 'style="display:none"' : '' }}
          data-id="{{ model.cdartn }}-C{{ color.seqrap }}" data-cdcolo="{{ model.cdartn }}-C{{ color.seqrap }}" data-cdarti="{{ model.cdartn }}-C{{ color.seqrap }}">
          {{ elements.getModelImgOrDefault(model.flimag, model.cdartn ~ '-C' ~ color.seqrap, ['title': model.cdartn ~ '-C' ~ color.seqrap, 'style': 'margin:0' ]) }}
        </div>
        {% endfor %}
      {% endif %}
      </div>
    </div>
  </div>
</div>
{% endif %}

<div class="row wizard-selector-box">
  <div class="col-12">
    <div class="box-container" id="color-selector" style="font-size:13px">
      <div class="font-weight-bold title w-100" id="variants-title">{{ mt._('model.available.variants') }}</div>
      <div class="font-weight-bold title w-100" id="personalization-title" style="display:none">{{ mt._('_common.variants.personalization') }}</div>
      <div class="title w-100 mb-20x" id="personalization-detail" style="display:none">-</div>
      <div class="row m-0" id="all-variants-container">
        <!-- Standard items -->
      {% for color in model.colors %}
      {% set title = color['cdarti'] %}
        {% if color.components|length > 0 %}
          {% set title = '' %}
          {% for component in color.components %}
            {% set title = title ~ '<b>' ~ component.dscomp ~ ':</b> ' ~ component.cdmate|escape ~ ' - ' ~ component.dsmate|escape ~ (not loop.last ? '<br/>' : '') %}
          {% endfor %}
        {% endif %}
        <div class="color-box {{ color.presence < 0 ? '' : 'selected ask-delete' }}"
          data-id="{{ color.cdarti }}" data-cdcolo="{{ color.cdcolo }}" data-cdarti="{{ color.cdarti }}">
          <div class="check"><i class="fa fa-check"></i></div>
          <div>{{ elements.getModelImgOrDefault(color.flimag, color.dscolo, ['data-toggle': 'tooltip', 'data-placement': 'top', 'title': title]) }}</div>
          <div class="description" style="line-height:20px" title="{{ color.cdarti }}">
            {{ color.cdarti }}{{ common['isOrder'] ? '<br/>' ~ color.prezzo|currency ~ ' ' ~ currency : '' }}
          </div>
        </div>
      {% endfor %}
      {% if model.customColors|length > 0 %}
        {% for color in model.customColors %}
          {% set title = model.cdartn ~ '-C' ~ color.seqrap %}
          {% if color.components|length > 0 %}
            {% set title = '' %}
            {% for component in color.components %}
              {% set title = title ~ '<b>' ~ component.dscomp ~ ':</b> ' ~ component.cdmate|escape ~ ' - ' ~ component.dsmate|escape ~ (not loop.last ? '<br/>' : '') %}
            {% endfor %}
          {% endif %}
          <div class="color-box {{ color.presence < 0 ? '' : 'selected ask-delete' }}"
            data-id="{{ model.cdartn }}-C{{ color.seqrap }}" data-cdcolo="{{ model.cdartn }}-C{{ color.seqrap }}" data-cdarti="{{ model.cdartn }}-C{{ color.seqrap }}">
            <div class="check"><i class="fa fa-check"></i></div>
            <div>{{ elements.getModelImgOrDefault(model.flimag, model.cdartn ~ ' - ' ~ color.seqrap, ['data-toggle': 'tooltip', 'data-placement': 'top', 'title': title]) }}</div>
            <div class="description" style="line-height:20px" title="{{ model.cdartn }}-C{{ color.seqrap }}">{{ model.cdartn }}-C{{ color.seqrap }}<br/>{{ color.prezzo|currency }} {{ currency }}</div>
          </div>
        {% endfor %}
      {% endif %}
      </div>

      {% if hasComponents %}
      <div id="feature-custom" class="color-features" style="display:none">
        <div class="preloader" style="position:relative">{{ image("assets/img/preloader.gif", "alt": "Preloader") }}</div>
        <div id="custom-form">

        </div>
        <div class="row wizard-tools" style="border:0">
          <div class="col-6 tool-button text-right pr-15x">
            <span id="cancel-custom">{{ mt._('_common.cancel') }}</span>
          </div>
          <div class="col-2 tool-button pl-15x">
            <span id="save-custom">{{ mt._('_common.save') }}</span>
          </div>
          <div class='col-4 msg-error custom-feature-result text-center' style="line-height:15px">{{ mt._('model.wizard.warning.duplicate') }}</div>
        </div>
      </div>
      {% endif %}

    </div>
    <div class="box-container component-selector" id="feature-selector" style="display:none">
      {% for color in model.colors %}
      <div id="feature-{{ color['cdarti'] }}" class="color-features" style="display:none">
        <div class="row m-0">
          <div class="col-12 text-center font-weight-bold">{{ color['cdarti'] }}</div>
        </div>
        {% for component in color.components %}
        <div class="row m-0">
          <div class="col-4 text-right">{{ component.dscomp }}</div>
          <div class="col-8">
            <div class="float-left pr-15x">
              {{ elements.getModelImgOrDefault(component.flimag, component.cdmate, ['class': 'configurator-preview lazy', 'data-toggle': 'tooltip', 'data-placement': 'top', 'title': component.cdmate], true) }}
            </div>
            <div class="float-left font-weight-bold">{{ component.cdmate }} - {{ component.dsmate }}</div>
          </div>
        </div>
        {% endfor %}
      </div>
      {% endfor %}
      {% if model.customColors|length > 0 %}
        {% for color in model.customColors %}
      <div id="feature-{{ model.cdartn }}-C{{ color.seqrap }}" class="color-features" style="display:none">
        <div class="row m-0">
          <div class="col-12 text-center font-weight-bold">{{ model.cdartn }}-C{{ color.seqrap }}</div>
        </div>
          {% for component in color.components %}
        <div class="row m-0">
          <div class="col-4 text-right">{{ component.dscomp }}</div>
          <div class="col-8">
            <div class="float-left pr-15x">
              {{ elements.getModelImgOrDefault(component.flimag, component.dsmate, ['class': 'configurator-preview lazy', 'data-toggle': 'tooltip', 'data-placement': 'top', 'title': component.dsmate], true) }}
            </div>
            <div class="float-left font-weight-bold">{{ component.cdmate }} - {{ component.dsmate }}</div>
          </div>
        </div>
          {% endfor %}
      </div>
        {% endfor %}
      {% endif %}
    </div>
    <div class="box-container" id="size-selector" style="display:none">
      <div class="font-weight-bold title w-100">{{ mt._('model.size.selector') }}</div>
      <div class="caption w-100">{{ mt._('model.size.caption3') }}</div>
      <div class="row m-0" id="size-content" style="overflow-x:auto">

      </div>
    </div>
  </div>
</div>
