{% set exist_video = false %}
{% if modinf != null and modinf.filvid != '' %}
  {% set vidurl = 'upload/products/' ~ modinf.filvid %}
  <?php $exist_video = file_exists($vidurl); ?>
{% endif %}

{% if not exist_video and model.flvide != '' %}
  {% set vidurl = "video/" ~ model.flvide %}
  <?php $exist_video = file_exists($vidurl); ?>
{% endif %}

<div class="row mx-0 my-10x">
  <!-- Left column: images and info -->
  <div class="col-12 col-lg-6">
    <div class="row model-wizard-images pt-0" id="model-images">
      <div class="col-12 col-lg-2 preview-thumbnail-wizard-container">
        <div class="row">
          <div class="col-4 col-lg-12 text-center">
            {{ elements.getModelImgOrDefault(model.flimag, mt._('_common.see'), ["data-index": 0, "class": "preview-thumbnail preview-selected"]) }}
          </div>
        {% if model.imgart|length > 0 %}
          {% set i = 1 %}
          {% for imgart in model.imgart %}
          <div class="col-4 col-lg-12 text-center">
            {{ elements.getModelImgOrDefault(imgart.flimag, mt._('_common.see'), ["data-index": i, "class": "preview-thumbnail"]) }}
          </div>
            {% set i = i + 1 %}
          {% endfor %}
        {% endif %}
        </div>
      </div>
      <div class="col-12 col-lg-10 text-center" id="model-main-image" unselectable="on">
        {% if model.imgart|length > 0 %}
        <div class="fa fa-chevron-left"></div>
        {% endif %}
        {{ elements.getModelImgOrDefault(model.flimag, model.dsartn, ["style": "width:90%;max-width:550px;max-height:550px;cursor:zoom-in;", "data-enlargable": ""]) }}
        {% if model.imgart|length > 0 %}
        <div class="fa fa-chevron-right"></div>
        {% endif %}
      </div>
    </div>

    {# Article preview: only for ModelDetailStyle = 3 or = 4 or = 5 #}
    {% if common['modelDetailStyle'] in [3, 4, 5] %}
    <div id="images-preloader" class="preloader" style="display:none">{{ image("assets/img/preloader.gif", "alt": "Preloader") }}</div>
    <div class="row model-wizard-images pt-0" id="article-images" style="display:none"></div>
    {% endif %}
    {# Color preview: only for ModelDetailStyle = 4 #}
    {% if common['modelDetailStyle'] == 4 %}
    <div class="row model-wizard-images pt-0" id="color-images" style="display:none"></div>
    {% endif %}

    {% if exist_video %}
    <div class="row">
      <div id="video-box" class="col-12 offset-lg-2 col-lg-10 text-center" style="display:none;padding-top:24px">
      {# style="display:none" #}
      {# width="200" height="200" #}
        <video id="video-model" class="video-js" preload="auto" playsinline poster="{{ elements.getModelImageUrl(model.flimag) }}" data-setup="{}">
          <source src="{{ url(vidurl) }}" type='video/mp4'>
          <p class="vjs-no-js">
            To view this video please enable JavaScript, and consider upgrading to a web browser that
            <a href="https://videojs.com/html5-video-support/" target="_blank">supports HTML5 video</a>
          </p>
        </video>
      </div>
    </div>
    <div class="row">
      <div class="col-12 offset-lg-2 col-lg-10 text-center">
        <a href="#" id="play-video" class="btn btn-generic w-50">{{ mt._('model.watchvideo') }}</a>
        <a href="#" id="show-photos" class="btn btn-generic w-50" style="display:none">{{ mt._('model.showphotos') }}</a>
      </div>
    </div>
    {% endif %}
  </div>

  <!-- Right column: wizard -->
  <div class="col-12 col-lg-6">
  {% if common['modelDetailStyle'] == 2 %}
    {% include "model/wizard/fabric_wizard_panel.volt" %}
  {% elseif common['modelDetailStyle'] == 3 %}
    {% include "model/wizard/article_wizard_panel.volt" %}
  {% elseif common['modelDetailStyle'] == 4 %}
    {% include "model/wizard/fabric_preview_wizard_panel.volt" %}
  {% elseif common['modelDetailStyle'] == 5 %}
    {% include "model/wizard/configurator_wizard_panel.volt" %}
  {% endif %}
  </div>
</div>

<div class="row mx-0 my-10x">
{% if common['modelDetailStyle'] == 2 %}
  {% include "model/wizard/fabric_wizard_description.volt" %}
{% elseif common['modelDetailStyle'] == 3 %}
  {% include "model/wizard/article_wizard_description.volt" %}
{% elseif common['modelDetailStyle'] == 4 %}
  {% include "model/wizard/fabric_preview_wizard_description.volt" %}
{% elseif common['modelDetailStyle'] == 5 %}
  {% include "model/wizard/configurator_wizard_description.volt" %}
{% endif %}

{% if common['isOrder'] %}
  {% if common['modelDetailStyle'] == 2 %}
    {% include "model/wizard/fabric_wizard_footer.volt" %}
  {% elseif common['modelDetailStyle'] == 3 %}
    {% include "model/wizard/article_wizard_footer.volt" %}
  {% elseif common['modelDetailStyle'] == 4 %}
    {% include "model/wizard/fabric_preview_wizard_footer.volt" %}
  {% elseif common['modelDetailStyle'] == 5 %}
    {% include "model/wizard/configurator_wizard_footer.volt" %}
  {% endif %}
{% endif %}
</div>

{% if common['modelDetailStyle'] == 4 %}
<div class="row mx-0">
  <div class="d-none d-lg-block col-lg-6" style="border-top: 5px solid #eee;">&nbsp;</div>
  {% if common['isOrder'] %}
  <div class="d-none d-lg-block col-lg-6"><div class="col-12" style="border-top: 5px solid #eee;">&nbsp;</div></div>
  {% endif %}
</div>
{% endif %}

{# Footer models (related, recents and linked buy) will be loaded on document.ready #}
<div class="row mx-0" id="loading-footer-models">
  <div class="preloader my-20x" style="position:relative">{{ image("assets/img/preloader.gif", "alt": "Preloader") }}</div>
</div>
