{% set exist_video = false %}
{% if modinf != null and modinf.filvid != '' %}
  {% set vidurl = 'upload/products/' ~ modinf.filvid %}
  <?php $exist_video = file_exists($vidurl); ?>
{% endif %}

{% if not exist_video and model.flvide != '' %}
  {% set vidurl = "video/" ~ model.flvide %}
  <?php $exist_video = file_exists($vidurl); ?>
{% endif %}

{# SET IF IT IS AVAILABILITY ORDER #}
{% set is_availability_order = common['isOrder'] and common['order_info'].tpordc == 0 %}

{% set code = common['catalogProductType'] == 0 ? model.cdartn : model.cdarti %}

{% set description = common['catalogProductType'] != 0 and model.dsarti is defined ? model.dsarti : model.dsartn %}

{% if (config.release.user == 'psq') %}
  {# MARCO MOD. 07.03.23 #}
  {% set description = model.anaart is defined and model.anaart|length > 0 ? model.anaart[0]['dsarti'] : description %}
{% endif %}

{% if common['productNameType'] is defined and common['productNameType'] == 1 %}
  {#{% set description = description ~ ' ' ~ model.cdtagl %}#}
  {% set sizes = tipolo.getAvailableSizes() %}
  {% if sizes is defined and sizes|length > 0 %}
     {% set description = description ~ ' [' ~ sizes[tipolo.tglini] ~ '-' ~ sizes[tipolo.tglfin] ~ ']' %}
{#     {% set description = description ~ ' <small class="label-scales">' ~ i18n._('_common.sizes.qty') ~ ': ' ~ sizes[tipolo.tglini] ~ '-' ~ sizes[tipolo.tglfin] ~ '</small>' %}#}
  {% endif %}
{% endif %}


<div class="row mx-0 mb-30x" style="border-bottom:10px solid #eee">
  <div class="col-12 col-lg-6 offset-lg-1" id="images-section">
    <!-- Pager + Product Gallery -->
    <section class="fw-section">

      <div class="padding-top">
        <!-- Product Gallery -->
        <div class="product-gallery">

      {# MAIN IMAGES SCROLLER #}
      {{ elements.getMainImagesScroller(model.imgart|length > 0, model, description) }}
      {#{% if common['defaultImage'] == 0 or common['catalogProductType'] == 1 %}
        {{ elements.getMainImagesScroller(model.imgart|length > 0, model, description) }}
      {% endif %}#}

      {# VARIANT IMAGES SCROLLER #}
      {% if common['catalogProductType'] == 0 and model.anaart is defined and model.anaart|length > 0 %}
        {% if common['defaultImage'] == 0 and common['modelDetailStyle'] != 0 %}
        {#
        {% if common['defaultImage'] == 0 and common['modelDetailStyle'] != 0 and (not common['isOrder'] or common['order_info'].tpordc == 1) %}
        20/09/2021
        #}
          {% for article in model.anaart %}
            {{ elements.getArticleImagesScroller(article) }}
          {% endfor %}
        {% elseif common['defaultImage'] == 1 %}
          {{ elements.getArticleImagePreview() }}
        {% elseif common['defaultImage'] == 2 %}
          {% for article in model.anaart %}
            {{ elements.getModelAndArticleImagesScroller(article, model) }}
          {% endfor %}
        {% endif %}
      {% elseif (model.colors is defined) %}
        {% for color in model.colors if (color['flimag'] != '' or color['imgart']|length > 0) %}
          {{ elements.getColorImagesScroller(color) }}
        {% endfor %}
      {% endif %}

      {# PRICE OVER IMAGE #}
      {% if common['showPriceOverImage'] %}
          <div class='over-info-model-box'>
            <div>{{ is_numeric(substr(model.cdartn, 0, 4)) ? substr(model.cdartn, 4) : model.cdartn }}</div>
          {% if common['catalogProductType'] == 0 and model.anaart|length > 0 %}
            {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : 0 %}
            {% set cust_disc = model.anaart[0].cust_disc > 0 ? model.anaart[0].cust_disc : cust_disc %}
            {{ elements.getPriceDiv(model.anaart[0].prezzo, cust_disc, common['currency'], common['cdvalu']) }}
          {% else %}
            {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : 0 %}
            {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : cust_disc %}
            {{ elements.getPriceDiv(model.prezzo, cust_disc, common['currency'], common['cdvalu']) }}
          {% endif %}
          </div>
      {% endif %}

        </div>
      </div>
    </section>

    {% if exist_video %}
    <div id="video-box" class="text-center" style="display:none;padding-top:24px;height:100%">
    {# style="display:none" #}
    {# width="200" height="200" #}
      <video id="video-model" class="video-js" preload="auto" poster="{{ elements.getModelImageUrl(model.flimag) }}" data-setup="{}">
        <source src="{{ url(vidurl) }}" type='video/mp4'>
        <p class="vjs-no-js">
          To view this video please enable JavaScript, and consider upgrading to a web browser that
          <a href="https://videojs.com/html5-video-support/" target="_blank">supports HTML5 video</a>
        </p>
      </video>
    </div>
    {% endif %}
  </div>

  {% if (common['modelDetailStyle'] not in [1, 6, 7, 8, 9]) %}

  <div class="col-12 col-lg-4" id="descr-section">
    <div class="model-description-box">
      <span class="model-description">{{ description }}</span><br/>
      <span class="model-code {{ common['modelDetailHighlight'] is not empty ? elements.getHighlightClass() : '' }}">{{ code }}</span><br/>
      <span class="model-code" style="text-transform:uppercase">{{ model.anaart|length ~ ' ' ~ (model.anaart|length > 1 ? mt._('model.availablevariants') : mt._('model.availablevariant')) }}</span>
    </div>

    <div class="row model-info">
      <div class="col-6">{{ mt._('_common.brand') }}: {{ model.dstitl }}</div>
      <div class="col-6">{{ mt._('_common.genre') }}: {{ model.dsgene }}</div>
      <div class="col-6">{{ mt._('_common.line') }}: {{ model.dslinm }}</div>
      <div class="col-6">{{ mt._('_common.modeltype') }}: {{ model.dstmod }}</div>
      {% if model.dsserm != '' %}
      <div class="col-6">{{ mt._('_common.series') }}: {{ model.dsserm }}</div>
      {% endif %}
      {% if (modinf != null and modinf.compos != '') or model.descmp != '' %}
      <div class="col-6">{{ mt._('_common.composition') }}: {{ modinf != null and modinf.compos != '' ? modinf.compos : model.descmp }}</div>
      {% endif %}
      {% if (modinf != null and modinf.madein != '') or model.desmad != '' %}
      <div class="col-6">{{ mt._('_common.madein') }} {{ modinf != null and modinf.madein != '' ? modinf.madein : model.desmad }}</div>
      {% endif %}
    </div>

    {% if common['isOrder'] %}
    <div class="quantity-model-box">
      <a href="#quantity" class="btn btn-main w-100 mb-0">{{ mt._('_common.buy') }}</a>
    </div>
    {% else %}
    <div class="quantity-model-box">
      <span data-toggle='modal' data-target='.modal-new-order' class="btn btn-main w-100 mb-0">{{ mt._('user.menu.neworder') }}</span>
    </div>
    {% endif %}

    <div class="model-buttons-box container p-0">
      <div class="row">
        <div class="col pr-5x">
          {{ link_to(url('catalog/list'), mt._('_common.list'), 'class': 'btn btn-generic w-100') }}
        </div>
        <div class="col pl-5x">
          {{ link_to(url('catalog/collection'), mt._('_common.catalog'), 'class': 'btn btn-generic w-100 float-right') }}
        </div>
      </div>
    </div>

    <!-- Nav Tabs -->
    <div class="model-tabs">
      <ul class="nav nav-tabs nav-justified w-100 ml-0 d-sm-block" role="tablist">
        <li class="nav-item"><a class="active" href="#tab_com" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.description') }}</a></li>
        <li class="nav-item"><a href="#tab_tec" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.details') }}</a></li>
        {% if showDownloadSection %}<li class="nav-item"><a href="#tab_dwn" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.downloadtechnicalfile') }}</a></li>{% endif %}
      </ul><!-- .nav-tabs -->

      <div class="tab-content account-info">
        <div id="tab_com" role="tabpanel" class="tab-pane fade show active">
          {% if model.descom == "" and (modinf == null or modinf.vestib == '') %}
            {{ mt._('_common.descr.no') }}
          {% else %}
            {% if model.descom != "" %}{{ nl2br(common['printHtmlTags'] ? model.descom : htmlspecialchars(model.descom)) }}<br/>{% endif %}
            {% if modinf != null and modinf.vestib != '' %}{{ mt._('_common.fit') ~ ': ' ~ modinf.vestib }}{% endif %}
          {% endif %}
        </div>

        <div id="tab_tec" role="tabpanel" class="tab-pane fade">
          {% if model.destec == "" and
              (modinf == null or
              (session.get('language') == 'it' and modinf.dettit == "") or
              (session.get('language') == 'en' and modinf.detten == "") or
              (session.get('language') == 'es' and modinf.dettes == "") or
              (session.get('language') == 'de' and modinf.dettde == "") or
              (session.get('language') == 'fr' and modinf.dettfr == "")) %}
            {{ mt._('_common.notes.no') }}
          {% else %}
            {{ model.destec != "" ? nl2br(common['printHtmlTags'] ? model.destec : htmlspecialchars(model.destec)) ~ '<br/>' : '' }}
            {{ modinf != null and session.get('language') == 'it' ? modinf.dettit : '' }}
            {{ modinf != null and session.get('language') == 'en' ? modinf.detten : '' }}
            {{ modinf != null and session.get('language') == 'es' ? modinf.dettes : '' }}
            {{ modinf != null and session.get('language') == 'de' ? modinf.dettde : '' }}
            {{ modinf != null and session.get('language') == 'fr' ? modinf.dettfr : '' }}
          {% endif %}
        </div>

        <div id="tab_dwn" role="tabpanel" class="tab-pane fade">
          {% set pdfurl = "/upload/products/" ~ code ~ ".pdf" %}
          {% set exist = diskManager.fileExistsInPublic(pdfurl)%}
          {% if not exist %}
            {% set pdfurl = "techfiles/" ~ code ~ ".pdf" %}
            {% set exist = diskManager.fileExistsInPublic(pdfurl)%}
          {% endif %}
          {% if exist %}
          <a href="{{ pdfurl }}" class="btn btn-generic mr-0 mt-0" style="width:250px">{{ mt._('_common.downloadtechnicalfile.btn') }}</a>
          {% else %}
          {{ mt._('_common.downloadtechnicalfile.no') }}
          {% endif %}
        </div>
      </div><!-- .tab-content -->

      {% if exist_video %}
      <div class="model-video-btn-box">
        <a href="#" id="play-video" class="btn btn-generic w-100">{{ mt._('model.watchvideo') }}</a>
        <a href="#" id="show-photos" class="btn btn-generic w-100" style="display:none">{{ mt._('model.showphotos') }}</a>
      </div>
      {% endif %}

    </div>
  </div>

  {% else %}

  <div class="col-12 col-lg-4" id="descr-section">
    <div class="model-description-box">
      <span class="model-description">{{ description }}</span><br/>
      <span class="model-code {{ common['modelDetailHighlight'] is not empty ? elements.getHighlightClass() : '' }}">{{ code }}</span><br/>
      {% if common['modelDetailStyle'] != 0 and model.compos is defined and model.compos|length > 0 %}
      <span style="font-size:12px;font-style:italic">
        {{ model.compos }}
      </span><br/>
      {% endif %}
      {% if model.tags is defined and model.tags|length > 0 %}
      <span style="font-size:10px;font-style:italic">
        {% for modelTag in model.tags %}
          {{ modelTag.valore }}&nbsp;&nbsp;
        {% endfor %}
      </span><br/>
      {% endif %}
      <br/>
      <div id="model-price" class="float-left w-50" style="display:none">
      {% if common['catalogProductType'] == 0 and model.anaart|length > 0 %}
        {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : 0 %}
        {% set cust_disc = model.anaart[0].cust_disc > 0 ? model.anaart[0].cust_disc : cust_disc %}
        {{ elements.getModelPriceSpan(model.anaart[0].prezzo, cust_disc, common['currency'], common['cdvalu']) }}
      {% else %}
        {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : 0 %}
        {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : cust_disc %}
        {{ elements.getModelPriceSpan(model.prezzo, cust_disc, common['currency'], common['cdvalu']) }}
      {% endif %}
      </div>

      {% if (common['catalogProductType'] == 1 or common['catalogProductType'] == 2) and model.tppers == 'PT' and sameFabricArticles|length > 0 %}
      <div class="row collapse-row mt-20x float-left" style="clear:both">
        <div class="col-12">
          <a class="label-for-collapse label-no-underline" data-toggle="collapse"
            href="#fabric-articles-collapse" role="button" aria-expanded="false" aria-controls="fabric-articles-collapse" style="color:#999">
            {{ mt._('_common.articles.samefabric') }}
          </a>
        </div>
        <div class="col-12 mt-10x collapse show" id="fabric-articles-collapse">
          <div class="row">
            {% for anaart in sameFabricArticles %}
            <div class="col-2 mb-5x">
              <a href="{{ url('model/' ~ anaart.cdarti) }}">
                <div class="w-100">{{ elements.getModelImgOrDefaultFromImgurl(anaart.flimag, anaart.dsarti, ['title': anaart.dsarti, 'style': 'width:100%']) }}</div>
                <div class="w-100" style="font-size:10px">{{ anaart.cdarti }}</div>
              </a>
            </div>
            {% endfor %}
          </div>
        </div>
      </div>
      {% endif %}

      {% if exist_video %}
      <div id="model-video-container" class="float-left w-50 text-right">
        <a href="#" id="play-video" style="background-color:transparent;color:#606060">{{ mt._('model.watchvideo') }}</a>
        <a href="#" id="show-photos" style="background-color:transparent;color:#606060;display:none">{{ mt._('model.showphotos') }}</a>
      </div>
      {% endif %}
    </div>

    <div class="compact-model-detail-divider"></div>

    <div class="row" {{ common['modelDetailStyle'] == 8 ? 'style="display:none"' : "" }}>
      <div class="col-12" style="color:#aaa">{{ mt._('_common.colors.available') }}</div>
    {% if (common['catalogProductType'] == 0 and model.anaart|length > 0) or
          (common['catalogProductType'] == 1 and model.colors|length > 0) or
          (common['catalogProductType'] == 2 and model.colors|length > 0) %}
      <div class="col-12">
        <div class="row pt-20x px-15x">
      {% set products = common['catalogProductType'] == 0 ? model.anaart : model.colors %}
      {% set selectedArticleCode = request.hasQuery('v') ? request.hasQuery('v') : null %}
      {% set selectedColorCode = request.hasQuery('COL') ? request.hasQuery('COL') : null %}
      {% for product in products %}
        {% if selectedArticleCode == null and selectedColorCode == null %}
          {% set selectedArticleCode = (product.cdarti is defined ? product.cdarti : (product['cdarti'] is defined ? product['cdarti'] : null)) %}
          {% set selectedColorCode = (product.cdcolo is defined ? product.cdcolo : (product['cdcolo'] is defined ? product['cdcolo'] : null)) %}
        {% elseif selectedColorCode == null %}
          {% if selectedArticleCode != null %}
            {% if product.cdarti == selectedArticleCode %}
              {% set selectedColorCode = product.cdcolo is defined ? product.cdcolo : product['cdcolo'] %}
            {% endif %}
          {% else %}
            {% set selectedColorCode = product.cdcolo is defined ? product.cdcolo : product['cdcolo'] %}
          {% endif %}
        {% endif %}
        {% if not common['isOrder'] or common['order_info'].tpordc == 1 or
          (common['catalogProductType'] == 0 and product.is_available == 'true') or
          (common['catalogProductType'] == 1 and product['is_available'] > 0) or
          (common['catalogProductType'] == 2 and product['is_available'] > 0) %}
          <div class="px-2 pb-20x model-color-picker-container">
            {# Prices #}
            {% set catalogPriceText = '' %}
            {% set real_price = '' %}
            {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : 0 %}
            {% if common['catalogProductType'] == 0 and model.anaart|length > 0 %}
              {% set cust_disc = product.cust_disc is defined and product.cust_disc > 0 ? product.cust_disc : cust_disc %}
              {{ elements.getPrices(product.prezzo, cust_disc, common['currency'], common['cdvalu'], catalogPriceText, real_price) }}
            {% else %}
              {% set cust_disc = product.cust_disc is defined and product.cust_disc > 0 ? product.cust_disc : cust_disc %}
              {{ elements.getPrices(model.prezzo, cust_disc, common['currency'], common['cdvalu'], catalogPriceText, real_price) }}
            {% endif %}

            {% if common['catalogProductType'] == 0 %}
              {% set title = product.col_codice %}
              {% set dataId = product.col_codice %}
              {% set dataCdarti = product.cdarti %}
              {% set dataDsarti = product.dsarti %}
              {% set dataCdcolo = product.cdcolo %}
              {% set dataDscolo = product.dscolo %}
              {% set dataDtdrop = product.dtdrop %}
              {% set dataRawFlimag = product.flimag %}
            {% else %}
              {% set title = product['col_codice'] %}
              {% set dataId = product['col_codice'] %}
              {% set dataCdarti = model.cdarti %}
              {% set dataDsarti = model.dsarti %}
              {% set dataCdcolo = product['cdcolo'] %}
              {% set dataDscolo = product['dscolo'] %}
              {% set dataDtdrop = product['dtdrop'] is defined ? product['dtdrop'] : '' %}
              {% set colorImage = product['imgart']|length > 0 ? product['imgart'][0].flimag : product['flimag'] %}
              {% set dataRawFlimag = colorImage %}
            {% endif %}

            <div class="model-color-picker {{ common['modelDetailStyle'] == 7 ? 'rect' : '' }} {{ common['modelDetailPickerSize'] is not empty ? 'size-' ~ common['modelDetailPickerSize'] : '' }}"
              style="{{ common['catalogProductType'] == 0
                ? elements.getCustomColorBackgroundFromObject(product, common['modelDetailStyle'] == 7)
                : elements.getCustomColorBackgroundFromArray(product) }}"
              data-toggle="tooltip" title="{{ title }}" data-id="{{ dataId }}" data-cdarti="{{ dataCdarti }}"
              data-dsarti="{{ dataDsarti }}" data-cdcolo="{{ dataCdcolo }}" data-dscolo="{{ dataDscolo }}"
              data-dtdrop="{{ dataDtdrop }}" data-realprice="{{ real_price }}" data-discprice="{{ catalogPriceText }}"
              data-raw-flimag="{{ dataRawFlimag }}" data-flimag="{{ elements.getModelImageUrl(common['catalogProductType'] == 0 ? product.flimag : colorImage) }}">&nbsp;</div>
          </div>
        {% endif %}
      {% endfor %}
        </div>
      </div>
    {% endif %}
      <div class="col-12 font-weight-bold color-selected"></div>
    </div>

    {% if (common['modelDetailStyle'] == 1 or common['modelDetailStyle'] == 8 or common['modelDetailStyle'] == 9)  and common['isOrder'] and common['catalogProductType'] == 0 %}
    <div class="row pt-20x" id="model-sizes" style="display:none">
      <div class="col-6" style="color:#aaa">{{ mt._('_common.sizes.qty') }}</div>
      <div class="col-6 text-right"><a href="#" data-toggle='modal' data-target='.modal-fast-buy' id="fastbuy-btn">{{ mt._('model.fastbuy') }}</a></div>
      <div class="col-12" id="model-sizes-content">

      </div>
    </div>
    {% endif %}

    <div class="compact-model-detail-divider" {{ common['modelDetailStyle'] == 8 ? 'style="display:none"' : '' }}></div>

    {% if common['catalogProductType'] == 0 and (common['modelDetailStyle'] == 1 or common['modelDetailStyle'] == 8 or common['modelDetailStyle'] == 9) %}
    <div class="row" id="model-insert-quantity" style="display:none; width: 100%">
      {% if common['order_info'].tpordc == 0 %}
      <div class="col-12" id="availability-text"></div>
      {% endif %}
      <div class="col-12 col-md-6 insert-quantity-row compact-row pt-5x" id="insert-quantity-box" style="background-color:white;display:none">
        <div class='btn-number minus-qty' data-type='minus'><i class='fa fa-minus' aria-hidden='true'></i></div>
        <div class='float-left w-40 box-qty' style="height:48px"><input type='text' style="height:100%" class='input-number' data-old_value='' value='' min='0'></div>
        <div class='btn-number plus-qty' data-type='plus'><i class='fa fa-plus' aria-hidden='true'></i></div>
        {% if common['enableMinMulLabel'] %}
        <div class='regqta-info'>
          {{ mt._('_common.qty.min.short') }}: <span id="regqta-qtamin-value"></span>, {{ mt._('_common.qty.mul.short') }}: <span id="regqta-qtamul-value"></span><span id="regqta-max-container">, {{ mt._('_common.qty.max.short') }}: <span id="regqta-qtamax-value"></span></span>
        </div>
        {% endif %}
      </div>
      <div class="col-12 col-md-6 insert-quantity-row compact-row footer-insert-block mt-0" style="background-color:white;border:0;display:none">
        <a href="#" class='btn btn-main add-to-cart w-100 m-0' id='add-to-cart-size'>{{ mt._('_common.addtocart') }}</a>
      </div>
      <div class='col-12'>
        <div class='success-box' style='padding:10px 0;display:none'>
          {% set param = "<a href='" ~ url('cart/index') ~ "' style='color:#606060'>" ~ mt._('_common.cart') ~ "</a>" %}
          <div id="go-to-cart">{{ mt._('quantity.insert.success', ["cart": param]) }}</div>
          <div id="dont-go-to-cart">{{ mt._('quantity.insert.success.nocart') }}</div>
        </div>
        <div class='unsuccess-box' style='padding:10px 0;display:none'>
          <div>{{ mt._('quantity.insert.unsuccess') }}</div>
        </div>
      </div>
    </div>
    {% else %}
      {% if model.dtdrop is defined and model.dtdrop != '' %}
    <div class="row"><div class="col-12" style="color:#aaa">{{ mt._('_common.delivery') }}: {{ model.dtdrop }}</div></div>
      {% endif %}
    <div class="row" id="model-insert-quantity" style="display:none; width: 100%"></div>
    {% endif %}

    <div class="model-tabs">
      <ul class="nav nav-tabs nav-justified w-100 ml-0" role="tablist">
        <li class="nav-item"><a class="active" href="#tab_des" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.description') }}</a></li>
        <li class="nav-item"><a href="#tab_tec" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.details') }}</a></li>
        <li class="nav-item"><a href="#tab_com" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.notes') }}</a></li>
        {% if showDownloadSection %}<li class="nav-item"><a href="#tab_dwn" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.downloadtechnicalfile') }}</a></li>{% endif %}
      </ul><!-- .nav-tabs -->

      <div class="tab-content account-info">
        <div id="tab_des" role="tabpanel" class="tab-pane fade show active">
          {% if model.descom == "" and (model.descomhtml is not defined or model.descomhtml == "") and (modinf == null or modinf.vestib == '') %}
            {{ mt._('_common.descr.no') }}
          {% else %}
            {% if model.descomhtml is defined and model.descomhtml != "" %}
              {{ model.descomhtml }}<br/>
            {% elseif model.descom != "" %}
              {{ nl2br(common['printHtmlTags'] ? model.descom : htmlspecialchars(model.descom)) }}<br/>
            {% endif %}

            {% if modinf != null and modinf.vestib != '' %}{{ mt._('_common.fit') ~ ': ' ~ modinf.vestib }}{% endif %}
          {% endif %}
        </div>
        <div id="tab_tec" role="tabpanel" class="tab-pane fade">
          {% if model.destec == "" and
              (modinf == null or
              (session.get('language') == 'it' and modinf.dettit == "") or
              (session.get('language') == 'en' and modinf.detten == "") or
              (session.get('language') == 'es' and modinf.dettes == "") or
              (session.get('language') == 'de' and modinf.dettde == "") or
              (session.get('language') == 'fr' and modinf.dettfr == "")) %}
            {{ mt._('_common.notes.no') }}
          {% else %}
            {{ model.destec != "" ? nl2br(common['printHtmlTags'] ? model.destec : htmlspecialchars(model.destec)) ~ '<br/>' : '' }}
            {{ modinf != null and session.get('language') == 'it' ? modinf.dettit : '' }}
            {{ modinf != null and session.get('language') == 'en' ? modinf.detten : '' }}
            {{ modinf != null and session.get('language') == 'es' ? modinf.dettes : '' }}
            {{ modinf != null and session.get('language') == 'de' ? modinf.dettde : '' }}
            {{ modinf != null and session.get('language') == 'fr' ? modinf.dettfr : '' }}
          {% endif %}
        </div>

        <div id="tab_com" role="tabpanel" class="tab-pane fade">
          <div class="row model-info p-0" style="color:#606060">
            <div class="col-12 col-md-6">{{ mt._('_common.brand') }}: {{ model.dstitl }}</div>
            <div class="col-12 col-md-6">{{ mt._('_common.genre') }}: {{ model.dsgene }}</div>
            <div class="col-12 col-md-6">{{ mt._('_common.line') }}: {{ model.dslinm }}</div>
            <div class="col-12 col-md-6">{{ mt._('_common.modeltype') }}: {{ model.dstmod }}</div>
            {% if model.dsserm != '' %}
            <div class="col-12 col-md-6">{{ mt._('_common.series') }}: {{ model.dsserm }}</div>
            {% endif %}
            {% if (modinf != null and modinf.compos != '') or model.descmp != '' %}
            <div class="col-12 col-md-6">{{ mt._('_common.composition') }}: {{ modinf != null and modinf.compos != '' ? modinf.compos : model.descmp }}</div>
            {% endif %}
            {% if (modinf != null and modinf.madein != '') or model.desmad != '' %}
            <div class="col-12 col-md-6">{{ mt._('_common.madein') }} {{ modinf != null and modinf.madein != '' ? modinf.madein : model.desmad }}</div>
            {% endif %}
          </div>
        </div>

        <div id="tab_dwn" role="tabpanel" class="tab-pane fade">
          {% set pdfurl = "/upload/products/" ~ code ~ ".pdf" %}
          {% set exist = diskManager.fileExistsInPublic(pdfurl)%}
          {% if not exist %}
            {% set pdfurl = "techfiles/" ~ code ~ ".pdf" %}
            {% set exist = diskManager.fileExistsInPublic(pdfurl)%}
          {% endif %}
          {% if exist %}
          <a href="{{ pdfurl }}" class="btn btn-generic mr-0 mt-0" style="width:250px">{{ mt._('_common.downloadtechnicalfile.btn') }}</a>
          {% else %}
          {{ mt._('_common.downloadtechnicalfile.no') }}
          {% endif %}
        </div>
      </div><!-- .tab-content -->
    </div>

  </div>

  {% endif %}
</div>

{% if common['modelDetailStyle'] not in [1, 6, 7, 8, 9] %}

{% if common['isOrder'] %}
<div class="row model-look">
  <span class="{{ common['modelDetailHighlight'] is not empty ? elements.getHighlightClass() : '' }} p-0-15x">{{ mt._('_common.insertquantity') }}</span>
</div>
{% endif %}

<div class="row qty-model">

  {# Articles/Tissues/Colors #}
  <div class="col-12 col-lg-{{ common['isOrder'] ? 7 : 12 }} qty-model-inner">

    {# Model or tissue title #}
    <div class="row model-title">
      <div class="col-12">
        <span class="label-title">{{ model.tppers != "PT" ? mt._('_common.variants') : mt._('_common.variants.tissue') }}</span>
        <a class="fullscreenvar_artn" href="#">{{ image("assets/img/full_view_icon.png", "alt": code, "style": "width:15px") }}</a>
      </div>
    </div>

    <div class="title-underline"></div>
    {% if common['isOrder'] and model.tppers != "PT" and model.anaart|length > 0 %}
      {% set total_tipolo = 0 %}
      {% for anaart in model.anaart if anaart.quantity > 0 %}
        {% set total_tipolo = total_tipolo + anaart.quantity %}
      {% endfor %}
    <div class="font-weight-bold ml-50x pt-10x">{{ mt._('_common.total.qty.mod') }}: <span id="tot_tipolo">{{ total_tipolo }}</span></div>
    {% endif %}

    {% if common['noslider'] == 0 %}
    {# Slider arrows #}
    <div id="backward-slider-variants" style="opacity:0.5">{{ image("assets/img/backward_slider.png", "alt": mt._('_common.previous')) }}</div>
    <div id="forward-slider-variants">{{ image("assets/img/forward_slider.png", "alt": mt._('_common.next')) }}</div>
    {% endif %}

    {# Slider #}
{% if model.anaart|length > 0 %}
    <!-- .row.slide-variants BEGIN -->
    <div class="row slide-variants" style="display:block{% if common['noslider'] == 1 %};min-height:200px;height:auto{% endif %}">
      <!-- .slider-variants BEGIN -->
      <div {% if common['noslider'] == 0 %}id="slider-variants"{% endif %}>

  {# SLIDER FOR ARTICLES/FABRICS #}
  {% for anaart in model.anaart %}

    {% if not common['isOrder'] or common['order_info'].tpordc != 0 or common['shownotavailable'] == 1 or anaart.is_available == 'true' %}
      {% set data_available = is_availability_order ? (anaart.is_available == "true" ? "data-available='1'" : "data-available='0'") : "" %}
      {% set data_info = model.tppers == 'PT' ? "data-code='" ~ anaart.cdpers ~ "' " : "data-cdcolo='" ~ anaart.cdcolo ~ "' data-code='" ~ anaart.dscolo ~ "' " %}

        {# Variant Box #}
        <div class="variant-box {% if common['noslider'] == 1 %}mr-10x ml-0{% endif %}"
          data-loop="{{ loop.index }}" data-cdarti="{{ anaart.cdarti }}" {{ data_info }} {{ data_available }}>

          {# Price - if needed #}
          {% set pad_top = "" %}
          {% if model.tppers != "PT" %}
          <div class="pt-10x w-70 float-left font-weight-bold">
            {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : 0 %}
            {% set cust_disc = anaart.cust_disc > 0 ? anaart.cust_disc : cust_disc %}
            {{ elements.getPriceDiv(anaart.prezzo, cust_disc, common['currency'], common['cdvalu'], 'left') }}
          </div>
          <div class="pt-10x w-30 float-left font-weight-bold text-right totals_arti" data-id="tot_{{ anaart.cdarti }}">{{ anaart.quantity > 0 ? anaart.quantity : '&nbsp;' }}</div>
          {% else %}
            {% set pad_top = "pt-10x" %}
          {% endif %}

          {# Image #}
          {{ elements.getModelImgOrDefault(anaart.flimag, anaart.dsarti, ["class": "float-left " ~ pad_top, "data-descr": anaart.dsarti]) }}
          {% if common['isOrder'] %}<div class="highlight{{ model.tppers == 'PT' ? '-pt' : '' }} {{ anaart.presence < 0 ? 'd-none' : '' }}" data-id="{{ anaart.cdarti }}">&nbsp;</div>{% endif %}

          {# Code/Description #}
          {% set variant_descr = "" %}
          {% if model.tppers == "PT" %}
            {% set variant_descr = anaart.cdpers ~ " - " ~ anaart.dsarti ~ "<br/><span>" ~ anaart.descom ~ "&nbsp;</span>" %}
          {% else %}
            {% if common['description'] == 0 %}{% set variant_descr = anaart.cdcolo != '' ? anaart.cdcolo : anaart.dscolo %}
            {% elseif common['description'] == 1 %}{% set variant_descr = anaart.dscolo != '' ? anaart.dscolo : anaart.cdcolo %}
            {% elseif common['description'] == 2 %}{% set variant_descr = anaart.cdcolo ~ " - " ~  anaart.dscolo %}
            {% endif %}
          {% endif %}
          <div class="float-left variant-code {{ common['isOrder'] and anaart.presence >= 0 ? 'highlight-txt' : '' }}">{{ variant_descr }}</div>
          {% if is_availability_order and anaart.is_available != "true" %}
          <div class="float-left availability-model-box">{{ mt._('_common.notavailable') }}</div>
          {% endif %}

        </div>
    {% endif %}

  {% endfor %}

      </div><!-- .row.slide-variants END -->
    </div><!-- .slider-variants END -->

  {# SLIDERS FOR COLOR #}
  {% if model.tppers == "PT" %}
    {% for anaart in model.anaart %}
      {% if not common['isOrder'] or common['order_info'].tpordc != 0 or common['shownotavailable'] == 1 or anaart.is_available == 'true' %}

    <div id="slide-color-{{ loop.index }}" class="slide-color-variants-container" {% if loop.index != 1 %}style="display:none"{% endif %}>

      {# Article title #}
      <div class="row model-title">
        <div class="col-12">
          <span class="label-title">{{ mt._('_common.variants.tissuecolor') }}: <span style="color:black">{{ anaart.cdpers }}</span></span>
          <a class="fullscreenvar_arti" href="#">{{ image("assets/img/full_view_icon.png", "alt": anaart.cdpers, "style": "width:15px") }}</a>
        </div>
      </div>

      <div class="title-underline"></div>

      {# Slider arrows #}
      <div class="backward-slider-color-variants" data-index="{{ loop.index }}" style="opacity:0.5">
        {{ image("assets/img/backward_slider.png", "class": "float-left", "alt": mt._('_common.previous')) }}
      </div>
      <div class="forward-slider-color-variants" data-index="{{ loop.index }}">
        {{ image("assets/img/forward_slider.png", "class": "float-right", "alt": mt._('_common.next')) }}
      </div>

      {# Slider #}
      <div class="row slide-color-variants" style="display:block">
        <div class="slider-color-variants">
        {% set selected_color = "" %}
        {% for artcol in anaart.colors %}

          {% if not common['isOrder'] or common['order_info'].tpordc != 0 or common['shownotavailable'] == 1 or artcol['is_available'] > 0 %}
            {% set data_available = is_availability_order ? (artcol['is_available'] > 0 ? "data-available='1'" : "data-available='0'") : "" %}

            {% set color_descr = "" %}
            {% if common['description'] == 0 %}{% set color_descr = artcol['cdcolo'] %}
            {% elseif common['description'] == 1 %}{% set color_descr = artcol['dscolo'] %}
            {% elseif common['description'] == 2 %}{% set color_descr = artcol['cdcolo'] ~ " - " ~ artcol['dscolo'] %}
            {% endif %}

          <div class="color-variant-box" data-code="{{ artcol['cdcolo'] }}" {{ data_available }}>
            {# Price #}
            <div class="pt-10x">
              {% set cust_disc = model.cust_disc > 0 ? model.cust_disc : 0 %}
              {% set cust_disc = anaart.cust_disc > 0 ? anaart.cust_disc : cust_disc %}
              {{ elements.getPriceDiv(anaart.prezzo, cust_disc, common['currency'], common['cdvalu']) }}
            </div>

            {# Image #}
            {{ elements.getModelImgOrDefault(artcol['flimag'], artcol['dscolo'], ["data-descr": color_descr]) }}

            {% if common['isOrder'] %}<div class="highlight-cl-pt {{ artcol['presence'] < 0 ? 'd-none' : '' }}" data-id="{{ artcol['cdcolo'] }}">&nbsp;</div>{% endif %}

            {# Code #}
            <div class="color-code {{ common['isOrder'] and artcol['presence'] >= 0 ? 'highlight-txt' : '' }}">{{ color_descr }}</div>
            {% if is_availability_order and artcol['is_available'] <= 0 %}
            <div class="availability-model-box">{{ mt._('_common.notavailable') }}</div>
            {% endif %}
          </div>
          {% endif %}
        {% endfor %}
        </div>
      </div>
    </div>
      {% endif %}
    {% endfor %}

  {% endif %}

{% endif %}

  </div>

{# INSERT QUANTITY #}
{% if common['isOrder'] %}
  <div class="offset-0 col-12 offset-md-2 col-md-8 offset-lg-0 col-lg-5 insert-quantity-box">
    <a name="quantity"></a>
    <div class="row font-weight-bold py-10x">
      <div class="col-{{ model.tppers == 'PT' ? 6 : 12 }}">
        <span class="label-title {{ common['modelDetailHighlight'] is not empty ? elements.getHighlightClass() : '' }} p-0-15x fs13">
          {{ model.tppers == "PT" ? mt._('_common.tissue') : mt._('_common.color') }}:
          <span id="selected-article" style="color:black" data-cdarti="" data-cdcolo=""></span>
        </span>
      </div>
      {% if model.tppers == "PT" %}
      <div class="col-6">
        <span class="label-title fs13">{{ mt._('_common.color') }}: <span id="selected-color" style="color:black"></span></span>
      </div>
      {% endif %}
    </div>

    <div id="insert_quantity">

    </div>

    {# In order to notify availability we need: 1-2) to be in an availability order, 3) to be customer, 4) to have a valid email address
    {% if common['isOrder'] and common['order_info'].tpordc == 0 and session.get('auth')['type'] == 4 and common['order_info'].indema != '' %}
    <div id="notify_products">{{ mt._('model.notifyproducts', {'tag': '<a href="#" id="open-modal-notify-product">' }) }}</div>
    {% endif %}
    #}

  </div>
{% endif %}

</div>

{% endif %}
{# endif common['modelDetailStyle'] != 1 #}

{# Footer models (related, recents and linked buy) will be loaded on document.ready #}
<div class="row mt-50x mb-20x" id="loading-footer-models">
  <div class="preloader" style="position:relative">{{ image("assets/img/preloader.gif", "alt": "Preloader") }}</div>
</div>

{% if common['modelDetailStyle'] != 1 and common['modelDetailStyle'] != 8 and common['modelDetailStyle'] != 9 %}
{# MODAL ROW INFO #}
<div class="modal fade modal-info-row" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="row-index-info" value=""/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('quantity.articleinfo') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        {% if common['visible_notes'] == 1 %}
        <div class="modal-section pb-10x">
          <div class="text-uppercase">{{ mt._('_common.notes') }}</div>
          <div class="form-element"><textarea rows="2" id="dsnoco-info" class="form-control"></textarea></div>
        </div>
        {% endif %}

        {% if common['visible_indicative'] == 1 %}
        <div class="modal-section pb-10x">
          <div class="text-uppercase">{{ mt._('_common.indicative') }}</div>
          <div class="form-element"><input type="text" id="indorc-info" class="form-control"></div>
        </div>
        {% endif %}

        {% if common['visible_reference'] == 1 %}
        <div class="modal-section pb-10x">
          <div sclass="text-uppercase">{{ mt._('_common.reference') }}</div>
          <div class="form-element"><input type="text" id="sgrifc-info" class="form-control"></div>
        </div>
        {% endif %}

      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main save-row-order-info" data-action="">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
{% endif %}
