<div class="modal fade modal-new-order px-0" id="modal-new-order" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" style="max-width:unset">
        <div class="modal-content">
            <!-- Questo mi sembra un refuso delle modali d'inserimento nel carrello -->
            <input type="hidden" id="row-index-info" value=""/>

            <div class="modal-body">
                <div class="row new-order-section">
                    <div class="col-12">
                        <h4 class="new-order-title">
                            {{ session.get('auth')['type'] != 3 or common['customers']|length > 0
                            ? (common['popup'] ? mt._('user.menu.neworder.title2') : mt._('user.menu.neworder.title'))
                            : mt._('order.error.nocustomers') }}
                        </h4>
                        <div class="modal-close"
                             data-dismiss="modal">{{ image("assets/img/times_grey.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
                        {% if session.get('auth')['type'] != 3 or common['customers']|length > 0 %}
                            <div class="d-none d-md-block">
                            <span class="new-order-subtitle">
                              {{ common['popup'] ? mt._('user.menu.neworder.title2.sub') : mt._('user.menu.neworder.title.sub') }}
                            </span>
                            </div>
                        {% endif %}
                    </div>
                </div>
            </div>
            {% if session.get('auth')['type'] != 3 or common['customers']|length > 0 %}
                <div class="modal-body modal-body-new-order">
                    {% if session.get('auth')['type'] in [3, 4] %}

                        {# Customers list #}
                        {% if session.get('auth')['type'] == 3 %}
                            <div class="row new-order-section default-info">
                                <div class="col-12 col-lg-3 new-order-label">{{ mt._('order.selectcustomer') }}</div>
                                <div class="col-12 col-lg-9">
                                    <select name="customer" id="customer-selector"
                                            class="form-control selectpicker"
                                            data-live-search="true">
                                        {% for anagra in common['customers'] %}
                                            {{ elements.getCustomerOptionForNewOrder(loop.index, anagra) }}
                                        {% endfor %}
                                    </select>
                                </div>
                            </div>
                        {% endif %}

                        {# Destinations list #}
                        <div class="row new-order-section default-info with-border">
                            <div class="col-12 col-lg-3 new-order-label row-destinations">{{ mt._('order.selectdestination') }}</div>
                            <div class="col-12 col-lg-9 row-destinations">
                                <div class="form-element form-select">
                                    <label class="form-custom-select">
                                        <select name="destination" id="destination-selector"
                                                class="form-control selectpicker"
                                                data-live-search="true"></select>
                                    </label>
                                </div>
                            </div>
                        </div>
                    {% endif %}
                    <div class="row new-order-section default-info with-border" id="catalog-section">
                        {# Catalogs list #}
                        <div class="col-12 col-lg-3 new-order-label">{{ mt._('order.selectcatalog') }}</div>
                        <div class="col-12 col-lg-9">
                            <div class="form-element form-select">
                                <label class="form-custom-select">
                                    <select name="catalog" id="catalog-selector"
                                            class="form-control selectpicker"></select>
                                </label>
                            </div>
                        </div>

                        {# Labels list #}
                        {% if common['chooseLabel'] == 1 and common['labels']|length > 0 %}
                            <div class="col-12 col-lg-3 new-order-label">{{ mt._('order.selectlabel') }}</div>
                            <div class="col-12 col-lg-9">
                                <div class="form-element form-select">
                                    <label class="form-custom-select">
                                        <select name="label" id="label-selector" class="form-control selectpicker">
                                            {% for anaeti in common['labels'] %}
                                                <option class="label_selector" data-cdcata="{{ anaeti.cdcata }}"
                                                        value="{{ anaeti.cdetic }}"
                                                        {{ anaeti.cdcata is defined and anaeti.cdcata != common['catalogs'][0].cdcata ? 'style="display:none"' : '' }}>{{ anaeti.dsetic }}</option>
                                            {% endfor %}
                                        </select>
                                    </label>
                                </div>
                            </div>
                        {% endif %}
                    </div>
                    <div class="row new-order-section with-border">
                        <div class="col-12 col-lg-3 new-order-label">
                            {{ mt._('order.type') }}
                        </div>
                        <div class="col-12 col-lg-9">
                            <div class="form-element form-select">
                                <label class="form-custom-select">
                                    {% if common['orderTypeChoice'] == 3 %}
                                        <select name="cdtipord" id="tipord-selector" class="form-control selectpicker">
                                            <option value="" selected disabled>
                                                {{ mt._('cart.select.tipord.title') }}
                                            </option>
                                        </select>
                                    {% else %}
                                        <select name="order_type" class="form-control selectpicker"
                                                id="order_type" {{ common['orderTypeChoice'] != 2 and common['enableXlsOrder'] not in [1, 3] ? 'disabled' : '' }}>
                                            {# ORDER TYPE: reservation #}
                                            {% if common['orderTypeChoice'] != 1 %}
                                                {% set checked = (common['enableXlsOrder'] == 1 or common['enableXlsOrder'] == 3) and common['orderTypeChoice'] == 0 ? 'checked' : '' %}
                                                <option value="res" {{ common['orderTypeChoice'] == 0 or common['defaultOrderType'] == 0 ? 'selected' : '' }}>{{ mt._('order.reservation') }}</option>
                                            {% endif %}

                                            {# ORDER TYPE: availability #}
                                            {% if common['orderTypeChoice'] != 0 %}
                                                <option value="ava" {{ common['orderTypeChoice'] == 1 or common['defaultOrderType'] == 1 ? 'selected' : '' }}>{{ mt._('order.availability') }}</option>
                                            {% endif %}

                                            {# ORDER TYPE: xls #}
                                            {% if common['enableXlsOrder'] == 1 or common['enableXlsOrder'] == 3 %}
                                                <option value="xls">{{ mt._('order.xls') }}</option>
                                            {% endif %}
                                        </select>
                                    {% endif %}
                                </label>
                            </div>
                        </div>

                        {# Reservation Order Sub-Menu #}
                        {% if common['orderTypeChoice'] != 1 %}
                            <div class="col-12 col-lg-3 new-order-label reservation-order-submenu" style="display:none">
                                {{ mt._('order.mode') }}
                            </div>
                            <div class="col-12 col-lg-9 reservation-order-submenu" style="display:none">
                                <div class="form-element form-select">
                                    <label class="form-custom-select">
                                        <select name="reservation_order_type" id="reservation_order_type"
                                                class="form-control selectpicker">
                                            <option value="new">{{ mt._('order.new') }}</option>
                                            <option value="dup">{{ mt._('order.duplicate') }}</option>
                                        </select>
                                    </label>
                                </div>
                            </div>
                            {# Orders list (for duplicate order) #}
                            <div class="col-12 col-lg-3 new-order-label reservation-new-order-submenu"
                                 style="display:none">
                                {{ mt._('order.ordertoduplicate') }}
                            </div>
                            <div class="col-12 col-lg-9 reservation-new-order-submenu" style="display:none">
                                <div class="form-element form-select">
                                    <label class="form-custom-select">
                                        <select name="old_orders" id="old_orders" class="form-control selectpicker"
                                                data-live-search="true">
                                            {% for octest in common['old_orders'] %}
                                                <option value="{{ octest.nuordc }}">{{ octest.nuordc }}{{ octest.dtmcli != '' ? ' - ' ~ octest.dtmcli : '' }}
                                                    - {{ octest.descri }} - {{ octest.dscata }}</option>
                                            {% endfor %}
                                        </select>
                                    </label>
                                </div>
                            </div>
                        {% endif %}

                        {# Xls Order Sub-Menu #}
                        {% if common['enableXlsOrder'] == 1 or common['enableXlsOrder'] == 3 %}
                            <div class="col-12 col-lg-9 offset-lg-3" id="xls-order-submenu" style="display:none">
                                <div class="form-element form-select">
                                    <label class="form-custom-select">
                                        <select name="xls_order_type" id="xls_order_type"
                                                class="form-control selectpicker">
                                            <option value="dow">{{ mt._('order.template.download') }}</option>
                                            <option value="upl">{{ mt._('order.upload.completed') }}</option>
                                        </select>
                                    </label>
                                </div>
                            </div>
                        {% endif %}
                    </div>

                    {% if session.get('auth')['type'] == 3 and common['choosePriceList'] %}
                        <div class="row new-order-section with-border default-info">
                            <div class="col-12 col-lg-3 new-order-label">
                                {{ mt._('order.selectpricelist') }}
                            </div>
                            <div class="col-12 col-lg-9">
                                <div class="form-element form-select">
                                    <label class="form-custom-select">
                                        <select name="pricelist" id="pricelist-selector"
                                                class="form-control selectpicker">
                                            {% set defautPricelist = common['customers']|length > 0 ? common['customers'][0].nulist : '' %}
                                            {% for priceList in common['priceLists'] %}
                                                <option value="{{ priceList.nulist }}" {{ priceList.nulist == defautPricelist ? 'selected' : '' }}>{{ priceList.nulist }}
                                                    - {{ priceList.dslist }}</option>
                                            {% endfor %}
                                        </select>
                                        <span class="pointer"><i class="fa fa-caret-down"></i></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    {% endif %}

                    {# Delivery #}
                    {% if common['hideDeliveryDate'] != 1 %}
                        <div class="row new-order-section default-info delivery-date-section">
                            {% if common['dateTypeResOrder'] == 5 %}
                                <div class="col-12 col-lg-3 new-order-label text-capitalize">
                                    {{ mt._('_common.delivery') }}
                                </div>
                                <div class="col-12 col-lg-9 descr">
                                    {# Select #}
                                    <div class="form-element form-select">
                                        <label class="form-custom-select">
                                            <select id="per-res-step-1" name="period" class="form-control selectpicker">
                                                {% for scacon in common['periods'] %}
                                                    <option value="{{ scacon['tpcond'] }}" {{ loop.first ? 'selected' : '' }}>{{ scacon['dsscad'] }}</option>
                                                {% endfor %}
                                            </select>
                                            <span class="pointer"><i class="fa fa-caret-down"></i></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-3">&nbsp;</div>
                                <div class="col-12 col-lg-9 descr">
                                    <div class="form-element form-select per-res" {{ display }}>
                                        <label class="form-custom-select">
                                            <select id="per-res" name="period" class="form-control selectpicker">
                                                {% for scacon in common['periods'] %}
                                                    {% set externalIsFirst = loop.first %}
                                                    {% for date in scacon['secondStep'] %}
                                                        <option value="{{ date }}"
                                                                data-tpcond="{{ scacon['tpcond'] }}" {{ loop.first and externalIsFirst ? 'selected' : '' }} {{ externalIsFirst ? '' : 'style="display:none"' }}>
                                                            {{ date('d/m/Y', strtotime(date)) }}
                                                        </option>
                                                    {% endfor %}
                                                {% endfor %}
                                            </select>
                                            <span class="pointer"><i class="fa fa-caret-down"></i></span>
                                        </label>
                                    </div>
                                </div>
                            {% else %}
                                <div class="col-12 col-lg-3 new-order-label text-capitalize">
                                    {{ mt._('_common.delivery') }}
                                </div>
                                <div class="col-12 col-lg-9">
                                    {# Select #}
                                    <div id="delivery-period-selector-wrapper" class="form-element form-select"
                                         style="display:none">
                                        <label class="form-custom-select">
                                            <select id="delivery-period-selector" name="delivery-date"></select>
                                        </label>
                                    </div>
                                    {# Free Date #}
                                    <div id="delivery-date-selector-wrapper" class="form-element"
                                         style="display:none">
                                        <div>
                                            <input type="hidden" id="delivery-date-selector-real" value="" name="delivery-date">
                                            <input type="text" id="delivery-date-selector"
                                                   class="form-control datepicker datepicker-new-order" value="" autocomplete="off">
                                        </div>
                                        <label for="delivery-date-selector" class="btn btn-default bg-default m-0">
                                            <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                                        </label>
                                    </div>
                                </div>
                            {% endif %}
                        </div>
                    {% endif %}

                    {% if common['manageIndicative'] > 0 %}
                        <div class="row new-order-section default-info">
                            <div class="col-12 col-lg-3 new-order-label">
                                {{ common['indicativeText'] == 0 ? mt._('order.selectindicative') : mt._('order.selectordertype') }}
                            </div>
                            <div class="col-12 col-lg-9">
                                <div class="form-element form-select">
                                    <label class="form-custom-select">
                                        <select name="indicative" id="indicative-selector"
                                                class="form-control selectpicker">
                                            {% if session.get('auth')['type'] == 4 %}
                                                {% for indicative in common['indicatives'] %}
                                                    {% if common['customers'][0].default_tpindo == '' or common['customers'][0].default_tpindo == indicative.tpindo %}
                                                        {% set isSelected = common['customers'][0].default_tpindo == indicative.tpindo or loop.index0 == 0 %}
                                                        <option value="{{ indicative.tpindo }}" {{ isSelected ? "selected" : '' }}>{{ indicative.dsindo }}</option>
                                                    {% endif %}
                                                {% endfor %}
                                            {% else %}
                                                {% if common['manageIndicative'] == 1 %}
                                                    <option value="unassigned">&nbsp;</option>
                                                {% endif %}
                                                {% for indicative in common['indicatives'] %}
                                                    {% set isSelected = common['modelDetailStyle'] == 3 and common['zanDefaultInd'] == indicative.tpindo %}
                                                    <option value="{{ indicative.tpindo }}" {{ isSelected ? "selected" : '' }}>{{ indicative.dsindo }}</option>
                                                {% endfor %}
                                            {% endif %}
                                        </select>
                                    </label>
                                </div>
                            </div>
                        </div>
                    {% endif %}

                    {# Xls upload info #}
                    {% if common['enableXlsOrder'] == 1 or common['enableXlsOrder'] == 3 %}
                        <div class="row xls-upload-info" style="display:none">
                            <div class="col-12 text-center" style="margin-top:20px;color:white;font-size:15px">
                                <form action="{{ url('excel/uploadCompiledXlsTemplateForNewOrder') }}" method="post"
                                      enctype="multipart/form-data" id="load-template">
                                    <input type="file" name="file" id="file">
                                </form>
                            </div>
                        </div>
                    {% endif %}

                    {% if common['doubleRowsNewOrder'] == 1 %}
                        <div class="row new-order-section default-info" style="border:0">
                            <div class="col-12 col-lg-3 new-order-label">{{ mt._('_common.doublerows') }}</div>
                            <div class="col-12 col-lg-9">
                                <div class="form-element form-select">
                                    <label class="form-custom-select">
                                        <select name="doublerows" id="doublerows-selector"
                                                class="form-control selectpicker">
                                            <option value="0">Wholesale</option>
                                            <option value="1">Retail</option>
                                        </select>
                                    </label>
                                </div>
                            </div>
                        </div>
                    {% endif %}

                    {# Action buttons #}
                    {% if session.get('auth')['type'] != 3 or common['customers']|length > 0 %}
                        <div class="row new-order-section text-center mt-40x">
                            <div class="col">
                                <a href="#" id="create-order" class="btn btn-primary btn-block mt-0">
                                    {{ common['popup'] ? mt._('user.menu.neworder.title2.btn') : mt._('_common.confirm') }}
                                </a>
                                {% if common['enableXlsOrder'] == 1 or common['enableXlsOrder'] == 3 %}
                                    <a href="#" id="download-template" class="btn btn-generic mt-0 w-50"
                                       style="display:none">{{ mt._('order.template.download') }}</a>
                                    <a href="#" id="load-order" class="btn btn-generic mt-0 w-50"
                                       style="display:none">{{ mt._('order.upload') }}</a>
                                {% endif %}
                            </div>
                        </div>
                    {% endif %}

                    {# Missing date error #}
                    <div class="row">
                        <div class="col-12 msg-error dtmcli-error text-center pr-30x pb-15x"
                             style="color:white">{{ mt._('_common.dtmcli.mandatory') }}</div>
                    </div>
                </div> <!-- ./modal-body-new-order -->
            {% endif %}
        </div>
    </div>
</div>
