<div class="modal fade modal-row-info" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('quantity.articleinfo') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section font-weight-bold pb-20x">
          <span class="text-custom" id="modal-row-info-descr1"></span><br/>
          <span id="modal-row-info-descr2"></span>
        </div>

        <div class="modal-section pb-10x">
          <span class="modal-info-row-title">{{ mt._('_common.notes') }}</span><br/>
          <span id="modal-row-info-dsnoco"></span>
        </div>

        <div class="modal-section pb-10x">
          <span class="modal-info-row-title">{{ mt._('_common.indicative') }}</span><br/>
          <span id="modal-row-info-indorc"></span>
        </div>

        <div class="modal-section pb-10x">
          <span class="modal-info-row-title">{{ mt._('_common.reference') }}</span><br/>
          <span id="modal-row-info-sgrifc"></span>
        </div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4 offset-6 offset-lg-8 text-right">
              <a href="#" class="font-weight-bold w-80" data-dismiss="modal">{{ mt._('_common.close') }}</a>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

{% if common['showRowDelivery'] > 0 or common['showRowIndicative'] > 0 or common['showRowNotes'] > 0 or common['showRowReference'] > 0 and nuordc < 0 %}
<div class="modal fade modal-modify-row-info" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('quantity.rowinfo') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <input type="hidden" id="modal-modify-row-info-nurorc"/>
      <div class="modal-body" id="modal-modify-row-info-content">

      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main confirm-modify-order-row text-uppercase">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
{% endif %}

{% if nuordc < 0 %}
<div class="modal fade modal-delete-row-order" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('quantity.deleterow') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section pb-10x" id="warning-delete-row">
          {{ mt._('cart.deleterow.warning') }}<span id="nurorc-to-delete" style="display:none"></span>
        </div>
        <div class="modal-section pb-10x" style="display:none" id="error-delete-row">
          {{ mt._('cart.lastrow.warning') }}
        </div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main confirm-delete-row text-uppercase">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
<div class="modal fade" id="modal-cart-insert-quantity" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="row-index-info" value=""/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.quantity') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">

      </div>
    </div>
  </div>
</div>
{% endif %}

{% if common['modelDetailStyle'] == 2 and nuordc < 0 %}
<div class="modal fade modal-modify-row-quantity" tabindex="-1" role="dialog" aria-hidden="true" id="modal-modify-row-quantity">
  <div class="modal-dialog modal-lg">
    <div class="modal-content" style="max-height:680px">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.modify.quantity') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <input type="hidden" id="modal-modify-row-quantity-nurorc" value="">
        <div class="row m-0">
          <div class="col-4">
            <div class="row m-0">
              <div class="col-12"><img src="" id="modal-modify-row-quantity-model-img"/></div>
            </div>
          </div>
          <div class="col-8">
            <div class="row m-0">
              <div class="col-3 cart-info-title">{{ mt._('_common.model') }}:</div>
              <div class="col-9 cart-info-text text-left" id="modal-modify-row-quantity-model"></div>
            </div>
            <div class="row m-0 pt-20x">
              <div class="col-3 cart-info-title">{{ mt._('_common.tissue') }}:</div>
              <div class="col-9 cart-info-text text-left" id="modal-modify-row-quantity-fabric"></div>
            </div>
            <div class="row m-0">
              <div class="col-3 cart-info-title">{{ mt._('_common.color') }}:</div>
              <div class="col-9 cart-info-text text-left" id="modal-modify-row-quantity-color"></div>
            </div>
            <div class="row m-0">
              <div class="col-3 cart-info-title">{{ mt._('_common.variations') }}:</div>
              <div class="col-9 cart-info-text text-left" id="modal-modify-row-quantity-variants"></div>
            </div>
            <div class="row m-0 pt-20x">
              <div class="col-3 cart-info-title">{{ mt._('cart.deliverydate') }}:</div>
              <div class="col-9 cart-info-text text-left">
                {% if (common['order_info'].tpordc == 1 and common['dateTypeResOrder'] < 2) or
                      (common['order_info'].tpordc == 0 and common['dateTypeAvaOrder'] < 2) %}
                <div class="form-element form-select mt-10x">
                  <label class="form-custom-select">
                    <select name="period" id="modal-modify-row-quantity-date">
                      <option value="0000-00-00"></option>
                      {% for scacon in common['periods'] %}
                      <option value="{{ scacon.dtmcli }}"}>{{ scacon.dsscad }}</option>
                      {% endfor %}
                    </select>
                    <span class="pointer"><i class="fa fa-caret-down"></i></span>
                  </label>
                </div>
                {% else %}
                <div class="row form-element form-element-datepicker mx-0">
                  <div class="col-10 px-0">
                    <input type="text" class="datepicker datepicker-new-order" id="modal-modify-row-quantity-date" tabindex="-1" value="" style="border: 1px solid #ccc;border-right:0;cursor:pointer">
                  </div>
                  <div class="col-2 new-order-calendar"><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                </div>
                {% endif %}
              </div>
            </div>
          </div>
        </div>
        <div class="row m-0">
          <div class="col-4 h-100">
            <div class="row m-0 h-100">
              <div class="col-6"><img src="" id="modal-modify-row-quantity-color-img" style="height:80px"/></div>
            </div>
          </div>
          <div class="col-8">
            <textarea class="form-control m-0" id="modal-modify-row-quantity-notes" placeholder="{{ mt._('model.fastbuy.notes') }}" style="height:80px!important"></textarea>
          </div>
        </div>
        <div class="row m-0 mt-10x" id="modal-modify-row-content" style="overflow-y:auto;max-height:252px">

        </div>
        <div class="row mt-10x" style="margin-left:-25px;margin-right:-25px">
          <div class='col-12'>
            <button type='button' class='btn btn-main w-100 mt-0 mb-0' id="modal-modify-row-quantity-confirm">{{ mt._('_common.cart.modify') }}</button>
          </div>
          <div class="col-12 unsuccess-box" style="display:none;padding-left:15px;padding-right:15px;">
            <div>{{ mt._('_common.regqtm.warning', ['qtamin': "<span id='modal-modify-row-quantity-regqtm-qtamin'></span>", 'qtamul': "<span id='modal-modify-row-quantity-regqtm-qtamul'></span>"]) }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade modal-modify-row-variants" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content" style="max-height:680px">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.modify.variants') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <input type="hidden" id="modal-modify-row-variants-nurorc" value="">
        <input type="hidden" id="modal-modify-row-variants-oldcdvari" value="">
        <div class="row m-0">
          <div class="col-4">
            <div class="row m-0">
              <div class="col-12"><img src="" id="modal-modify-row-variants-model-img"/></div>
            </div>
          </div>
          <div class="col-8">
            <div class="row m-0">
              <div class="col-3 cart-info-title">{{ mt._('_common.model') }}:</div>
              <div class="col-9 cart-info-text text-left" id="modal-modify-row-variants-model"></div>
            </div>
            <div class="row m-0 pt-20x">
              <div class="col-3 cart-info-title">{{ mt._('_common.tissue') }}:</div>
              <div class="col-9 cart-info-text text-left" id="modal-modify-row-variants-fabric"></div>
            </div>
            <div class="row m-0">
              <div class="col-3 cart-info-title">{{ mt._('_common.color') }}:</div>
              <div class="col-9 cart-info-text text-left" id="modal-modify-row-variants-color"></div>
            </div>
            <div class="row m-0">
              <div class="col-3 cart-info-title">{{ mt._('_common.variations') }}:</div>
              <div class="col-9 cart-info-text text-left" id="modal-modify-row-variants-variants"></div>
            </div>
            <div class="row m-0">
              <div class="col-12 h-100 p-0 mt-20x">
                <img src="" id="modal-modify-row-variants-color-img" style="height:80px"/>
              </div>
            </div>
          </div>
        </div>
        <div class="row m-0 mt-10x modal-wizard-selector-box" id="modal-modify-row-variants-content" style="overflow-y:auto;max-height:263px">

        </div>
        <div class="row mt-10x" style="margin-left:-25px;margin-right:-25px">
          <div class='col-12'>
            <button type='button' class='btn btn-main w-100 mt-0 mb-0' id="modal-modify-row-variants-confirm">{{ mt._('_common.variants.modify') }}</button>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
{% endif %}

{% if common['modelDetailStyle'] == 3 and nuordc < 0 %}
<!-- Modal for deleting articles with no quantity -->
<div class="modal fade modal-delete-no-qty" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content" style="max-height:680px">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" id="modal-multiple-nurorc" value=""/>
      <div class="modal-body">
        <div class="row pb-20x">
          <div class="col-12">{{ mt._('model.wizard.warning.deleterows') }}</div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main text-capitalize" id="delete-no-qty">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

{% if thereAreDoubles and nuordc < 0 %}
<!-- Modal for deleting articles with no quantity -->
<div class="modal fade modal-double-rows-confirm" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content" style="max-height:680px">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.warning') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" id="modal-flstat-confirm" value=""/>
      <div class="modal-body">
        <div class="row pb-20x">
          <div class="col-12">{{ mt._('order.therearedouble.warning') }}</div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main text-uppercase" id="confirm-double-rows">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

{% if common['multipleInsert'] == 1 and nuordc < 0 %}
<!-- Modal for bulk insert -->
<div class="modal fade modal-bulk-insert" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content" style="max-height:680px">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.header.barcode.bulk') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" id="modal-bulk-insert-nurorcs" value=""/>
      <div class="modal-body">

      </div>
      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main text-uppercase" id="confirm-bulk-insert">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}
