{% set neededByModel = router.getControllerName() == "model" and
  router.getActionName() != "fullscreen" and
  router.getActionName() != "fullscreenvar" and
  router.getActionName() != "img360"
%}
{% set menuNeeded = router.getControllerName() == "account" or
  router.getControllerName() == "cart" or
  router.getControllerName() == "catalog" or
  router.getControllerName() == "info" or
  router.getControllerName() == "statistics" or
  neededByModel
%}
{% set cartNeeded = (router.getControllerName() == "cart" or
  router.getControllerName() == "catalog" or
  router.getControllerName() == "info" or
  neededByModel) and common['isOrder']
%}
{% set searchNeeded = router.getControllerName() == "cart" or
  router.getControllerName() == "catalog" or
  neededByModel
%}
{% set accountNeeded = (router.getControllerName() == "account" or
  router.getControllerName() == "cart" or
  router.getControllerName() == "catalog" or
  router.getControllerName() == "info" or
  router.getControllerName() == "statistics" or
  router.getControllerName() == "support" or
  neededByModel) and not common['isOrder']
%}
{% set catalogNeeded = (router.getControllerName() == "catalog" or
  router.getControllerName() == "info" or
  router.getControllerName() == "support" or
  neededByModel) and (not common['isOrder'] or common['useMoreCatalogs'] == 1)
%}
{% set promoNeeded = (router.getControllerName() == "cart" or
  router.getControllerName() == "catalog" or
  neededByModel) and common['isOrder'] and common['coupon_promo'] == 2
%}
{% set filterNeeded = router.getControllerName() == "catalog" and (
  router.getActionName() == "collection" or
  router.getActionName() == "fabric" or
  router.getActionName() == "fabricDetail" or
  router.getActionName() == "list" or
  router.getActionName() == "results" or
  router.getActionName() == "resultslist" or
  router.getActionName() == "sales" or
  router.getActionName() == "selection" or
  router.getActionName() == "tag" or
  (router.getActionName() == "classification" and products is not empty)
  )
%}
{% set orderByNeeded = router.getControllerName() == "catalog" and (
  router.getActionName() == "collection" or
  router.getActionName() == "fabric" or
  router.getActionName() == "fabricDetail" or
  router.getActionName() == "list" or
  router.getActionName() == "sales" or
  router.getActionName() == "selection" or
  router.getActionName() == "tag")
%}

{% if menuNeeded %}
{% include "layouts/slider/menu.volt" %}
{% include "scripts/slider/menu.volt" %}
{% endif %}

{% if cartNeeded %}
{% include "layouts/slider/order.volt" %}
{% include "scripts/common/info_order.volt" %}
{% endif %}

{% if searchNeeded %}
{% include "layouts/slider/search.volt" %}
{% include "scripts/common/search.volt" %}
{% endif %}

{% if accountNeeded %}
{% include "layouts/slider/account.volt" %}
{% include "scripts/slider/account.volt" %}
{% endif %}

{% if catalogNeeded %}
{% include "layouts/slider/catalog.volt" %}
{% include "scripts/slider/catalog.volt" %}
{% endif %}

{% if promoNeeded %}
{% include "layouts/slider/promo.volt" %}
{% include "scripts/slider/promo.volt" %}
{% endif %}

{% if filterNeeded %}
{% include "layouts/slider/filter.volt" %}
{% include "scripts/slider/filter.volt" %}
{% endif %}

{% if orderByNeeded %}
{% include "layouts/slider/orderby.volt" %}
{% include "scripts/slider/orderby.volt" %}
{% endif %}
