{% set banner_present = router.getControllerName() == 'catalog' and common['banner'] != "" %}

<header class="navbar {% if router.getControllerName() == 'account' and router.getActionName() == 'info' or router.getControllerName() == 'support' %}navbar-fixed{% else %}navbar-sticky{% endif %} {% if banner_present %}navbar-with-banner{% endif %} p-0" id="my-menu">
  <div class="w-100 mx-auto" style="background-color:{{ common['navbarBgColor'] is not empty ? common['navbarBgColor'] : '#eee' }}">
    <div class="row p-0 w-100 mx-auto">
      <div class="col-6 menu-btn font-weight-bold header-menu-btn-lft">
        {{ navbarBuilder.getCatalogButton(common['isOrder'], router.getControllerName(), common['selected_catalog'], common['useMoreCatalogs']) }}
      </div>
      <div class="col-6 menu-btn font-weight-bold header-menu-btn-rgt text-right">
        {{ navbarBuilder.getSupportButton(common['isOrder'], common['supportavailable'], session.get('auth')['type']) }}
        {{ navbarBuilder.getStatsButton(common['isOrder'], session.get('auth')['type']) }}
        {{ hasShipmentConditions ? navbarBuilder.getShipmentInfoButton(common['isOrder']) : '' }}
        {{ navbarBuilder.getAccountButton(common['isOrder']) }}
        {{ navbarBuilder.getOrdersButton(common['isOrder'], common['showOrders']) }}
        {{ navbarBuilder.getDownloadButton(common['isOrder']) }}
        {{ navbarBuilder.getPromoButton(common['isOrder'], router.getControllerName(), common['coupon_promo']) }}
        {{ navbarBuilder.getSearchBoxForSmartphone(router.getControllerName()) }}
        {{ navbarBuilder.getBarcodeButton(common['isOrder'], common['enableBarcode']) }}
        {{ navbarBuilder.getQuickOrderButton(common['isOrder'], common['showQuickOrder'], common['isOrder'] ? common['order_info'].tpordc : -1) }}
        {{ navbarBuilder.getExcelCartButton(common['isOrder'], common['allowExcelCart']) }}
        {{ navbarBuilder.getCancelOrderButton(common['isOrder']) }}
        {{ navbarBuilder.getLanguageButton(common['isOrder'], session.get('language')) }}
        {{ navbarBuilder.getLogoutButton() }}
      </div>
    </div>
  </div>
  <div class="w-100 mx-auto" style="padding:10px 0">
    <div class="row p-0 w-100 mx-auto">
      {% set newOrderBtnClass = common['addHeaderBtnLink'] != '' and common['addHeaderBtnText'] != '' ? 'col-2' : 'col-4' %}
      <div class="{{ newOrderBtnClass }} menu-btn new-order">
        {{ navbarBuilder.getNewOrderButton(router.getControllerName(), common['isOrder'], common['catalogs']|length, common['canDoOrder'], common['orderInfoBtn'], common['order_info']) }}
      </div>
      {% if common['addHeaderBtnLink'] != '' and common['addHeaderBtnText'] != '' %}
      <div class="col-2 menu-btn additional-btn">{{ navbarBuilder.getAdditionalButton(common['addHeaderBtnText'], common['addHeaderBtnLink']) }}</div>
      {% endif %}
      <div class="col-4 menu-btn logo-box">{{ navbarBuilder.getLogo(common['logoimg'], common['homepage']) }}</div>
      <div class="col-4 menu-btn menu-btn-right mt-0">
        {{ navbarBuilder.getSearchBoxForDesktop(router.getControllerName()) }}
        {{ navbarBuilder.getSearchBoxForTablet(router.getControllerName()) }}
        {{ navbarBuilder.getCartButton(common['isOrder'], router.getControllerName(), common['hideDeliveryDate'], common['order_info'], common['dateTypeAvaOrder'], common['dateTypeResOrder'], common['tot']['totRows'], common['tot']['totCart'], common['tot']['totSpend']) }}
        {{ navbarBuilder.getMobileMenuButton() }}
      </div>
    </div>
  </div>

  <!-- Catalog Navigation Header -->
{% if common['NavbarContent'] == 0 or common['NavbarContent'] == 3 or (common['NavbarContent'] == 4 and common['customMenu']|length == 0) %}
  {% set hide = config.release.user == 'asp' or (router.getControllerName() == 'catalog' and router.getActionName() == 'index' and hideNavbar is defined and hideNavbar) %}
  {{ navbarBuilder.getDefaultNavbarNavigation(common['brands'], common['lines'], common['series'], common['lookbooks'], common['sales'], common['galleries'], common['catalogAccessType'], hide, common['NavbarContent'] == 3, common['catalogMenuAlignment']) }}
{% elseif common['NavbarContent'] == 1 %}
  {{ navbarBuilder.getModelTypesNavigation(common['modelTypes'], common['lookbooks'], common['sales'], common['galleries']) }}
{% elseif common['NavbarContent'] == 2 %}
  {{ navbarBuilder.getGenresNavigation(common['genres'], common['lookbooks'], common['sales'], common['galleries'], false, common['catalogMenuAlignment']) }}
{% elseif common['NavbarContent'] == 4 and common['customMenu']|length > 0 %}
  {{ navbarBuilder.getCustomMenuNavigation(common['customMenu'], common['lookbooks'], common['sales'], common['galleries'], common['catalogMenuAlignment']) }}
{% elseif common['NavbarContent'] == 5 %}
  {{ navbarBuilder.getGenresNavigation(common['genres'], common['lookbooks'], common['sales'], common['galleries'], true, common['catalogMenuAlignment']) }}
{% elseif common['NavbarContent'] == 6 %}
  {{ navbarBuilder.getClassificationsNavigation(common['classifications'], common['sales'], false, common['catalogMenuAlignment']) }}
{% elseif common['NavbarContent'] == 7 %}
  {% set hide = config.release.user == 'asp' or (router.getControllerName() == 'catalog' and router.getActionName() == 'index' and hideNavbar is defined and hideNavbar) %}
  {{ navbarBuilder.getDefaultNavbarNavigationPlus(common['brands'], common['lines'], common['series'], common['lookbooks'], common['sales'], common['galleries'], (common['classifications'] is defined ? common['classifications'] : []), common['catalogAccessType'], hide, common['NavbarContent'] == 3, common['catalogMenuAlignment']) }}
{% endif %}

  <div class="w-100 py-2">
    <div class="row text-capitalize mx-0">
      <div class="col-12">
        <div class="breadcrumbs">
          {{ navbarBuilder.getBreadcrumbs(router.getControllerName(), router.getActionName(),
            common['homepage'], cdlkbk is defined ? cdlkbk : '&nbsp', tag is defined ? tag : '&nbsp',
            common['catalogAccessType'], ctg_vt is defined ? ctg_vt : '&nbsp;',
            ctg_br is defined ? ctg_br : '&nbsp;', ctg_ln is defined ? ctg_ln : '&nbsp;', ctg_sm is defined ? ctg_sm : '&nbsp;') }}
        </div>
      </div>
      <div class="col-6">
        <div class="d-flex">
          {{ navbarBuilder.getLeftButtonsOnBottomHeader(router.getControllerName(), router.getActionName(), common['catalogAccessType'],
            common['isOrder'], common['isOrder'] ? common['order_info'].tpordc : '', common['enableFabricView'],
            cdtitl is defined ? cdtitl : '', cdlinm is defined ? cdlinm : '', common['showQuickOrder'], common['showList'], common['showVisual']) }}
        </div>
      </div>
      <div class="col-6 col-lg-6">
        <div class="d-flex flex-row-reverse">
          {{ navbarBuilder.getRightButtonsOnBottomHeader(router.getControllerName(), router.getActionName(), common['catalogAccessType'],
          common['isOrder'], common['isOrder'] ? common['order_info'].tpordc : '', common['enableFabricView'],
          cdtitl is defined ? cdtitl : '', cdlinm is defined ? cdlinm : '', common['showQuickOrder'], common['showList'], common['showVisual']) }}
        </div>
      </div>
    </div>
    {% include "layouts/widgets/flash_messages.volt" %}

  </div>

  {% if banner_present %}
  <!-- Banner -->
  <div class="banner w-100"><div class="row d-flex justify-content-center banner-row">{{ common['banner'] }}</div></div>
  {% endif %}

</header><!-- .navbar.navbar-sticky -->
