<!-- Footer -->
<footer class="footer">
  <div class="row mx-0 fs13">
    <div class="col-12 col-lg-4 footer-box">
      {% if common['showContactInfo'] %}
      <div class="row">
        <div class="col-12 text-center text-uppercase font-weight-bold">{{ mt._('footer.contacts') }}</div>
        <div class="d-none d-lg-block col-6 fast-link text-right pt-10x">
          <span>{{ mt._('_common.phone') }}</span><br/>
          <a href="tel:{{ (common['tel'])|escape_attr }}" target="_blank" rel="noopener noreferrer">{{ common['tel'] }}</a>
        </div>
        <div class="d-none d-lg-block col-6 fast-link text-left pt-10x">
          <span>{{ mt._('_common.email') }}</span><br/>
          <a href="mailto:{{ (common['email'])|escape_attr }}" target="_blank" rel="noopener noreferrer">{{ common['email'] }}</a>
        </div>
        <div class="d-block d-lg-none col-12 fast-link text-center pt-10x">
          <span>{{ mt._('_common.phone') }}</span>:
          <a href="tel:{{ (common['tel'])|escape_attr }}" target="_blank" rel="noopener noreferrer">{{ common['tel'] }}</a>
        </div>
        <div class="d-block d-lg-none col-12 fast-link text-center pt-10x">
          <span>{{ mt._('_common.email') }}</span>:
          <a href="email:{{ (common['email'])|escape_attr }}" target="_blank" rel="noopener noreferrer">{{ common['email'] }}</a>
        </div>
      </div>
      {% endif %}
    </div>
    <div class="col-12 col-lg-4 footer-box" style="background-color:#eee">
      <div class="row">
        <div class="col-12 text-center text-uppercase font-weight-bold">{{ mt._('footer.shortlinks') }}</div>
        <div class="col-12 text-center pt-10x">{{ mt._('footer.shortlinks.sub') }}</div>
        <div class="col-6 fast-link">
          <span><a href="{{ url('info/salesconditions') }}">{{ mt._('_common.salesconditions') }}</a></span><br/>
        </div>
        {% if common['isOrder'] == false %}
          <div class="col-6 fast-link">
            <span><a href="{{ url('account/info/pro') }}">{{ mt._('_common.account') }}</a></span><br/>
          </div>
          <div class="col-6 fast-link">
            <span><a href="{{ url('info/contacts') }}">{{ mt._('_common.contacts') }}</a></span><br/>
          </div>
          <div class="col-6 fast-link">
            <span><a href="{{ url('account/info/ord') }}">{{ mt._('_common.orders') }}</a></span>
          </div>
        {% endif %}
      </div>
    </div>
    <div class="col-12 col-lg-4 footer-box">
      {% if common['paypal'] > 0 %}
      <div class="row">
        <div class="col-12 text-center text-uppercase font-weight-bold">{{ mt._('footer.payment') }}</div>
        <div class="col-12 text-center pt-10x">{{ mt._('footer.payment.sub') }}</div>
        <div class="col-6 fast-link">{{ image("assets/img/paypal-footer.png", "alt": "PayPal", "class": "ft-pay") }}</div>
        <div class="col-6 fast-link">{{ image("assets/img/stripe-footer.png", "alt": "Stripe", "class": "ft-pay") }}</div>
      </div>
      {% endif %}
    </div>
  </div>
  <div class="row rights">
    <div class="col-6 d-none d-lg-block font-weight-bold">Powered by <a href="https://www.sinergiattiva.com/" style="color:black">Sinergiattiva Srl</a> - All Rights Reserved</div>
    <div class="col-6 d-none d-lg-block text-right"><span>{{ mt._('footer.info', {'bus': common['business'], 'adr': common['address'] }) }}</span></div>
    <div class="col-12 d-block d-lg-none text-center"><span>{{ mt._('footer.info', {'bus': common['business'], 'adr': common['address'] }) }}</span></div>
    <div class="col-12 d-block d-lg-none text-center">Powered by <a href="https://www.sinergiattiva.com/" style="color:black">Sinergiattiva Srl</a> - All Rights Reserved</div>
  </div>
</footer><!-- .footer -->
