{#
#}

<!-- Body -->
{% if router.getActionName() in ["listAdmin", "chatAdmin"] %}
  <body class="nav-md">
    <div class="container body mw-100">
      <div class="main_container mw-100">
        {% include "layouts/widgets/admin_left_col.volt" %}
        {% include "layouts/widgets/admin_top_nav.volt" %}

        <!-- page content -->
        <div class="right_col" role="main">
          <h2 class="section_title">{{ mt._('admin.menu.title') }}</h2>
          {{ content() }}
        </div>
        <!-- /page content -->

      </div>
    </div>
    {% include "bottom_scripts.volt" %}
    {% include "layouts/widgets/modals.volt" %}

    <!-- jQuery -->
    {{ javascript_include("js/jquery.min.js") }}
    {{ javascript_include("vendors/jquery-ui-1.12.1.custom/jquery-ui.min.js") }}
    {{ javascript_include("js/go2b.js") }}
    {{ partial("scripts/support/" ~ router.getActionName()) }}
    
  </body>
{% endif %}


{% if router.getActionName() in ["list", "chat"] %}
  <body class="page-preloading">
    <!-- Page Pre-Loader -->
    <div class="page-preloader"><div class="preloader">{{ image("assets/img/preloader.gif", "alt": "Preloader") }}</div></div>
    <div class="page-wrapper h-100">

      <!-- Navbar -->
      {% include "layouts/widgets/navbar.volt" %}

      <!-- content -->
      <div class="content">
      {{ content() }}
      </div><!-- .content -->

      {% include "layouts/widgets/footer.volt" %}

    </div>
    {% include "layouts/widgets/modals.volt" %}
    {% include "bottom_scripts.volt" %}
    {% include "layouts/widgets/sliders.volt" %}
    
    {{ partial("scripts/support/" ~ router.getActionName()) }}
  </body>
{% endif %}
