{% if common['isOrder'] %}

<div id="order-slider" class="ext-slider">
  <div class="row">
    <div class="col-8 title-slider-rgt">{{ mt._('user.menu.orderinfo') }}</div>
    <div class="col-4 slider-exit-rgt"><span class="slider-exit">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</span></div>
  </div>
  <div class="row sld_space">
    <div class="col-12 text-slider-lft">{{ mt._('_common.customer') }}</div>
    <div class="col-12 text-slider-lft descr">{{ common['order_info'].cdanag }} - {{ common['order_info'].dsanag }}</div>
  </div>
  <div class="row">
    <div class="col-12 text-slider-lft">{{ mt._('_common.shippings') }}</div>
    <div class="col-12 text-slider-lft descr">{{ elements.printOrderAddress(common['order_info']) }}</div>
  </div>
  <div class="row">
    <div class="col-12 text-slider-lft">{{ mt._('order.type') }}</div>
    <div class="col-12 text-slider-lft descr">{{ common['order_info'].tpordc == 1 ? mt._('order.reservation') : mt._('order.availability') }}</div>
  </div>
  {% if common['order_info'].cdetic is not null %}
  <div class="row">
    <div class="col-12 text-slider-lft">{{ mt._('_common.label') }}</div>
    <div class="col-12 text-slider-lft descr">{{ common['order_info'].dsetic }}</div>
  </div>
  {% endif %}
  <div class="row">
    <div class="col-12 text-slider-lft">{{ mt._('_common.ordernumber') }}</div>
    <div class="col-12 text-slider-lft descr">{{ common['order_info'].nuordc }}</div>
  </div>
  <div class="row">
    <div class="col-12 text-slider-lft">{{ mt._('_common.orderdate') }}</div>
    <div class="col-12 text-slider-lft descr">{{ common['order_info'].dtcrea }}</div>
  </div>
  <div class="row">
    <div class="col-12 text-slider-lft">{{ mt._('_common.delivery') }}</div>
    <div class="col-12 text-slider-lft descr">
      {{ elements.getOrderSliderDate(common['order_info'], common['dateTypeAvaOrder'], common['dateTypeResOrder'], common['periods'], router.getControllerName() )}}
    </div>
  </div>
  {% if session.get('auth')['type'] == 3 and common['changePriceList'] %}
  <div class="row collapse-row">
    <div class="col-12 text-slider-lft"><a class="label-for-collapse" data-toggle="collapse" href="#pricelistcollapse" role="button" aria-expanded="false" aria-controls="pricelistcollapse">{{ mt._('_common.pricelist') }}</a></div>
    <div class="collapse" id="pricelistcollapse">
      <div class="col-12 text-slider-lft descr">
        <div class="form-element form-select mt-10x mb-0">
          <label class="form-custom-select mb-0">
            <select name="pricelist" id="pricelist">
              {% for priceList in common['priceLists'] %}
              <option value="{{ priceList.nulist }}" {% if common['order_info'].nulist == priceList.nulist %}selected{% endif %}>{{ priceList.nulist }} - {{ priceList.dslist }}</option>
              {% endfor %}
            </select>
          </label>
        </div>
      </div>
      <div class="col-12 text-slider-lft mt-0"><a href="#" class="slider-exit" data-toggle='modal' data-target='.modal-recalculate-prices' id="recalculate-order-prices" style="display:none">{{ mt._('_common.pricelist.recalculate') }}</a></div>
    </div>
  </div>
  {% endif %}
  {% if common['manageIndicative'] > 0 %}
  <div class="row">
    <div class="col-12 text-slider-lft">{{ common['indicativeText'] == 0 ? mt._('_common.orderindicative') : mt._('_common.ordertype') }}</div>
    <div class="col-12 text-slider-lft descr">
      <div class="form-element form-select mt-10x mb-0">
        <label class="form-custom-select mb-0">
          <select name="indicative" id="indicative">
            {% if common['manageIndicative'] == 1 %}
            <option value="unassigned">&nbsp;</option>
            {% endif %}
            {% for indicative in common['indicatives'] %}
            <option value="{{ indicative.tpindo }}" {% if common['order_info'].tpindo == indicative.tpindo %}selected{% endif %}>{{ indicative.dsindo }}</option>
            {% endfor %}
          </select>
        </label>
      </div>
    </div>
  </div>
  {% endif %}
  {% if common['budgetManagement'] > 0 and common['budget']['line']|length > 0 and common['budget']['drop']|length > 0 %}
  <div class="row collapse-row">
    <div class="col-12 text-slider-lft"><a class="label-for-collapse" data-toggle='collapse' href='#budgetslidercollapse' role='button' aria-expanded="false" aria-controls="budgetslidercollapse">{{ mt._('cart.analysis.full') }}</a></div>
    <div class="collapse" id="budgetslidercollapse">
      <div class="col-12 text-slider-lft descr ml-30x">
        <a href="#" data-toggle='modal' data-target='.modal-budget-analysis-line'>{{ mt._('_common.budget.grouping.line') }}</a>
      </div>
      <div class="col-12 text-slider-lft descr ml-30x">
        <a href="#" data-toggle='modal' data-target='.modal-budget-analysis-drop'>{{ mt._('_common.budget.grouping.drop') }}</a>
      </div>
    </div>
  </div>
  {% endif %}
  <div class="row sld_space">
    <div class="col-12 text-slider-lft"><a href="#" class="slider-exit" data-toggle='modal' data-target='.modal-cancel-order'>{{ mt._('_common.cancelorder') }}</a></div>
  </div>
</div>

<!-- Modal for cancel order -->
<div class="modal fade modal-cancel-order" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.cancelorder') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section pb-10x">{{ mt._('_common.cancelorder.warning') }}</div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="confirm-cancel-order" data-action="">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

{% if common['allowExcelCart'] %}
<!-- Modal for xls cart import -->
<div class="modal fade modal-excel-cart px-0" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog" style="max-width:unset">
    <div class="modal-content" style="background-color:transparent;border:0">
      <div class="mt-40x" style="background-color:transparent;border:none;display:flex">
        <h4 class="xls-order-title">{{ mt._('_common.modifyorder.xls') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times_grey.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="d-none d-md-block" style="background-color:transparent;border:none;text-align:center">
        <span class="xls-order-title">{{ mt._('_common.modifyorder.xlscart.sub') }}</span>
      </div>

      <div class="modal-body modal-body-xls-order">
        <div class="row">
          <div class="col-12" style="text-align: center">
            <a class="btn btn-generic mt-0" href="{{ url('io/template/cart/template.xls') }}" style="font-size:12px;padding:6px 15px;height:auto;line-height:normal;" target="_blank">Template</a>
          </div>
        </div>
        <div class="row xls-upload-info">
          <div class="col-12 text-center" style="margin-top:20px;color:white;font-size:15px">
            <form action="{{ url('excel/uploadCompiledXlsForCart') }}"  method="post" enctype="multipart/form-data" id="load-excel-cart">
              <input type="file" name="file" id="xls_file">
            </form>
          </div>
        </div>
        <div class="row text-center mt-40x">
          <div class="col">
            <a href="#" id="load-excel-btn" class="btn btn-generic mt-0 w-50">{{ mt._('_common.load') }}</a>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
{% endif %}

{% if session.get('auth')['type'] == 3 and common['changePriceList'] %}
<!-- Modal for recalculate prices -->
<div class="modal fade modal-recalculate-prices" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.pricelist.recalculate') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="modal-section pb-10x">{{ mt._('_common.pricelist.warning') }}</div>
      </div>

      <div class="modal-footer">
        <div class="container">
          <div class="row justify-content-between">
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-generic" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
            <div class="col-6 col-lg-4"><button type="button" class="btn btn-main" id="confirm-recalculate-prices" data-action="">{{ mt._('_common.confirm') }}</button></div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
{% endif %}

{% if common['budgetManagement'] > 0 and common['budget']['line']|length > 0 and common['budget']['drop']|length > 0 %}
  {% set addBrand = false %}
  {% set currentBrandCode = common['budget']['line'][0].cdtitl %}
  {% for item in common['budget']['line'] %}
    {% if item.cdtitl != currentBrandCode %}
      {% set addBrand = true %}
    {% endif %}
  {% endfor %}

  {% set lineColumnWidth = 300 %}
  {% set otherColumnWidth = 150 %}
<!-- Modal for budget -->
<div class="modal fade modal-budget-analysis-line" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document" style="max-width:100%">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('cart.analysis.full') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body" style="overflow-x:auto">
        <div class="row">
          <div class="col-12">
            <span class="text-capitalize">{{ mt._('_common.season') }}:</span>
            {{ common['order_info'].dsstag != '' ? common['order_info'].dsstag : common['order_info'].cdstag }}
            - <span class="text-capitalize">{{ mt._('_common.drop') }}:</span>
            {{ common['order_info'].tpindo }}
            {{ common['order_info'].dsindo != '' and common['order_info'].dsindo != common['order_info'].dsindo ? ' - ' ~ common['order_info'].dsindo : '' }}
          </div>
        </div>
        {% set title = mt._('_common.line') ~ ' - ' ~ mt._('_common.drop') %}
        {{ elements.getBudgetHeaderHtml(lineColumnWidth, otherColumnWidth, 'px', common['budget']['line'][0], title, false, false, true) }}
        {{ elements.getBudgetForCustomerBodyHtml(lineColumnWidth, otherColumnWidth, 'px', common['budget']['line'], addBrand, common['currency'], true, false, false, true) }}
      </div>

    </div>
  </div>
</div>
<div class="modal fade modal-budget-analysis-drop" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document" style="max-width:100%">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('cart.analysis.full') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body" style="overflow-x:auto">
        <div class="row">
          <div class="col-12">
            <span class="text-capitalize">{{ mt._('_common.season') }}:</span>
            {{ common['order_info'].dsstag != '' ? common['order_info'].dsstag : common['order_info'].cdstag }}
            - <span class="text-capitalize">{{ mt._('_common.drop') }}:</span>
            {{ common['order_info'].tpindo }}
            {{ common['order_info'].dsindo != '' and common['order_info'].dsindo != common['order_info'].dsindo ? ' - ' ~ common['order_info'].dsindo : '' }}
          </div>
        </div>
        {% set title = mt._('_common.drop') ~ ' - ' ~ mt._('_common.line') %}
        {{ elements.getBudgetHeaderHtml(lineColumnWidth, otherColumnWidth, 'px', common['budget']['drop'][0], title, false, false, true) }}
        {{ elements.getBudgetForCustomerBodyHtml(lineColumnWidth, otherColumnWidth, 'px', common['budget']['drop'], addBrand, common['currency'], false, false, false, true) }}
      </div>

    </div>
  </div>
</div>
{% endif %}

{% endif %}
