<div class="x_panel">
	<div class="x_title">
		<h2>{{ mt._('_common.sizes.scale') }}</h2>
		<div class="clearfix"></div>
	</div>

	<div class="x_content">
		<div class="row">
      <div class="col-sm-6 col-md-6 col-xs-6">
				<button type="button" class="btn btn-primary waves-effect waves-light left-btn" data-toggle='modal' data-target='#modal-insert-scale'>
					{{ mt._('admin.sizes.new') }}
				</button>
			</div>
		</div>

		<div class="row py-10x">
			<div class="col-sm-12 col-md-12 col-xs-12">
			{% if scales|length > 0 %}
				<table id="table-sizes" class="table table-striped table-bordered">
					<thead>
						<tr>
							<th>{{ mt._('_common.code') }}</th>
							<th>{{ mt._('_common.description') }}</th>
							{% for i in 1..(numsizes) %}
							<th>Tg. {{ i > 9 ? i : '0' ~ i }}</th>
							{% endfor %}
							<th></th>
						</tr>
					</thead>
					<tbody>
					{% for scale in scales %}
						<tr data-cdtagl="{{ scale['cdtagl'] }}" data-dstagl="{{ scale['dstagl'] }}">
							<td>{{ scale['cdtagl'] }}</td>
							<td>{{ scale['dstagl'] }}</td>
						{% for i in 1..numsizes %}
							{% if scale['sizes'][i] is defined %}
							<td data-tgl="{{ scale['sizes'][i]['taglia'] }}" data-pos="{{ scale['sizes'][i]['postgl'] }}" class="size">
								{{ scale['sizes'][i]['taglia'] }}
							</td>
							{% else %}
							<td></td>
							{% endif %}
						{% endfor %}
							<td class="center" style="vertical-align:middle">
								<a href="#" class="open-edit-scale" title="{{ mt._('admin.sizes.edit') }}"
									data-toggle='modal' data-target='#modal-edit-scale'>
									<span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
								</a>
								<a href="#" class="open-delete-scale pl-10x" title="{{ mt._('admin.sizes.delete') }}"
									data-toggle='modal' data-target='#modal-delete-scale'>
									<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
								</a>
							</td>
						</tr>
					{% endfor %}
					</tbody>
				</table>
			{% else %}
			{{ mt._('admin.sizes.no') }}
			{% endif %}
			</div>
		</div>
	</div>
</div>

<!-- Modal for insert scale -->
<div class="modal fade" id="modal-insert-scale" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.sizes.new') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<input class="sizes-counter" type="hidden" value="0">
				<div class="modal-section">
					<div class="row py-10x">
						<div class="col-md-6 col-sm-6 col-xs-6">
							<button type="button" class="add-size btn btn-default btn-sm mr-10x">
								<span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
							</button>
							<button type="button" class="remove-last btn btn-default btn-sm">
								<span class="glyphicon glyphicon-minus" aria-hidden="true"></span>
							</button>
						</div>
						<div class="col-md-6 col-sm-6 col-xs-6">
							<div class="msg-error"></div>
							<div class="msg-success"></div>
						</div>
					</div>
				</div>
				<div class="my-20x">
					<h5>{{ mt._('_common.sizes.scale') }}</h5>
					<div class="row">
						<div class="col-md-6 col-sm-6 col-xs-6">
							<input type="text" id="cdtagl" name="cdtagl" class="form-control" maxlength="10" placeholder="{{ mt._('_common.code') }}">
						</div>
						<div class="col-md-6 col-sm-6 col-xs-6">
							<input type="text" id="dstagl" name="dstagl" class="form-control" placeholder="{{ mt._('_common.description') }}">
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="insert-scale" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for edit scale -->
<div class="modal fade" id="modal-edit-scale" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.sizes.edit') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body px-20x">
				<div class="modal-section">
					<div class="row py-10x">
						<div class="col-md-6 col-sm-6 col-xs-6">
							<button type="button" class="add-size btn btn-default btn-sm mr-10x">
								<span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
							</button>
							<button type="button" class="remove-last btn btn-default btn-sm mr-20x">
								<span class="glyphicon glyphicon-minus" aria-hidden="true"></span>
							</button>
						</div>
						<div class="col-md-6 col-sm-6 col-xs-6">
							<div class="msg-error"></div>
							<div class="msg-success"></div>
						</div>
					</div>
				</div>
				<input type="hidden" class="sizes-counter">
				<input type="hidden" id="edit-cdtagl">
				<div class="py-10x">
				     <h5>{{ mt._('_common.sizes.scale') }}</h5>
					<input type="text" id="edit-dstagl" class="form-control" title="{{ mt._('_common.description') }}">
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="edit-scale" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.save') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for delete scale -->
<div class="modal fade" id="modal-delete-scale" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.sizes.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<input type="hidden" id="delete-cdtagl">
				<div class="py-10x">{{ mt._('admin.sizes.warning') }}</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-scale" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
