<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.promo') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
		<div class="row">
      <div class="col-sm-6 col-md-6 col-xs-6">
        <a href="{{ url('gomanagement/editPromo') }}" class="btn btn-primary waves-effect waves-light left-btn">{{ mt._('admin.promo.new') }}</a>
			</div>
		</div>

		<div class="row py-10x">
			<div class="col-sm-12 col-md-12 col-xs-12">
			{% if promos|length > 0 %}
        <table id="table-promos" class="table table-striped table-bordered">
          <thead>
            <tr>
              <th style="width:25%">{{ mt._('_common.code') }}</th>
              <th style="width:25%">{{ mt._('_common.description') }}</th>
              <th style="width:15%">{{ mt._('_common.date.start') }}</th>
              <th style="width:15%">{{ mt._('_common.date.end') }}</th>
              <th style="width:10%">{{ mt._('promo.exclusive') }}</th>
              <th style="width:10%"></th>
            </tr>
          </thead>

          <tbody>
            {% for promo in promos %}
            <tr id="{{ promo.cdprom }}" style="line-height:28px">
              <td><span>{{ promo.cdprom }}</span></td>
              <td><span>{{ promo.dsprom }}</span></td>
              <td><span>{{ promo.dtiniz }}</span></td>
              <td><span>{{ promo.dtfine }}</span></td>
              <td class="center">{% if promo.flescl == 1 %}<i class="fa fa-check" aria-hidden="true"></i>{% endif %}</td>
              <td class="center" style="vertical-align:middle">
                <a href="{{ url('gomanagement/editPromo/' ~ promo.cdprom) }}" title="{{ mt._('admin.promo.edit') }}">
                  <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                </a>
                <a href="#" class="open-delete-promo pl-10x" title="{{ mt._('admin.promo.delete') }}"
                  data-toggle='modal' data-target='#modal-delete-promo'>
                  <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                </a>
              </td>
            </tr>
            {% endfor %}
          </tbody>
        </table>
      {% else %}
			{{ mt._('admin.promo.no') }}
      {% endif %}
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete promo -->
<div class="modal fade" id="modal-delete-promo" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.promo.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
        <input type="hidden" id="delete-cdprom">
				<div class="py-10x">{{ mt._('admin.promo.warning') }}</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-promo" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
