<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.lookbookmanager') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row">
      <div class="col-md-12 form-group">
        <label class="control-label col-md-3 col-sm-3 col-xs-12 text-right" style="line-height:34px">{{ mt._('admin.selectcatalog') }}</label>
        <div class="col-md-6 col-sm-6 col-xs-12">
          <select class="select2_single form-control" id="select-catalog" tabindex="-1">
            <option value="none"> </option>
            {% for catalog in catalogs %}
            <option value="{{ catalog.cdcata }}">{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
            {% endfor %}
          </select>
        </div>
        <div class="col-md-3 col-sm-3 col-xs-12">
          <button type="button" class="btn btn-primary fr" data-toggle='modal' data-target='#modal-new-lookbook'>
            {{ mt._('admin.lookbook.new') }}
          </button>
        </div>
      </div>
    </div>
  </div>

  <div id="lookbook-structure" style="display:none">
    <div class="x_title">
      <h2>{{ mt._('admin.lookbook.structure') }}</h2>
      <div class="clearfix"></div>
    </div>
    <div class="x_content">
      <div class="row">
        <div class="col-md-12">
          <table id='table-lookbook' class="table table-striped table-bordered">
            <thead>
              <tr>
                <th class="no-sort">{{ mt._('_common.rs') }}</th>
                <th>{{ mt._('_common.code') }}</th>
                <th>{{ mt._('_common.description') }}</th>
                <th>{{ mt._('_common.page.abbr') }}</th>
                <th class="no-sort">{{ mt._('_common.image') }}</th>
                <th class="no-sort"></th>
              </tr>
            </thead>

            <tbody>
            {% for lookbook in lookbooks %}
              <tr class="{{ lookbook.cdcata }}" data-cdlkbk="{{ lookbook.cdlkbk }}">
                <td class='text-center'><span>{{ lookbook.seqrap }}</span></td>
                <td><span>{{ lookbook.cdlkbk }}</span></td>
                <td><span>{{ lookbook.dslkbk }}</span></td>
                <td><span>{{ lookbook.num_look }}</span></td>
                <td><span>{{ lookbook.filimg }}</span></td>
                <td class="text-center">
                  <span>
                    <a href='{{ url("gomanagement/editLookbook/" ~ lookbook.cdlkbk) }}' class='mod-lkbk mr-20x' title="{{ mt._('_common.edit') }}">
                      <span class='glyphicon glyphicon-edit' aria-hidden='true'></span>
                    </a>
                    <a href='#' class='del-lkbk' title="{{ mt._('_common.delete') }}">
                      <span class='glyphicon glyphicon-remove' aria-hidden='true'></span>
                    </a>
                  </span>
                </td>
              </tr>
            {% endfor %}
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for new lookbook -->
<div class="modal fade" id="modal-new-lookbook" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm" style="width:50%">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.lookbook.new') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x">
          <div class="col-md-8">
            <div class="row">
              <label for="new-cdcata" class="control-label col-md-4 col-sm-4 col-xs-12 text-right" style="margin-top:13px">
                {{ mt._('_common.catalog') }}
              </label>
              <div class="col-md-8 col-sm-8 col-xs-12">
                <select class="select2_single form-control" id="new-cdcata" tabindex="-1">
                  <option value="none"> </option>
                  {% for catalog in catalogs %}
                  <option value="{{ catalog.cdcata }}">{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
            <div class="row" style="padding-top:23px">
              <label for="new-cdlkbk" class="control-label col-md-4 col-sm-4 col-xs-12 text-right" style="margin-top:13px">
                {{ mt._('_common.code') }}
              </label>
              <div class="col-md-8 col-sm-8 col-xs-12">
                <input type="text" id="new-cdlkbk" name="new-cdlkbk" class="form-control" maxlength="10" size="10">
              </div>
            </div>
            <div class="row" style="padding-top:23px">
              <label for="new-dslkbk" class="control-label col-md-4 col-sm-4 col-xs-12 text-right" style="margin-top:13px">
                {{ mt._('_common.description') }}
              </label>
              <div class="col-md-8 col-sm-8 col-xs-12">
                <input type="text" id="new-dslkbk" name="new-dslkbk" class="form-control" maxlength="40" size="40">
              </div>
            </div>
          </div>
          <div class="col-md-4 form-group">
            <form action="{{ url('admin/uploadImage') }}" class="dropzone" id="dropzone-new-lookbook"></form>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn" id="save-lookbook">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="msg-error">{{ mt._('_common.update.error') }}</div>
            <div class="msg-success">{{ mt._('_common.update.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete lookbook -->
<div class="modal fade modal-delete-lktest" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-lktest-cdlkbk" name="modal-delete-lktest"/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.lookbook.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.lookbook.deletewarning') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn capitalize" id="delete-lktest" data-action="">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
