<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.menu.expirations') }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div role="tabpanel" data-example-id="togglable-tabs">
      <ul class="nav nav-tabs bar_tabs" role="tablist">
        <li role="presentation" class="active">
          <a href="#tab1" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.date.delivery.catalog') }}</a>
        </li>
        <li role="presentation" class="">
          <a href="#tab2" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.date.delivery.special') }}</a>
        </li>
      </ul>

      <div class="tab-content">
        <div role="tabpanel" class="tab-pane fade active in" id="tab1">
        <div class="row">
            <div class="form-group col-md-6">
              <label for="cond-catalog" class="control-label col-md-4 col-sm-4 col-xs-12 right" style="line-height:34px">
                {{ mt._('_common.catalog') }}
              </label>
              <div class="col-md-8 col-sm-8 col-xs-12">
                {% if catalogs|length > 0 %}
                <select class="select2_single form-control" id="cond-catalog" tabindex="-1">
                  {% for catalog in catalogs %}
                  <option value="{{ catalog.cdcata }}">{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
                  {% endfor %}
                </select>
                {% else %}
                <span style="line-height:34px">{{ mt._('admin.custommenu.warning') }}</span>
                {% endif %}
              </div>
            </div>
            <div class="form-group col-md-6">
              <label for="cond-type" class="control-label col-md-3 col-sm-3 col-xs-12 right" style="line-height:34px">
                {{ mt._('_common.condition.type') }}
              </label>
              <div class="col-md-9 col-sm-9 col-xs-12">
                {% if conditions|length > 0 %}
                <select class="select2_single form-control" id="cond-type" tabindex="-1">
                  {% for condition in conditions %}
                  <option value="{{ condition.tpcond }}">{{ condition.tpcond }} - {{ condition.dscond }}</option>
                  {% endfor %}
                </select>
                {% else %}
                <span style="line-height:34px">{{ mt._('admin.conditions.no') }}</span>
                {% endif %}
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6 col-sm-6 col-xs-12">
              <button type="button" class="btn btn-default waves-effect waves-light left-btn" id="load-conditions">
                {{ mt._('_common.condition.load') }}
              </button>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-12">
              <button id="create-condition" type="button" class="btn btn-default waves-effect waves-light right-btn"
                data-toggle='modal' data-target='#modal1' style="display:none">
                {{ mt._('admin.conditions.new') }}</a>
              </button>
            </div>
          </div>

          <div class="spacer"></div>
          <div id="conditions-list" style="display:none">
            <div class="x_title">
              <h2>{{ mt._('_common.condition.list') }}</h2>
              <div class="clearfix"></div>
            </div>
            <div class="x_content">
              <div class="row">
                <div class="col-md-12">
                  <table id='table-conditions' class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th>{{ mt._('_common.date.min') }}</th>
                        <th>{{ mt._('_common.date.max') }}</th>
                        <th>{{ mt._('_common.shipping.internal') }}</th>
                        <th>{{ mt._('_common.shipping.customer') }}</th>
                        <th>{{ mt._('_common.description') }}</th>
                        <th>{{ mt._('_common.period.min') }}</th>
                        <th>{{ mt._('_common.period.max') }}</th>
                        <th></th>
                      </tr>
                    </thead>
                    <tbody>

                    </tbody>
                  </table>
                </div>
              </div>

            </div>
          </div>

        </div>

        <div role="tabpanel" class="tab-pane fade" id="tab2">
          <div class="row">
            <div class="form-group col-md-6">
              <label for="cond-special-catalog" class="control-label col-md-4 col-sm-4 col-xs-12 right" style="line-height:34px">
                {{ mt._('_common.catalog') }}
              </label>
              <div class="col-md-8 col-sm-8 col-xs-12">
                <select class="select2_single form-control" id="cond-special-catalog" tabindex="-1">
                  {% for catalog in catalogs %}
                  <option value="{{ catalog.cdcata }}">{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6 col-sm-6 col-xs-12">
              <button type="button" class="btn btn-default waves-effect waves-light left-btn" id="load-special-conditions">
                {{ mt._('_common.condition.load') }}
              </button>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-12">
              <button id="create-special-condition" type="button" class="btn btn-default waves-effect waves-light right-btn"
                data-toggle='modal' data-target='#modal1' style="display:none">
                {{ mt._('admin.conditions.new') }}</a>
              </button>
            </div>
          </div>

          <div class="spacer"></div>
          <div id="special-conditions-list" style="display:none">
            <div class="x_title">
              <h2>{{ mt._('_common.condition.list') }}</h2>
              <div class="clearfix"></div>
            </div>
            <div class="x_content">
              <div class="row">
                <div class="col-md-12">
                  <table id='table-special-conditions' class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th></th>
                        <th>{{ mt._('_common.condition') }}</th>
                        <th>{{ mt._('_common.date.min') }}</th>
                        <th>{{ mt._('_common.date.max') }}</th>
                        <th>{{ mt._('_common.shipping.customer') }}</th>
                        <th>{{ mt._('_common.period.min') }}</th>
                        <th>{{ mt._('_common.period.max') }}</th>
                        <th>{{ mt._('_common.description') }}</th>
                        <th></th>
                      </tr>
                    </thead>
                    <tbody>

                    </tbody>
                  </table>
                </div>
              </div>

            </div>
          </div>

        </div>

      </div>

    </div>
  </div>
</div>

<!-- Modal for tab 1 new/edit/duplicate expiration condition -->
<div class="modal fade" id="modal1" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title"></h4>
        <div class="modal-close" data-dismiss="modal">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x">
          <div class="form-group">
            <label class="control-label col-md-2 col-sm-2 col-xs-12 mt-10x right">
              {{ mt._('_common.validity') }}
            </label>
            <div class="col-md-4 col-sm-4 col-xs-12">
              <fieldset>
                <div class="control-group">
                  <div class="controls">
                    <div class="input-prepend input-group">
                      <span class="add-on input-group-addon"><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></span>
                      <input type="text" name="validity" id="validity" class="form-control" value="" />
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>

          <div class="spacer"></div>

          <div class="form-group">
            <div class="col-md-12 col-sm-12 col-xs-12 right">
              <label class="radio-container">
                <input type="radio" name="date-type" id="descr-date-radio" value="descr-date-radio" checked="checked" /> {{ mt._('_common.date.description') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12 right">
              <label class="radio-container">
                <input type="radio" name="date-type" id="range-date-radio" value="range-date-radio" /> {{ mt._('_common.date.range') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
          </div>

          <div class="spacer"></div>

          <div class="form-group descr-date-info">
            <label class="control-label col-md-2 col-sm-2 col-xs-12 mt-10x right">{{ mt._('_common.date.delivery') }}</label>
            <div class="col-md-4 col-sm-4 col-xs-12">

              <fieldset>
                <div class="control-group">
                  <div class="controls">
                    <div class="xdisplay_inputx form-group has-feedback">
                      <input type="text" class="form-control has-feedback-left" id="descr-date" placeholder="" aria-describedby="inputSuccess2Status2">
                      <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true" style="left:6px"></span>
                      <span id="inputSuccess2Status2" class="sr-only">(success)</span>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
            <label class="control-label col-md-2 col-sm-2 col-xs-12 mt-10x right">{{ mt._('_common.description') }}</label>
            <div class="col-md-4 col-sm-4 col-xs-12">
              <input type="text" id="descr-description" name="descr-description" class="form-control" value="" maxlength="40" size="40">
            </div>
          </div>

          <div class="form-group range-date-info" style="display:none">
            <label class="control-label col-md-2 col-sm-2 col-xs-12 mt-10x right">{{ mt._('_common.date.range') }}</label>
            <div class="col-md-4 col-sm-4 col-xs-12">
              <fieldset>
                <div class="control-group">
                  <div class="controls">
                    <div class="input-prepend input-group">
                      <span class="add-on input-group-addon"><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></span>
                      <input type="text" name="range-date" id="range-date" class="form-control" value="" />
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
            <label class="control-label col-md-2 col-sm-2 col-xs-12 mt-10x right">{{ mt._('_common.description') }}</label>
            <div class="col-md-4 col-sm-4 col-xs-12">
              <input type="text" id="range-description" name="range-description" class="form-control" value="" maxlength="40" size="40">
            </div>
          </div>

          <input type="hidden" id="mode">
          <input type="hidden" id="seqrap">

        </div>
      </div>
      <div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="save" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
        <div class="row">
          <div class="col-md-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- modal for tab 1 remove expiration condition -->
<div class="modal fade" id="modal1-remove" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.remove') }}</h4>
        <div class="modal-close" data-dismiss="modal">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x">
          {{ mt._('admin.condition.deletewarning') }}
        </div>
        <input type="hidden" id="tpcond">
      </div>
      <div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.delete') }}</button>
					</div>
				</div>
        <div class="row">
          <div class="col-md-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for tab 2 new/edit/duplicate expiration condition -->
<div class="modal fade" id="modal2" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title-special"></h4>
        <div class="modal-close" data-dismiss="modal">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="form-group pb-30x">
            <div class="col-md-3 col-sm-3 col-xs-12 right">
              <label class="radio-container">
                <input type="radio" name="type-special" id="line-radio" value="line-radio" checked="checked" /> {{ mt._('_common.line') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12 right">
              <label class="radio-container">
                <input type="radio" name="type-special" id="line-series-radio" value="line-series-radio" /> {{ mt._('_common.line.series') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12 right">
              <label class="radio-container">
                <input type="radio" name="type-special" id="model-radio" value="model-radio" /> {{ mt._('_common.model') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class="col-md-3 col-sm-3 col-xs-12 right">
              <label class="radio-container">
                <input type="radio" name="type-special" id="article-radio" value="article-radio" /> {{ mt._('_common.article') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
          </div>

          <div class="form-group pb-30x" id="line-special-box">
            <label class="control-label col-md-3 col-sm-3 col-xs-12 mt-10x right">{{ mt._('admin.analysis.select.line') }}</label>
            <div class="col-md-9 col-sm-9 col-xs-12">
              <select class="select2_single_line form-control" id="line-special">
              {% for line in lines %}
                <option value="{{ line.cdlinm }}" id="{{ line.cdlinm }}">{{ line.dslinm }}</option>
              {% endfor %}
              </select>
            </div>
          </div>

          <div class="form-group pb-30x" id="line-series-special-box" style="display:none">
            <label class="control-label col-md-3 col-sm-3 col-xs-12 mt-10x right">{{ mt._('admin.analysis.select.series') }}</label>
            <div class="col-md-9 col-sm-9 col-xs-12">
              <select class="select2_group_lineseries form-control" id="line-series-special">
              {% if series|length > 0 %}
                {% set current_cdlinm = series[0].cdlinm %}
                <optgroup label="{{ series[0].dslinm }}">
                {% for serie in series %}
                  {% if current_cdlinm != serie.cdlinm %}
                </optgroup>
                <optgroup label="{{ serie.dslinm }}">
                  {% set current_cdlinm = serie.cdlinm %}
                  {% endif %}
                  <option value="{{ serie.cdlinm }}{{ serie.cdserm }}" id="{{ serie.cdlinm }}{{ serie.cdserm }}" data-cdlinm="{{ serie.cdlinm }}" data-cdserm="{{ serie.cdserm }}">{{ serie.dsserm }}</option>
                {% endfor %}
                </optgroup>
              {% endif %}
              </select>
            </div>
          </div>

          <div class="form-group pb-30x" id="model-special-box" style="display:none">
            <label class="control-label col-md-3 col-sm-3 col-xs-12 mt-10x right">{{ mt._('_common.model.select') }}</label>
            <div class="col-md-9 col-sm-9 col-xs-12">
              <select class="select2_single_model form-control" id="model-special">
              {% for model in models %}
                <option value="{{ model.cdartn }}" id="{{ model.cdartn }}">{{ model.dsartn }}</option>
              {% endfor %}
              </select>
            </div>
          </div>

          <div class="form-group pb-30x" id="article-special-box" style="display:none">
            <label class="control-label col-md-3 col-sm-3 col-xs-12 mt-10x right">{{ mt._('admin.order.selectarticle') }}</label>
            <div class="col-md-9 col-sm-9 col-xs-12">
              <select class="select2_group_article form-control" id="article-special">
              {% if articles|length > 0 %}
                {% set current_cdartn = articles[0].cdartn %}
                <optgroup label="{{ articles[0].dsartn }}">
                {% for article in articles %}
                  {% if current_cdartn != article.cdartn %}
                </optgroup>
                <optgroup label="{{ article.dsartn }}">
                  {% set current_cdartn = article.cdartn %}
                  {% endif %}
                  <option value="{{ article.cdartn }}{{ article.cdarti }}" id="{{ article.cdartn }}{{ article.cdarti }}" data-cdartn="{{ article.cdartn }}" data-cdarti="{{ article.cdarti }}">{{ article.dsarti }}</option>
                {% endfor %}
                </optgroup>
              {% endif %}
              </select>
            </div>
          </div>

          <div class="form-group pb-30x">
            <label class="control-label col-md-2 col-sm-2 col-xs-12 mt-10x right">{{ mt._('_common.validity') }}</label>
            <div class="col-md-4 col-sm-4 col-xs-12">
              <fieldset>
                <div class="control-group">
                  <div class="controls">
                    <div class="input-prepend input-group">
                      <span class="add-on input-group-addon"><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></span>
                      <input type="text" name="validity-special" id="validity-special" class="form-control" value="" />
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>

          <div class="spacer"></div>

          <div class="form-group descr-date-info-special">
            <label class="control-label col-md-2 col-sm-2 col-xs-12 mt-10x right">{{ mt._('_common.date.delivery') }}</label>
            <div class="col-md-4 col-sm-4 col-xs-12">

              <fieldset>
                <div class="control-group">
                  <div class="controls">
                    <div class="xdisplay_inputx form-group has-feedback">
                      <input type="text" class="form-control has-feedback-left" id="descr-date-special" placeholder="" aria-describedby="inputSuccess2Status2">
                      <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true" style="left:6px"></span>
                      <span id="inputSuccess2Status2" class="sr-only">(success)</span>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
            <label class="control-label col-md-2 col-sm-2 col-xs-12 mt-10x right">{{ mt._('_common.description') }}</label>
            <div class="col-md-4 col-sm-4 col-xs-12">
              <input type="text" id="descr-description-special" name="descr-description-special" class="form-control" value="" maxlength="40" size="40">
            </div>
          </div>

          <input type="hidden" id="mode-special">
          <input type="hidden" id="seqrap-special">
          <input type="hidden" id="cdlinm-special">
          <input type="hidden" id="cdserm-special">
          <input type="hidden" id="cdartn-special">
          <input type="hidden" id="cdarti-special">

        </div>
      </div>
      <div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="save-special" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.save') }}</button>
					</div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- modal for tab 2 remove expiration condition -->
<div class="modal fade" id="modal2-remove" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.remove') }}</h4>
        <div class="modal-close" data-dismiss="modal">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x">
          {{ mt._('admin.condition.deletewarning') }}
        </div>
      </div>
      <div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-special" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.delete') }}</button>
					</div>
				</div>
        <div class="row">
          <div class="col-md-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
