<div class="x_panel">
  <div class="x_title">
    <h2>{{ type == 'p' ? mt._('admin.menu.payments.types') : mt._('admin.menu.shippings.types') }}</h2>
    <div class="clearfix"></div>
  </div>
  <div class="x_content">

    <div class="" role="tabpanel" data-example-id="togglable-tabs">
      <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
        {% if type == 'p' %}
        <li role="presentation" class="active">
          <a href="#tab1" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('admin.conditions.payment.s') }}</a>
        </li>
        <li role="presentation" class="">
          <a href="#tab2" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('admin.conditions.payment.d') }}</a>
        </li>
        {% elseif type == 's' %}
        <li role="presentation" class="active">
          <a href="#tab1" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('admin.conditions.shipping.s') }}</a>
        </li>
        <li role="presentation" class="">
          <a href="#tab2" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('admin.conditions.shipping.d') }}</a>
        </li>
        {% endif %}
      </ul>

      <div class="tab-content">
        <div role="tabpanel" class="tab-pane fade active in" id="tab1">
          <div class="row">
            <div class="form-group col-md-6">
              <label for="cond-season" class="control-label col-md-4 col-sm-4 col-xs-12 right capitalize" style="line-height:34px">
                {{ mt._('_common.season') }}
              </label>
              <div class="col-md-8 col-sm-8 col-xs-12">
                <select class="select2_single form-control" id="cond-season" tabindex="-1">
                  {% for season in seasons %}
                  <option value="{{ season.cdstag }}">{{ season.cdstag }} - {{ season.dsstag }}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
            <div class="form-group col-md-6">
              <label for="cond-type" class="control-label col-md-3 col-sm-3 col-xs-12 right capitalize" style="line-height:34px">
                {{ mt._('_common.condition.type') }}
              </label>
              <div class="col-md-9 col-sm-9 col-xs-12">
                <select class="select2_single form-control" id="cond-type" tabindex="-1">
                  {% for condition in conditions %}
                  <option value="{{ condition.tpcond }}">{{ condition.tpcond }} - {{ condition.dscond }}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-sm-6 col-md-6 col-xs-6">
      				<button type="button" class="btn btn-default waves-effect waves-light left-btn" id="load-conditions">
      					{{ mt._('_common.condition.load') }}
      				</button>
      			</div>
            <div class="col-sm-6 col-md-6 col-xs-6" style="display:none">
        			<button type="button" class="btn btn-primary waves-effect waves-light right-btn btn-cond-save">
        				{{ mt._('_common.save') }}
        			</button>
        		</div>
          </div>

          <div class="spacer"></div>
          <div id="conditions-list" style="display:none">
            <div class="x_title">
              <h2>{{ mt._('_common.condition.list') }}</h2>
              <div class="clearfix"></div>
            </div>
            <div class="x_content">
              <div class="row">
                <div class="col-md-12">
                  <table id='table-conditions' class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th></th>
                        <th>{{ mt._('_common.code') }}</th>
                        <th>{{ mt._('_common.description') }}</th>
                        <th style="width:200px">{{ mt._('_common.qty.min') }}</th>
                      </tr>
                    </thead>

                    {% if conditions|length > 0 %}
                    <tbody>
                      {% for item in conditions %}
                      <tr id="{{ item.code }}">
                        <td class="center">
                          <label class='checkbox-container' style="padding-top:6px">
                            <input type='checkbox' id='{{ item.code }}'>
                            <span class="checkbox-checkmark"></span>
                          </label>
                        </td>
                        <td><span>{{ item.code }}</span></td>
                        <td><span>{{ item.description }}</span></td>
                        <td><div><input type="text" name="valmin" class="form-control" style="display:none" value="0" /></div></td>
                      </tr>
                      {% endfor %}
                    </tbody>
                    {% else %}
                    {{ mt._('admin.conditions.no') }}
                    {% endif %}
                  </table>
                </div>
              </div>
              <div class="row mt-20x">
                <div class="col-md-6 col-sm-6 col-xs-12"></div>
                <div class="col-md-6 col-sm-6 col-xs-12">
            			<button type="button" class="btn btn-primary waves-effect waves-light right-btn btn-cond-save">
                    {{ mt._('save') }}
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div role="tabpanel" class="tab-pane fade" id="tab2">
          <div class="row">
            <div class="col-sm-6 col-md-6 col-xs-6"></div>
            <div class="col-sm-6 col-md-6 col-xs-6">
              <button type="button" class="btn btn-primary waves-effect waves-light right-btn btn-define-cond-save">
                {{ mt._('_common.save') }}
              </button>
            </div>
          </div>


          <div class="x_title">
            <h2>{{ type == 'p' ? mt._('admin.conditions.payment.d') : mt._('admin.conditions.shipping.d') }}</h2>
            <div class="clearfix"></div>
          </div>

          <div class="row" style="padding-bottom:10px">
            <div class="col-md-12">
              <select multiple="multiple" size='20' name="duallistbox_conditions" style="height:500px">
                {% for condition in conditions %}
                <option value="{{ condition.code }}" id="{{ condition.code }}" {{ condition.defcon == 1 ? "selected='selected'" : '' }}>
                  {{ condition.code }} - {{ condition.description }}
                </option>
                {% endfor %}
              </select>
            </div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-6 col-sm-6 col-xs-12"></div>
            <div class="col-md-6 col-sm-6 col-xs-12">
              <button type="button" class="btn btn-primary waves-effect waves-light right-btn btn-define-cond-save">
                {{ mt._('save') }}
              </button>
            </div>
          </div>

        </div>

      </div>
    </div>

  </div>
</div>
