<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('_common.sorting') }} {{ catalog.cdcata }} - {{ catalog.dscata }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row">
      <div class="col-sm-2 col-md-2">&nbsp;</div>
      <div class="form-group col-md-10" style="line-height:34px">
        <label class="checkbox-container fl">
          <input type="checkbox" id="use-custom" name="use-custom" class="form-control m-0 mt-5x fl" style="height:16px;width:16px"
          {{ catalog.seqrapType == 1 ? 'checked' : '' }}>
          <span class="checkbox-checkmark mt-5x"></span>
        </label>
        {{ mt._('admin.catalog.sorting.usecustom') }}
      </div>
    </div>
    <div class="row">
      {% if sortingType == 2 %}
      <div class="col-sm-2 col-md-2 right" style="line-height:34px">
        <label for="zone">{{ mt._('_common.zone') }}</label>
      </div>
      <div class="col-sm-4 col-md-4">
        <select class="select2_single form-control" id="zone" tabindex="-1">
          <option value="0">{{ mt._('_common.default') }}</option>
          <option value="1">U.S.A.</option>
        </select>
      </div>
      {% endif %}
      <div class="col-sm-2 col-md-2 right" style="line-height:34px">
        <label for="zone">{{ mt._('_common.brand') }} / {{ mt._('_common.line') }} / {{ mt._('_common.series') }}</label>
      </div>
      <div class="col-sm-4 col-md-4">
        <select class="select2_single form-control" id="category" tabindex="-1">
          <option value="-1">{{ mt._('_common.allf') }}</option>
          {% if categories|length > 0 %}
          {% for category in categories %}
          <option id="category-{{ loop.index }}" value="{{ loop.index }}"
            data-cdtitl="{{ category.cdtitl }}" data-cdlinm="{{ category.cdlinm }}" data-cdserm="{{ category.cdserm }}">
            {{ category.dstitl }} ({{ category.cdtitl }})
            / {{ category.dslinm }} ({{ category.cdlinm }})
            {{ category.cdserm != '' ? '/ ' ~ category.cdserm ~ ' (' ~ category.cdserm ~ ')' : '' }}
          </option>
          {% endfor %}
          {% endif %}
        </select>
      </div>
    </div>

    <div class="row mt-30x">
      <div class="col-xs-2 col-sm-2 col-md-2">
        <a href="{{ url('gomanagement/catalogDetail/' ~ catalog.cdcata) }}" class="btn btn-default w-100">{{ mt._('_common.close') }}</a>
      </div>
      <div class="col-xs-2 col-sm-2 col-md-2">
        <button type="button" class="btn btn-primary btn-download w-100" {{ catalog.seqrapType == 0 ? 'style="display:none"' : '' }}>
          {{ mt._('_common.template.download') }}&nbsp;
        </button>
      </div>
      <div class="col-xs-2 col-sm-2 col-md-2">
        <button type="button" data-toggle="modal" data-target=".modal-xls-upload" class="btn btn-primary btn-upload w-100" {{ catalog.seqrapType == 0 ? 'style="display:none"' : '' }}>
          {{ mt._('_common.template.upload') }}
        </button>&nbsp;
      </div>
      <div class="col-xs-4 col-sm-4 col-md-4">&nbsp;</div>
      <div class="col-xs-2 col-sm-2 col-md-2">
        <button type="button" class="btn btn-primary btn-save w-100">{{ mt._('_common.save') }}</button>
        <div class='loader' id='save-loader' style="text-align:center;display:none">{{ image("assets/img/loading.gif", "alt": "Preloader", 'style': 'height:34px') }}</div>
      </div>
      <div class="col-md-12">
        <div class="msg-error">{{ mt._('_common.update.error') }}</div>
        <div class="msg-success">{{ mt._('_common.update.success') }}</div>
      </div>
    </div>
  </div>
</div>

<div id="catalog-sorting" style="display:none">

</div>

<!-- Modal for xls -->
<div class="modal fade modal-xls-upload px-0" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px">
  <div class="modal-dialog modal-sm" style="width:40%">
    <div class="modal-content" >
      <div class="modal-header">
        <h4 class="xls-order-title">{{ mt._('_common.template.upload') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body modal-body-xls-order">
        <div class="row xls-upload-info">
          <div class="col-md-12" style="font-size:13px">
            <form action="{{ url('excel/uploadSortingCatalogXls') }}" method="post" enctype="multipart/form-data" id="load-xls-template">
              <input type="file" name="file" id="xls_file">
            </form>
          </div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary left-btn w-50" id="xls-load">{{ mt._('_common.upload') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
